/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.service.SfaApprovalService;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.CopyTaskRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.approval.req.SfaApprovalListReqVo;
import com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SfaApprovalServiceImpl
implements SfaApprovalService {
    private static final String processName = "SFA";
    @Resource
    ActivitiMobileFeign activitiMobileFeign;
    @Resource
    MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaApprovalListRespVo> getApprovalList(SfaApprovalListReqVo sfaApprovalListReqVo) {
        AssertUtils.isNotEmpty((String)sfaApprovalListReqVo.getApprovalState(), (String)"\u8bf7\u4f20\u5165\u5ba1\u6279\u72b6\u6001");
        if (ActivitiEnum.approvalState.SEND.getVal().equals(sfaApprovalListReqVo.getApprovalState())) {
            return this.getApprovalSendList(sfaApprovalListReqVo);
        }
        TaskQueryReqVO taskQuery = this.getTaskQuery(sfaApprovalListReqVo);
        Result currentTask = null;
        if (ActivitiEnum.approvalState.NOT_DONE.getVal().equals(sfaApprovalListReqVo.getApprovalState())) {
            currentTask = this.activitiMobileFeign.findCurrentTask(taskQuery);
        } else if (ActivitiEnum.approvalState.DONE.getVal().equals(sfaApprovalListReqVo.getApprovalState())) {
            currentTask = this.activitiMobileFeign.findDoneTask(taskQuery);
        } else {
            throw new BusinessException("\u5ba1\u6279\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        List data = ((PageResult)currentTask.getResult()).getData();
        ArrayList respVos = new ArrayList();
        if (CollectionUtil.listNotEmpty((List)data)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List posStrings = data.stream().map(TaskRspVO::getStartPosCode).collect(Collectors.toList());
            Result batchByIds = this.mdmPositionFeign.detailBatchByIds(posStrings);
            Map<String, String> stringMap = ((List)batchByIds.getResult()).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, MdmPositionUserOrgRespVo::getOrgName));
            data.forEach(item -> {
                SfaApprovalListRespVo respVo = (SfaApprovalListRespVo)CrmBeanUtil.copy((Object)item, SfaApprovalListRespVo.class);
                respVo.setApprovalType(item.getCostType());
                respVo.setId(item.getFormNo());
                respVo.setCreateTime(simpleDateFormat.format(item.getCreateTime()));
                respVo.setOrgName((String)stringMap.get(item.getStartPosName()));
                respVos.add(respVo);
            });
        }
        return PageResult.builder().data(respVos).count(((PageResult)currentTask.getResult()).getCount()).build();
    }

    @Override
    public Result countSend() {
        return null;
    }

    private PageResult<SfaApprovalListRespVo> getApprovalSendList(SfaApprovalListReqVo sfaApprovalListReqVo) {
        CopyTaskReqVO copyTaskQuery = this.getCopyTaskQuery(sfaApprovalListReqVo);
        Result myCopyTask = this.activitiMobileFeign.findMyCopyTask(copyTaskQuery);
        List data = ((PageResult)myCopyTask.getResult()).getData();
        ArrayList respVos = new ArrayList();
        if (CollectionUtil.listNotEmpty((List)data)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List posStrings = data.stream().map(CopyTaskRspVO::getFromPosCode).collect(Collectors.toList());
            Result batchByIds = this.mdmPositionFeign.detailBatchByIds(posStrings);
            Map<String, String> stringMap = ((List)batchByIds.getResult()).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, MdmPositionUserOrgRespVo::getOrgName));
            data.forEach(item -> {
                SfaApprovalListRespVo respVo = (SfaApprovalListRespVo)CrmBeanUtil.copy((Object)item, SfaApprovalListRespVo.class);
                respVo.setApprovalType(item.getCostType());
                respVo.setId(item.getFormNo());
                respVo.setCreateTime(simpleDateFormat.format(item.getCreateTime()));
                respVo.setOrgName((String)stringMap.get(item.getFromPosCode()));
                respVos.add(respVo);
            });
        }
        return PageResult.builder().data(respVos).count(((PageResult)myCopyTask.getResult()).getCount()).build();
    }

    private CopyTaskReqVO getCopyTaskQuery(SfaApprovalListReqVo sfaApprovalListReqVo) {
        CopyTaskReqVO copyTaskReqVO = new CopyTaskReqVO();
        copyTaskReqVO.setUserCode(UserUtils.getUser().getUsername());
        copyTaskReqVO.setProcessName(processName);
        copyTaskReqVO.setPageNum(sfaApprovalListReqVo.getPageNum());
        copyTaskReqVO.setPageSize(sfaApprovalListReqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)sfaApprovalListReqVo.getRealName())) {
            copyTaskReqVO.setFromUserName(sfaApprovalListReqVo.getRealName());
        }
        if (StringUtils.isNotEmpty((String)sfaApprovalListReqVo.getApprovalType())) {
            copyTaskReqVO.setProcessName(processName + ActivitiEnum.getTitleByCostType((String)sfaApprovalListReqVo.getApprovalType()));
        }
        return copyTaskReqVO;
    }

    private TaskQueryReqVO getTaskQuery(SfaApprovalListReqVo sfaApprovalListReqVo) {
        TaskQueryReqVO queryReqVO = new TaskQueryReqVO();
        queryReqVO.setUserCode(UserUtils.getUser().getUsername());
        queryReqVO.setProcessName(processName);
        queryReqVO.setPageNum(sfaApprovalListReqVo.getPageNum());
        queryReqVO.setPageSize(sfaApprovalListReqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)sfaApprovalListReqVo.getRealName())) {
            queryReqVO.setStartUserName(sfaApprovalListReqVo.getRealName());
        }
        if (StringUtils.isNotEmpty((String)sfaApprovalListReqVo.getApprovalType())) {
            queryReqVO.setProcessName(processName + ActivitiEnum.getTitleByCostType((String)sfaApprovalListReqVo.getApprovalType()));
        }
        return queryReqVO;
    }
}

