/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.impl.AbstractSfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="outletsResolver")
public class SfaVisitPlanOutletsResolver
extends AbstractSfaVisitPlanResolver {
    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate;
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (null != (visitDate = this.visitDateNext(context, futurePlanInfo))) {
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.produceOutlets(context);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);
    }

    private List<SfaVisitPlanInfoEntity> produceOutlets(SfaVisitPlanExecuteContext context) {
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        ArrayList planInfoEntities = Lists.newArrayList();
        planRangeEntities.forEach(data -> {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)((Object)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanEntity), SfaVisitPlanInfoEntity.class)));
            sfaVisitPlanInfoEntity.setId(null);
            sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
            sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
            sfaVisitPlanInfoEntity.setClientCode(data.getClientCode());
            sfaVisitPlanInfoEntity.setClientName(data.getClientName());
            sfaVisitPlanInfoEntity.setClientType(data.getClientType());
            sfaVisitPlanInfoEntity.setClientAddress(data.getClientAddress());
            sfaVisitPlanInfoEntity.setClientPhone(data.getClientPhone());
            sfaVisitPlanInfoEntity.setLongitude(data.getLongitude());
            sfaVisitPlanInfoEntity.setLatitude(data.getLatitude());
            sfaVisitPlanInfoEntity.setClientPhoto(data.getClientPhoto());
            planInfoEntities.add(sfaVisitPlanInfoEntity);
        });
        return planInfoEntities;
    }
}

