/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="summaryVisitStepExecutor")
public class SummaryVisitStepExecutor
extends AbstractVisitStepRedisExecutor<SummaryStepExecuteData, SummaryStepExecuteDataResp, ExecutorLoadReq> {
    @Override
    public void execute(VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SummaryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)((Object)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate).toString(), (Object)visitStepExecuteReq.getRedisHashKey()));
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        sfaVisitPlanInfoExecuteRedisData.setVisitSummary(executeData.getVisitSummary());
        this.changeStepStatus(sfaVisitPlanInfoRedisData, "summary");
        this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(nowDate).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 691200L);
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        SummaryStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getVisitSummary())) {
            throw new BusinessException("\u8bf7\u586b\u5199\u62dc\u8bbf\u603b\u7ed3");
        }
    }

    @Override
    protected SummaryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        if (StringUtils.isBlank((CharSequence)redisHashKey.getRedisHashKey())) {
            throw new BusinessException("redisHashKey\u4e3a\u7a7a");
        }
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData)((Object)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        SummaryStepExecuteDataResp dataResp = (SummaryStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SummaryStepExecuteDataResp.class);
        dataResp.setVisitDetailStep(this.summaryStepStatus(redisData));
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
    }

    private Map<String, String> summaryStepStatus(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        List<VisitStepResp> step = sfaVisitPlanInfoRedisData.getStep();
        HashMap<String, String> stepMap = new HashMap<String, String>();
        step.forEach(data -> stepMap.put("\u662f\u5426" + data.getStepName(), data.getIsSuccessDesc()));
        return stepMap;
    }
}

