/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgContactPageRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.impl.AbstractSfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="lineResolver")
public class SfaVisitPlanLineResolver
extends AbstractSfaVisitPlanResolver {
    @Resource
    private ISfaVisitGroupService iSfaVisitGroupService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate;
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (null != (visitDate = this.visitDateNext(context, futurePlanInfo))) {
            Result terminalResult;
            Result customerResult;
            SfaVisitGroupRespVo sfaVisitGroupRespVo = this.loadSfaVisitGroupRespVo(context);
            if (null == sfaVisitGroupRespVo) {
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                return;
            }
            List sfaVisitclientRelRespVos = sfaVisitGroupRespVo.getSfaVisitclientRelRespVos();
            if (CollectionUtils.isEmpty((Collection)sfaVisitclientRelRespVos)) {
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                return;
            }
            final List customerCodes = sfaVisitclientRelRespVos.stream().filter(o -> o.getClientCode().equals(SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal())).map(SfaVisitclientRelRespVo::getClientCode).collect(Collectors.toList());
            final List terminalCodes = sfaVisitclientRelRespVos.stream().filter(o -> !o.getClientCode().equals(SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal())).map(SfaVisitclientRelRespVo::getClientCode).collect(Collectors.toList());
            Map<String, Object> terminalMap = new HashMap<String, MdmTerminalContactPageVo>();
            Map<String, Object> customerMap = new HashMap<String, MdmCustomerMsgContactPageRespVo>();
            if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes) && (customerResult = this.mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo(){
                {
                    this.setCustomerCodeList(customerCodes);
                    this.setPageSize(-1);
                }
            })).isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)customerResult.getResult()).getData())) {
                customerMap = ((PageResult)customerResult.getResult()).getData().stream().collect(Collectors.toMap(MdmCustomerMsgContactPageRespVo::getCustomerCode, Function.identity()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodes) && (terminalResult = this.mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo(){
                {
                    this.setTerminalCodeList(terminalCodes);
                    this.setPageSize(-1);
                }
            })).isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)terminalResult.getResult()).getData())) {
                terminalMap = ((PageResult)terminalResult.getResult()).getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, Function.identity()));
            }
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.resolveSfaVisitPlanInfoEntityList(context, sfaVisitclientRelRespVos, terminalMap, customerMap);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);
    }

    private List<SfaVisitPlanInfoEntity> resolveSfaVisitPlanInfoEntityList(SfaVisitPlanExecuteContext context, List<SfaVisitclientRelRespVo> sfaVisitclientRelRespVos, Map<String, MdmTerminalContactPageVo> terminalMap, Map<String, MdmCustomerMsgContactPageRespVo> customerMap) {
        ArrayList visitPlanInfoEntities = Lists.newArrayList();
        for (SfaVisitclientRelRespVo data : sfaVisitclientRelRespVos) {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.buildSfaVisitPlanInfoEntity(context, data);
            if (customerMap.containsKey(data.getClientCode())) {
                MdmCustomerMsgContactPageRespVo customer = customerMap.get(data.getClientCode());
                sfaVisitPlanInfoEntity.setClientAddress(customer.getRegisteredAddress());
                sfaVisitPlanInfoEntity.setClientPhone(customer.getContactPhone());
                if (StringUtils.isNotEmpty((String)customer.getLongitude()) && StringUtils.isNotEmpty((String)customer.getLatitude())) {
                    sfaVisitPlanInfoEntity.setLongitude(new BigDecimal(customer.getLongitude()));
                    sfaVisitPlanInfoEntity.setLatitude(new BigDecimal(customer.getLatitude()));
                }
            }
            if (terminalMap.containsKey(data.getClientCode())) {
                MdmTerminalContactPageVo terminal = terminalMap.get(data.getClientCode());
                sfaVisitPlanInfoEntity.setClientAddress(terminal.getTerminalAddress());
                sfaVisitPlanInfoEntity.setClientPhone(terminal.getContactPhone());
                sfaVisitPlanInfoEntity.setClientPhoto(terminal.getShopImagePath());
                if (StringUtils.isNotEmpty((String)terminal.getLongitude()) && StringUtils.isNotEmpty((String)terminal.getLatitude())) {
                    sfaVisitPlanInfoEntity.setLongitude(new BigDecimal(terminal.getLongitude()));
                    sfaVisitPlanInfoEntity.setLatitude(new BigDecimal(terminal.getLatitude()));
                }
            }
            visitPlanInfoEntities.add(sfaVisitPlanInfoEntity);
        }
        return visitPlanInfoEntities;
    }

    private SfaVisitPlanInfoEntity buildSfaVisitPlanInfoEntity(SfaVisitPlanExecuteContext context, SfaVisitclientRelRespVo data) {
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanEntity), SfaVisitPlanInfoEntity.class));
        sfaVisitPlanInfoEntity.setId(null);
        sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
        sfaVisitPlanInfoEntity.setClientCode(data.getClientCode());
        sfaVisitPlanInfoEntity.setClientName(data.getClientName());
        sfaVisitPlanInfoEntity.setClientType(data.getClientType());
        SfaVisitPlanInfoEntity.buildPlanEntity(sfaVisitPlanInfoEntity);
        return sfaVisitPlanInfoEntity;
    }

    private SfaVisitGroupRespVo loadSfaVisitGroupRespVo(SfaVisitPlanExecuteContext context) {
        final SfaVisitPlanRangeEntity sfaVisitPlanRangeEntity = this.getLine(context);
        if (null == sfaVisitPlanRangeEntity) {
            return null;
        }
        SfaVisitGroupReqVo groupReqVo = new SfaVisitGroupReqVo(){
            {
                this.setId(sfaVisitPlanRangeEntity.getVisitGroupId());
            }
        };
        SfaVisitGroupRespVo sfaVisitGroupRespVo = this.iSfaVisitGroupService.query(groupReqVo);
        return sfaVisitGroupRespVo;
    }

    private SfaVisitPlanRangeEntity getLine(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate = context.getVisitDate();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        if (CollectionUtils.isEmpty(planRangeEntities)) {
            return null;
        }
        Integer num = this.notWeekNum(LocalDate.parse(sfaVisitPlanEntity.getVisitStartDate()), visitDate, sfaVisitPlanEntity.getNotWeekSet());
        LocalDate startDate = context.getVisitStartDate();
        Integer days = Period.between(startDate, visitDate).getDays() - num;
        int lineNum = 0;
        int size = planRangeEntities.size();
        if (size > 1) {
            lineNum = days % size;
        }
        return planRangeEntities.get(lineNum);
    }

    private Integer notWeekNum(LocalDate startDate, LocalDate visitEndDate, String week) {
        Integer days = Period.between(startDate, visitEndDate).getDays() + 1;
        Integer num = 0;
        for (int i = 0; i < days; ++i) {
            LocalDate visitDate = startDate.plusDays(i);
            if (!StringUtils.isNotEmpty((String)week) || !week.contains(String.valueOf(visitDate.getDayOfWeek().getValue()))) continue;
            Integer n = num;
            Integer n2 = num = Integer.valueOf(num + 1);
        }
        return num;
    }
}

