/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.impl.SfaCustomerServiceImpl;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderItemMapper;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepOrderServiceExpandImpl"})
public class SfaVisitStepOrderServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepOrderMapper, SfaVisitStepOrderEntity>
implements ISfaVisitStepOrderService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceImpl.class);
    @Resource
    private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;
    @Autowired
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private TaActBaseFeign taActBaseFeign;
    @Resource
    private SfaVisitStepOrderItemMapper itemMapper;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    private static String ONE = "1";
    private static String TWO = "2";
    private static String THREE = "3";

    @Override
    public PageResult<SfaVisitStepOrderRespVo> findList(SfaVisitStepOrderReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findList((Page<SfaVisitStepOrderRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepOrderRespVo query(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepOrderEntity), SfaVisitStepOrderRespVo.class);
        List<SfaVisitStepOrderItemRespVo> sfaVisitStepOrderItemRespVos = this.sfaVisitStepOrderItemService.findList(reqVo.getId());
        sfaVisitStepOrderRespVo.setSfaVisitStepOrderItemRespVos(sfaVisitStepOrderItemRespVos);
        return sfaVisitStepOrderRespVo;
    }

    @Override
    public SfaVisitStepOrderRespVo queryDetailByVisitDetailId(String visitId) {
        AssertUtils.isNotEmpty((String)visitId, (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepOrderEntity::getVisitId, (Object)visitId)).one());
        if (null == sfaVisitStepOrderEntity) {
            SfaVisitStepOrderRespVo orderRespVo = new SfaVisitStepOrderRespVo();
            orderRespVo.setSfaVisitStepOrderItemRespVos((List)Lists.newArrayList());
            return orderRespVo;
        }
        SfaVisitStepOrderRespVo orderRespVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepOrderEntity), SfaVisitStepOrderRespVo.class);
        List orderItemEntities = this.sfaVisitStepOrderItemService.list((Wrapper)new QueryWrapper().lambda().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)sfaVisitStepOrderEntity.getId()));
        List orderItemRespVos = CrmBeanUtil.copyList((List)orderItemEntities, SfaVisitStepOrderItemRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)orderItemRespVos)) {
            orderRespVo.setSfaVisitStepOrderItemRespVos(orderItemRespVos);
        }
        return orderRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepOrderReqVo reqVo) {
        this.checkParam(reqVo);
        SfaVisitStepOrderEntity entity = new SfaVisitStepOrderEntity();
        if (StringUtils.isNotEmpty((String)reqVo.getVisitId())) {
            entity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepOrderEntity::getVisitId, (Object)reqVo.getVisitId())).one());
            if (null != entity) {
                entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
                entity.setCustomerCode(reqVo.getCustomerCode());
                entity.setCustomerName(reqVo.getCustomerName());
                entity.setAddress(reqVo.getAddress());
                entity.setContacts(reqVo.getContacts());
                entity.setTelephone(reqVo.getTelephone());
                entity.setExpectReceive(reqVo.getExpectReceive());
                entity.setOrderSource(SfaOrderSourceEnum.REPLACE_ORDER.getCode());
                entity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
                entity.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
                if (StringUtils.isNotEmpty((String)reqVo.getRemarks())) {
                    entity.setRemarks(reqVo.getRemarks());
                }
                log.info("\u66f4\u65b0\u7684\u6570\u636e" + (Object)((Object)entity));
                this.updateById((Object)entity);
            } else {
                throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u6570\u636e");
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getActExecuteId())) {
            entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
            entity.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
            entity.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
            entity.setOrderSource(SfaOrderSourceEnum.PROGRAMME_ACTIVITY.getCode());
            entity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
            entity.setActExecuteId(reqVo.getActExecuteId());
            this.save((Object)entity);
        } else {
            entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
            entity.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
            entity.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
            entity.setVisitId(reqVo.getVisitId());
            entity.setOrderSource(SfaOrderSourceEnum.PROGRAMME_IMPLEMENT.getCode());
            entity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
            log.info("\u4fdd\u5b58\u7684\u6570\u636e" + (Object)((Object)entity));
            this.save((Object)entity);
        }
        String orderId = entity.getId();
        reqVo.getSfaVisitStepOrderItems().forEach(data -> data.setOrderId(orderId));
        this.sfaVisitStepOrderItemService.remove((Wrapper)Wrappers.lambdaUpdate(SfaVisitStepOrderItemEntity.class).eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)orderId));
        List sfaVisitStepOrderItemEntities = CrmBeanUtil.copyList((List)reqVo.getSfaVisitStepOrderItems(), SfaVisitStepOrderItemEntity.class);
        this.sfaVisitStepOrderItemService.saveBatch(sfaVisitStepOrderItemEntities);
    }

    @Override
    public PageResult<SfaVisitStepOrderRespVo> findWorkOrderList(SfaVisitStepOrderReqVo reqVo) {
        if (!StringUtils.isNotEmpty((String)reqVo.getUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setPosCode(userRedis.getPoscode());
        }
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findList((Page<SfaVisitStepOrderRespVo>)page, reqVo);
        this.translateEnum(list);
        this.getOrderItem(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepOrderRespVo queryOrderDetail(String id) {
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).isNull(SfaVisitStepOrderEntity::getVisitId)).one());
        if (sfaVisitStepOrderEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u96c6\u8be6\u7ec6\u4fe1\u606f");
        }
        String orderId = sfaVisitStepOrderEntity.getId();
        SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepOrderEntity), SfaVisitStepOrderRespVo.class);
        List sfaVisitStepOrderItemEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderItemService.lambdaQuery().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)orderId)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitStepOrderItemEntities)) {
            List sfaVisitStepOrderItemRespVos = CrmBeanUtil.copyList((List)sfaVisitStepOrderItemEntities, SfaVisitStepOrderItemRespVo.class);
            this.translateUnit(sfaVisitStepOrderItemRespVos);
            sfaVisitStepOrderRespVo.setSfaVisitStepOrderItemRespVos(sfaVisitStepOrderItemRespVos);
        }
        return sfaVisitStepOrderRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrder(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)sfaVisitStepOrderReqVo.getId())).one());
        if (sfaVisitStepOrderEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u96c6\u8be6\u7ec6\u4fe1\u606f");
        }
        this.checkParam(sfaVisitStepOrderReqVo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_id", (Object)sfaVisitStepOrderReqVo.getId());
        List entityList = this.itemMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)entityList)) {
            this.itemMapper.delete((Wrapper)wrapper);
        }
        sfaVisitStepOrderReqVo.getSfaVisitStepOrderItems().forEach(data -> data.setOrderId(sfaVisitStepOrderReqVo.getId()));
        this.sfaVisitStepOrderItemService.remove((Wrapper)Wrappers.lambdaUpdate(SfaVisitStepOrderItemEntity.class).eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)sfaVisitStepOrderReqVo.getId()));
        List sfaVisitStepOrderItemEntities = CrmBeanUtil.copyList((List)sfaVisitStepOrderReqVo.getSfaVisitStepOrderItems(), SfaVisitStepOrderItemEntity.class);
        this.sfaVisitStepOrderItemService.saveBatch(sfaVisitStepOrderItemEntities);
        Result result = this.taActBaseFeign.startProcess(this.startProcessReqVo(sfaVisitStepOrderEntity.getId()));
        if (!result.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25");
        }
        SfaVisitStepOrderEntity copy = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)sfaVisitStepOrderReqVo, SfaVisitStepOrderEntity.class));
        copy.setProcessNo(((ProcessCommonVo)result.getResult()).getProcessNo());
        copy.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.APPROVAL.getValue());
        this.updateById((Object)copy);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateOrderApprovalStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (activitiCallBackVo.getProcessState() == 1) {
            SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)activitiCallBackVo.getFormNo())).one());
            if (sfaVisitStepOrderEntity == null) {
                throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u8ba2\u5355");
            }
            sfaVisitStepOrderEntity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.APPROVAL.getValue());
            this.updateById((Object)sfaVisitStepOrderEntity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result recoverApproval(SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)sfaVisitStepOrderReqVo.getId())).one());
        if (sfaVisitStepOrderEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba1\u6279\u8ba2\u5355");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO();
        reqVO.setProcessNo(sfaVisitStepOrderEntity.getProcessNo());
        reqVO.setFormNo(sfaVisitStepOrderEntity.getProcessNo());
        reqVO.setUserCode(UserUtils.getUser().getUsername());
        reqVO.setCostType(ActivitiEnum.FormTypeEnum.ORDER.getCostType());
        reqVO.setFormType(ActivitiEnum.FormTypeEnum.ORDER.getFormType());
        Result result = this.taActBaseFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        sfaVisitStepOrderEntity.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getValue());
        this.updateById((Object)sfaVisitStepOrderEntity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVisitOrder(SfaVisitStepOrderReqVo orderReqVo) {
        LambdaQueryWrapper itemEntityLambdaQueryWrapper;
        List itemEntityList;
        AssertUtils.isNotEmpty((String)orderReqVo.getVisitId(), (String)"\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u4e3b\u952eid\u4e0d\u5b58\u5728");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseIdEntity::getId, (Object)orderReqVo.getVisitId());
        SfaVisitDealerDetailEntity dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)this.sfaVisitDealerDetailMapper.selectOne((Wrapper)queryWrapper));
        if (dealerDetailEntity == null) {
            throw new BusinessException("\u4e3a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
        }
        SfaVisitStepOrderEntity orderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepOrderEntity::getVisitId, (Object)orderReqVo.getVisitId())).one());
        if (orderEntity != null && CollectionUtils.isNotEmpty((Collection)(itemEntityList = this.sfaVisitStepOrderItemService.list((Wrapper)(itemEntityLambdaQueryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)orderEntity.getId())))))) {
            List itemIdList = itemEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.sfaVisitStepOrderItemService.removeByIds(itemIdList);
        }
        orderReqVo.setClientCode(dealerDetailEntity.getClientCode());
        orderReqVo.setClientName(dealerDetailEntity.getClientName());
        orderReqVo.setClientType(dealerDetailEntity.getClientType());
        this.save(orderReqVo);
    }

    @Override
    public List<MdmTerminalSupplyVo> findTerminalSupplyList(String terminalCode) {
        List mdmTerminalSupplyVos = Lists.newArrayList();
        Result mdmTerminalVoResult = this.mdmTerminalFeign.query(null, terminalCode);
        if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null && CollectionUtil.listNotEmptyNotSizeZero((List)((MdmTerminalVo)mdmTerminalVoResult.getResult()).getSupplys())) {
            mdmTerminalSupplyVos = ((MdmTerminalVo)mdmTerminalVoResult.getResult()).getSupplys();
        }
        return mdmTerminalSupplyVos;
    }

    private void checkParam(SfaVisitStepOrderReqVo orderReqVo) {
        AssertUtils.isNotEmpty((String)orderReqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getClientId(), (String)"\u5ba2\u6237id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getClientName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getClientType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getContacts(), (String)"\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getTelephone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getAddress(), (String)"\u6536\u83b7\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)orderReqVo.getExpectReceive(), (String)"\u671f\u671b\u6536\u83b7\u65f6\u95f4\u4e3a\u7a7a");
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)orderReqVo.getSfaVisitStepOrderItems())) {
            throw new BusinessException("\u5546\u54c1\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        }
        orderReqVo.getSfaVisitStepOrderItems().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getUnit(), (String)"\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
            if (data.getQuantity() == null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
        });
        if (StringUtils.isEmpty((String)orderReqVo.getUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            orderReqVo.setUserName(userRedis.getUsername());
            orderReqVo.setRealName(userRedis.getRealname());
            orderReqVo.setPosCode(userRedis.getPoscode());
            orderReqVo.setPosName(userRedis.getPosname());
            orderReqVo.setOrgCode(userRedis.getOrgcode());
            orderReqVo.setOrgName(userRedis.getOrgname());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity entity = (SfaVisitStepOrderEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
        this.updateById((Object)entity);
        this.sfaVisitStepOrderItemService.deleteByOrderId(reqVo.getId());
        this.sfaVisitStepOrderItemService.batchSave(reqVo.getSfaVisitStepOrderItems());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    public void translateEnum(List<SfaVisitStepOrderRespVo> list) {
        Map orderType = DictUtil.getDictValueMapsByCodes((String)"sfa_order_source");
        Map approalType = DictUtil.getDictValueMapsByCodes((String)"sfa_approval");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(data -> {
                data.setOrderSourceName((String)orderType.get(data.getOrderSource()));
                data.setApprovalStatusName((String)approalType.get(data.getApprovalStatus()));
            });
        }
    }

    public void translateUnit(List<SfaVisitStepOrderItemRespVo> list) {
        Map unitName = DictUtil.getDictValueMapsByCodes((String)"product_sale_unit");
        list.forEach(data -> data.setUnitName((String)unitName.get(data.getUnit())));
    }

    private StartProcessReqVo startProcessReqVo(String formNo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo process = new StartProcessReqVo();
        process.setUserCode(user.getUsername());
        process.setPosCode(user.getPoscode());
        String processKey = null;
        Map map = DictUtil.getDictValueMapsByCodes((String)"customer_activity_keys");
        if (map == null) {
            throw new BusinessException("\u8bf7\u914d\u7f6e<\u6570\u636e\u5b57\u5178>:customer_activity_keys");
        }
        processKey = (String)map.get("sfa_order");
        if (StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u8bf7\u5728\u6570\u636e\u5b57\u5178-customer_activity_keys-\u4e2d\u6dfb\u52a0\u5b57\u5178");
        }
        process.setProcessKey(processKey);
        process.setTitle("\u8ba2\u5355\u7a0b\u5ba1\u6279");
        process.setFormUrl("https");
        process.setFormNo(formNo);
        process.setCallBackFeign("SfaOrderFeign");
        process.setSignTicket(System.currentTimeMillis() + "");
        return process;
    }

    @Override
    public Integer getOrderNum(String dateFlag) {
        String lastDay;
        String firstDay;
        Integer num = 0;
        String userCode = UserUtils.getUser().getUsername();
        SfaCustomerServiceImpl customerService = new SfaCustomerServiceImpl();
        if (dateFlag.equals(ONE)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"create_date", (Object)DateUtil.getYYYYMMDD());
            wrapper.eq((Object)"create_code", (Object)userCode);
            List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectList((Wrapper)wrapper);
            if (CollectionUtil.listEmpty((List)sfaVisitStepOrderEntities)) {
                return num;
            }
        }
        if (dateFlag.equals(TWO)) {
            firstDay = customerService.getMondayOfThisWeek(ONE);
            List<SfaVisitStepOrderRespVo> vos = this.sfaVisitStepOrderMapper.getVisitNum(firstDay, lastDay = customerService.getMondayOfThisWeek(TWO), userCode);
            if (CollectionUtil.listEmpty(vos)) {
                return num;
            }
            num = vos.size();
        }
        if (dateFlag.equals(THREE)) {
            firstDay = customerService.getMondayOfThisWeek(ONE);
            List<SfaVisitStepOrderRespVo> visitNum = this.sfaVisitStepOrderMapper.getVisitNum(firstDay, lastDay = customerService.getMondayOfThisWeek(TWO), userCode);
            if (CollectionUtil.listEmpty(visitNum)) {
                return num;
            }
            num = visitNum.size();
        }
        return num;
    }

    public void getOrderItem(List<SfaVisitStepOrderRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(data -> {
                List sfaVisitStepOrderItemEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepOrderItemService.lambdaQuery().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)data.getId())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitStepOrderItemEntities)) {
                    List sfaVisitStepOrderItemRespVos = CrmBeanUtil.copyList((List)sfaVisitStepOrderItemEntities, SfaVisitStepOrderItemRespVo.class);
                    this.translateUnit(sfaVisitStepOrderItemRespVos);
                    SfaVisitStepOrderItemRespVo vo = (SfaVisitStepOrderItemRespVo)sfaVisitStepOrderItemRespVos.get(0);
                    data.setProductCode(vo.getProductCode());
                    data.setProductName(vo.getProductName());
                    data.setQuantity(vo.getQuantity());
                }
            });
        }
    }

    @Override
    public List<OptRecordRspVO> findSfaOrderById(String id) {
        OptRecordReqVO optRecordReqVO = new OptRecordReqVO();
        optRecordReqVO.setFormType(ActivitiEnum.getFormType());
        optRecordReqVO.setCostType("overtime");
        optRecordReqVO.setFormNo(id);
        Result result = this.mobileFeign.getOptRecords(optRecordReqVO);
        if (result == null || result.getResult() == null || ((PageResult)result.getResult()).getCount() == 0L) {
            return null;
        }
        return ((PageResult)result.getResult()).getData();
    }
}

