/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Table;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;

@TableName(value="sfa_visit_plan_info")
@Document(indexName="sfa_visit_plan_info", type="sfa_visit_plan_info")
@Entity
@javax.persistence.Table(name="sfa_visit_plan_info")
@Table(appliesTo="sfa_visit_plan_info", comment="\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6")
public class SfaVisitPlanInfoEntity
extends CrmExtTenEntity<SfaVisitPlanInfoEntity> {
    public static final long CACHE_TIME = 691200L;
    public static final String TABLE_NAME = "sfa_visit_plan_info";
    @Column(name="redis_hash_key", length=1024)
    private String redisHashKey;
    private String visitPlanCode;
    private String visitUserName;
    private String visitRealName;
    private String visitPosCode;
    private String visitPosName;
    private String visitOrgCode;
    private String visitOrgName;
    private String parentOrgCode;
    private String parentOrgName;
    private String visitDate;
    private String visitType;
    private String routeType;
    private String clientCode;
    private String clientName;
    private String clientType;
    private String clientAddress;
    @Field(index=false)
    private String clientPhoto;
    @Field(index=false)
    private String clientContacts;
    @Field(index=false)
    private String clientPhone;
    private BigDecimal longitude;
    private BigDecimal latitude;
    private String visitStatus;

    public static SfaVisitPlanInfoEntity getInstance() {
        return Instance.instance;
    }

    public StringJoiner redisHashCurrent(String visitDate) {
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
        }
        return this.redisHash(visitDate, userRedis.getUsername(), userRedis.getPoscode());
    }

    public StringJoiner redisHash(String visitDate, String visitUserName, String visitPosCode) {
        if (StringUtils.isBlank((CharSequence)visitDate)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u65e5\u671f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)visitUserName)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\uff01");
        }
        if (StringUtils.isBlank((CharSequence)visitPosCode)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\u804c\u4f4d\uff01");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add(TABLE_NAME).add(visitUserName).add(visitPosCode).add(visitDate);
        return joiner;
    }

    public StringJoiner redisHash() {
        if (StringUtils.isBlank((CharSequence)this.visitDate)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u65e5\u671f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.visitUserName)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.visitPosCode)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\u804c\u4f4d\uff01");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add(TABLE_NAME).add(this.visitUserName).add(this.visitPosCode).add(this.visitDate);
        return joiner;
    }

    public String getRedisHashKey() {
        if (StringUtils.isBlank((CharSequence)this.getVisitUserName())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getVisitPosCode())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7528\u6237\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getVisitDate())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getClientType())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7f51\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getClientCode())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7f51\u70b9\u7f16\u7801\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add(TABLE_NAME).add(this.getVisitUserName()).add(this.getVisitPosCode()).add(this.getVisitDate()).add(this.getClientType()).add(this.getClientCode());
        return joiner.toString();
    }

    public Map<Object, Object> buildRedisDataForWrite() {
        HashMap redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    public static void buildPlanEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
        UserRedis userRedis = UserUtils.getUser();
        sfaVisitPlanInfoEntity.setCreateCode(userRedis.getUsername());
        sfaVisitPlanInfoEntity.setCreateName(userRedis.getRealname());
        LocalDateTime now = LocalDateTime.now();
        sfaVisitPlanInfoEntity.setCreateDate(now.format(CrmDateUtils.yyyyMMdd));
        sfaVisitPlanInfoEntity.setCreateDateSecond(now.format(CrmDateUtils.HHmmss));
        sfaVisitPlanInfoEntity.setCreateOrgCode(userRedis.getOrgcode());
        sfaVisitPlanInfoEntity.setCreateOrgName(userRedis.getOrgname());
        sfaVisitPlanInfoEntity.setCreatePosCode(userRedis.getPoscode());
        sfaVisitPlanInfoEntity.setCreatePosName(userRedis.getPosname());
    }

    public String getVisitPlanCode() {
        return this.visitPlanCode;
    }

    public String getVisitUserName() {
        return this.visitUserName;
    }

    public String getVisitRealName() {
        return this.visitRealName;
    }

    public String getVisitPosCode() {
        return this.visitPosCode;
    }

    public String getVisitPosName() {
        return this.visitPosName;
    }

    public String getVisitOrgCode() {
        return this.visitOrgCode;
    }

    public String getVisitOrgName() {
        return this.visitOrgName;
    }

    public String getParentOrgCode() {
        return this.parentOrgCode;
    }

    public String getParentOrgName() {
        return this.parentOrgName;
    }

    public String getVisitDate() {
        return this.visitDate;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public String getRouteType() {
        return this.routeType;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getClientPhoto() {
        return this.clientPhoto;
    }

    public String getClientContacts() {
        return this.clientContacts;
    }

    public String getClientPhone() {
        return this.clientPhone;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public String getVisitStatus() {
        return this.visitStatus;
    }

    public SfaVisitPlanInfoEntity setRedisHashKey(String redisHashKey) {
        this.redisHashKey = redisHashKey;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitPlanCode(String visitPlanCode) {
        this.visitPlanCode = visitPlanCode;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitUserName(String visitUserName) {
        this.visitUserName = visitUserName;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitRealName(String visitRealName) {
        this.visitRealName = visitRealName;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitPosCode(String visitPosCode) {
        this.visitPosCode = visitPosCode;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitPosName(String visitPosName) {
        this.visitPosName = visitPosName;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitOrgCode(String visitOrgCode) {
        this.visitOrgCode = visitOrgCode;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitOrgName(String visitOrgName) {
        this.visitOrgName = visitOrgName;
        return this;
    }

    public SfaVisitPlanInfoEntity setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
        return this;
    }

    public SfaVisitPlanInfoEntity setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitDate(String visitDate) {
        this.visitDate = visitDate;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitType(String visitType2) {
        this.visitType = visitType2;
        return this;
    }

    public SfaVisitPlanInfoEntity setRouteType(String routeType) {
        this.routeType = routeType;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientCode(String clientCode) {
        this.clientCode = clientCode;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientType(String clientType2) {
        this.clientType = clientType2;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientPhoto(String clientPhoto) {
        this.clientPhoto = clientPhoto;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientContacts(String clientContacts) {
        this.clientContacts = clientContacts;
        return this;
    }

    public SfaVisitPlanInfoEntity setClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
        return this;
    }

    public SfaVisitPlanInfoEntity setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
        return this;
    }

    public SfaVisitPlanInfoEntity setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
        return this;
    }

    public SfaVisitPlanInfoEntity setVisitStatus(String visitStatus2) {
        this.visitStatus = visitStatus2;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SfaVisitPlanInfoEntity)) {
            return false;
        }
        SfaVisitPlanInfoEntity other = (SfaVisitPlanInfoEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$redisHashKey = this.getRedisHashKey();
        String other$redisHashKey = other.getRedisHashKey();
        if (this$redisHashKey == null ? other$redisHashKey != null : !this$redisHashKey.equals(other$redisHashKey)) {
            return false;
        }
        String this$visitPlanCode = this.getVisitPlanCode();
        String other$visitPlanCode = other.getVisitPlanCode();
        if (this$visitPlanCode == null ? other$visitPlanCode != null : !this$visitPlanCode.equals(other$visitPlanCode)) {
            return false;
        }
        String this$visitUserName = this.getVisitUserName();
        String other$visitUserName = other.getVisitUserName();
        if (this$visitUserName == null ? other$visitUserName != null : !this$visitUserName.equals(other$visitUserName)) {
            return false;
        }
        String this$visitRealName = this.getVisitRealName();
        String other$visitRealName = other.getVisitRealName();
        if (this$visitRealName == null ? other$visitRealName != null : !this$visitRealName.equals(other$visitRealName)) {
            return false;
        }
        String this$visitPosCode = this.getVisitPosCode();
        String other$visitPosCode = other.getVisitPosCode();
        if (this$visitPosCode == null ? other$visitPosCode != null : !this$visitPosCode.equals(other$visitPosCode)) {
            return false;
        }
        String this$visitPosName = this.getVisitPosName();
        String other$visitPosName = other.getVisitPosName();
        if (this$visitPosName == null ? other$visitPosName != null : !this$visitPosName.equals(other$visitPosName)) {
            return false;
        }
        String this$visitOrgCode = this.getVisitOrgCode();
        String other$visitOrgCode = other.getVisitOrgCode();
        if (this$visitOrgCode == null ? other$visitOrgCode != null : !this$visitOrgCode.equals(other$visitOrgCode)) {
            return false;
        }
        String this$visitOrgName = this.getVisitOrgName();
        String other$visitOrgName = other.getVisitOrgName();
        if (this$visitOrgName == null ? other$visitOrgName != null : !this$visitOrgName.equals(other$visitOrgName)) {
            return false;
        }
        String this$parentOrgCode = this.getParentOrgCode();
        String other$parentOrgCode = other.getParentOrgCode();
        if (this$parentOrgCode == null ? other$parentOrgCode != null : !this$parentOrgCode.equals(other$parentOrgCode)) {
            return false;
        }
        String this$parentOrgName = this.getParentOrgName();
        String other$parentOrgName = other.getParentOrgName();
        if (this$parentOrgName == null ? other$parentOrgName != null : !this$parentOrgName.equals(other$parentOrgName)) {
            return false;
        }
        String this$visitDate = this.getVisitDate();
        String other$visitDate = other.getVisitDate();
        if (this$visitDate == null ? other$visitDate != null : !this$visitDate.equals(other$visitDate)) {
            return false;
        }
        String this$visitType = this.getVisitType();
        String other$visitType = other.getVisitType();
        if (this$visitType == null ? other$visitType != null : !this$visitType.equals(other$visitType)) {
            return false;
        }
        String this$routeType = this.getRouteType();
        String other$routeType = other.getRouteType();
        if (this$routeType == null ? other$routeType != null : !this$routeType.equals(other$routeType)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$clientAddress = this.getClientAddress();
        String other$clientAddress = other.getClientAddress();
        if (this$clientAddress == null ? other$clientAddress != null : !this$clientAddress.equals(other$clientAddress)) {
            return false;
        }
        String this$clientPhoto = this.getClientPhoto();
        String other$clientPhoto = other.getClientPhoto();
        if (this$clientPhoto == null ? other$clientPhoto != null : !this$clientPhoto.equals(other$clientPhoto)) {
            return false;
        }
        String this$clientContacts = this.getClientContacts();
        String other$clientContacts = other.getClientContacts();
        if (this$clientContacts == null ? other$clientContacts != null : !this$clientContacts.equals(other$clientContacts)) {
            return false;
        }
        String this$clientPhone = this.getClientPhone();
        String other$clientPhone = other.getClientPhone();
        if (this$clientPhone == null ? other$clientPhone != null : !this$clientPhone.equals(other$clientPhone)) {
            return false;
        }
        BigDecimal this$longitude = this.getLongitude();
        BigDecimal other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        BigDecimal this$latitude = this.getLatitude();
        BigDecimal other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        String this$visitStatus = this.getVisitStatus();
        String other$visitStatus = other.getVisitStatus();
        return !(this$visitStatus == null ? other$visitStatus != null : !this$visitStatus.equals(other$visitStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SfaVisitPlanInfoEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $redisHashKey = this.getRedisHashKey();
        result = result * 59 + ($redisHashKey == null ? 43 : $redisHashKey.hashCode());
        String $visitPlanCode = this.getVisitPlanCode();
        result = result * 59 + ($visitPlanCode == null ? 43 : $visitPlanCode.hashCode());
        String $visitUserName = this.getVisitUserName();
        result = result * 59 + ($visitUserName == null ? 43 : $visitUserName.hashCode());
        String $visitRealName = this.getVisitRealName();
        result = result * 59 + ($visitRealName == null ? 43 : $visitRealName.hashCode());
        String $visitPosCode = this.getVisitPosCode();
        result = result * 59 + ($visitPosCode == null ? 43 : $visitPosCode.hashCode());
        String $visitPosName = this.getVisitPosName();
        result = result * 59 + ($visitPosName == null ? 43 : $visitPosName.hashCode());
        String $visitOrgCode = this.getVisitOrgCode();
        result = result * 59 + ($visitOrgCode == null ? 43 : $visitOrgCode.hashCode());
        String $visitOrgName = this.getVisitOrgName();
        result = result * 59 + ($visitOrgName == null ? 43 : $visitOrgName.hashCode());
        String $parentOrgCode = this.getParentOrgCode();
        result = result * 59 + ($parentOrgCode == null ? 43 : $parentOrgCode.hashCode());
        String $parentOrgName = this.getParentOrgName();
        result = result * 59 + ($parentOrgName == null ? 43 : $parentOrgName.hashCode());
        String $visitDate = this.getVisitDate();
        result = result * 59 + ($visitDate == null ? 43 : $visitDate.hashCode());
        String $visitType = this.getVisitType();
        result = result * 59 + ($visitType == null ? 43 : $visitType.hashCode());
        String $routeType = this.getRouteType();
        result = result * 59 + ($routeType == null ? 43 : $routeType.hashCode());
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $clientAddress = this.getClientAddress();
        result = result * 59 + ($clientAddress == null ? 43 : $clientAddress.hashCode());
        String $clientPhoto = this.getClientPhoto();
        result = result * 59 + ($clientPhoto == null ? 43 : $clientPhoto.hashCode());
        String $clientContacts = this.getClientContacts();
        result = result * 59 + ($clientContacts == null ? 43 : $clientContacts.hashCode());
        String $clientPhone = this.getClientPhone();
        result = result * 59 + ($clientPhone == null ? 43 : $clientPhone.hashCode());
        BigDecimal $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        BigDecimal $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        String $visitStatus = this.getVisitStatus();
        result = result * 59 + ($visitStatus == null ? 43 : $visitStatus.hashCode());
        return result;
    }

    private static class Instance {
        private static final SfaVisitPlanInfoEntity instance = new SfaVisitPlanInfoEntity();

        private Instance() {
        }
    }
}

