/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.SfaCustomerInventoryRecordsMapper;
import com.biz.crm.customer.service.SfaCustomerInventoryRecordsService;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerInventoryRecordsRespVo;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SfaCustomerInventoryRecordsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCustomerInventoryRecordsMapper, SfaVisitStepStockInventoryEntity>
implements SfaCustomerInventoryRecordsService {
    private static final Logger log = LoggerFactory.getLogger(SfaCustomerInventoryRecordsServiceImpl.class);
    @Autowired
    private SfaCustomerInventoryRecordsMapper sfacustomerInventoryRecordsMapper;

    @Override
    public SfaCustomerInventoryRecordsRespVo findInventoryRecords(String clientCode) {
        Page page = new Page(1L, 2L);
        List<SfaCustomerInventoryRecordsRespVo> records = this.sfacustomerInventoryRecordsMapper.findInventoryRecords((Page<SfaCustomerInventoryRecordsRespVo>)page, clientCode);
        if (ObjectUtils.isEmpty(records)) {
            return new SfaCustomerInventoryRecordsRespVo();
        }
        if (records.size() == 1) {
            return records.get(0).setQuantityDifference(records.get(0).getQuantity());
        }
        SfaCustomerInventoryRecordsRespVo respVo = records.get(0);
        BigDecimal thisQuantity = new BigDecimal(records.get(0).getQuantity());
        BigDecimal lastQuantity = new BigDecimal(records.get(1).getQuantity());
        respVo.setQuantityDifference(thisQuantity.subtract(lastQuantity).toString());
        return respVo;
    }
}

