/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitExceptionReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitInOutReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExceptionResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.SfaVisitStepStockVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitController"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u65e5\u7a0b\u9875\u9762-\u62dc\u8bbf\u6267\u884c"})
public class SfaVisitController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitController.class);
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource(name="sfaVisitDealerDetailServiceImpl")
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;
    @Resource
    private RedisService redisService;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource(name="sfaVisitStepStockInventoryServiceImpl")
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;
    @Resource(name="sfaVisitStepColletServiceImpl")
    private ISfaVisitStepColletService sfaVisitStepColletService;
    @Resource(name="sfaVisitStepOrderServiceImpl")
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource(name="sfaVisitStepStoreCheckServiceImpl")
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;
    @Resource(name="sfaVisitStepActivityExecutionServiceImpl")
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private Map<String, AbstractVisitStepRedisExecutor> visitStepExecutors;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6307\u5b9a\u65e5\u671f\u7684\u62dc\u8bbf\u5217\u8868")
    @PostMapping(value={"/getVisitInfoList"})
    @CrmLog
    public Result<SfaVisitResp> getVisitInfoList(@RequestBody GetVisitListReq req) {
        if (StringUtils.isEmpty((String)req.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            req.setVisitUserName(userRedis.getUsername());
            req.setVisitPositionCode(userRedis.getPoscode());
        }
        AssertUtils.isNotEmpty((String)req.getVisitDate(), (String)"\u8bf7\u9009\u62e9\u62dc\u8bbf\u65e5\u671f");
        AssertUtils.isNotEmpty((String)req.getLongitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        AssertUtils.isNotEmpty((String)req.getLatitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        return Result.ok((Object)this.sfaVisitPlanInfoService.getVisitInfoList(req));
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u62dc\u8bbf\u6b65\u9aa4\u5217\u8868")
    @GetMapping(value={"/findRoleDirectoryList/{redisHashKey}"})
    @CrmLog
    @CrmDictMethod
    public Result<List<SfaVisitRoleDirectoryRespVo>> findRoleDirectoryList(@PathVariable(value="redisHashKey") String redisHashKey) {
        List<SfaVisitRoleDirectoryRespVo> result = this.sfaVisitRoleDirectoryService.findVisitRoleDirectoryList(redisHashKey);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u4fe1\u606f")
    @PostMapping(value={"/queryVisitInfo"})
    @Deprecated
    @CrmLog
    public Result<SfaVisitDealerDetailRespVo> queryVisitInfo(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        SfaVisitDealerDetailRespVo respVo = this.sfaVisitDealerDetailService.query(sfaVisitDealerDetailReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u62dc\u8bbf-\u67e5\u8be2\u62dc\u8bbf\u5ba2\u6237\u4fe1\u606f\u3001\u6b65\u9aa4\u5217\u8868")
    @PostMapping(value={"/getVisitSteps"})
    @CrmLog
    public Result<SfaVisitExecuteResp> getVisitSteps(@RequestBody CrmRedisHashKeyVo redisHashKeyVo) {
        return Result.ok((Object)this.sfaVisitDealerDetailService.getVisitSteps(redisHashKeyVo));
    }

    @ApiOperation(value="\u62dc\u8bbf\u8fdb\u5e97\u6253\u5361")
    @PostMapping(value={"/visitInStore"})
    @CrmLog
    public Result visitInStore(@RequestBody SfaVisitInOutReq inOutReq) {
        this.sfaVisitDealerDetailService.visitInStore(inOutReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u79bb\u5e97\u6253\u5361")
    @PostMapping(value={"/visitOutStore"})
    @CrmLog
    public Result visitOutStore(@RequestBody SfaVisitInOutReq inOutReq) {
        this.sfaVisitDealerDetailService.visitOutStore(inOutReq);
        return Result.ok();
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u8fdb\u5e97\u6253\u5361")
    @PostMapping(value={"/inStoreSave"})
    @Deprecated
    public Result inStoreSave(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        String businessId = this.sfaVisitDealerDetailService.inStoreSave(reqVo);
        HashMap map = Maps.newHashMap();
        map.put("id", businessId);
        return Result.ok((Object)map);
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u79bb\u5e97\u6253\u5361")
    @PostMapping(value={"/outStoreUpdate"})
    @Deprecated
    public Result outStoreUpdate(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setOutStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.sfaVisitDealerDetailService.outStoreUpdate(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u8ba1\u5212\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @Deprecated
    public Result<PageResult<SfaVisitPlanInfoRespVo>> list(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u8bf7\u9009\u62e9\u67e5\u770b\u62dc\u8bbf\u65e5\u671f");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        PageResult<SfaVisitPlanInfoRespVo> result = this.sfaVisitPlanInfoService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u65e5\u62dc\u8bbf\u8fdb\u5ea6")
    @PostMapping(value={"/progress"})
    @CrmLog
    @Deprecated
    public Result<SfaVisitProgressRespVo> visitProgress(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitDate())) {
            sfaVisitPlanInfoReqVo.setVisitDate(DateUtil.formatDate());
        }
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            sfaVisitPlanInfoReqVo.setVisitUserName(userName);
        }
        SfaVisitProgressRespVo sfaVisitProgressRespVo = this.sfaVisitPlanInfoService.visitProgress(sfaVisitPlanInfoReqVo);
        return Result.ok((Object)sfaVisitProgressRespVo);
    }

    @ApiOperation(value="\u63d0\u4ea4\u62dc\u8bbf\u603b\u7ed3")
    @PostMapping(value={"/update"})
    @Deprecated
    @CrmLog
    public Result update(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        this.sfaVisitDealerDetailService.update(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u62dc\u8bbf\u603b\u7ed3")
    @PostMapping(value={"/saveVisitStepSummary"})
    @CrmLog
    public Result saveVisitStepSummary(@RequestBody VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("summaryVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[summary]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        visitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u62dc\u8bbf\u603b\u7ed3-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepSummary"})
    @CrmLog
    public Result<SummaryStepExecuteDataResp> loadVisitStepSummary(@RequestBody ExecutorLoadReq redisHashKey) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("summaryVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[summary]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        SummaryStepExecuteDataResp dataResp = (SummaryStepExecuteDataResp)visitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u8fdb\u5e97\u5f02\u5e38\u63d0\u62a5")
    @PostMapping(value={"/storeExceptionSave"})
    @Deprecated
    @CrmLog
    public Result storeExceptionSave(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setExceptionTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.sfaVisitDealerDetailService.storeExceptionSave(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u5f02\u5e38\u63d0\u62a5")
    @PostMapping(value={"/visitException"})
    @CrmLog
    public Result<SfaVisitExceptionResp> visitException(@RequestBody SfaVisitExceptionReq exceptionReq) {
        return Result.ok((Object)this.sfaVisitDealerDetailService.visitException(exceptionReq));
    }

    @ApiOperation(value="(\u5c0f\u5730\u56fe)\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f")
    @PostMapping(value={"/findSfaVisitDealerVisitComplete"})
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findSfaVisitDealerVisitComplete(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitDealerDetailRespVos = this.sfaVisitDealerDetailService.findSfaVisitMapComplete(reqVo);
        return Result.ok(sfaVisitDealerDetailRespVos);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e93\u5b58\u76d8\u70b9")
    @PostMapping(value={"/saveVisitStockList"})
    @Deprecated
    @CrmLog
    public Result saveVisitStockList(@RequestBody SfaVisitStepStockVo sfaVisitStepStockVo) {
        this.sfaVisitStepStockInventoryService.saveVisitStockList(sfaVisitStepStockVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e93\u5b58\u76d8\u70b9")
    @PostMapping(value={"/saveVisitStepStockInventory"})
    @CrmLog
    public Result saveVisitStepStockInventory(@RequestBody VisitStepExecuteReq<StockInventoryStepExecuteData> visitStepExecuteReq) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("stockVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[stock]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        visitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e93\u5b58\u76d8\u70b9-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepStockInventory"})
    @CrmLog
    public Result<StockInventoryStepExecuteDataResp> loadVisitStepStockInventory(@RequestBody ExecutorLoadReq redisHashKey) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("stockVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[stock]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)visitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u7ade\u54c1\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepCollet"})
    @Deprecated
    @CrmLog
    public Result saveVisitStepCollet(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
        this.sfaVisitStepColletService.saveVisitStepCollet(sfaVisitStepColletReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u7ade\u54c1\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepCompetitor"})
    @CrmLog
    public Result saveVisitStepCompetitor(@RequestBody VisitStepExecuteReq<CompetitorStepExecuteData> visitStepExecuteReq) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("competitorVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[competitor]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        visitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u7ade\u54c1\u91c7\u96c6-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepCompetitor"})
    @CrmLog
    public Result<CompetitorStepExecuteDataResp> loadVisitStepCompetitor(@RequestBody ExecutorLoadReq redisHashKey) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("competitorVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[competitor]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)visitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u8ba2\u5355\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepOrder"})
    @Deprecated
    @CrmLog
    public Result saveVisitStepOrder(@RequestBody SfaVisitStepOrderReqVo orderReqVo) {
        this.sfaVisitStepOrderService.saveVisitOrder(orderReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u8ba2\u5355\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepOrders"})
    @CrmLog
    public Result saveVisitStepOrder(@RequestBody VisitStepExecuteReq<OrderStepExecuteData> visitStepExecuteReq) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("orderVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[order]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        visitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u8ba2\u5355\u91c7\u96c6-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepOrders"})
    @CrmLog
    public Result<OrderStepExecuteDataResp> loadVisitStepOrder(@RequestBody ExecutorLoadReq redisHashKey) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("orderVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[order]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)visitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e97\u9762\u68c0\u67e5")
    @PostMapping(value={"/saveVisitStepStoreCheck"})
    @CrmLog
    public Result saveVisitStepStoreCheck(@RequestBody VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("storeCheckVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[storeCheck]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        visitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e97\u9762\u68c0\u67e5-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepStoreCheck"})
    @CrmLog
    public Result<StoreCheckStepExecuteDataResp> loadVisitStepStoreCheck(@RequestBody ExecutorLoadReq redisHashKey) {
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get("storeCheckVisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[storeCheck]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)visitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @CrmLog
    @ApiOperation(value="\u62dc\u8bbf\u6d3b\u52a8\u6267\u884c\u5217\u8868")
    @PostMapping(value={"findVisitActivityExecutionList"})
    public Result<PageResult<SfaActivityExecutionEntityResp>> findVisitActivityExecutionList(@RequestBody LoadVisitActivityListReq reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActivityType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getRedisHashKey(), (String)"redisHashKey");
        PageResult<SfaActivityExecutionEntityResp> pageResult = this.sfaVisitStepActivityExecutionService.loadVisitActivityList(reqVo);
        return Result.ok(pageResult);
    }

    @CrmLog
    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u6d3b\u52a8\u6267\u884c\u660e\u7ec6")
    @Deprecated
    @PostMapping(value={"queryVisitActivityExecutionDetailById"})
    public Result<SfaActivityExecutionRespVo> queryVisitActivityExecutionDetailById(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaVisitStepActivityExecutionService.queryVisitActivityExecutionDetailById(reqVo);
        return Result.ok((Object)sfaActivityExecutionRespVo);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u6d3b\u52a8\u6267\u884c")
    @PostMapping(value={"/saveVisitStepActivity"})
    @CrmLog
    public Result saveVisitStepActivity(@RequestBody VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)visitStepExecuteReq.getStepExecuteData().getActivityType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get(visitStepExecuteReq.getStepExecuteData().getActivityType() + "VisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[" + visitStepExecuteReq.getStepExecuteData().getActivityType() + "]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        visitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u6d3b\u52a8\u6267\u884c-\u67e5\u8be2\u8868\u5355\u6267\u884c\u6570\u636e")
    @PostMapping(value={"/loadVisitStepActivity"})
    @CrmLog
    public Result<ActivityStepExecuteDataResp> loadVisitStepActivity(@RequestBody ActivityExecutorLoadReq redisHashKey) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)redisHashKey.getActivityType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        AbstractVisitStepRedisExecutor visitStepExecutor = this.visitStepExecutors.get(redisHashKey.getActivityType() + "VisitStepExecutor");
        if (null == visitStepExecutor) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u6b65\u9aa4[" + redisHashKey.getActivityType() + "]\u7684\u6267\u884c\u5668\u5b9e\u4f8b\uff01");
        }
        ActivityStepExecuteDataResp dataResp = (ActivityStepExecuteDataResp)visitStepExecutor.load(redisHashKey);
        return Result.ok((Object)dataResp);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6267\u884c-\u6d3b\u52a8\u6267\u884c(\u9648\u5217\uff0c\u8d39\u7528\u6d3b\u52a8\u6267\u884c)")
    @PostMapping(value={"/saveVisitActivityExecutionForVisit"})
    @Deprecated
    @CrmLog
    public Result saveVisitActivityExecutionForVisit(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        this.sfaVisitStepActivityExecutionService.saveVisitActivityExecutionForVisit(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u62dc\u8bbf\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/queryVisitDetailInfo"})
    @Deprecated
    @CrmLog
    public Result<SfaVisitDealerDetailRespVo> queryVisitDetailInfo(@RequestParam String id) {
        SfaVisitDealerDetailRespVo respVo = this.sfaVisitDealerDetailService.queryVisitDetailInfo(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u6b65\u9aa4\u8be6\u60c5")
    @PostMapping(value={"/findVisitDetail"})
    @CrmLog
    @CrmDictMethod
    public Result<List<SfaVisitRoleDirectoryRespVo>> findVisitDetail(@RequestBody FindVisitDetailReqVo reqVo) {
        reqVo.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
        List<SfaVisitRoleDirectoryRespVo> result = this.sfaVisitRoleDirectoryService.findVisitDetail(reqVo);
        return Result.ok(result);
    }
}

