/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component;

import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.VisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import java.time.LocalDate;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractVisitStepRedisExecutor<ExecuteReq extends VisitStepExecuteReq.StepExecuteDataReq, Resp extends StepExecuteDataResp, LoadParam extends ExecutorLoadReq>
implements VisitStepExecutor<ExecuteReq, Resp, LoadParam> {
    @Resource
    protected RedisService redisService;
    @Resource
    protected ISfaVisitStepFromService sfaVisitStepFromService;

    @Override
    public Resp load(LoadParam loadParam) {
        if (StringUtils.isBlank((CharSequence)((ExecutorLoadReq)((Object)loadParam)).getFormId())) {
            throw new BusinessException("\u8868\u5355id\u4e3a\u7a7a");
        }
        Resp resp = this.doLoad(loadParam);
        this.loadFormData((ExecutorLoadReq)((Object)loadParam), (StepExecuteDataResp)resp);
        return resp;
    }

    protected abstract Resp doLoad(LoadParam var1);

    public abstract void transToEs(ExecutorLoadReq var1);

    protected void loadFormData(ExecutorLoadReq loadParam, StepExecuteDataResp resp) {
        SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(loadParam.getFormId());
        resp.setSfaVisitStepFrom(fromRespVo);
    }

    protected SfaVisitStepFromRespVo getFormData(ExecutorLoadReq loadParam) {
        return this.sfaVisitStepFromService.queryById(loadParam.getFormId());
    }

    protected void updateStepStatus(String redisHashKey, String stepCode) {
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData)((Object)this.redisService.hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate).toString(), (Object)redisHashKey));
        this.changeStepStatus(sfaVisitPlanInfoRedisData, stepCode);
        this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(nowDate).toString(), sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), 691200L);
    }

    protected void changeStepStatus(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData, String stepCode) {
        if (StringUtils.isBlank((CharSequence)stepCode)) {
            throw new BusinessException("\u6b65\u9aa4\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7c7b\u578b");
        }
        List<VisitStepResp> steps = sfaVisitPlanInfoRedisData.getStep();
        if (null == steps) {
            return;
        }
        for (VisitStepResp step : steps) {
            if (!stepCode.equals(step.getPageCode())) continue;
            step.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            step.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            break;
        }
    }

    protected SfaVisitPlanInfoEntity loadAndCheckSfaVisitPlanInfoEntity(String redisHashKey) {
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)this.redisService.hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(nowDate).toString(), (Object)redisHashKey));
        if (null == sfaVisitPlanInfoEntity) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u62dc\u8bbf\u8ba1\u5212\uff0c\u6216\u8be5\u8ba1\u5212\u4e0d\u5728\u4eca\u65e5\u8ba1\u5212\u5185\uff01");
        }
        UserRedis userRedis = UserUtils.getUser();
        if (!StringUtils.equals((CharSequence)sfaVisitPlanInfoEntity.getVisitPosCode(), (CharSequence)userRedis.getPoscode())) {
            throw new BusinessException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\u6216\u5207\u6362\u804c\u4f4d\u518d\u5c1d\u8bd5\uff01");
        }
        return sfaVisitPlanInfoEntity;
    }

    protected void check(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        if (StringUtils.isBlank((CharSequence)visitStepExecuteReq.getRedisHashKey())) {
            throw new BusinessException("\u8bf7\u6307\u5b9aredisHashKey");
        }
    }
}

