/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component;

import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class SfaVisitPlanExecuteContext {
    private boolean dataReady = true;
    private String dataReadyMsg;
    private Map<String, List<SfaVisitPlanEntity>> userPosMapPlan;
    private Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange;
    private SfaVisitPlanEntity currentPlanEntity;
    private LocalDate visitDate;
    private LocalDate visitStartDate;
    private LocalDate visitEndDate;
    private Map<String, FuturePlanInfo> planCodeMapFuturePlanInfo;

    public void setUserPosMapPlan(Map<String, List<SfaVisitPlanEntity>> userPosMapPlan) {
        this.userPosMapPlan = userPosMapPlan;
        if (CollectionUtils.isEmpty(userPosMapPlan)) {
            this.dataReady = false;
            this.dataReadyMsg = "\u6ca1\u6709\u53ef\u6267\u884c\u7684\u62dc\u8bbf\u8ba1\u5212\u914d\u7f6e\u6570\u636e";
        }
    }

    public void clean() {
        this.planCodeMapFuturePlanInfo = Maps.newHashMap();
        this.currentPlanEntity = null;
        this.visitDate = null;
        this.visitStartDate = null;
        this.visitEndDate = null;
    }

    public boolean isDataReady() {
        return this.dataReady;
    }

    public String getDataReadyMsg() {
        return this.dataReadyMsg;
    }

    public void setDataReadyMsg(String dataReadyMsg) {
        this.dataReadyMsg = dataReadyMsg;
    }

    public Map<String, List<SfaVisitPlanEntity>> getUserPosMapPlan() {
        return this.userPosMapPlan;
    }

    public Map<String, List<SfaVisitPlanRangeEntity>> getPlanCodeMapPlanRange() {
        return this.planCodeMapPlanRange;
    }

    public void setPlanCodeMapPlanRange(Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange) {
        this.planCodeMapPlanRange = planCodeMapPlanRange;
    }

    public SfaVisitPlanEntity getCurrentPlanEntity() {
        return this.currentPlanEntity;
    }

    public void setCurrentPlanEntity(SfaVisitPlanEntity currentPlanEntity) {
        this.currentPlanEntity = currentPlanEntity;
    }

    public LocalDate getVisitDate() {
        return this.visitDate;
    }

    public void setVisitDate(LocalDate visitDate) {
        this.visitDate = visitDate;
    }

    public LocalDate getVisitStartDate() {
        return this.visitStartDate;
    }

    public void setVisitStartDate(LocalDate visitStartDate) {
        this.visitStartDate = visitStartDate;
    }

    public LocalDate getVisitEndDate() {
        return this.visitEndDate;
    }

    public void setVisitEndDate(LocalDate visitEndDate) {
        this.visitEndDate = visitEndDate;
    }

    public Map<String, FuturePlanInfo> getPlanCodeMapFuturePlanInfo() {
        return this.planCodeMapFuturePlanInfo;
    }

    public void setPlanCodeMapFuturePlanInfo(Map<String, FuturePlanInfo> planCodeMapFuturePlanInfo) {
        this.planCodeMapFuturePlanInfo = planCodeMapFuturePlanInfo;
    }

    public static class FuturePlanInfo
    extends HashMap<String, List<SfaVisitPlanInfoEntity>> {
        public List<SfaVisitPlanInfoEntity> getPlan(LocalDate visitDate) {
            if (null == visitDate) {
                return Lists.newArrayList();
            }
            List data = (List)this.get(visitDate.format(CrmDateUtils.yyyyMMdd));
            if (null == data) {
                data = Lists.newArrayList();
            }
            return data;
        }

        public void putPlan(LocalDate visitDate, List<SfaVisitPlanInfoEntity> newData) {
            if (null == visitDate) {
                return;
            }
            if (CollectionUtils.isEmpty(newData)) {
                return;
            }
            this.put(visitDate.format(CrmDateUtils.yyyyMMdd), newData);
        }
    }
}

