/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksummary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSummaryEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryAtLogRespVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryCommentRespVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPictureRespVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPrimaryRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryAtLogMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryCommentMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryLikeMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryPictureMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryPrimaryMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryScopeMapper;
import com.biz.crm.worksummary.model.SfaWorkSummaryAtLogEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryLikeEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryPictureEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryPrimaryEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryScopeEntity;
import com.biz.crm.worksummary.service.ISfaWorkSummaryPrimaryService;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSummaryServiceExpandImpl"})
public class SfaWorkSummaryPrimaryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSummaryPrimaryMapper, SfaWorkSummaryPrimaryEntity>
implements ISfaWorkSummaryPrimaryService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryPrimaryServiceImpl.class);
    @Resource
    private SfaWorkSummaryPrimaryMapper sfaWorkSummaryPrimaryMapper;
    @Autowired
    private SfaWorkSummaryPictureMapper sfaWorkSummaryPictureMapper;
    @Autowired
    private SfaWorkSummaryAtLogMapper sfaWorkSummaryAtLogMapper;
    @Autowired
    private SfaWorkSummaryScopeMapper sfaWorkSummaryScopeMapper;
    @Autowired
    private SfaWorkSummaryCommentMapper sfaWorkSummaryCommentMapper;
    @Autowired
    private SfaWorkSummaryLikeMapper sfaWorkSummaryLikeMapper;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaWorkSummaryPrimaryRespVo> findList(SfaWorkSummaryPrimaryReqVo reqVo) {
        reqVo.setIds((List)Lists.newArrayList());
        UserRedis currUser = UserUtils.getUser();
        reqVo.setCurrAccount(currUser.getUsername());
        String currOrgcode = currUser.getOrgcode();
        String currPoscode = currUser.getPoscode();
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        String queryType = reqVo.getQueryType();
        if (SfaWorkSummaryEnum.QueryType.AT.getVal().equals(queryType)) {
            Page atLogPage = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
            List<SfaWorkSummaryAtLogRespVo> atLogList = this.sfaWorkSummaryAtLogMapper.findAtLogList((Page<SfaWorkSummaryAtLogRespVo>)atLogPage, reqVo);
            atLogList.forEach(o -> reqVo.getIds().add(o.getSummaryId()));
            page.setTotal(atLogPage.getTotal());
        }
        if (SfaWorkSummaryEnum.QueryType.COMMENT.getVal().equals(queryType)) {
            Page commentPage = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
            List<SfaWorkSummaryCommentRespVo> commentList = this.sfaWorkSummaryCommentMapper.findCommentList((Page<SfaWorkSummaryCommentRespVo>)commentPage, reqVo);
            commentList.forEach(o -> reqVo.getIds().add(o.getSummaryId()));
            page.setTotal(commentPage.getTotal());
        }
        List<SfaWorkSummaryPrimaryRespVo> list = null;
        if (!SfaWorkSummaryEnum.QueryType.AT.getVal().equals(queryType) && !SfaWorkSummaryEnum.QueryType.COMMENT.getVal().equals(queryType)) {
            List orgRespVos = null;
            List posRespVos = null;
            MdmPositionUserOrgReqVo posQueryVo = new MdmPositionUserOrgReqVo();
            posQueryVo.setParentCode(currPoscode);
            posQueryVo.setIncludeEmptyUserPosition(Boolean.valueOf(false));
            HashSet scopeArray = Sets.newHashSet();
            if (StringUtils.isEmpty((Object)queryType)) {
                orgRespVos = OrgUtil.getParentOrgListIncludeSelf((String)currOrgcode);
                orgRespVos.forEach(o -> scopeArray.add(o.getOrgCode()));
                posRespVos = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(posQueryVo));
                posRespVos.forEach(o -> scopeArray.add(o.getPositionCode()));
                scopeArray.add(SfaWorkSummaryEnum.ScopeType.ALL.getVal());
                scopeArray.add(currUser.getUsername());
            } else if (SfaWorkSummaryEnum.QueryType.SELF.getVal().equals(queryType)) {
                scopeArray.add(currUser.getUsername());
                reqVo.setCreateCode(currUser.getUsername());
            } else if (SfaWorkSummaryEnum.QueryType.POSITION.getVal().equals(queryType)) {
                posRespVos = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(posQueryVo));
                posRespVos.forEach(o -> scopeArray.add(o.getPositionCode()));
            }
            reqVo.setScopeArray((Set)scopeArray);
            list = this.sfaWorkSummaryPrimaryMapper.findListByAuth((Page<SfaWorkSummaryPrimaryRespVo>)page, reqVo);
        } else if (!CollectionUtils.isEmpty((Collection)reqVo.getIds())) {
            list = this.sfaWorkSummaryPrimaryMapper.findListByIds(reqVo);
        }
        if (!CollectionUtils.isEmpty(list)) {
            HashSet createCodes = Sets.newHashSet();
            ArrayList ids = Lists.newArrayList();
            ArrayList summaryIds = Lists.newArrayList();
            list.forEach(o -> {
                createCodes.add(o.getCreateCode());
                ids.add(o.getId());
                if (!StringUtils.isEmpty((Object)o.getSummaryId())) {
                    summaryIds.add(o.getSummaryId());
                    ids.add(o.getSummaryId());
                }
            });
            ArrayList atLogRespVos = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : this.sfaWorkSummaryAtLogMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap = atLogRespVos.stream().collect(Collectors.groupingBy(SfaWorkSummaryAtLogRespVo::getBusinessId));
            atLogRespVoMap.forEach((k, v) -> v.forEach(o -> createCodes.add(o.getAtUserCode())));
            SfaWorkSummaryPrimaryReqVo forwardQureyVo = new SfaWorkSummaryPrimaryReqVo();
            if (!CollectionUtils.isEmpty((Collection)summaryIds)) {
                forwardQureyVo.setIds((List)summaryIds);
            }
            ArrayList forwardRespVos = CollectionUtils.isEmpty((Collection)summaryIds) ? Lists.newArrayList() : this.sfaWorkSummaryPrimaryMapper.findListByIds(forwardQureyVo);
            forwardRespVos.forEach(o -> createCodes.add(o.getCreateCode()));
            Map forwardMap = forwardRespVos.stream().collect(Collectors.toMap(UuidVo::getId, Function.identity()));
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            userQueryVo.setPrimaryFlag("1");
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            ArrayList userOrgRespVos = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(userQueryVo));
            Map userOrgRespVoMap = userOrgRespVos.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity()));
            ArrayList likeRespVos = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : this.sfaWorkSummaryLikeMapper.findCountByBusinessIds(ids);
            Map likeRespVoMap = likeRespVos.stream().collect(Collectors.toMap(SfaWorkSummaryLikeRespVo::getBusinessId, Function.identity()));
            LambdaQueryWrapper buildLikeQuery = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmBaseEntity::getCreateCode, (Object)currUser.getUsername())).in(SfaWorkSummaryLikeEntity::getBusinessId, (Collection)ids);
            ArrayList summaryLikeEntities = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : this.sfaWorkSummaryLikeMapper.selectList((Wrapper)buildLikeQuery);
            Map likedMap = summaryLikeEntities.stream().collect(Collectors.toMap(SfaWorkSummaryLikeEntity::getBusinessId, Function.identity()));
            ArrayList commentRespVos = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : this.sfaWorkSummaryCommentMapper.findCountByBusinessIds(ids);
            Map commentRespVoMap = commentRespVos.stream().collect(Collectors.toMap(SfaWorkSummaryCommentRespVo::getBusinessId, Function.identity()));
            ArrayList forwardSumCountRespVos = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : this.sfaWorkSummaryPrimaryMapper.findForwardSumCountByIds(ids);
            Map forwardRespVoMap = forwardSumCountRespVos.stream().collect(Collectors.toMap(SfaWorkSummaryPrimaryRespVo::getSummaryId, Function.identity()));
            ArrayList pictureRespVos = !StringUtils.isEmpty((Object)reqVo.getIsExport()) ? Lists.newArrayList() : this.sfaWorkSummaryPictureMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryPictureRespVo>> pictureRespVoMap = pictureRespVos.stream().collect(Collectors.groupingBy(SfaWorkSummaryPictureRespVo::getBusinessId));
            list.forEach(o -> {
                if (!StringUtils.isEmpty((Object)o.getSummaryId())) {
                    SfaWorkSummaryPrimaryRespVo forwardRespVo = (SfaWorkSummaryPrimaryRespVo)forwardMap.get(o.getSummaryId());
                    this.builData(forwardRespVo, pictureRespVoMap, forwardRespVoMap, commentRespVoMap, likeRespVoMap, userOrgRespVoMap, atLogRespVoMap, likedMap);
                    o.setForwardRespVos(forwardRespVo);
                }
                this.builData((SfaWorkSummaryPrimaryRespVo)o, pictureRespVoMap, forwardRespVoMap, commentRespVoMap, likeRespVoMap, userOrgRespVoMap, atLogRespVoMap, likedMap);
                o.setLectureTypeStr((String)SfaWorkSummaryEnum.LectureType.GETMAP.get(o.getLectureType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void builData(SfaWorkSummaryPrimaryRespVo o, Map<String, List<SfaWorkSummaryPictureRespVo>> pictureRespVoMap, Map<String, SfaWorkSummaryPrimaryRespVo> forwardRespVoMap, Map<String, SfaWorkSummaryCommentRespVo> commentRespVoMap, Map<String, SfaWorkSummaryLikeRespVo> likeRespVoMap, Map<String, MdmPositionUserOrgRespVo> userOrgRespVoMap, Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap, Map<String, SfaWorkSummaryLikeEntity> likedMap) {
        SfaWorkSummaryLikeEntity summaryLikeEntity;
        List<SfaWorkSummaryAtLogRespVo> atLogArray;
        List<SfaWorkSummaryPictureRespVo> pictureList;
        SfaWorkSummaryPrimaryRespVo summaryPrimaryRespVo;
        SfaWorkSummaryCommentRespVo sfaWorkSummaryCommentRespVo;
        SfaWorkSummaryLikeRespVo likeRespVo;
        String id = o.getId();
        MdmPositionUserOrgRespVo userOrgRespVo = userOrgRespVoMap.get(o.getCreateCode());
        if (!ObjectUtils.isEmpty((Object)userOrgRespVo)) {
            o.setPhoto(userOrgRespVo.getUserHeadUrl());
        }
        if (!ObjectUtils.isEmpty((Object)(likeRespVo = likeRespVoMap.get(id)))) {
            o.setLikeSumCount(likeRespVo.getSumCount());
        }
        if (!ObjectUtils.isEmpty((Object)(sfaWorkSummaryCommentRespVo = commentRespVoMap.get(id)))) {
            o.setCommentSumCount(sfaWorkSummaryCommentRespVo.getCommentSumCount());
        }
        if (!ObjectUtils.isEmpty((Object)(summaryPrimaryRespVo = forwardRespVoMap.get(id)))) {
            o.setForwardSumCount(summaryPrimaryRespVo.getForwardSumCount());
        }
        if (!CollectionUtils.isEmpty(pictureList = pictureRespVoMap.get(id))) {
            o.setPictureRespVos(pictureList);
        }
        if (!CollectionUtils.isEmpty(atLogArray = atLogRespVoMap.get(id))) {
            atLogArray.forEach(e -> {
                MdmPositionUserOrgRespVo userRespVo = (MdmPositionUserOrgRespVo)userOrgRespVoMap.get(e.getAtUserCode());
                if (!ObjectUtils.isEmpty((Object)userRespVo)) {
                    e.setAtUserName(userRespVo.getFullName());
                }
            });
            o.setAtLogRespVos(atLogArray);
        }
        if (!ObjectUtils.isEmpty((Object)((Object)(summaryLikeEntity = likedMap.get(id))))) {
            o.setLiked("Y");
        } else {
            o.setLiked("N");
        }
    }

    @Override
    public SfaWorkSummaryPrimaryRespVo query(SfaWorkSummaryPrimaryReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSummaryPrimaryReqVo reqVo) {
        SfaWorkSummaryPrimaryEntity summaryEntity;
        UserRedis user = UserUtils.getUser();
        reqVo.setCreateCode(user.getUsername());
        this.validation(reqVo);
        if (SfaWorkSummaryEnum.IsForward.Y.getVal().equals(reqVo.getIsForward())) {
            ValidateUtils.validate((Object)reqVo.getSummaryId(), (String)"\u8f6c\u53d1\u5173\u8054\u5de5\u4f5c\u603b\u7ed3Id\u4e0d\u80fd\u4e3a\u7a7a");
            summaryEntity = (SfaWorkSummaryPrimaryEntity)((Object)this.sfaWorkSummaryPrimaryMapper.selectById((Serializable)((Object)reqVo.getSummaryId())));
            if (ObjectUtils.isEmpty((Object)((Object)summaryEntity))) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8f6c\u53d1\u5173\u8054\u7684\u5de5\u4f5c\u603b\u7ed3");
            }
            if (summaryEntity.getCreateCode().equals(user.getUsername())) {
                throw new BusinessException("\u4e0d\u80fd\u8f6c\u53d1\u81ea\u5df1\u7684\u52a8\u6001!");
            }
            reqVo.setLectureType(summaryEntity.getLectureType());
        }
        summaryEntity = (SfaWorkSummaryPrimaryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryPrimaryEntity.class));
        this.save((Object)summaryEntity);
        String dynamicId = summaryEntity.getId();
        if (!CollectionUtils.isEmpty((Collection)reqVo.getPictureReqVos())) {
            reqVo.getPictureReqVos().forEach(o -> {
                SfaWorkSummaryPictureEntity pictureEntity = (SfaWorkSummaryPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaWorkSummaryPictureEntity.class)));
                pictureEntity.setBusinessId(dynamicId);
                this.sfaWorkSummaryPictureMapper.insert((Object)pictureEntity);
            });
        }
        HashMap scopeEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)reqVo.getAtColleagueCode())) {
            reqVo.getAtColleagueCode().forEach(o -> {
                SfaWorkSummaryAtLogEntity atLogEntity = new SfaWorkSummaryAtLogEntity();
                atLogEntity.setAtUserCode((String)o);
                if (SfaWorkSummaryEnum.IsForward.Y.getVal().equals(reqVo.getIsForward())) {
                    atLogEntity.setSummaryId(reqVo.getSummaryId());
                } else {
                    atLogEntity.setSummaryId(dynamicId);
                }
                atLogEntity.setBusinessId(dynamicId);
                this.sfaWorkSummaryAtLogMapper.insert((Object)atLogEntity);
                SfaWorkSummaryScopeEntity scopeEntity = new SfaWorkSummaryScopeEntity();
                scopeEntity.setBusinessId(dynamicId);
                scopeEntity.setScopeCode((String)o);
                scopeEntity.setScopeCount(1);
                scopeEntity.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
                this.sfaWorkSummaryScopeMapper.insert((Object)scopeEntity);
                scopeEntityMap.put(o, scopeEntity);
            });
        }
        SfaWorkSummaryEnum.ScopeType scopeType = SfaWorkSummaryEnum.ScopeType.valueOf((String)reqVo.getScopeType());
        if (!SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal().equals(scopeType.getVal())) {
            SfaWorkSummaryScopeEntity scopeEntity = new SfaWorkSummaryScopeEntity();
            scopeEntity.setBusinessId(dynamicId);
            scopeEntity.setScopeCount(1);
            scopeEntity.setScopeType(scopeType.getVal());
            switch (scopeType) {
                case ALL: {
                    scopeEntity.setScopeCode(scopeType.getVal());
                    break;
                }
                case SELF_SUPERIORS: {
                    scopeEntity.setScopeCode(summaryEntity.getCreatePosCode());
                    break;
                }
                case ORG_SUBORDINATE: {
                    scopeEntity.setScopeCode(summaryEntity.getCreateOrgCode());
                    break;
                }
            }
            this.sfaWorkSummaryScopeMapper.insert((Object)scopeEntity);
        } else {
            reqVo.getScopeColleagueCode().forEach(o -> {
                SfaWorkSummaryScopeEntity scopeEntity = (SfaWorkSummaryScopeEntity)((Object)((Object)scopeEntityMap.get(o)));
                if (!ObjectUtils.isEmpty((Object)((Object)scopeEntity))) {
                    scopeEntity.setScopeCount(scopeEntity.getScopeCount() + 1);
                    this.sfaWorkSummaryScopeMapper.updateById((Object)scopeEntity);
                } else {
                    scopeEntity = new SfaWorkSummaryScopeEntity();
                    scopeEntity.setBusinessId(dynamicId);
                    scopeEntity.setScopeCode((String)o);
                    scopeEntity.setScopeCount(1);
                    scopeEntity.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
                    this.sfaWorkSummaryScopeMapper.insert((Object)scopeEntity);
                }
            });
        }
        SfaWorkSummaryScopeEntity currScope = (SfaWorkSummaryScopeEntity)((Object)scopeEntityMap.get(user.getUsername()));
        if (!ObjectUtils.isEmpty((Object)((Object)currScope))) {
            currScope.setScopeCount(currScope.getScopeCount() + 1);
            this.sfaWorkSummaryScopeMapper.updateById((Object)currScope);
        } else {
            currScope = new SfaWorkSummaryScopeEntity();
            currScope.setBusinessId(dynamicId);
            currScope.setScopeCode(user.getUsername());
            currScope.setScopeCount(1);
            currScope.setScopeType(SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal());
            this.sfaWorkSummaryScopeMapper.insert((Object)currScope);
        }
    }

    private void validation(SfaWorkSummaryPrimaryReqVo reqVo) {
        ValidateUtils.validate((Object)reqVo.getIsForward(), (String)"\u662f\u5426\u8f6c\u53d1\uff08Y/N\uff09\u6807\u793a\u4e0d\u80fd\u4e3a\u7a7a");
        String isForward = (String)SfaWorkSummaryEnum.IsForward.GETMAP.get(reqVo.getIsForward());
        ValidateUtils.validate((Object)isForward, (String)"\u662f\u5426\u8f6c\u53d1\uff08Y/N\uff09\u6807\u793a\u9519\u8bef");
        ValidateUtils.validate((Object)reqVo.getScopeType(), (String)"\u53ef\u89c1\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        String scopeType = (String)SfaWorkSummaryEnum.ScopeType.GETMAP.get(reqVo.getScopeType());
        ValidateUtils.validate((Object)scopeType, (String)"\u53ef\u89c1\u8303\u56f4\u7c7b\u578b\u9519\u8bef");
        if (SfaWorkSummaryEnum.ScopeType.COLLEAGUE.getVal().equals(reqVo.getScopeType())) {
            ValidateUtils.notEmpty((Collection)reqVo.getScopeColleagueCode(), (String)"\u81ea\u5b9a\u4e49\u6743\u9650\u7c7b\u578b\u9700\u8981\u6307\u5b9a\u4eba\u5458", (String[])new String[0]);
        }
        if (SfaWorkSummaryEnum.IsForward.N.getVal().equals(reqVo.getIsForward())) {
            String lectureType = reqVo.getLectureType();
            ValidateUtils.validate((Object)lectureType, (String)"\u603b\u7ed3\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            String lectureTypeStr = (String)SfaWorkSummaryEnum.LectureType.GETMAP.get(lectureType);
            ValidateUtils.validate((Object)lectureTypeStr, (String)"\u603b\u7ed3\u7c7b\u578b\u9519\u8bef");
            if (SfaWorkSummaryEnum.LectureType.DAILY.getVal().equals(lectureType) || SfaWorkSummaryEnum.LectureType.WEEKLY.getVal().equals(lectureType) || SfaWorkSummaryEnum.LectureType.MONTHLY.getVal().equals(lectureType)) {
                SfaWorkSummaryPrimaryRespVo sfaWorkSummaryPrimaryRespVo = this.sfaWorkSummaryPrimaryMapper.findByOnlyOne(reqVo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSummaryPrimaryReqVo reqVo) {
        SfaWorkSummaryPrimaryEntity entity = (SfaWorkSummaryPrimaryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSummaryPrimaryReqVo reqVo) {
        List sfaWorkSummaryEntities = this.sfaWorkSummaryPrimaryMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryEntities)) {
            sfaWorkSummaryEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSummaryPrimaryReqVo reqVo) {
        List sfaWorkSummaryEntities = this.sfaWorkSummaryPrimaryMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryEntities)) {
            sfaWorkSummaryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSummaryPrimaryReqVo reqVo) {
        List sfaWorkSummaryEntities = this.sfaWorkSummaryPrimaryMapper.selectBatchIds(reqVo.getIds());
        if (!CollectionUtils.isEmpty((Collection)sfaWorkSummaryEntities)) {
            sfaWorkSummaryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSummaryEntities);
    }

    @Override
    public PageResult<SfaWorkSummaryPrimaryRespVo> forwradList(SfaWorkSummaryPrimaryReqVo params) {
        Page page = new Page((long)params.getPageNum().intValue(), (long)params.getPageSize().intValue());
        List<SfaWorkSummaryPrimaryRespVo> list = this.sfaWorkSummaryPrimaryMapper.forwradList((Page<SfaWorkSummaryPrimaryRespVo>)page, params);
        if (!CollectionUtils.isEmpty(list)) {
            HashSet createCodes = Sets.newHashSet();
            ArrayList ids = Lists.newArrayList();
            list.forEach(o -> {
                createCodes.add(o.getCreateCode());
                ids.add(o.getId());
            });
            List<SfaWorkSummaryAtLogRespVo> atLogRespVos = this.sfaWorkSummaryAtLogMapper.findListByBusinessIds(ids);
            Map<String, List<SfaWorkSummaryAtLogRespVo>> atLogRespVoMap = atLogRespVos.stream().collect(Collectors.groupingBy(SfaWorkSummaryAtLogRespVo::getBusinessId));
            atLogRespVoMap.forEach((k, v) -> v.forEach(o -> createCodes.add(o.getAtUserCode())));
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            List userOrgRespVos = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(userQueryVo));
            Map userOrgRespVoMap = userOrgRespVos.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity()));
            list.forEach(o -> {
                MdmPositionUserOrgRespVo userOrgRespVo = (MdmPositionUserOrgRespVo)userOrgRespVoMap.get(o.getCreateCode());
                o.setPhoto(userOrgRespVo.getUserHeadUrl());
                List atLogArray = (List)atLogRespVoMap.get(o.getId());
                if (!CollectionUtils.isEmpty((Collection)atLogArray)) {
                    atLogArray.forEach(e -> {
                        MdmPositionUserOrgRespVo userRespVo = (MdmPositionUserOrgRespVo)userOrgRespVoMap.get(e.getAtUserCode());
                        e.setAtUserName(userRespVo.getFullName());
                    });
                    o.setAtLogRespVos(atLogArray);
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

