/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.helpdefense.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.helpdefense.mapper.SfaHelpDefenseMapper;
import com.biz.crm.helpdefense.model.SfaHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.model.SfaHelpDefenseEntity;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseDetailService;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseService;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.sfa.helpdefense.SfaHelpDefenseDto;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaHelpDefenseServiceExpandImpl"})
@Transactional
public class SfaHelpDefenseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaHelpDefenseMapper, SfaHelpDefenseEntity>
implements ISfaHelpDefenseService {
    private static final Logger log = LoggerFactory.getLogger(SfaHelpDefenseServiceImpl.class);
    @Resource
    private SfaHelpDefenseMapper sfaHelpDefenseMapper;
    @Autowired
    private ISfaHelpDefenseDetailService sfaHelpDefenseDetailService;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Override
    public PageResult<SfaHelpDefenseRespVo> findList(SfaHelpDefenseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaHelpDefenseRespVo> list = this.sfaHelpDefenseMapper.findList((Page<SfaHelpDefenseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaHelpDefenseRespVo findSfaHelpDefenseDetail(SfaHelpDefenseReqVo reqVo) {
        SfaHelpDefenseEntity sfaHelpDefenseEntity;
        SfaHelpDefenseRespVo respVo = null;
        AssertUtils.isNotEmpty((String)reqVo.getHelpDefenseDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        if (!StringUtils.isNotEmpty((String)reqVo.getHelpUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setHelpUserName(userRedis.getUsername());
            reqVo.setHelpPosCode(userRedis.getPoscode());
        }
        if ((sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaHelpDefenseEntity::getHelpUserName, (Object)reqVo.getHelpUserName())).eq(SfaHelpDefenseEntity::getHelpPosCode, (Object)reqVo.getHelpPosCode())).eq(SfaHelpDefenseEntity::getHelpDefenseDate, (Object)reqVo.getHelpDefenseDate())).one())) == null) {
            return respVo;
        }
        respVo = (SfaHelpDefenseRespVo)CrmBeanUtil.copy((Object)((Object)sfaHelpDefenseEntity), SfaHelpDefenseRespVo.class);
        this.getSfaHelpDefenseDetailList(respVo);
        return respVo;
    }

    @Override
    public SfaHelpDefenseRespVo queryDetailById(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        SfaHelpDefenseEntity sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaHelpDefenseEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u4e3a\u7a7a");
        }
        SfaHelpDefenseRespVo sfaHelpDefenseRespVo = (SfaHelpDefenseRespVo)CrmBeanUtil.copy((Object)((Object)sfaHelpDefenseEntity), SfaHelpDefenseRespVo.class);
        this.getSfaHelpDefenseDetailList(sfaHelpDefenseRespVo);
        return sfaHelpDefenseRespVo;
    }

    private void getSfaHelpDefenseDetailList(SfaHelpDefenseRespVo sfaHelpDefenseRespVo) {
        List sfaHelpDefenseDetailEntityList = ((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(SfaHelpDefenseDetailEntity::getHelpDefenseId, (Object)sfaHelpDefenseRespVo.getId())).list();
        List sfaHelpDefenseDetailRespVos = CrmBeanUtil.copyList((List)sfaHelpDefenseDetailEntityList, SfaHelpDefenseDetailRespVo.class);
        Map<String, List<SfaHelpDefenseDetailRespVo>> detailMap = sfaHelpDefenseDetailRespVos.stream().collect(Collectors.groupingBy(data -> this.fetchGroupKey((SfaHelpDefenseDetailRespVo)data)));
        ArrayList<SfaHelpDefenseDto> sfaHelpDefenseDtos = new ArrayList<SfaHelpDefenseDto>();
        for (Map.Entry<String, List<SfaHelpDefenseDetailRespVo>> map : detailMap.entrySet()) {
            SfaHelpDefenseDetailRespVo sfaHelpDefenseDetailRespVo = map.getValue().get(0);
            SfaHelpDefenseDto sfaHelpDefenseDto = (SfaHelpDefenseDto)CrmBeanUtil.copy((Object)sfaHelpDefenseDetailRespVo, SfaHelpDefenseDto.class);
            map.getValue().forEach(data -> {
                data.setHelpDefenseStatusDesc((String)SfaVisitEnum.helpDefenseStatus.GETMAP.get(data.getHelpDefenseStatus()));
                data.setClientTypeDesc((String)SfaVisitEnum.visitCusType.GETMAP.get(data.getClientType()));
            });
            sfaHelpDefenseDto.setSfaHelpDefenseDetailList(map.getValue());
            sfaHelpDefenseDtos.add(sfaHelpDefenseDto);
        }
        sfaHelpDefenseRespVo.setSfaHelpDefenseList(sfaHelpDefenseDtos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaHelpDefenseReqVo reqVo) {
        this.checkParam(reqVo);
        SfaHelpDefenseEntity entity = (SfaHelpDefenseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaHelpDefenseEntity.class));
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        String id = entity.getId();
        ArrayList sfaHelpDefenseDetailEntityList = new ArrayList();
        reqVo.getSfaHelpDefenseList().forEach(data -> {
            reqVo.setCoverHelpPosCode(data.getCoverHelpPosCode());
            Integer count = this.sfaHelpDefenseMapper.selectSfaHelpDefenseCountByCondition(reqVo);
            if (count > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u534f\u8bbf\u65e5\u671f\u5185\u7684\u534f\u8bbf\u6570\u636e\u4fe1\u606f");
            }
            data.getSfaHelpDefenseDetailList().forEach(da -> {
                SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)da, SfaHelpDefenseDetailEntity.class))));
                sfaHelpDefenseDetailEntity.setCoverHelpOrgCode(data.getCoverHelpOrgCode());
                sfaHelpDefenseDetailEntity.setCoverHelpOrgName(data.getCoverHelpOrgName());
                sfaHelpDefenseDetailEntity.setCoverHelpPosCode(data.getCoverHelpPosCode());
                sfaHelpDefenseDetailEntity.setCoverHelpPosName(data.getCoverHelpPosName());
                sfaHelpDefenseDetailEntity.setCoverHelpRealName(data.getCoverHelpRealName());
                sfaHelpDefenseDetailEntity.setCoverHelpUserName(data.getCoverHelpUserName());
                sfaHelpDefenseDetailEntity.setHelpDefenseStatus(SfaVisitEnum.helpDefenseStatus.READY_HELP_DEFENSE.getVal());
                sfaHelpDefenseDetailEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                sfaHelpDefenseDetailEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                sfaHelpDefenseDetailEntity.setHelpDefenseId(id);
                sfaHelpDefenseDetailEntityList.add(sfaHelpDefenseDetailEntity);
            });
        });
        this.sfaHelpDefenseDetailService.saveBatch(sfaHelpDefenseDetailEntityList);
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u62dc\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        GetVisitListReq.MoreReq req = new GetVisitListReq.MoreReq();
        req.setVisitUserName(reqVo.getVisitUserName());
        req.setVisitPositionCode(reqVo.getVisitPosCode());
        req.setVisitDate(reqVo.getVisitDate());
        req.setClientType(reqVo.getClientType());
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoService.getVisitInfoListByClientType(req);
        return CrmBeanUtil.copyList(list, SfaVisitPlanInfoRespVo.class);
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findAllSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u62dc\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.findAllSfaVisitPlanInfo(reqVo);
        return sfaVisitPlanInfoEntities;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952eid\u4e3a\u7a7a");
        this.checkParam(reqVo);
        LocalDate now = LocalDate.now();
        LocalDate updateNow = LocalDate.parse(reqVo.getHelpDefenseDate());
        if (!updateNow.isEqual(now) && !updateNow.isAfter(now)) {
            throw new BusinessException("\u4fee\u6539\u7684\u534f\u8bbf\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        SfaHelpDefenseEntity sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).one());
        if (sfaHelpDefenseEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u534f\u8bbf\u6570\u636e\u4fe1\u606f\u4e3a\u7a7a");
        }
        sfaHelpDefenseEntity.setHelpDefenseDate(reqVo.getHelpDefenseDate());
        LocalDate helpDefenseDate = LocalDate.parse(sfaHelpDefenseEntity.getHelpDefenseDate());
        if (!helpDefenseDate.isAfter(now)) {
            throw new BusinessException("\u4e0d\u53ef\u4fee\u6539\u5f53\u5929/\u5386\u53f2\u534f\u8bbf\u6570\u636e");
        }
        String id = sfaHelpDefenseEntity.getId();
        List sfaHelpDefenseDetailEntities = ((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(SfaHelpDefenseDetailEntity::getHelpDefenseId, (Object)id)).list();
        List detailIds = sfaHelpDefenseDetailEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.updateById((Object)sfaHelpDefenseEntity);
        this.sfaHelpDefenseDetailService.removeByIds(detailIds);
        ArrayList sfaHelpDefenseDetailEntityList = new ArrayList();
        reqVo.getSfaHelpDefenseList().forEach(data -> {
            reqVo.setCoverHelpPosCode(data.getCoverHelpPosCode());
            Integer count = this.sfaHelpDefenseMapper.selectSfaHelpDefenseCountByCondition(reqVo);
            if (now.isEqual(updateNow) ? count > 1 : count > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u534f\u8bbf\u65e5\u671f\u5185\u7684\u534f\u8bbf\u6570\u636e\u4fe1\u606f");
            }
            data.getSfaHelpDefenseDetailList().forEach(da -> {
                SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)da, SfaHelpDefenseDetailEntity.class))));
                sfaHelpDefenseDetailEntity.setCoverHelpOrgCode(data.getCoverHelpOrgCode());
                sfaHelpDefenseDetailEntity.setCoverHelpOrgName(data.getCoverHelpOrgName());
                sfaHelpDefenseDetailEntity.setCoverHelpPosCode(data.getCoverHelpPosCode());
                sfaHelpDefenseDetailEntity.setCoverHelpPosName(data.getCoverHelpPosName());
                sfaHelpDefenseDetailEntity.setCoverHelpRealName(data.getCoverHelpRealName());
                sfaHelpDefenseDetailEntity.setCoverHelpUserName(data.getCoverHelpUserName());
                sfaHelpDefenseDetailEntity.setHelpDefenseStatus(SfaVisitEnum.helpDefenseStatus.READY_HELP_DEFENSE.getVal());
                sfaHelpDefenseDetailEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                sfaHelpDefenseDetailEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                sfaHelpDefenseDetailEntity.setHelpDefenseId(id);
                sfaHelpDefenseDetailEntityList.add(sfaHelpDefenseDetailEntity);
            });
        });
        this.sfaHelpDefenseDetailService.saveBatch(sfaHelpDefenseDetailEntityList);
    }

    private void checkParam(SfaHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getHelpOrgCode(), (String)"\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpOrgName(), (String)"\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpPosCode(), (String)"\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpPosName(), (String)"\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpUserName(), (String)"\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpRealName(), (String)"\u534f\u8bbf\u4eba\u5458\u59d3\u540d\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpDefenseDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getSfaHelpDefenseList(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        List defensePosCodeList = reqVo.getSfaHelpDefenseList().stream().map(SfaHelpDefenseDto::getCoverHelpPosCode).distinct().collect(Collectors.toList());
        if (defensePosCodeList.size() != reqVo.getSfaHelpDefenseList().size()) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u88ab\u534f\u8bbf\u4eba\u5458\u7684\u7f51\u70b9\u4fe1\u606f\u5217\u8868");
        }
        reqVo.getSfaHelpDefenseList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getCoverHelpOrgCode(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getCoverHelpOrgName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getCoverHelpPosCode(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getCoverHelpPosName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getCoverHelpUserName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getCoverHelpRealName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u59d3\u540d\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((Collection)data.getSfaHelpDefenseDetailList(), (String)"\u88ab\u534f\u8bbf\u5ba2\u6237\u5217\u8868\u4e3a\u7a7a");
            List clientIdList = data.getSfaHelpDefenseDetailList().stream().map(SfaHelpDefenseDetailRespVo::getClientId).distinct().collect(Collectors.toList());
            if (clientIdList.size() != data.getSfaHelpDefenseDetailList().size()) {
                throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u7f51\u70b9\u4fe1\u606f");
            }
            data.getSfaHelpDefenseDetailList().forEach(da -> {
                AssertUtils.isNotEmpty((String)da.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)da.getClientId(), (String)"\u7f51\u70b9id\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)da.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)da.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
            });
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        List sfaHelpDefenseEntities = this.sfaHelpDefenseMapper.selectBatchIds(ids);
        List idList = sfaHelpDefenseEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        List sfaHelpDefenseDetailEntityList = ((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().in(SfaHelpDefenseDetailEntity::getHelpDefenseId, idList)).list();
        List detailIdList = sfaHelpDefenseDetailEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.removeByIds(idList);
        this.sfaHelpDefenseDetailService.removeByIds(detailIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaHelpDefenseReqVo reqVo) {
        List sfaHelpDefenseEntities = this.sfaHelpDefenseMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaHelpDefenseEntities)) {
            sfaHelpDefenseEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaHelpDefenseEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaHelpDefenseReqVo reqVo) {
        List sfaHelpDefenseEntities = this.sfaHelpDefenseMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaHelpDefenseEntities)) {
            sfaHelpDefenseEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaHelpDefenseEntities);
    }

    private String fetchGroupKey(SfaHelpDefenseDetailRespVo respVo) {
        return respVo.getCoverHelpUserName() + "_" + respVo.getCoverHelpPosCode() + "_" + respVo.getCoverHelpOrgCode();
    }
}

