/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSfaVisitPlanResolver
implements SfaVisitPlanResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractSfaVisitPlanResolver.class);

    @Override
    public void resolve(SfaVisitPlanExecuteContext context) {
        this.doResolve(context);
    }

    protected abstract void doResolve(SfaVisitPlanExecuteContext var1);

    protected LocalDate visitDateNext(SfaVisitPlanExecuteContext context, SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo) {
        LocalDate visitStartDate;
        LocalDate now = LocalDate.now();
        LocalDate visitDate = context.getVisitDate();
        visitDate = null == context.getVisitDate() ? LocalDate.now() : visitDate.plusDays(1L);
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        LocalDate visitEndDate = null == context.getVisitEndDate() ? LocalDate.parse(sfaVisitPlanEntity.getVisitEndDate(), CrmDateUtils.yyyyMMdd) : context.getVisitEndDate();
        LocalDate localDate = visitStartDate = null == context.getVisitStartDate() ? LocalDate.parse(sfaVisitPlanEntity.getVisitStartDate(), CrmDateUtils.yyyyMMdd) : context.getVisitStartDate();
        if (StringUtils.isBlank((CharSequence)sfaVisitPlanEntity.getNotWeekSet())) {
            if (this.checkVisitData(now, visitDate, visitEndDate, sfaVisitPlanEntity)) {
                context.setVisitDate(visitDate);
                context.setVisitStartDate(visitStartDate);
                context.setVisitEndDate(visitEndDate);
                return visitDate;
            }
            return null;
        }
        while (this.checkVisitData(now, visitDate, visitEndDate, sfaVisitPlanEntity)) {
            if (sfaVisitPlanEntity.getNotWeekSet().contains(String.valueOf(visitDate.getDayOfWeek().getValue()))) {
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                visitDate = visitDate.plusDays(1L);
                continue;
            }
            context.setVisitDate(visitDate);
            context.setVisitStartDate(visitStartDate);
            context.setVisitEndDate(visitEndDate);
            return visitDate;
        }
        return null;
    }

    private boolean checkVisitData(LocalDate now, LocalDate visitDate, LocalDate visitEndDate, SfaVisitPlanEntity sfaVisitPlanEntity) {
        if (visitDate.compareTo(visitEndDate) > 0) {
            log.warn("[\u62dc\u8bbf\u8ba1\u5212\u89e3\u6790\u5668]->" + this.getClass().getName() + "\uff1a\u5f53\u5929\u65e5\u671f\u5df2\u7ecf\u5927\u4e8e\u8ba1\u5212\u7ed3\u675f\u65e5\u671f, visitDate={}, sfaVisitPlanEntity={}", (Object)visitDate, (Object)JsonPropertyUtil.toJsonString((Object)((Object)sfaVisitPlanEntity)));
            return false;
        }
        if (visitDate.compareTo(now) > 15) {
            Object[] objectArray = new Object[3];
            objectArray[0] = visitDate;
            objectArray[1] = 15;
            objectArray[2] = JsonPropertyUtil.toJsonString((Object)((Object)sfaVisitPlanEntity));
            log.warn("[\u62dc\u8bbf\u8ba1\u5212\u89e3\u6790\u5668]->" + this.getClass().getName() + "\uff1a\u5df2\u7ecf\u8d85\u51fa\u80fd\u591f\u89e3\u6790\u672a\u6765\u7684\u5929\u6570, visitDate={}, futureDays={}, sfaVisitPlanEntity={}", objectArray);
            return false;
        }
        return true;
    }
}

