/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.ActivityExecuteHelper;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityCostStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.ActivityWorkbenchDataReq;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="costVisitStepExecutor")
public class ActivityCostVisitStepExecutor<ExecuteReq extends ActivityStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, ActivityCostStepExecuteDataResp, ActivityExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(ActivityCostVisitStepExecutor.class);
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ActivityExecuteHelper activityExecuteHelper;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setId(sfaVisitPlanInfoEntity.getId());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), "cost", redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
        if (this.activityExecuteHelper.activityStepCompleted(visitStepExecuteReq.getRedisHashKey(), "cost", redisData.getStepCode())) {
            this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "cost");
        }
    }

    public String executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(UUIDGenerator.generate());
        ActivityWorkbenchDataReq dataReq = (ActivityWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.doTransToEs(Lists.newArrayList((Object[])new SfaVisitStepActivityExecutionRedisData[]{redisData}), fromRespVo);
        return redisData.getId();
    }

    protected SfaVisitStepActivityExecutionRedisData buildRedisData(VisitStepExecuteReq<? extends ActivityStepExecuteData> visitStepExecuteReq) {
        ActivityStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(executeData.getActivityExecutionId());
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepActivityExecutionRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setActivityRequireReqVoList(executeData.getActivityRequireReqVoList());
        redisData.setActivityCode(sfaActivityExecutionRespVo.getActivityCode());
        redisData.setActivityType(sfaActivityExecutionRespVo.getActivityType());
        redisData.setActivityTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        redisData.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        redisData.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        redisData.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        redisData.setSalesVolume(sfaActivityExecutionRespVo.getSalesVolume());
        redisData.setApplyAmount(sfaActivityExecutionRespVo.getApplyAmount());
        redisData.setActivityDesc(sfaActivityExecutionRespVo.getActivityDesc());
        return redisData;
    }

    protected SfaActivityExecutionRespVo loadSfaActData(String activityExecutionId) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(activityExecutionId);
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6570\u636e");
        }
        return sfaActivityExecutionRespVo;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepActivityExecutionRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        ActivityStepExecuteData stepExecuteData = (ActivityStepExecuteData)((Object)visitStepExecuteReq.getStepExecuteData());
    }

    @Override
    protected ActivityCostStepExecuteDataResp doLoad(ActivityExecutorLoadReq loadParam) {
        this.loadAndCheckSfaVisitPlanInfoEntity(loadParam.getRedisHashKey());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(loadParam.getFormId());
        final SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(loadParam.getActivityExecutionId());
        StringJoiner redisHash = SfaVisitStepActivityExecutionRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), sfaActivityExecutionRespVo.getActivityType(), fromRespVo.getStepCode());
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)((Object)this.redisService.hmget(redisHash.toString(), (Object)redisHash.add(sfaActivityExecutionRespVo.getActivityCode()).toString()));
        if (null == redisData) {
            redisData = new SfaVisitStepActivityExecutionRedisData(){
                {
                    this.buildActivityRequireReqVoList(sfaActivityExecutionRespVo.getActivityRequire());
                }
            };
        }
        ActivityCostStepExecuteDataResp dataResp = (ActivityCostStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), ActivityCostStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    public ActivityCostStepExecuteDataResp loadActExecutionEditPageForWorkbench(ActivityExecutorWorkbenchLoadReq loadParam) {
        SfaVisitStepActivityExecutionRedisData redisData;
        if (StringUtils.isBlank((CharSequence)loadParam.getClientType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
            throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
        }
        String activityStepExecutionId = loadParam.getActivityStepExecutionId();
        if (StringUtils.isBlank((CharSequence)activityStepExecutionId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getActivityExecutionId())) {
                throw new BusinessException("\u6d3b\u52a8id\u4e3a\u7a7a");
            }
            final SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(loadParam.getActivityExecutionId());
            redisData = new SfaVisitStepActivityExecutionRedisData(){
                {
                    this.buildActivityRequireReqVoList(sfaActivityExecutionRespVo.getActivityRequire());
                }
            };
        } else {
            Optional optional = this.sfaVisitStepActivityCostExecutionEsDataRepositories.findById(loadParam.getActivityStepExecutionId());
            if (optional.isPresent()) {
                redisData = (SfaVisitStepActivityExecutionRedisData)((Object)optional.get());
            } else {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
            }
        }
        ActivityCostStepExecuteDataResp dataResp = (ActivityCostStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), ActivityCostStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode()));
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        List redisDataList = (List)this.redisService.hmValues(SfaVisitStepActivityExecutionRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), "cost", fromRespVo.getStepCode()).toString());
        if (CollectionUtils.isEmpty((Collection)redisDataList)) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        this.doTransToEs(redisDataList, fromRespVo);
    }

    protected void doTransToEs(List<SfaVisitStepActivityExecutionRedisData> redisDataList, SfaVisitStepFromRespVo fromRespVo) {
        ArrayList esData = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionRedisData redisData : redisDataList) {
            SfaVisitStepActivityCostExecutionEsData dataResp = (SfaVisitStepActivityCostExecutionEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepActivityCostExecutionEsData.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            dataResp.setSfaVisitStepFrom(fromRespVo);
            esData.add(dataResp);
        }
        this.sfaVisitStepActivityCostExecutionEsDataRepositories.saveAll(esData);
    }
}

