/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Table;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@TableName(value="sfa_visit_plan_info")
@Document(indexName="sfa_visit_plan_info", type="sfa_visit_plan_info")
@Entity
@javax.persistence.Table(name="sfa_visit_plan_info")
@Table(appliesTo="sfa_visit_plan_info", comment="\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6")
public class SfaVisitPlanInfoEntity
extends CrmExtTenEntity<SfaVisitPlanInfoEntity>
implements ClientReq {
    public static final long CACHE_TIME = 691200L;
    public static final String TABLE_NAME = "sfa_visit_plan_info";
    @Column(name="redis_hash_key", length=1024)
    private String redisHashKey;
    private String visitPlanCode;
    private String visitUserName;
    private String visitRealName;
    private String visitPosCode;
    private String visitPosName;
    private String visitOrgCode;
    private String visitOrgName;
    private String parentOrgCode;
    private String parentOrgName;
    @Field(type=FieldType.Date, format=DateFormat.date)
    private String visitDate;
    private String visitType;
    private String routeType;
    private String clientCode;
    private String clientName;
    private String clientType;
    private String clientAddress;
    @Field(index=false)
    private String clientPhoto;
    @Field(index=false)
    private String clientContacts;
    @Field(index=false)
    private String clientPhone;
    private BigDecimal longitude;
    private BigDecimal latitude;
    private String visitStatus;

    public static SfaVisitPlanInfoEntity getInstance() {
        return Instance.instance;
    }

    public StringJoiner redisHashCurrent(String visitDate) {
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
        }
        return this.redisHash(visitDate, userRedis.getUsername(), userRedis.getPoscode());
    }

    public StringJoiner redisHash(String visitDate, String visitUserName, String visitPosCode) {
        if (StringUtils.isBlank((CharSequence)visitDate)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u65e5\u671f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)visitUserName)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\uff01");
        }
        if (StringUtils.isBlank((CharSequence)visitPosCode)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\u804c\u4f4d\uff01");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add(TABLE_NAME).add(visitUserName).add(visitPosCode).add(visitDate);
        return joiner;
    }

    public StringJoiner redisHash() {
        if (StringUtils.isBlank((CharSequence)this.visitDate)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u65e5\u671f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.visitUserName)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.visitPosCode)) {
            throw new BusinessException("\u751f\u6210redishash\u5931\u8d25\uff0c\u8bf7\u6307\u5b9a\u62dc\u8bbf\u7528\u6237\u804c\u4f4d\uff01");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add(TABLE_NAME).add(this.visitUserName).add(this.visitPosCode).add(this.visitDate);
        return joiner;
    }

    public String getRedisHashKey() {
        if (StringUtils.isBlank((CharSequence)this.getVisitUserName())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getVisitPosCode())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7528\u6237\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getVisitDate())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getClientType())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7f51\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)this.getClientCode())) {
            throw new BusinessException("\u6570\u636e\u9519\u8bef\uff0c\u62dc\u8bbf\u7f51\u70b9\u7f16\u7801\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add(TABLE_NAME).add(this.getVisitUserName()).add(this.getVisitPosCode()).add(this.getVisitDate()).add(this.getClientType()).add(this.getClientCode());
        return joiner.toString();
    }

    public Map<Object, Object> buildRedisDataForWrite() {
        HashMap redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    public String getVisitPlanCode() {
        return this.visitPlanCode;
    }

    public String getVisitUserName() {
        return this.visitUserName;
    }

    public String getVisitRealName() {
        return this.visitRealName;
    }

    public String getVisitPosCode() {
        return this.visitPosCode;
    }

    public String getVisitPosName() {
        return this.visitPosName;
    }

    public String getVisitOrgCode() {
        return this.visitOrgCode;
    }

    public String getVisitOrgName() {
        return this.visitOrgName;
    }

    public String getParentOrgCode() {
        return this.parentOrgCode;
    }

    public String getParentOrgName() {
        return this.parentOrgName;
    }

    public String getVisitDate() {
        return this.visitDate;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public String getRouteType() {
        return this.routeType;
    }

    @Override
    public String getClientCode() {
        return this.clientCode;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public String getClientType() {
        return this.clientType;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getClientPhoto() {
        return this.clientPhoto;
    }

    public String getClientContacts() {
        return this.clientContacts;
    }

    public String getClientPhone() {
        return this.clientPhone;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public String getVisitStatus() {
        return this.visitStatus;
    }

    public void setRedisHashKey(String redisHashKey) {
        this.redisHashKey = redisHashKey;
    }

    public void setVisitPlanCode(String visitPlanCode) {
        this.visitPlanCode = visitPlanCode;
    }

    public void setVisitUserName(String visitUserName) {
        this.visitUserName = visitUserName;
    }

    public void setVisitRealName(String visitRealName) {
        this.visitRealName = visitRealName;
    }

    public void setVisitPosCode(String visitPosCode) {
        this.visitPosCode = visitPosCode;
    }

    public void setVisitPosName(String visitPosName) {
        this.visitPosName = visitPosName;
    }

    public void setVisitOrgCode(String visitOrgCode) {
        this.visitOrgCode = visitOrgCode;
    }

    public void setVisitOrgName(String visitOrgName) {
        this.visitOrgName = visitOrgName;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public void setVisitDate(String visitDate) {
        this.visitDate = visitDate;
    }

    public void setVisitType(String visitType2) {
        this.visitType = visitType2;
    }

    public void setRouteType(String routeType) {
        this.routeType = routeType;
    }

    @Override
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    @Override
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public void setClientPhoto(String clientPhoto) {
        this.clientPhoto = clientPhoto;
    }

    public void setClientContacts(String clientContacts) {
        this.clientContacts = clientContacts;
    }

    public void setClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setVisitStatus(String visitStatus2) {
        this.visitStatus = visitStatus2;
    }

    private static class Instance {
        private static final SfaVisitPlanInfoEntity instance = new SfaVisitPlanInfoEntity();

        private Instance() {
        }
    }
}

