/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepdetail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.availablelist.TerminalAvailableListNewFeign;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.nebular.sfa.visitstepdetail.SfaVisitStepStockVo;
import com.biz.crm.nebular.sfa.visitstepdetail.req.ListTerminalProductsReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockDetailReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockInventoryReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.ListTerminalProductsRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaStockInventoryRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockDetailRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockInventoryMapper;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockDetailEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockDetailService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepStockInventoryServiceExpandImpl"})
@Transactional
public class SfaVisitStepStockInventoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepStockInventoryMapper, SfaVisitStepStockInventoryEntity>
implements ISfaVisitStepStockInventoryService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStockInventoryServiceImpl.class);
    @Resource
    private SfaVisitStepStockInventoryMapper sfaVisitStepStockInventoryMapper;
    @Autowired
    private ISfaVisitStepStockDetailService sfaVisitStepStockDetailService;
    @Resource
    private TerminalAvailableListNewFeign terminalAvailableListNewFeign;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;

    @Override
    @CrmAPIDiscard
    public Result<PageResult<ListTerminalProductsRespVo>> loadAndBuildStepStockDetail(ListTerminalProductsReqVo listTerminalProductsReqVoParam) {
        TerminalAvailablelistVo terminalAvailablelistVoParam = (TerminalAvailablelistVo)CrmBeanUtil.copy((Object)listTerminalProductsReqVoParam, TerminalAvailablelistVo.class);
        Result data = this.terminalAvailableListNewFeign.listTerminal(terminalAvailablelistVoParam);
        String visitId = listTerminalProductsReqVoParam.getVisitId();
        if (null == data) {
            return null;
        }
        if (null == data.getResult() || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)visitId)) {
            return (Result)CrmBeanUtil.copy((Object)data, Result.class);
        }
        Result resultData = (Result)CrmBeanUtil.copy((Object)data, Result.class);
        PageResult pageResult = (PageResult)CrmBeanUtil.copy((Object)data.getResult(), PageResult.class);
        resultData.setResult((Object)pageResult);
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getStepCode, (Object)visitId)).one());
        if (null == entity) {
            pageResult.setData(CrmBeanUtil.copyList((List)((PageResult)data.getResult()).getData(), ListTerminalProductsRespVo.class));
            return resultData;
        }
        Map<String, SfaVisitStepStockDetailEntity> detailEntitiesMap = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)entity.getId())).list().stream().collect(Collectors.toMap(SfaVisitStepStockDetailEntity::getProductCode, v -> v, (t, t2) -> t2));
        ArrayList listTerminalProductsRespVos = Lists.newArrayList();
        List tempVos = ((PageResult)data.getResult()).getData();
        for (TerminalAvailablelistVo terminalAvailablelistVo : tempVos) {
            ListTerminalProductsRespVo tempVo = (ListTerminalProductsRespVo)CrmBeanUtil.copy((Object)terminalAvailablelistVo, ListTerminalProductsRespVo.class);
            Integer setQuantity = null;
            if (detailEntitiesMap.containsKey(terminalAvailablelistVo.getProductCode())) {
                setQuantity = detailEntitiesMap.get(terminalAvailablelistVo.getProductCode()).getQuantity();
            }
            tempVo.setQuantity(Integer.valueOf(null == setQuantity ? 0 : setQuantity));
            listTerminalProductsRespVos.add(tempVo);
        }
        pageResult.setData((List)listTerminalProductsRespVos);
        return resultData;
    }

    @Override
    public PageResult<SfaVisitStepStockInventoryRespVo> findList(SfaVisitStepStockInventoryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findList((Page<SfaVisitStepStockInventoryRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitStepStockInventoryRespVo> findStockInventoryReportList(SfaVisitStepStockInventoryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStockInventoryRespVo> stockTimeList = this.sfaVisitStepStockInventoryMapper.findStockTimeAndClientCode(reqVo.getClientCode());
        if (!CollectionUtil.listNotEmptyNotSizeZero(stockTimeList)) {
            return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(page.getTotal())).build();
        }
        List stockTimes = stockTimeList.stream().map(SfaVisitStepStockInventoryRespVo::getStockTime).collect(Collectors.toList());
        List clientCodeList = stockTimeList.stream().map(SfaVisitStepStockInventoryRespVo::getClientCode).collect(Collectors.toList());
        reqVo.setClientCodeList(clientCodeList);
        reqVo.setStockTimeList(stockTimes);
        List<SfaVisitStepStockInventoryRespVo> respVos = this.sfaVisitStepStockInventoryMapper.findStockInventoryReportList((Page<SfaVisitStepStockInventoryRespVo>)page, reqVo);
        Page pageTemp = new Page();
        pageTemp.setSize(1L);
        pageTemp.setCurrent(1L);
        respVos.forEach(data -> {
            List stockDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)data.getId())).list();
            Integer stockNum = stockDetailEntities.stream().mapToInt(SfaVisitStepStockDetailEntity::getQuantity).sum();
            data.setStockNum(stockNum);
            SfaVisitStepStockInventoryEntity stockInventoryEntity = null;
            List tempList = ((Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getClientCode, (Object)data.getClientCode())).lt(SfaVisitStepStockInventoryEntity::getStockTime, (Object)data.getStockTime())).orderByDesc(SfaVisitStepStockInventoryEntity::getStockTime)).select(new SFunction[]{BaseIdEntity::getId, SfaVisitStepStockInventoryEntity::getStockTime}).page((IPage)pageTemp)).getRecords();
            if (tempList.size() > 0) {
                stockInventoryEntity = (SfaVisitStepStockInventoryEntity)((Object)((Object)tempList.get(0)));
            }
            if (stockInventoryEntity != null) {
                data.setLastStockTime(stockInventoryEntity.getStockTime());
                List lastStockDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)stockInventoryEntity.getId())).list();
                Integer lastStockNum = lastStockDetailEntities.stream().mapToInt(SfaVisitStepStockDetailEntity::getQuantity).sum();
                data.setLastStockNum(lastStockNum);
                data.setStockDiffer(Integer.valueOf(stockNum - lastStockNum));
            }
        });
        return PageResult.builder().data(respVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepStockInventoryRespVo queryStockInventoryReportDetail(String id) {
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (entity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u660e\u7ec6\u4fe1\u606f");
        }
        SfaVisitStepStockInventoryRespVo respVo = (SfaVisitStepStockInventoryRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaVisitStepStockInventoryRespVo.class);
        List stockDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)respVo.getId())).list();
        Integer stockNum = stockDetailEntities.stream().mapToInt(SfaVisitStepStockDetailEntity::getQuantity).sum();
        respVo.setStockNum(stockNum);
        Page pageTemp = new Page();
        pageTemp.setSize(1L);
        pageTemp.setCurrent(1L);
        SfaVisitStepStockInventoryEntity stockInventoryEntity = null;
        List tempList = ((Page)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getClientCode, (Object)respVo.getClientCode())).lt(SfaVisitStepStockInventoryEntity::getStockTime, (Object)respVo.getStockTime())).orderByDesc(SfaVisitStepStockInventoryEntity::getStockTime)).select(new SFunction[]{BaseIdEntity::getId, SfaVisitStepStockInventoryEntity::getStockTime}).page((IPage)pageTemp)).getRecords();
        if (tempList.size() > 0) {
            stockInventoryEntity = (SfaVisitStepStockInventoryEntity)((Object)tempList.get(0));
        }
        if (stockInventoryEntity != null) {
            respVo.setLastStockTime(stockInventoryEntity.getStockTime());
            List lastStockDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)stockInventoryEntity.getId())).list();
            Integer lastStockNum = lastStockDetailEntities.stream().mapToInt(SfaVisitStepStockDetailEntity::getQuantity).sum();
            respVo.setLastStockNum(lastStockNum);
            respVo.setStockDiffer(Integer.valueOf(stockNum - lastStockNum));
        }
        List stockInventoryEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getClientCode, (Object)respVo.getClientCode())).eq(SfaVisitStepStockInventoryEntity::getUserName, (Object)respVo.getUserName())).eq(SfaVisitStepStockInventoryEntity::getPosCode, (Object)respVo.getPosCode())).orderByDesc(SfaVisitStepStockInventoryEntity::getStockTime)).list();
        return respVo;
    }

    @Override
    public SfaVisitStepStockInventoryRespVo query(SfaVisitStepStockInventoryReqVo reqVo) {
        return null;
    }

    @Override
    public SfaVisitStepStockInventoryRespVo queryDetailByVisitDetailId(String visitDetailId) {
        SfaVisitStepStockInventoryEntity inventoryEntity = (SfaVisitStepStockInventoryEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getStepCode, (Object)visitDetailId)).one());
        if (null == inventoryEntity) {
            SfaVisitStepStockInventoryRespVo sfaVisitStepStockInventoryRespVos = new SfaVisitStepStockInventoryRespVo();
            sfaVisitStepStockInventoryRespVos.setDetailRespVos((List)Lists.newArrayList());
            return sfaVisitStepStockInventoryRespVos;
        }
        SfaVisitStepStockInventoryRespVo sfaVisitStepStockInventoryRespVos = (SfaVisitStepStockInventoryRespVo)CrmBeanUtil.copy((Object)((Object)inventoryEntity), SfaVisitStepStockInventoryRespVo.class);
        List detailEntityList = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)inventoryEntity.getId())).list();
        List detailRespVos = CrmBeanUtil.copyList((List)detailEntityList, SfaVisitStepStockDetailRespVo.class);
        sfaVisitStepStockInventoryRespVos.setDetailRespVos(detailRespVos);
        return sfaVisitStepStockInventoryRespVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepStockInventoryReqVo reqVo) {
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepStockInventoryEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVisitStockList(SfaVisitStepStockVo stockVo) {
        LambdaQueryWrapper queryWrapper;
        SfaVisitDealerDetailEntity dealerDetailEntity;
        AssertUtils.isNotEmpty((String)stockVo.getVisitId(), (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)stockVo.getVisitStepStockList(), (String)"\u5e93\u5b58\u76d8\u70b9\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        this.checkParam(stockVo);
        SfaVisitStepStockInventoryEntity sfaVisitStepStockInventoryEntity = (SfaVisitStepStockInventoryEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getStepCode, (Object)stockVo.getVisitId())).one());
        if (sfaVisitStepStockInventoryEntity != null) {
            this.removeById((Serializable)((Object)sfaVisitStepStockInventoryEntity.getId()));
            this.sfaVisitStepStockDetailService.remove((Wrapper)Wrappers.lambdaUpdate(SfaVisitStepStockDetailEntity.class).eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)sfaVisitStepStockInventoryEntity.getId()));
        }
        if ((dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)this.sfaVisitDealerDetailMapper.selectOne((Wrapper)(queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseIdEntity::getId, (Object)stockVo.getVisitId()))))) == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
        }
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)CrmBeanUtil.copy((Object)stockVo, SfaVisitStepStockInventoryEntity.class));
        UserRedis userRedis = UserUtils.getUser();
        String stockTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        entity.setClientCode(dealerDetailEntity.getClientCode());
        entity.setClientType(dealerDetailEntity.getClientType());
        entity.setClientName(dealerDetailEntity.getClientName());
        entity.setStockTime(stockTime);
        entity.setUserName(userRedis.getUsername());
        entity.setRealName(userRedis.getRealname());
        entity.setPosCode(userRedis.getPoscode());
        entity.setPosName(userRedis.getPosname());
        entity.setOrgCode(userRedis.getOrgcode());
        entity.setOrgName(userRedis.getOrgname());
        this.save((Object)entity);
        List stockDetailEntityList = CrmBeanUtil.copyList((List)stockVo.getVisitStepStockList(), SfaVisitStepStockDetailEntity.class);
        String stockInventoryId = entity.getId();
        stockDetailEntityList.forEach(data -> data.setStockInventoryId(stockInventoryId));
        this.sfaVisitStepStockDetailService.saveBatch(stockDetailEntityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWorkStockList(SfaVisitStepStockVo stepStockVo) {
        AssertUtils.isNotEmpty((Collection)stepStockVo.getVisitStepStockList(), (String)"\u5e93\u5b58\u76d8\u70b9\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        this.checkVisitStepParam(stepStockVo);
        UserRedis userRedis = UserUtils.getUser();
        String stockTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        SfaVisitStepStockInventoryEntity stockInventoryEntity = (SfaVisitStepStockInventoryEntity)((Object)CrmBeanUtil.copy((Object)stepStockVo, SfaVisitStepStockInventoryEntity.class));
        stockInventoryEntity.setStockTime(stockTime);
        stockInventoryEntity.setUserName(userRedis.getUsername());
        stockInventoryEntity.setRealName(userRedis.getRealname());
        stockInventoryEntity.setPosCode(userRedis.getPoscode());
        stockInventoryEntity.setPosName(userRedis.getPosname());
        stockInventoryEntity.setOrgCode(userRedis.getOrgcode());
        stockInventoryEntity.setOrgName(userRedis.getOrgname());
        this.save((Object)stockInventoryEntity);
        String stockInventoryId = stockInventoryEntity.getId();
        List stockDetailEntities = CrmBeanUtil.copyList((List)stepStockVo.getVisitStepStockList(), SfaVisitStepStockDetailEntity.class);
        stockDetailEntities.forEach(data -> data.setStockInventoryId(stockInventoryId));
        this.sfaVisitStepStockDetailService.saveBatch(stockDetailEntities);
    }

    @Override
    public PageResult<SfaVisitStepStockInventoryRespVo> findWorkStockList(SfaVisitStepStockInventoryReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        if (!StringUtils.isNotEmpty((String)reqVo.getUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setPosCode(userRedis.getPoscode());
        }
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findWorkStockList((Page<SfaVisitStepStockInventoryRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaStockInventoryRespVo queryStockInventoryDetail(String id) {
        SfaVisitStepStockInventoryEntity stockInventoryEntity = (SfaVisitStepStockInventoryEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (stockInventoryEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5e93\u5b58\u76d8\u70b9\u660e\u7ec6\u6570\u636e");
        }
        SfaStockInventoryRespVo sfaStockInventoryRespVo = (SfaStockInventoryRespVo)CrmBeanUtil.copy((Object)((Object)stockInventoryEntity), SfaStockInventoryRespVo.class);
        List stockDetailEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepStockDetailService.lambdaQuery().eq(SfaVisitStepStockDetailEntity::getStockInventoryId, (Object)stockInventoryEntity.getId())).list();
        Map<String, List<SfaVisitStepStockDetailEntity>> stockMap = stockDetailEntities.stream().collect(Collectors.groupingBy(SfaVisitStepStockDetailEntity::getSeriesCode));
        Integer productTypeNum = 0;
        ArrayList<1> sfaVisitStepStockVoList = new ArrayList<1>();
        for (Map.Entry<String, List<SfaVisitStepStockDetailEntity>> map : stockMap.entrySet()) {
            final List<SfaVisitStepStockDetailEntity> stockDetailEntityList = map.getValue();
            SfaVisitStepStockVo sfaVisitStepStockVo = new SfaVisitStepStockVo(){
                {
                    this.setSeriesCode(((SfaVisitStepStockDetailEntity)((Object)stockDetailEntityList.get(0))).getSeriesCode());
                    this.setSeriesName(((SfaVisitStepStockDetailEntity)((Object)stockDetailEntityList.get(0))).getSeriesName());
                }
            };
            List stockDetailReqVoList = CrmBeanUtil.copyList(stockDetailEntityList, SfaVisitStepStockDetailReqVo.class);
            productTypeNum = productTypeNum + stockDetailReqVoList.size();
            sfaVisitStepStockVo.setVisitStepStockList(stockDetailReqVoList);
            sfaVisitStepStockVoList.add(sfaVisitStepStockVo);
        }
        sfaStockInventoryRespVo.setSfaVisitStepStockVoList(sfaVisitStepStockVoList);
        sfaStockInventoryRespVo.setSeriesTypeNum(Integer.valueOf(stockMap.size()));
        sfaStockInventoryRespVo.setProductTypeNum(productTypeNum);
        Integer totalNum = stockDetailEntities.stream().mapToInt(SfaVisitStepStockDetailEntity::getQuantity).sum();
        sfaStockInventoryRespVo.setProductTotalNum(totalNum);
        return sfaStockInventoryRespVo;
    }

    private void checkVisitStepParam(SfaVisitStepStockVo stockVo) {
        AssertUtils.isNotEmpty((String)stockVo.getStockAddress(), (String)"\u76d8\u5e93\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLatitude(), (String)"\u7ef4\u5ea6\u4e3a\u7a7a");
        stockVo.getVisitStepStockList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesCode(), (String)"\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesName(), (String)"\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getUnit(), (String)"\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
            if (data.getQuantity() == null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
        });
    }

    private void checkParam(SfaVisitStepStockVo stockVo) {
        AssertUtils.isNotEmpty((String)stockVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLatitude(), (String)"\u7ef4\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientId(), (String)"\u7f51\u70b9id\u4e3a\u7a7a");
        stockVo.getVisitStepStockList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesCode(), (String)"\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesName(), (String)"\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getUnit(), (String)"\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
            if (data.getQuantity() == null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepStockInventoryReqVo reqVo) {
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepStockInventoryReqVo reqVo) {
        List sfaVisitStepStockInventoryEntities = this.sfaVisitStepStockInventoryMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStockInventoryEntities)) {
            sfaVisitStepStockInventoryEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStockInventoryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepStockInventoryReqVo reqVo) {
        List sfaVisitStepStockInventoryEntities = this.sfaVisitStepStockInventoryMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStockInventoryEntities)) {
            sfaVisitStepStockInventoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStockInventoryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepStockInventoryReqVo reqVo) {
        List sfaVisitStepStockInventoryEntities = this.sfaVisitStepStockInventoryMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStockInventoryEntities)) {
            sfaVisitStepStockInventoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStockInventoryEntities);
    }
}

