/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.OrderWorkbenchDataReq;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEsData;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="orderVisitStepExecutor")
public class OrderVisitStepExecutor<ExecuteReq extends OrderStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, OrderStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(OrderVisitStepExecutor.class);
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "order");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(UUIDGenerator.generate());
        redisData.setOrderSource(SfaOrderSourceEnum.WORKBENCH.getCode());
        OrderWorkbenchDataReq dataReq = (OrderWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected SfaVisitStepOrderRedisData buildRedisData(VisitStepExecuteReq<? extends OrderStepExecuteData> visitStepExecuteReq) {
        OrderStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepOrderRedisData.class));
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setSfaVisitStepOrderItems(executeData.getSfaVisitStepOrderItems());
        redisData.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        redisData.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
        redisData.setCustomerCode(executeData.getCustomerCode());
        redisData.setCustomerName(executeData.getCustomerName());
        redisData.setAddress(executeData.getAddress());
        redisData.setContacts(executeData.getContacts());
        redisData.setTelephone(executeData.getTelephone());
        redisData.setExpectReceive(executeData.getExpectReceive());
        if (StringUtils.isNotEmpty((CharSequence)executeData.getRemarks())) {
            redisData.setRemarks(executeData.getRemarks());
        }
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepOrderRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)((Object)visitStepExecuteReq.getStepExecuteData());
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepOrderItems())) {
            throw new BusinessException("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
    }

    public OrderStepExecuteDataResp loadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        SfaVisitStepOrderRedisData redisData;
        if (StringUtils.isBlank((CharSequence)loadParam.getClientType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
            throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
        }
        String bizId = loadParam.getBizId();
        if (StringUtils.isBlank((CharSequence)bizId)) {
            redisData = new SfaVisitStepOrderRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
        } else {
            Optional optional = this.sfaVisitStepOrderEsDataRepositories.findById(bizId);
            if (optional.isPresent()) {
                redisData = (SfaVisitStepOrderRedisData)((Object)optional.get());
            } else {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
            }
        }
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), OrderStepExecuteDataResp.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode()));
        return dataResp;
    }

    @Override
    protected OrderStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepOrderRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
        }
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), OrderStepExecuteDataResp.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepOrderRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepOrderEsData dataResp = (SfaVisitStepOrderEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepOrderEsData.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.sfaVisitStepOrderEsDataRepositories.save(dataResp);
    }
}

