/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.StockInventoryWorkbenchDataReq;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryRedisData;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="stockVisitStepExecutor")
public class StockInventoryVisitStepExecutor<ExecuteReq extends StockInventoryStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, StockInventoryStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(StockInventoryVisitStepExecutor.class);
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "stock");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(UUIDGenerator.generate());
        StockInventoryWorkbenchDataReq dataReq = (StockInventoryWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected SfaVisitStepStockInventoryRedisData buildRedisData(VisitStepExecuteReq<? extends StockInventoryStepExecuteData> visitStepExecuteReq) {
        StockInventoryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepStockInventoryRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setVisitStepStockList(executeData.getVisitStepStockList());
        redisData.setStockTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepStockInventoryRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        StockInventoryStepExecuteData stepExecuteData = (StockInventoryStepExecuteData)((Object)visitStepExecuteReq.getStepExecuteData());
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getStockAddress())) {
            throw new BusinessException("\u5730\u5740\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getLatitude())) {
            throw new BusinessException("\u7ef4\u5ea6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getLongitude())) {
            throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
        }
    }

    @Override
    protected StockInventoryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)((Object)this.redisService.hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepStockInventoryRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setVisitStepStockList(list);
                }
            };
        }
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    public StockInventoryStepExecuteDataResp loadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        SfaVisitStepStockInventoryRedisData redisData;
        if (StringUtils.isBlank((CharSequence)loadParam.getClientType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
            throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
        }
        String bizId = loadParam.getBizId();
        if (StringUtils.isBlank((CharSequence)bizId)) {
            redisData = new SfaVisitStepStockInventoryRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setVisitStepStockList(list);
                }
            };
        } else {
            Optional optional = this.sfaVisitStepStockInventoryEsDataRepositories.findById(bizId);
            if (optional.isPresent()) {
                redisData = (SfaVisitStepStockInventoryRedisData)((Object)optional.get());
            } else {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
            }
        }
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode()));
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)((Object)this.redisService.hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepStockInventoryRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepStockInventoryEsData dataResp = (SfaVisitStepStockInventoryEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepStockInventoryEsData.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.sfaVisitStepStockInventoryEsDataRepositories.save(dataResp);
    }
}

