/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.GetCompleteActivityPageReq;
import com.biz.crm.visitstep.req.GetCompleteActivityReq;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.elasticsearch.index.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepActivityExecutionServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepActivityExecutionServiceEsImpl.class);
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    public PageResult<SfaVisitStepActivityExecutionRespVo> getCompleteActivityPage(GetCompleteActivityPageReq req) {
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(req.getActivityType())) {
            Page list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((SearchQuery)req.buildQuery());
            return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepActivityExecutionRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
        }
        Page list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((SearchQuery)req.buildQuery());
        return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepActivityExecutionRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
    }

    public List<SfaVisitStepActivityCostExecutionEsData> getCompleteCostActivityList(GetCompleteActivityReq req) {
        Iterable list = this.sfaVisitStepActivityCostExecutionEsDataRepositories.search((QueryBuilder)req.buildQuery());
        return Lists.newArrayList((Iterable)list);
    }

    public Set<String> getCompleteCostActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "23:59:59");
        return this.getCompleteCostActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public Set<String> getCompleteCostActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "00:00:00");
        return this.getCompleteCostActivityList(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public List<SfaVisitStepActivityDisplayExecutionEsData> getCompleteDisplayActivityPage(GetCompleteActivityReq req) {
        Iterable list = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.search((QueryBuilder)req.buildQuery());
        return Lists.newArrayList((Iterable)list);
    }

    public Set<String> getCompleteDisplayActivityIdsBeforeDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setEndActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "23:59:59");
        return this.getCompleteDisplayActivityPage(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }

    public Set<String> getCompleteDisplayActivityIdsAfterDate(String stepCode, String clientCode, LocalDate date) {
        GetCompleteActivityReq req = new GetCompleteActivityReq();
        req.setStepCode(stepCode);
        req.setClientCode(clientCode);
        req.setStartActivityTime(date.format(CrmDateUtils.yyyyMMdd) + " " + "00:00:00");
        return this.getCompleteDisplayActivityPage(req).stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toSet());
    }
}

