/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.achievement.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementRuleMapper;
import com.biz.crm.achievement.model.SfaAchievementRuleEntity;
import com.biz.crm.achievement.service.ISfaAchievementRuleService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleObjectReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleTableReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaIndexRuleReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementRuleTableRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SfaAchievementRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAchievementRuleMapper, SfaAchievementRuleEntity>
implements ISfaAchievementRuleService {
    private static final Logger log = LoggerFactory.getLogger(SfaAchievementRuleServiceImpl.class);
    @Autowired
    private SfaAchievementRuleMapper sfaAchievementRuleMapper;

    @Override
    public PageResult<SfaAchievementRuleTableRespVo> findList(SfaAchievementRuleTableReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaAchievementRuleTableRespVo> list = this.sfaAchievementRuleMapper.findList((Page<SfaAchievementRuleTableRespVo>)page, reqVo);
        this.setStatus(list);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaAchievementRuleReqVo reqVo) {
        BigDecimal bigDecimal = new BigDecimal("0");
        for (SfaIndexRuleReqVo indexRuleReqVo : reqVo.getIndexReqVos()) {
            BigDecimal wight = new BigDecimal(indexRuleReqVo.getWeight());
            bigDecimal = wight.add(bigDecimal);
        }
        if (bigDecimal.compareTo(new BigDecimal("1.0")) != 0) {
            throw new BusinessException("\u5408\u8ba1\u4e0d\u4e3a100%");
        }
        for (SfaAchievementRuleObjectReqVo objectReqVo : reqVo.getObjectList()) {
            SfaAchievementRuleTableReqVo ruleTableReqVo = (SfaAchievementRuleTableReqVo)CrmBeanUtil.copy((Object)reqVo, SfaAchievementRuleTableReqVo.class);
            ruleTableReqVo.setObjectCode(objectReqVo.getObjectCode());
            ruleTableReqVo.setObjectName(objectReqVo.getObjectName());
            ruleTableReqVo.setObjectPosName(objectReqVo.getObjectPosName());
            for (SfaIndexRuleReqVo indexRuleReqVo : reqVo.getIndexReqVos()) {
                ruleTableReqVo.setIndexCode(indexRuleReqVo.getIndexCode());
                ruleTableReqVo.setIndexName(indexRuleReqVo.getIndexName());
                ruleTableReqVo.setWeight(indexRuleReqVo.getWeight());
                ruleTableReqVo.setTargetNum(indexRuleReqVo.getTargetNum());
                ruleTableReqVo.setUnit(indexRuleReqVo.getUnit());
                this.checkParam(ruleTableReqVo);
                if (!ruleTableReqVo.getAchievementDateYear().isEmpty()) {
                    this.getDayOfDate(ruleTableReqVo);
                }
                SfaAchievementRuleEntity entity = (SfaAchievementRuleEntity)((Object)CrmBeanUtil.copy((Object)ruleTableReqVo, SfaAchievementRuleEntity.class));
                this.save((Object)entity);
            }
        }
    }

    public SfaAchievementRuleTableReqVo getDayOfDate(SfaAchievementRuleTableReqVo reqVo) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        String s = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
        Date date = null;
        try {
            date = format.parse(s);
        }
        catch (Exception e) {
            throw new BusinessException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        cale.setTime(date);
        cale.add(2, 0);
        cale.set(5, 1);
        String firstDay = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String lastDay = format.format(cale.getTime());
        if (StringUtils.isNotEmpty((String)reqVo.getAchievementDateTenDays())) {
            if (WorkSignEnum.achievementTimeType.SX.getVal().equals(reqVo.getAchievementDateTenDays())) {
                lastDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            } else {
                firstDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            }
        }
        reqVo.setBeginDate(firstDay).setEndDate(lastDay);
        return reqVo;
    }

    public void checkParam(SfaAchievementRuleTableReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getObjectCode(), (String)"\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getObjectName(), (String)"\u5bf9\u8c61\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getAchievementType(), (String)"\u7ee9\u6548\u7c7b\u578b\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((String)reqVo.getAchievementDateYear())) {
            StringBuilder achievementDate = new StringBuilder().append(reqVo.getAchievementDateYear()).append("\u5e74").append(reqVo.getAchievementDateMonth()).append("\u6708");
            if (StringUtils.isNotEmpty((String)reqVo.getAchievementDateTenDays())) {
                if (reqVo.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.SX.getVal())) {
                    achievementDate.append(WorkSignEnum.achievementTimeType.SX.getDesc());
                }
                if (reqVo.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.XX.getVal())) {
                    achievementDate.append(WorkSignEnum.achievementTimeType.XX.getDesc());
                }
            }
            reqVo.setAchievementDate(achievementDate.toString());
        }
        if (reqVo.getAchievementType().equals(WorkSignEnum.achievementTimeType.FT.getVal())) {
            LocalDate beginDate = null;
            try {
                beginDate = LocalDate.parse(reqVo.getBeginDate(), CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            LocalDate endDate = null;
            try {
                endDate = LocalDate.parse(reqVo.getEndDate(), CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            if (!beginDate.isBefore(endDate)) {
                throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4");
            }
            reqVo.setAchievementDate(reqVo.getBeginDate() + "-" + reqVo.getEndDate());
        }
        AssertUtils.isNotEmpty((String)reqVo.getAchievementDate(), (String)"\u7ee9\u6548\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getWeight(), (String)"\u6743\u91cd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTargetNum(), (String)"\u76ee\u6807\u6570\u91cf\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getUnit(), (String)"\u5355\u4f4d\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIndexCode(), (String)"\u6307\u6807\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIndexName(), (String)"\u6307\u6807\u540d\u79f0\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List sfaAchievementRuleEntities = this.sfaAchievementRuleMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaAchievementRuleEntities)) {
            sfaAchievementRuleEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaAchievementRuleEntities);
    }

    @Override
    public List<SfaAchievementRuleTableRespVo> miniListThisMonth(String timeType2, String objectCode) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String date = format.format(new Date());
        if (timeType2.equals(WorkSignEnum.TimeType.SY.getVal())) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(2, -1);
            date = format.format(c.getTime());
        }
        String[] s = date.split("-");
        SfaAchievementRuleTableReqVo reqVo = new SfaAchievementRuleTableReqVo();
        reqVo.setAchievementDate(s[0] + "\u5e74" + s[1] + "\u6708");
        reqVo.setObjectCode(objectCode);
        List<SfaAchievementRuleTableRespVo> list = this.sfaAchievementRuleMapper.miniList(reqVo);
        this.setStatus(list);
        return list;
    }

    public void setStatus(List<SfaAchievementRuleTableRespVo> list) {
        for (SfaAchievementRuleTableRespVo respVo : list) {
            respVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)respVo.getEnableStatus()));
            if (WorkSignEnum.achievementTimeType.MM.getVal().equals(respVo.getAchievementType())) {
                respVo.setAchievementTypeName(WorkSignEnum.achievementTimeType.MM.getDesc());
            }
            if (WorkSignEnum.achievementTimeType.TD.getVal().equals(respVo.getAchievementType())) {
                respVo.setAchievementTypeName(WorkSignEnum.achievementTimeType.TD.getDesc());
            }
            if (!WorkSignEnum.achievementTimeType.FT.getVal().equals(respVo.getAchievementType())) continue;
            respVo.setAchievementTypeName(WorkSignEnum.achievementTimeType.FT.getDesc());
        }
    }
}

