/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.biz.crm.visitinfo.resp.report.VisitInfoReportResp;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitPlanInfoRedisDataServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoRedisDataServiceEsImpl.class);
    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;

    public void save(SfaVisitPlanInfoRedisData data) {
        if (null == data || StringUtils.isBlank((CharSequence)data.getId())) {
            throw new BusinessException("\u62dc\u8bbf\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        this.sfaVisitPlanInfoRedisDataRepositories.save(data);
    }

    public SfaVisitExecuteResp getVisitExecuteInfoById(String visitInfoId) {
        Optional pptional = this.sfaVisitPlanInfoRedisDataRepositories.findById(visitInfoId);
        if (pptional.isPresent()) {
            SfaVisitPlanInfoRedisData planInfoRedisData = (SfaVisitPlanInfoRedisData)pptional.get();
            SfaVisitExecuteResp reportVo = (SfaVisitExecuteResp)CrmBeanUtil.copy((Object)((Object)planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData()), SfaVisitExecuteResp.class);
            reportVo.setSteps(this.buildSteps(planInfoRedisData, true));
            return reportVo;
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u62dc\u8bbf\u8ba1\u5212\u6267\u884c\u6570\u636e");
    }

    private VisitInfoReportResp buildVisitInfoReportResp(SfaVisitPlanInfoRedisData planInfoRedisData) {
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        VisitInfoReportResp reportVo = (VisitInfoReportResp)((Object)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), VisitInfoReportResp.class));
        reportVo.setId(planInfoRedisData.getId());
        reportVo.setVisitDetailStep(sfaVisitPlanInfoExecuteRedisData.getVisitDetailStep());
        reportVo.setStep(this.buildSteps(planInfoRedisData, false));
        return reportVo;
    }

    private List<VisitStepResp> buildSteps(SfaVisitPlanInfoRedisData planInfoRedisData, boolean summary) {
        List<VisitStepResp> stepTemp = planInfoRedisData.getStep();
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        ArrayList steps = Lists.newArrayList();
        VisitStepResp inStep = this.buildInStore(sfaVisitPlanInfoExecuteRedisData);
        VisitStepResp outStep = this.buildOutStore(sfaVisitPlanInfoExecuteRedisData);
        if (null != inStep) {
            steps.add(inStep);
        }
        if (null != stepTemp) {
            for (VisitStepResp stepResp : stepTemp) {
                if (!summary && SfaVisitEnum.visitStep.VISIT_STEP_SUMMARY.getVal().equals(stepResp.getPageCode())) continue;
                steps.add(VisitStepResp.build(stepResp));
            }
        }
        if (null != outStep) {
            steps.add(outStep);
        }
        return steps;
    }

    private VisitStepResp buildInStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (StringUtils.isNotBlank((CharSequence)sfaVisitPlanInfoExecuteRedisData.getInStore())) {
            VisitStepResp.InOutData inData = new VisitStepResp.InOutData();
            inData.setSfaVisitStepFromAsInStore(sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsInStore());
            inData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getInStoreAddress());
            inData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getInStore());
            inData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLatitude());
            inData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLongitude());
            inData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitInPics());
            VisitStepResp inStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal(), null, inData);
            return inStep;
        }
        return null;
    }

    private VisitStepResp buildOutStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (StringUtils.isNotBlank((CharSequence)sfaVisitPlanInfoExecuteRedisData.getOutStore())) {
            VisitStepResp.InOutData outData = new VisitStepResp.InOutData();
            outData.setSfaVisitStepFromAsInStore(sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsInStore());
            outData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getOutStoreAddress());
            outData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getOutStore());
            outData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
            outData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
            outData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitOutPics());
            VisitStepResp outStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal(), null, outData);
            return outStep;
        }
        return null;
    }

    public PageResult<VisitInfoReportResp> getVisitExecuteInfoReportPage(GetVisitReportsPageReq req) {
        Page list = this.sfaVisitPlanInfoRedisDataRepositories.search((SearchQuery)req.buildQuery());
        ArrayList reportResps = Lists.newArrayList();
        for (SfaVisitPlanInfoRedisData planInfoRedisData : list) {
            reportResps.add(this.buildVisitInfoReportResp(planInfoRedisData));
        }
        return PageResult.builder().data((List)reportResps).count(Long.valueOf(list.getTotalElements())).build();
    }
}

