/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u5206\u9875-\u53c2\u6570")
public class GetOrderPageReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u5f00\u59cb\u65f6\u95f4")
    private String startOrderTime;
    @ApiModelProperty(value="\u7ed3\u675f\u65f6\u95f4")
    private String endOrderTime;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)this.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode", (String)this.getStepCode()));
        if (StringUtils.isNotBlank((CharSequence)this.getStartOrderTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").from((Object)this.getStartOrderTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEndOrderTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"orderTime").to((Object)this.getEndOrderTime()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"orderTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getStartOrderTime() {
        return this.startOrderTime;
    }

    public String getEndOrderTime() {
        return this.endOrderTime;
    }

    public void setStartOrderTime(String startOrderTime) {
        this.startOrderTime = startOrderTime;
    }

    public void setEndOrderTime(String endOrderTime) {
        this.endOrderTime = endOrderTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrderPageReq)) {
            return false;
        }
        GetOrderPageReq other = (GetOrderPageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$startOrderTime = this.getStartOrderTime();
        String other$startOrderTime = other.getStartOrderTime();
        if (this$startOrderTime == null ? other$startOrderTime != null : !this$startOrderTime.equals(other$startOrderTime)) {
            return false;
        }
        String this$endOrderTime = this.getEndOrderTime();
        String other$endOrderTime = other.getEndOrderTime();
        return !(this$endOrderTime == null ? other$endOrderTime != null : !this$endOrderTime.equals(other$endOrderTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetOrderPageReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $startOrderTime = this.getStartOrderTime();
        result = result * 59 + ($startOrderTime == null ? 43 : $startOrderTime.hashCode());
        String $endOrderTime = this.getEndOrderTime();
        result = result * 59 + ($endOrderTime == null ? 43 : $endOrderTime.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetOrderPageReq(startOrderTime=" + this.getStartOrderTime() + ", endOrderTime=" + this.getEndOrderTime() + ")";
    }
}

