/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.req.GetOrderPageReq;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepOrderServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceEsImpl.class);
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;

    public PageResult<SfaVisitStepOrderRespVo> getWorkbenchOrderPage(GetOrderPageReq req) {
        Page list = this.sfaVisitStepOrderEsDataRepositories.search((SearchQuery)req.buildQuery());
        List resultData = list.stream().map(v -> {
            SfaVisitStepOrderRespVo respVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)v, SfaVisitStepOrderRespVo.class);
            List<OrderStepExecuteData.OrderItemReqVo> sfaVisitStepOrderItems = v.getSfaVisitStepOrderItems();
            BigDecimal priceTotal = BigDecimal.ZERO;
            BigDecimal quantityTotal = BigDecimal.ZERO;
            for (OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
                quantityTotal = quantityTotal.add(null == sfaVisitStepOrderItem.getQuantity() ? BigDecimal.ZERO : sfaVisitStepOrderItem.getQuantity());
                priceTotal = priceTotal.add(null == sfaVisitStepOrderItem.getPrice() ? BigDecimal.ZERO : sfaVisitStepOrderItem.getPrice());
            }
            OrderStepExecuteData.OrderItemReqVo temp = sfaVisitStepOrderItems.get(0);
            respVo.setProductName(temp.getProductName());
            respVo.setProductCode(temp.getProductCode());
            respVo.setSeriesCode(temp.getSeriesCode());
            respVo.setSeriesName(temp.getSeriesName());
            respVo.setPicUrl(temp.getPicUrl());
            respVo.setTotalPrice(priceTotal);
            respVo.setQuantity(quantityTotal);
            return respVo;
        }).collect(Collectors.toList());
        return PageResult.builder().data(resultData).count(Long.valueOf(list.getTotalElements())).build();
    }
}

