/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.CompetitorWorkbenchDataReq;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepColletRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="competitorVisitStepExecutor")
public class CompetitorVisitStepExecutor<ExecuteReq extends CompetitorStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, CompetitorStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(CompetitorVisitStepExecutor.class);
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "competitor");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(UUIDGenerator.generate());
        CompetitorWorkbenchDataReq dataReq = (CompetitorWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected SfaVisitStepColletRedisData buildRedisData(VisitStepExecuteReq<? extends CompetitorStepExecuteData> visitStepExecuteReq) {
        CompetitorStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)((Object)CrmBeanUtil.copy((Object)executeData, SfaVisitStepColletRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setSfaVisitStepColletItemReqVos(executeData.getSfaVisitStepColletItemReqVos());
        redisData.setSfaVisitPictureReqVos(executeData.getSfaVisitPictureReqVos());
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        MdmTerminalVo terminalVo = (MdmTerminalVo)this.mdmTerminalFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == terminalVo) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6570\u636e[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, terminalVo.getOrgCode()).getResult();
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        redisData.setClientOfficeId(terminalVo.getOrgCode());
        redisData.setClientOffice(terminalVo.getOrgName());
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        CompetitorStepExecuteData stepExecuteData = (CompetitorStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepColletItemReqVos())) {
            throw new BusinessException("\u7ade\u54c1\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        List<CrmAttachment> sfaVisitPictureReqVos = stepExecuteData.getSfaVisitPictureReqVos();
        this.checkPics(sfaVisitPictureReqVos, 1, 5, "\u7ade\u54c1");
    }

    @Override
    protected CompetitorStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)((Object)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepColletRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepColletEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    public CompetitorStepExecuteDataResp loadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        if (StringUtils.isBlank((CharSequence)bizId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getClientType())) {
                throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            CompetitorStepExecuteDataResp dataResp = new CompetitorStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode()));
            return dataResp;
        }
        SfaVisitStepColletEsData redisData = (SfaVisitStepColletEsData)this.getEsDataById(bizId);
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)((Object)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepColletRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepColletEsData dataResp = (SfaVisitStepColletEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepColletEsData.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.sfaVisitStepColletEsDataRepositories.save(dataResp);
    }
}

