/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitAssitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitAssitPlanRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanRangeMapper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitAssitPlanService;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitAssitPlanServiceExpandImpl"})
public class SfaVisitAssitPlanServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitPlanMapper, SfaVisitPlanEntity>
implements ISfaVisitAssitPlanService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitAssitPlanServiceImpl.class);
    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;
    @Resource
    private SfaVisitPlanRangeMapper sfaVisitPlanRangeMapper;
    @Autowired
    private ISfaVisitPlanRangeService iSfaVisitPlanRangeService;

    @Override
    public PageResult<SfaVisitAssitPlanRespVo> findList(SfaVisitAssitPlanReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitAssitPlanRespVo> list = this.sfaVisitPlanMapper.findAssitList((Page<SfaVisitAssitPlanRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitAssitPlanRespVo query(SfaVisitAssitPlanReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitAssitPlanRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitAssitPlanRespVo();
        }
        SfaVisitAssitPlanRespVo respVo = (SfaVisitAssitPlanRespVo)list.get(0);
        SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        sfaVisitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        List sfaVisitPlanRangeRespVos = this.iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
        respVo.setSfaVisitPlanRangeRespVos(sfaVisitPlanRangeRespVos);
        return respVo;
    }

    public void saveCheck(SfaVisitAssitPlanReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getPlanType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!SfaVisitEnum.visitType.GETMAP.containsKey(reqVo.getPlanType())) {
            throw new BusinessException("\u62dc\u8bbf\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u62dc\u8bbf\u7c7b\u578b(01:\u4e34\u65f6\u62dc\u8bbf\u300102:\u8ba1\u5212\u62dc\u8bbf\u300103:\u534f\u8bbf)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getRouteType(), (String)"\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a(1:\u7ebf\u8def\u7ec4\u30012:\u7f51\u70b9\u30013:\u9891\u7387)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())) {
            throw new BusinessException("\u7ef4\u5ea6\u7c7b\u578b\u6709\u8bef,\u4e0d\u5b58\u5728\u8be5\u7ef4\u5ea6(1:\u7ebf\u8def\u7ec4\u30012:\u7f51\u70b9\u30013:\u9891\u7387)");
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserId(), (String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitRealName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosId(), (String)"\u4eba\u5458\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosName(), (String)"\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgId(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgCode(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgName(), (String)"\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvUserId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvUserName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvRealName(), (String)"\u8bf7\u9009\u62e9\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getCvPosId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvPosCode(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvPosName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvOrgId(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvOrgCode(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvOrgName(), (String)"\u88ab\u534f\u8bbf\u7684\u4eba\u5458\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCvVisitDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = ymd.parse(reqVo.getCvVisitDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u534f\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (CollectionUtil.listNotEmpty((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            throw new BusinessException("\u62dc\u8bbf\u8ba1\u5212\u5236\u5b9a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : reqVo.getSfaVisitPlanRangeReqVos()) {
            AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientId(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a"));
            AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientCode(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientName(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            AssertUtils.isNotEmpty((String)sfaVisitPlanRangeReqVo.getClientType(), (String)("\u7b2c" + i + "\u884c,\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
            sfaVisitPlanRangeReqVo.setFirstVisitDate(reqVo.getCvVisitDate());
            ++i;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitAssitPlanReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanEntity.class));
        String code = CodeUtil.createCode();
        entity.setVisitPlanCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(SfaVisitAssitPlanReqVo reqVo, SfaVisitPlanEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaVisitPlanRangeReqVos())) {
            List visitPlanRangeEntities = reqVo.getSfaVisitPlanRangeReqVos().stream().map(o -> {
                SfaVisitPlanRangeEntity receivingEntity = new SfaVisitPlanRangeEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)receivingEntity));
                receivingEntity.setVisitPlanCode(entity.getVisitPlanCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitPlanRangeService.saveBatch(visitPlanRangeEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitAssitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanEntity entity = (SfaVisitPlanEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        reqVo.setVisitPlanCode(entity.getVisitPlanCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitAssitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaVisitPlanMapper.deleteProductsByParamsAssit(reqVo);
        List visitPlanCodes = list.stream().map(SfaVisitAssitPlanRespVo::getVisitPlanCode).collect(Collectors.toList());
        reqVo.setVisitPlanCodes(visitPlanCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitAssitPlanReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitPlanCode()) && CollectionUtil.listEmpty((List)reqVo.getVisitPlanCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitPlanRangeReqVo visitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        visitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        visitPlanRangeReqVo.setVisitPlanCodes(reqVo.getVisitPlanCodes());
        this.sfaVisitPlanRangeMapper.deleteProductsByParams(visitPlanRangeReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitAssitPlanReqVo reqVo) {
        List sfaVisitPlanEntities;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(reqVo.getIds())))) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitAssitPlanReqVo reqVo) {
        List sfaVisitPlanEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaVisitPlanEntities = this.sfaVisitPlanMapper.selectBatchIds(reqVo.getIds())))) {
            sfaVisitPlanEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }
}

