/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.controller.resp.BaseVisitStepResp;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAndSalesTrendChartRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingDetailedRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitPlanInfoServiceExpandImpl"})
@Transactional
public class SfaVisitPlanInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitPlanInfoMapper, SfaVisitPlanInfoEntity>
implements ISfaVisitPlanInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;

    @Override
    @Transactional(readOnly=true)
    public SfaVisitResp getVisitInfoList(GetVisitListReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req);
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoResp = this.convertPlanInfoData(planInfoEntities, req);
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(planInfoResp);
        int complete = 0;
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            if (!SfaVisitEnum.visitStatus.V3.getVal().equals(planInfoEntity.getVisitStatus()) && !SfaVisitEnum.visitStatus.V4.getVal().equals(planInfoEntity.getVisitStatus())) continue;
            ++complete;
        }
        sfaVisitResp.setTotal(planInfoEntities.size());
        sfaVisitResp.setComplete(complete);
        return sfaVisitResp;
    }

    public List<SfaVisitPlanInfoEntity> doGetVisitInfoList(GetVisitListReq req) {
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add("sfa_visit_plan_info").add(req.getVisitUserName()).add(req.getVisitPositionCode()).add(req.getVisitDate());
        List planInfoEntities = (List)this.redisService.hmValues(joiner.toString());
        if (null == planInfoEntities) {
            return Lists.newArrayList();
        }
        return planInfoEntities;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SfaVisitPlanInfoEntity> getVisitInfoListByClientType(GetVisitListReq.MoreReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req);
        String clientType2 = req.getClientType();
        if (StringUtils.isBlank((CharSequence)clientType2)) {
            return planInfoEntities;
        }
        return planInfoEntities.stream().filter(v -> clientType2.equals(v.getClientType())).collect(Collectors.toList());
    }

    private List<SfaVisitResp.SfaVisitPlanInfoResp> convertPlanInfoData(List<SfaVisitPlanInfoEntity> planInfoEntities, GetVisitListReq req) {
        List planInfoResp = CrmBeanUtil.copyList(planInfoEntities, SfaVisitResp.SfaVisitPlanInfoResp.class);
        Map cusType = DictUtil.getDictValueMapsByCodes((String)"sfacusType");
        Map visitStatus2 = DictUtil.getDictValueMapsByCodes((String)"visit_status");
        Map<String, Map<String, VisitStepResp>> stepRespMap = null;
        if (planInfoResp.size() > 0) {
            stepRespMap = this.sfaVisitRoleDirectoryService.findRoleVisitStepMapForClientTypes(planInfoEntities.get(0).getVisitPosCode(), Lists.newArrayList((Iterable)planInfoEntities.stream().map(SfaVisitPlanInfoEntity::getClientType).collect(Collectors.toSet())), SfaVisitEnum.sfaVisitType.VISIT);
        }
        for (SfaVisitResp.SfaVisitPlanInfoResp data : planInfoResp) {
            data.setClientTypeName((String)cusType.get(data.getClientType()));
            data.setVisitStatusName((String)visitStatus2.get(data.getVisitStatus()));
            if (null != data.getDistance()) {
                data.setDistance(data.getDistance().divide(new BigDecimal(1000)).setScale(2, 1));
            }
            if (com.biz.crm.util.StringUtils.isNotEmpty((String)req.getVisitUserName())) {
                Map<String, String> buttons = this.getButtons(req.getVisitUserName(), data.getVisitStatus(), data.getVisitDate());
                data.setButtons(buttons);
            }
            this.buildFormId(data, stepRespMap);
        }
        return planInfoResp;
    }

    private void buildFormId(SfaVisitResp.SfaVisitPlanInfoResp data, Map<String, Map<String, VisitStepResp>> stepRespMap) {
        Map<String, VisitStepResp> clientTypeStep = stepRespMap.get(data.getClientType());
        if (null == clientTypeStep) {
            return;
        }
        BaseVisitStepResp inStore = null;
        BaseVisitStepResp outStore = null;
        Collection<VisitStepResp> values = clientTypeStep.values();
        for (VisitStepResp value : values) {
            if (SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(value.getPageCode())) {
                inStore = value;
            }
            if (!SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(value.getPageCode())) continue;
            outStore = value;
        }
        if (null != inStore) {
            data.setFormIdAsInStore(inStore.getFormId());
        }
        if (null != outStore) {
            data.setFormIdAsOutStore(outStore.getFormId());
        }
    }

    @Override
    public PageResult<SfaVisitPlanInfoRespVo> findList(SfaVisitPlanInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitPlanInfoRespVo> list = this.sfaVisitPlanInfoMapper.findList((Page<SfaVisitPlanInfoRespVo>)page, reqVo);
        list.forEach(data -> {
            if (data.getDistance() != null) {
                data.setDistance(data.getDistance().divide(new BigDecimal(1000)).setScale(2, 1));
            }
            if (com.biz.crm.util.StringUtils.isNotEmpty((String)reqVo.getVisitUserName())) {
                Map<String, String> buttons = this.getButtons(reqVo.getVisitUserName(), data.getVisitStatus(), data.getVisitDate());
                data.setButtons(buttons);
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private Map<String, String> getButtons(String visitUserName, String visitStatus2, String visitDate) {
        LocalDate now = LocalDate.now();
        LocalDate localVisitDate = LocalDate.parse(visitDate, CrmDateUtils.yyyyMMdd);
        HashMap<String, String> map = new HashMap<String, String>();
        String username = UserUtils.getUser().getUsername();
        AssertUtils.isNotEmpty((String)username, (String)"\u672a\u83b7\u53d6\u5230\u767b\u9646\u4eba\u4fe1\u606f");
        map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
        map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
        map.put(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
        map.put(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal(), SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getDesc());
        map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
        map.put(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
        if (!now.isEqual(localVisitDate)) {
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
        }
        if (now.isBefore(localVisitDate) && !now.isEqual(localVisitDate)) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal());
        }
        if (visitStatus2.equals(SfaVisitEnum.visitStatus.V1.getVal())) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal());
            if (!visitUserName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            }
        } else if (visitStatus2.equals(SfaVisitEnum.visitStatus.V2.getVal())) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal());
            if (!visitUserName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            }
        } else if (visitStatus2.equals(SfaVisitEnum.visitStatus.V3.getVal())) {
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION_DETAIL.getVal());
        } else if (visitStatus2.equals(SfaVisitEnum.visitStatus.V4.getVal())) {
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal());
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
        }
        return map;
    }

    @Override
    @Deprecated
    public SfaVisitProgressRespVo visitProgress(final SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        SfaVisitProgressRespVo sfaVisitProgressRespVo = new SfaVisitProgressRespVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"visit_user_name", (Object)sfaVisitPlanInfoReqVo.getVisitUserName());
        queryWrapper.eq((Object)"visit_date", (Object)sfaVisitPlanInfoReqVo.getVisitDate());
        queryWrapper.eq((Object)"visit_status", (Object)SfaVisitStatusEnum.PROCESSING.getCode());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.getOne((Wrapper)queryWrapper);
        if (sfaVisitPlanInfoEntity != null) {
            sfaVisitProgressRespVo.setInProgress(Boolean.valueOf(true));
            sfaVisitProgressRespVo.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
            sfaVisitProgressRespVo.setClientName(sfaVisitPlanInfoEntity.getClientName());
            sfaVisitProgressRespVo.setClientType(sfaVisitPlanInfoEntity.getClientType());
        }
        sfaVisitPlanInfoReqVo.setVisitStatus(SfaVisitStatusEnum.FINISHED.getCode());
        int rows = this.sfaVisitPlanInfoMapper.getCount(sfaVisitPlanInfoReqVo);
        SfaVisitPlanInfoReqVo param = new SfaVisitPlanInfoReqVo(){
            {
                this.setVisitUserName(sfaVisitPlanInfoReqVo.getVisitUserName());
                this.setVisitDate(sfaVisitPlanInfoReqVo.getVisitDate());
                this.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            }
        };
        Integer totalNum = this.sfaVisitPlanInfoMapper.getCount(param);
        sfaVisitProgressRespVo.setComplete(Integer.valueOf(rows));
        sfaVisitProgressRespVo.setVisitTotalNum(totalNum);
        return sfaVisitProgressRespVo;
    }

    @Override
    public SfaVisitPlanInfoRespVo query(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.getById((Serializable)((Object)reqVo.getId()));
        return (SfaVisitPlanInfoRespVo)CrmBeanUtil.copy((Object)sfaVisitPlanInfoEntity, SfaVisitPlanInfoRespVo.class);
    }

    @Override
    public String checkAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
        String redisHash = this.doCheckAddForTempPlan(infoEntities);
        List dbData = (List)this.redisService.hmValues(redisHash);
        if (null == dbData) {
            dbData = Lists.newArrayList();
        }
        Map<String, SfaVisitPlanInfoEntity> objectObjectMap = dbData.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getRedisHashKey, v -> v, (t, t2) -> t2));
        StringJoiner msg = new StringJoiner(",");
        for (SfaVisitPlanInfoEntity infoEntity : infoEntities) {
            if (objectObjectMap.containsKey(infoEntity.getRedisHashKey())) {
                msg.add(infoEntity.getClientName());
            }
            objectObjectMap.put(infoEntity.getRedisHashKey(), infoEntity);
        }
        if (msg.length() > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728[" + msg.toString() + "]\u7684\u62dc\u8bbf\u8ba1\u5212");
        }
        return redisHash;
    }

    private Boolean positionHasClient(final String visitPosCode, String clientCode, String clientType2) {
        Boolean flag = true;
        if (SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal().equals(clientType2)) {
            Result mdmCustomerResult = this.mdmCustomerMsgFeign.listAndContactPage(new MdmCustomerContactPageReqVo(){
                {
                    this.setPositionCode(visitPosCode);
                    this.setPageSize(5000);
                    this.setPageNum(1);
                }
            });
            if (mdmCustomerResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)mdmCustomerResult.getResult()).getData())) {
                Map<String, String> customerMap = ((PageResult)mdmCustomerResult.getResult()).getData().stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, MdmCustomerMsgRespVo::getCustomerName));
                if (!customerMap.containsKey(clientCode)) {
                    flag = false;
                }
            } else {
                flag = false;
            }
        } else {
            Result mdmTerminalResult = this.mdmTerminalFeign.userTerminalContactPage(new MdmTerminalContactPageReqVo(){
                {
                    this.setPositionCode(visitPosCode);
                    this.setPageNum(1);
                    this.setPageSize(5000);
                }
            });
            if (mdmTerminalResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)mdmTerminalResult.getResult()).getData())) {
                Map<String, String> terminalMap = ((PageResult)mdmTerminalResult.getResult()).getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, MdmTerminalContactPageVo::getTerminalName));
                if (!terminalMap.containsKey(clientCode)) {
                    flag = false;
                }
            } else {
                flag = false;
            }
        }
        return flag;
    }

    @Override
    public void update(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity entity = (SfaVisitPlanInfoEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = this.deleteBatchCheck(ids);
        HashMap temp = Maps.newHashMap();
        for (SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity : sfaVisitPlanInfoEntities) {
            String redisHash2 = sfaVisitPlanInfoEntity.redisHash().toString();
            List list = (List)temp.get(redisHash2);
            if (null == list) {
                list = Lists.newArrayList();
            }
            list.add(sfaVisitPlanInfoEntity);
            temp.put(redisHash2, list);
        }
        temp.forEach((redisHash, infoEntities) -> {
            List<String> redisHashKeys = infoEntities.stream().map(SfaVisitPlanInfoEntity::getRedisHashKey).collect(Collectors.toList());
            Object[] redisHashKey = redisHashKeys.toArray(new String[redisHashKeys.size()]);
            this.redisService.hdel(redisHash, redisHashKey);
        });
        this.sfaVisitPlanInfoServiceEsImpl.deleteByIds(ids);
    }

    private List<SfaVisitPlanInfoEntity> deleteBatchCheck(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoServiceEsImpl.findByIds(ids);
        if (org.springframework.util.CollectionUtils.isEmpty(sfaVisitPlanInfoEntities)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u6570\u636e");
        }
        LocalDate nowDate = LocalDate.now();
        sfaVisitPlanInfoEntities.forEach(plan -> {
            LocalDate visitDate = LocalDate.parse(plan.getVisitDate(), CrmDateUtils.yyyyMMdd);
            if (nowDate.compareTo(visitDate) > 0) {
                throw new BusinessException("\u4e0d\u53ef\u5220\u9664\u5386\u53f2\u62dc\u8bbf\u8ba1\u5212");
            }
            if (!SfaVisitEnum.visitStatus.V1.getVal().equals(plan.getVisitStatus())) {
                throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u62dc\u8bbf\u7684\u8ba1\u5212");
            }
            SfaVisitPlanInfoEntity redisData = (SfaVisitPlanInfoEntity)this.redisService.hmget(plan.redisHash().toString(), (Object)plan.getRedisHashKey());
            if (null != redisData && !SfaVisitEnum.visitStatus.V1.getVal().equals(plan.getVisitStatus())) {
                throw new BusinessException("\u53ea\u80fd\u5220\u9664\u672a\u62dc\u8bbf\u7684\u8ba1\u5212");
            }
            if (!SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(plan.getVisitType()) && nowDate.compareTo(visitDate) == 0) {
                throw new BusinessException("\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u975e\u4e34\u65f6\u62dc\u8bbf\u8ba1\u5212");
            }
        });
        return sfaVisitPlanInfoEntities;
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    private String doCheckAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
        if (org.springframework.util.CollectionUtils.isEmpty(infoEntities)) {
            throw new BusinessException("\u6ca1\u6709\u53ef\u6dfb\u52a0\u7684\u4e34\u65f6\u8ba1\u5212");
        }
        StringJoiner joiner = new StringJoiner(":");
        joiner.add("SFA_VISIT").add("sfa_visit_plan_info").add(infoEntities.get(0).getVisitUserName()).add(infoEntities.get(0).getVisitPosCode()).add(infoEntities.get(0).getVisitDate());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)infoEntities.get(0).getVisitOrgCode());
        for (SfaVisitPlanInfoEntity infoEntity : infoEntities) {
            if (null != mdmOrgRespVo) {
                infoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
                infoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
            }
            infoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            infoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            infoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        }
        return joiner.toString();
    }

    @Override
    public List<SfaVisitAndSalesTrendChartRespVo> findVisiAndSalesTrendChart() {
        UserRedis userRedis = UserUtils.getUser();
        String monthsStr = ParamUtil.getParameterValue((String)"visi_sales_months");
        Integer months = ParameterParam.VISI_SALES_MONTHS_DEFAULT_VALUE;
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)monthsStr)) {
            months = Integer.valueOf(monthsStr);
        }
        ArrayList<String> monthsList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        monthsList.add(DateUtil.yyyy_MM.format(calendar.getTime()));
        for (int i = 1; i < months; ++i) {
            calendar.add(2, -1);
            monthsList.add(DateUtil.yyyy_MM.format(calendar.getTime()));
        }
        List<SfaAchievementTimeTotalRespVo> accomplishVisitNum = this.achievementAccomplishRecordMapper.findAccomplishNumByYm(userRedis.getPoscode(), SfaVisitEnum.indexType.WDBF.getCode(), monthsList);
        List visitList = accomplishVisitNum.stream().map(a -> new SfaVisitAndSalesTrendChartRespVo(a.getTimeOfPeriod(), new BigDecimal(a.getAccomplishNum()), new BigDecimal(0))).collect(Collectors.toList());
        Map<String, BigDecimal> visitMap = visitList.stream().collect(Collectors.toMap(SfaVisitAndSalesTrendChartRespVo::getYearMonth, SfaVisitAndSalesTrendChartRespVo::getVisitNumber));
        List<SfaAchievementTimeTotalRespVo> accomplishOrderNum = this.achievementAccomplishRecordMapper.findAccomplishNumByYm(userRedis.getPoscode(), SfaVisitEnum.indexType.XD.getCode(), monthsList);
        List salesList = accomplishOrderNum.stream().map(a -> new SfaVisitAndSalesTrendChartRespVo(a.getTimeOfPeriod(), new BigDecimal(0), new BigDecimal(a.getAccomplishNum()))).collect(Collectors.toList());
        Map<String, BigDecimal> salesMap = salesList.stream().collect(Collectors.toMap(SfaVisitAndSalesTrendChartRespVo::getYearMonth, SfaVisitAndSalesTrendChartRespVo::getSalesNumber));
        ArrayList<SfaVisitAndSalesTrendChartRespVo> voList = new ArrayList<SfaVisitAndSalesTrendChartRespVo>();
        Collections.sort(monthsList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer m1 = Integer.valueOf(o1.split("-")[0]) * 100 + Integer.valueOf(o1.split("-")[1]);
                Integer m2 = Integer.valueOf(o2.split("-")[0]) * 100 + Integer.valueOf(o2.split("-")[1]);
                return Integer.compare(m1, m2);
            }
        });
        String[] CN_CHARS = new String[]{"", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
        for (String monthsx : monthsList) {
            SfaVisitAndSalesTrendChartRespVo vo = new SfaVisitAndSalesTrendChartRespVo();
            vo.setYearMonth(monthsx);
            Integer month = Integer.valueOf(monthsx.split("-")[1]);
            vo.setMonthDes(CN_CHARS[month] + "\u6708");
            if (visitMap.containsKey(monthsx)) {
                vo.setVisitNumber(visitMap.get(monthsx));
            }
            if (salesMap.containsKey(monthsx)) {
                vo.setSalesNumber(salesMap.get(monthsx));
            }
            voList.add(vo);
        }
        return voList;
    }

    @Override
    public SfaVisitRankingRespVo findVisitRankingList() {
        UserRedis userRedis = UserUtils.getUser();
        String daysStr = ParamUtil.getParameterValue((String)"visit_ranking_cycle");
        Integer days = ParameterParam.VISIT_RANKING_CYCLE_DEFAULT_VALUE;
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)daysStr)) {
            days = Integer.valueOf(daysStr);
        }
        SfaVisitRankingRespVo respVo = new SfaVisitRankingRespVo();
        respVo.setDays(days);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        String endDate = DateUtil.date_sdf.format(calendar.getTime());
        calendar.add(5, -1 * (days - 1));
        String startDate = DateUtil.date_sdf.format(calendar.getTime());
        List positionRespVoList = PositionUtil.getChildrenPositionListExcludeSelf((String)userRedis.getPoscode());
        ArrayList<String> posCodeList = new ArrayList<String>();
        for (MdmPositionRespVo positionResp : positionRespVoList) {
            posCodeList.add(positionResp.getPositionCode());
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(posCodeList)) {
            return respVo;
        }
        List positionUserList = (List)this.mdmPositionFeign.detailBatchByPositionCodeList(posCodeList).getResult();
        ArrayList<String> positionCodeList = new ArrayList<String>();
        HashMap<String, MdmPositionUserOrgRespVo> positionUserMap = new HashMap<String, MdmPositionUserOrgRespVo>();
        for (MdmPositionUserOrgRespVo positionUser : positionUserList) {
            positionCodeList.add(positionUser.getPositionCode());
            positionUserMap.put(positionUser.getPositionCode(), positionUser);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            return respVo;
        }
        List<SfaAchievementTimeTotalRespVo> accomplishNum = this.achievementAccomplishRecordMapper.findPosCodeListAccomplishNum(positionCodeList, SfaVisitEnum.indexType.WDBF.getCode(), startDate, endDate);
        List respVoList = accomplishNum.stream().map(a -> new SfaVisitRankingDetailedRespVo(a.getPosCode(), new BigDecimal(a.getAccomplishNum()))).collect(Collectors.toList());
        ArrayList<SfaVisitRankingDetailedRespVo> detailedList = new ArrayList<SfaVisitRankingDetailedRespVo>();
        String topfewStr = ParamUtil.getParameterValue((String)"visit_ranking_topfew");
        Integer topfew = ParameterParam.VISIT_RANKING_TOPFEW_DEFAULT_VALUE;
        if (com.biz.crm.util.StringUtils.isNotEmpty((String)topfewStr)) {
            topfew = Integer.valueOf(topfewStr);
        }
        for (int i = 0; i < topfew && i < respVoList.size(); ++i) {
            SfaVisitRankingDetailedRespVo detailedRespVo = (SfaVisitRankingDetailedRespVo)respVoList.get(i);
            MdmPositionUserOrgRespVo positionUser = (MdmPositionUserOrgRespVo)positionUserMap.get(detailedRespVo.getPoscode());
            detailedRespVo.setPosname(positionUser.getPositionName());
            detailedRespVo.setUsername(positionUser.getUserName());
            detailedRespVo.setRealname(positionUser.getFullName());
            detailedList.add(detailedRespVo);
        }
        respVo.setDetailedList(detailedList);
        return respVo;
    }
}

