/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.checkin.mapper.SfaCheckInSignGroupReportMapper;
import com.biz.crm.checkin.model.SfaCheckInGroupEntity;
import com.biz.crm.checkin.model.SfaCheckInSignGroupReportEntity;
import com.biz.crm.checkin.service.ISfaCheckInGroupService;
import com.biz.crm.checkin.service.ISfaCheckInSignGroupReportService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInDateRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInTypeRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInUserRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaCheckInSignGroupReportServiceExpandImpl"})
public class SfaCheckInSignGroupReportServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCheckInSignGroupReportMapper, SfaCheckInSignGroupReportEntity>
implements ISfaCheckInSignGroupReportService {
    private static final Logger log = LoggerFactory.getLogger(SfaCheckInSignGroupReportServiceImpl.class);
    @Resource
    private SfaCheckInSignGroupReportMapper sfaCheckInSignGroupReportMapper;
    @Autowired
    private ISfaCheckInGroupService iSfaCheckInGroupService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void refreshReport(String groupCode) {
        SfaCheckInGroupRespVo groupVo = this.iSfaCheckInGroupService.getByGroupCode(groupCode);
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)groupVo.getOrgRespVos())) {
            List positionRespVos = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findOrgWithSinglePositionList(groupVo.getOrgRespVos().stream().map(vo -> vo.getOrgCode()).collect(Collectors.toList())), (boolean)true);
            positionRespVos.forEach(vo -> {
                if (CollectionUtils.isNotEmpty((Collection)vo.getPositionList())) {
                    vo.getPositionList().forEach(v -> {
                        if (YesNoEnum.yesNoEnum.ONE.getValue().equals(v.getPrimaryFlag())) {
                            UserInfo user = new UserInfo();
                            user.loding(v.getUserName(), v.getFullName(), v.getPositionCode(), v.getPositionName(), v.getOrgCode(), v.getOrgName(), v.getParentOrgCode(), v.getParentOrgName());
                            list.add(user);
                        }
                    });
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)groupVo.getUserRespVos())) {
            MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
            positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            positionUserOrgReqVo.setUserNameList(groupVo.getUserRespVos().stream().map(SfaCheckInUserRespVo::getUserName).collect(Collectors.toList()));
            positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            List mdmUserList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
            mdmUserList.forEach(v -> {
                UserInfo user = new UserInfo();
                user.loding(v.getUserName(), v.getFullName(), v.getPositionCode(), v.getPositionName(), v.getOrgCode(), v.getOrgName(), v.getParentOrgCode(), v.getParentOrgName());
                list.add(user);
            });
        }
        Map<String, UserInfo> userMap = list.stream().collect(Collectors.toMap(UserInfo::getUserName, vo -> vo, (k1, k2) -> k2));
        LocalDateTime nowTime = LocalDateTime.now();
        List signList = this.sfaCheckInSignGroupReportMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class).eq(SfaCheckInSignGroupReportEntity::getGroupCode, (Object)groupVo.getGroupCode())).eq(SfaCheckInSignGroupReportEntity::getSignStatus, (Object)SfaWorkSignEnum.WorkSignStatus.OK.getVal())).eq(CrmBaseEntity::getCreateDate, (Object)nowTime.format(CrmDateUtils.yyyyMMdd)));
        Set<Object> signEntitySet = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)signList)) {
            signEntitySet = signList.stream().map(entity -> entity.getGroupCode() + entity.getCheckInDateId() + entity.getCheckInTypeId()).collect(Collectors.toSet());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ArrayList<SfaCheckInSignGroupReportEntity> entityList = new ArrayList<SfaCheckInSignGroupReportEntity>();
        if (VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(groupVo.getTimeType())) {
            for (SfaCheckInDateRespVo sfaCheckInDateRespVo : groupVo.getDateRespVos()) {
                for (SfaCheckInTypeRespVo sfaCheckInTypeRespVo : groupVo.getTypeRespVos()) {
                    for (String key : userMap.keySet()) {
                        LocalDateTime startTime = LocalDateTime.of(LocalDate.parse(sfaCheckInDateRespVo.getStartTime(), formatter), LocalTime.MIN);
                        LocalDateTime endTime = LocalDateTime.of(LocalDate.parse(sfaCheckInDateRespVo.getEndTime(), formatter), LocalTime.MIN);
                        int compareToStartTime = nowTime.compareTo(startTime);
                        int compareToEndTime = nowTime.compareTo(endTime);
                        if (compareToStartTime < 0 && compareToEndTime > 0) continue;
                        UserInfo user = userMap.get(key);
                        SfaCheckInSignGroupReportEntity entity2 = (SfaCheckInSignGroupReportEntity)((Object)CrmBeanUtil.copy((Object)user, SfaCheckInSignGroupReportEntity.class));
                        entity2.setSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
                        entityList.add(entity2);
                        entity2.setGroupName(groupVo.getGroupName());
                        entity2.setGroupCode(groupVo.getGroupCode());
                        entity2.setCheckInDate(nowTime.format(CrmDateUtils.yyyyMMddHHmmss));
                        entity2.setCheckInTypeId(sfaCheckInTypeRespVo.getId());
                        entity2.setCheckInTypeName(sfaCheckInTypeRespVo.getTypeName());
                        if (!signEntitySet.contains(entity2.getGroupCode() + entity2.getCheckInDateId() + entity2.getCheckInTypeId())) continue;
                        entity2.setSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                    }
                }
            }
        } else {
            for (SfaCheckInTypeRespVo sfaCheckInTypeRespVo : groupVo.getTypeRespVos()) {
                for (String key : userMap.keySet()) {
                    UserInfo user = userMap.get(key);
                    SfaCheckInSignGroupReportEntity entity3 = (SfaCheckInSignGroupReportEntity)((Object)CrmBeanUtil.copy((Object)user, SfaCheckInSignGroupReportEntity.class));
                    entity3.setSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
                    entityList.add(entity3);
                    entity3.setGroupName(groupVo.getGroupName());
                    entity3.setGroupCode(groupVo.getGroupCode());
                    entity3.setCheckInDate(nowTime.format(CrmDateUtils.yyyyMMddHHmmss));
                    entity3.setCheckInTypeId(sfaCheckInTypeRespVo.getId());
                    entity3.setCheckInTypeName(sfaCheckInTypeRespVo.getTypeName());
                    if (!signEntitySet.contains(entity3.getGroupCode() + entity3.getCheckInDateId() + entity3.getCheckInTypeId())) continue;
                    entity3.setSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                }
            }
        }
        this.sfaCheckInSignGroupReportMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class).eq(SfaCheckInSignGroupReportEntity::getGroupCode, (Object)groupVo.getGroupCode())).eq(CrmBaseEntity::getCreateDate, (Object)nowTime.format(CrmDateUtils.yyyyMMdd)));
        this.saveBatch(entityList);
    }

    @Override
    public void refreshReportByUserName(String groupCode, String checkInDate, String checkInType, String userName) {
        SfaCheckInSignGroupReportEntity entity = (SfaCheckInSignGroupReportEntity)((Object)this.sfaCheckInSignGroupReportMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class).eq(SfaCheckInSignGroupReportEntity::getGroupCode, (Object)groupCode)).eq(SfaCheckInSignGroupReportEntity::getCheckInDateId, (Object)checkInDate)).eq(SfaCheckInSignGroupReportEntity::getCheckInTypeId, (Object)checkInType)).eq(SfaCheckInSignGroupReportEntity::getUserName, (Object)userName)));
        if (entity == null) {
            SfaCheckInGroupRespVo groupVo = this.iSfaCheckInGroupService.getByGroupCode(groupCode);
            SfaCheckInDateRespVo dateRespVo = (SfaCheckInDateRespVo)groupVo.getDateRespVos().stream().filter(vo -> vo.getId().equals(checkInDate)).collect(Collectors.toList()).get(0);
            SfaCheckInTypeRespVo typeRespVo = (SfaCheckInTypeRespVo)groupVo.getTypeRespVos().stream().filter(vo -> vo.getId().equals(checkInType)).collect(Collectors.toList()).get(0);
            MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
            positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            positionUserOrgReqVo.setUserName(userName);
            positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
            MdmPositionUserOrgRespVo mdmUserVo = (MdmPositionUserOrgRespVo)((List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true)).get(0);
            UserInfo user = new UserInfo();
            user.loding(mdmUserVo.getUserName(), mdmUserVo.getFullName(), mdmUserVo.getPositionCode(), mdmUserVo.getPositionName(), mdmUserVo.getOrgCode(), mdmUserVo.getOrgName(), mdmUserVo.getParentOrgCode(), mdmUserVo.getParentOrgName());
            entity = (SfaCheckInSignGroupReportEntity)((Object)CrmBeanUtil.copy((Object)user, SfaCheckInSignGroupReportEntity.class));
            entity.setGroupName(groupVo.getGroupName());
            entity.setGroupCode(groupVo.getGroupCode());
            entity.setCheckInDateId(dateRespVo.getId());
            entity.setCheckInDate(typeRespVo.getId());
            entity.setCheckInTypeId(typeRespVo.getId());
            entity.setCheckInTypeName(typeRespVo.getTypeName());
        }
        entity.setSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
        this.saveOrUpdate((Object)entity);
    }

    @Override
    public void timedTaskReport() {
        List groupEntities = this.iSfaCheckInGroupService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCheckInGroupEntity.class).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        groupEntities.forEach(data -> this.refreshReport(data.getGroupCode()));
    }

    private class UserInfo {
        private String userName;
        private String realName;
        private String posCode;
        private String posName;
        private String orgCode;
        private String orgName;
        private String parentOrgCode;
        private String parentOrgName;

        public void loding(String userName, String realName, String posCode, String posName, String orgCode, String orgName, String parentOrgCode, String parentOrgName) {
            this.userName = userName;
            this.realName = realName;
            this.posCode = posCode;
            this.posName = posName;
            this.orgCode = orgCode;
            this.orgName = orgName;
            this.parentOrgCode = parentOrgCode;
            this.parentOrgName = parentOrgName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRealName() {
            return this.realName;
        }

        public String getPosCode() {
            return this.posCode;
        }

        public String getPosName() {
            return this.posName;
        }

        public String getOrgCode() {
            return this.orgCode;
        }

        public String getOrgName() {
            return this.orgName;
        }

        public String getParentOrgCode() {
            return this.parentOrgCode;
        }

        public String getParentOrgName() {
            return this.parentOrgName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setRealName(String realName) {
            this.realName = realName;
        }

        public void setPosCode(String posCode) {
            this.posCode = posCode;
        }

        public void setPosName(String posName) {
            this.posName = posName;
        }

        public void setOrgCode(String orgCode) {
            this.orgCode = orgCode;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }

        public void setParentOrgCode(String parentOrgCode) {
            this.parentOrgCode = parentOrgCode;
        }

        public void setParentOrgName(String parentOrgName) {
            this.parentOrgName = parentOrgName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserInfo)) {
                return false;
            }
            UserInfo other = (UserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$realName = this.getRealName();
            String other$realName = other.getRealName();
            if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
                return false;
            }
            String this$posCode = this.getPosCode();
            String other$posCode = other.getPosCode();
            if (this$posCode == null ? other$posCode != null : !this$posCode.equals(other$posCode)) {
                return false;
            }
            String this$posName = this.getPosName();
            String other$posName = other.getPosName();
            if (this$posName == null ? other$posName != null : !this$posName.equals(other$posName)) {
                return false;
            }
            String this$orgCode = this.getOrgCode();
            String other$orgCode = other.getOrgCode();
            if (this$orgCode == null ? other$orgCode != null : !this$orgCode.equals(other$orgCode)) {
                return false;
            }
            String this$orgName = this.getOrgName();
            String other$orgName = other.getOrgName();
            if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
                return false;
            }
            String this$parentOrgCode = this.getParentOrgCode();
            String other$parentOrgCode = other.getParentOrgCode();
            if (this$parentOrgCode == null ? other$parentOrgCode != null : !this$parentOrgCode.equals(other$parentOrgCode)) {
                return false;
            }
            String this$parentOrgName = this.getParentOrgName();
            String other$parentOrgName = other.getParentOrgName();
            return !(this$parentOrgName == null ? other$parentOrgName != null : !this$parentOrgName.equals(other$parentOrgName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $realName = this.getRealName();
            result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
            String $posCode = this.getPosCode();
            result = result * 59 + ($posCode == null ? 43 : $posCode.hashCode());
            String $posName = this.getPosName();
            result = result * 59 + ($posName == null ? 43 : $posName.hashCode());
            String $orgCode = this.getOrgCode();
            result = result * 59 + ($orgCode == null ? 43 : $orgCode.hashCode());
            String $orgName = this.getOrgName();
            result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
            String $parentOrgCode = this.getParentOrgCode();
            result = result * 59 + ($parentOrgCode == null ? 43 : $parentOrgCode.hashCode());
            String $parentOrgName = this.getParentOrgName();
            result = result * 59 + ($parentOrgName == null ? 43 : $parentOrgName.hashCode());
            return result;
        }

        public String toString() {
            return "SfaCheckInSignGroupReportServiceImpl.UserInfo(userName=" + this.getUserName() + ", realName=" + this.getRealName() + ", posCode=" + this.getPosCode() + ", posName=" + this.getPosName() + ", orgCode=" + this.getOrgCode() + ", orgName=" + this.getOrgName() + ", parentOrgCode=" + this.getParentOrgCode() + ", parentOrgName=" + this.getParentOrgName() + ")";
        }
    }
}

