/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SfaVisitPlanInfoServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceEsImpl.class);
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;

    PageResult<SfaVisitPlanInfoEntity> ddd() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.fuzzyQuery((String)"visitRealName", (String)"\u563f\u563f"));
        builder.must((QueryBuilder)QueryBuilders.fuzzyQuery((String)"visitPosName", (String)"\u8bd5\u8bd5"));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)0, (int)2));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"visitPosCode").order(SortOrder.DESC));
        String groupName = "groupName";
        TermsAggregationBuilder termsAggregationBuilder = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)groupName).field("visitUserName")).field("visitPosCode")).field("visitDate");
        nativeSearchQueryBuilder.addAggregation((AbstractAggregationBuilder)termsAggregationBuilder);
        nativeSearchQueryBuilder.addAggregation((AbstractAggregationBuilder)AggregationBuilders.adjacencyMatrix((String)"visitStatusMerged", (Map)Maps.newHashMap()));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        Page list = this.sfaVisitPlanInfoEntityRepositories.search((SearchQuery)query);
        return PageResult.builder().data(list.getContent()).count(Long.valueOf(list.getTotalElements())).build();
    }

    public PageResult<SfaVisitPlanInfoRespVo> getVisitPlanInfoReportPage(GetVisitReportsPageReq req) {
        Page list = this.sfaVisitPlanInfoEntityRepositories.search((SearchQuery)req.buildQuery());
        return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitPlanInfoRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
    }

    public void saveAll(Collection<SfaVisitPlanInfoEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.saveAll(entities);
    }

    public void save(SfaVisitPlanInfoEntity entity) {
        if (null == entity) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.save(entity);
    }

    public List<SfaVisitPlanInfoEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)QueryBuilders.termsQuery((String)"id", (String[])ids.toArray(new String[ids.size()])));
        Page list = this.sfaVisitPlanInfoEntityRepositories.search((SearchQuery)nativeSearchQueryBuilder.build());
        return Lists.newArrayList((Iterable)list);
    }

    public SfaVisitPlanInfoEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u62dc\u8bbf\u8ba1\u5212ID");
        }
        Optional optional = this.sfaVisitPlanInfoEntityRepositories.findById(id);
        if (optional.isPresent()) {
            return (SfaVisitPlanInfoEntity)optional.get();
        }
        return null;
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByIdIn(ids);
    }

    public void deleteByVisitUserNameAndVisitPosCodeAndAndVisitDate(String visitUserName, String visitPosCode, String visitDate) {
        if (StringUtils.isBlank((CharSequence)visitUserName) || StringUtils.isBlank((CharSequence)visitPosCode) || StringUtils.isBlank((CharSequence)visitDate)) {
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByVisitUserNameAndVisitPosCodeAndAndVisitDate(visitUserName, visitPosCode, visitDate);
    }

    public List<SfaVisitPlanInfoEntity> findByVisitUserNameAndVisitPosCodeAndAndVisitDate(String visitUserName, String visitPosCode, String visitDate) {
        if (StringUtils.isBlank((CharSequence)visitUserName) || StringUtils.isBlank((CharSequence)visitPosCode) || StringUtils.isBlank((CharSequence)visitDate)) {
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitUserNameAndVisitPosCodeAndAndVisitDate(visitUserName, visitPosCode, visitDate);
    }
}

