/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepdetail.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.req.GetStockInventoryPageReq;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class SfaVisitStepStockInventoryServiceEsImpl {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStockInventoryServiceEsImpl.class);
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;

    public PageResult<SfaVisitStepStockInventoryRespVo> getWorkbenchStockInventoryPage(GetStockInventoryPageReq req) {
        Page list = this.sfaVisitStepStockInventoryEsDataRepositories.search((SearchQuery)req.buildQuery());
        return PageResult.builder().data(CrmBeanUtil.copyList((List)list.getContent(), SfaVisitStepStockInventoryRespVo.class)).count(Long.valueOf(list.getTotalElements())).build();
    }

    public SfaVisitStepStockInventoryEsData getLastTimeRecord(String stepCode, String clientCode, LocalDateTime stockTime, String currentId) {
        if (StringUtils.isBlank((CharSequence)stepCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        if (StringUtils.isBlank((CharSequence)clientCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u7f16\u7801");
        }
        if (null == stockTime) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6267\u884c\u65f6\u95f4");
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode.keyword", (String)stepCode));
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode.keyword", (String)clientCode));
        builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"stockTime").lte((Object)stockTime.format(CrmDateUtils.yyyyMMddHHmmss)));
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)0, (int)2));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"stockTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        List list = this.sfaVisitStepStockInventoryEsDataRepositories.search((SearchQuery)query).getContent();
        if (list.size() > 0) {
            SfaVisitStepStockInventoryEsData data;
            SfaVisitStepStockInventoryEsData dataCurrent = (SfaVisitStepStockInventoryEsData)list.get(0);
            SfaVisitStepStockInventoryEsData sfaVisitStepStockInventoryEsData = data = list.size() > 1 ? (SfaVisitStepStockInventoryEsData)list.get(1) : null;
            if (dataCurrent.getId().equals(currentId)) {
                return data;
            }
            return dataCurrent;
        }
        return null;
    }
}

