/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitclientRelReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitnote.mapper.SfaVisitGroupMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitclientRelMapper;
import com.biz.crm.visitnote.model.SfaVisitGroupEntity;
import com.biz.crm.visitnote.model.SfaVisitclientRelEntity;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.ISfaVisitclientRelService;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitGroupServiceExpandImpl"})
@Transactional
public class SfaVisitGroupServiceImpl
extends ServiceImpl<SfaVisitGroupMapper, SfaVisitGroupEntity>
implements ISfaVisitGroupService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitGroupServiceImpl.class);
    @Resource
    private SfaVisitGroupMapper sfaVisitGroupMapper;
    @Resource
    private SfaVisitclientRelMapper sfaVisitclientRelMapper;
    @Autowired
    private ISfaVisitclientRelService iSfaVisitclientRelService;
    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;

    @Override
    public PageResult<SfaVisitGroupRespVo> findList(SfaVisitGroupReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitGroupRespVo> list = this.sfaVisitGroupMapper.findList((Page<SfaVisitGroupRespVo>)page, reqVo);
        final List groupCodes = list.stream().map(SfaVisitGroupRespVo::getGroupCode).collect(Collectors.toList());
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo(){
            {
                this.setGroupCodes(groupCodes);
                this.setPageSize(-1);
            }
        };
        List sfaVisitclientRelRespVos = this.iSfaVisitclientRelService.findList(sfaVisitclientRelReqVo).getData();
        Map<String, List<SfaVisitclientRelRespVo>> map = sfaVisitclientRelRespVos.stream().collect(Collectors.groupingBy(SfaVisitclientRelRespVo::getGroupCode));
        list.forEach(data -> {
            data.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)data.getEnableStatus()));
            List clientRelRespVoList = (List)map.get(data.getGroupCode());
            data.setClientRelNum(Integer.valueOf(clientRelRespVoList.size()));
            StringBuffer clientNames = new StringBuffer();
            for (SfaVisitclientRelRespVo clientRel : clientRelRespVoList) {
                if (clientNames.length() > 0) {
                    clientNames.append(",");
                }
                clientNames.append(clientRel.getClientName());
            }
            data.setClientNames(clientNames.toString());
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitGroupRespVo queryDetailById(final String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        SfaVisitGroupReqVo reqVo = new SfaVisitGroupReqVo(){
            {
                this.setId(id);
            }
        };
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitGroupRespVo();
        }
        SfaVisitGroupRespVo respVo = (SfaVisitGroupRespVo)list.get(0);
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo();
        sfaVisitclientRelReqVo.setGroupCode(respVo.getGroupCode());
        sfaVisitclientRelReqVo.setPageSize(Integer.valueOf(-1));
        List visitclientRelRespVos = this.iSfaVisitclientRelService.findList(sfaVisitclientRelReqVo).getData();
        respVo.setSfaVisitclientRelRespVos(visitclientRelRespVos);
        return respVo;
    }

    @Override
    public SfaVisitGroupRespVo query(SfaVisitGroupReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitGroupRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitGroupRespVo();
        }
        SfaVisitGroupRespVo respVo = (SfaVisitGroupRespVo)list.get(0);
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo();
        sfaVisitclientRelReqVo.setGroupCode(respVo.getGroupCode());
        sfaVisitclientRelReqVo.setPageSize(Integer.valueOf(-1));
        List<SfaVisitclientRelRespVo> visitclientRelRespVos = this.sfaVisitclientRelMapper.findSfaVisitclientRelList(sfaVisitclientRelReqVo);
        respVo.setSfaVisitclientRelRespVos(visitclientRelRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitGroupReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isEmpty((String)reqVo.getUserName())) {
            reqVo.setUserName(userRedis.getUsername());
            reqVo.setFullName(userRedis.getRealname());
            reqVo.setOrgCode(userRedis.getOrgcode());
            reqVo.setOrgName(userRedis.getOrgname());
            reqVo.setPosCode(userRedis.getPoscode());
            reqVo.setPosName(userRedis.getPosname());
        }
        this.saveCheck(reqVo);
        SfaVisitGroupEntity entity = (SfaVisitGroupEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitGroupEntity.class));
        String code = CodeUtil.generateCode((String)SfaCodeEnum.VisitGroupCode.SFA_VISIT_GROUP_CODE.getVal());
        entity.setGroupCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveDate(reqVo, entity);
    }

    public void saveCheck(SfaVisitGroupReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getUserName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getFullName(), (String)"\u8bf7\u9009\u62e9\u4eba\u5458\u59d3\u540d");
        AssertUtils.isNotEmpty((String)reqVo.getGroupName(), (String)"\u8bf7\u586b\u5199\u7ebf\u8def\u7ec4\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u9009\u62e9\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgName(), (String)"\u9009\u62e9\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (String)"\u9009\u62e9\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosName(), (String)"\u9009\u62e9\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        if (CollectionUtil.listEmpty((List)reqVo.getSfaVisitclientRelReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f");
        }
        reqVo.getSfaVisitclientRelReqVos().stream().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getClientType(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            AssertUtils.isNotEmpty((String)data.getClientName(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            AssertUtils.isNotEmpty((String)data.getClientId(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            AssertUtils.isNotEmpty((String)data.getClientCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
        });
    }

    public void saveDate(SfaVisitGroupReqVo reqVo, SfaVisitGroupEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaVisitclientRelReqVos())) {
            List sfaVisitclientRelEntities = reqVo.getSfaVisitclientRelReqVos().stream().map(o -> {
                if (!SfaVisitEnum.ClientType.GETMAP.containsKey(o.getClientType())) {
                    throw new BusinessException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u7c7b\u578b,\u9519\u8bef\u5ba2\u6237\u7c7b\u578b:" + o.getClientType());
                }
                SfaVisitclientRelEntity sfaVisitclientRelEntity = new SfaVisitclientRelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)sfaVisitclientRelEntity));
                sfaVisitclientRelEntity.setId(null);
                sfaVisitclientRelEntity.setGroupCode(entity.getGroupCode());
                return sfaVisitclientRelEntity;
            }).collect(Collectors.toList());
            this.iSfaVisitclientRelService.saveBatch(sfaVisitclientRelEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitGroupEntity entity = (SfaVisitGroupEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u7ebf\u8def\u7ec4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        AssertUtils.isNotEmpty((String)reqVo.getGroupName(), (String)"\u8bf7\u586b\u5199\u7ebf\u8def\u7ec4\u540d\u79f0");
        entity.setGroupName(reqVo.getGroupName());
        this.updateById((Object)entity);
        if (CollectionUtil.listEmpty((List)reqVo.getSfaVisitclientRelReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f");
        }
        reqVo.setGroupCode(entity.getGroupCode());
        this.deleteBatchDate(reqVo);
        this.saveDate(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitGroupReqVo reqVo = new SfaVisitGroupReqVo(){
            {
                this.setIds(ids);
            }
        };
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        final List idList = list.stream().map(UuidVo::getId).collect(Collectors.toList());
        SfaVisitPlanReqVo sfaVisitPlanReqVo = new SfaVisitPlanReqVo(){
            {
                this.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
                this.setVisitGroupIdList(idList);
            }
        };
        Integer count = this.sfaVisitPlanMapper.findSfaVisitPlanGroupCount(sfaVisitPlanReqVo);
        if (count > 0) {
            throw new BusinessException("\u5220\u9664\u7ebf\u8def\u7ec4\u5df2\u5b58\u5728\u5468\u671f\u6027\u62dc\u8bbf\u8ba1\u5212");
        }
        this.sfaVisitGroupMapper.deleteProductsByParams(reqVo);
        List groupCodes = list.stream().map(SfaVisitGroupRespVo::getGroupCode).collect(Collectors.toList());
        reqVo.setGroupCodes(groupCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getGroupCode()) && CollectionUtil.listEmpty((List)reqVo.getGroupCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaVisitclientRelReqVo sfaVisitclientRelReqVo = new SfaVisitclientRelReqVo();
        sfaVisitclientRelReqVo.setGroupCode(reqVo.getGroupCode());
        sfaVisitclientRelReqVo.setGroupCodes(reqVo.getGroupCodes());
        this.sfaVisitclientRelMapper.deleteProductsByParams(sfaVisitclientRelReqVo);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitGroupEntities = this.sfaVisitGroupMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitGroupEntities)) {
            sfaVisitGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitGroupEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitGroupEntities = this.sfaVisitGroupMapper.selectBatchIds(ids);
        final List idList = sfaVisitGroupEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        SfaVisitPlanReqVo sfaVisitPlanReqVo = new SfaVisitPlanReqVo(){
            {
                this.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
                this.setVisitGroupIdList(idList);
            }
        };
        Integer count = this.sfaVisitPlanMapper.findSfaVisitPlanGroupCount(sfaVisitPlanReqVo);
        if (count > 0) {
            throw new BusinessException("\u7981\u7528\u7ebf\u8def\u7ec4\u5df2\u5b58\u5728\u5468\u671f\u6027\u62dc\u8bbf\u8ba1\u5212");
        }
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitGroupEntities)) {
            sfaVisitGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitGroupEntities);
    }
}

