/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaCustomerDistanceEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.gaode.vo.GaodeNearbyVo;
import com.biz.crm.gaode.vo.QueryAroundVo;
import com.biz.crm.mdm.map.MdmTerminalCustomerElasticsearchFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.service.ISfaNearbyCustomerService;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaNearbyCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaNearbyCustomerRespVo;
import com.biz.crm.sfa.map.GaoDeFeign;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfaNearbyCustomerServiceImpl
implements ISfaNearbyCustomerService {
    private static final Logger log = LoggerFactory.getLogger(SfaNearbyCustomerServiceImpl.class);
    @Autowired
    private GaoDeFeign gaoDeFeign;
    @Resource
    private MdmTerminalCustomerElasticsearchFeign mdmTerminalCustomerElasticsearchFeign;
    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Override
    public List<SfaNearbyCustomerRespVo> findNotCooperationCustomerList(SfaNearbyCustomerReqVo reqVo) {
        List keywordList;
        this.doCheckParam(reqVo);
        QueryAroundVo queryAroundVo = new QueryAroundVo();
        queryAroundVo.setLocation(reqVo.getLocation()).setRadius(null).setKeywords(null).setOffset(reqVo.getPageSize().toString()).setPage(reqVo.getPageNum().toString());
        List distanceList = DictUtil.list((String)SfaCustomerDistanceEnum.SFA_CUSTOMER_DISTANCE_ENUM.getDesc());
        if (CollectionUtil.listNotEmpty((List)distanceList)) {
            String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
            queryAroundVo.setRadius(radius);
        }
        if (CollectionUtil.listNotEmpty((List)(keywordList = DictUtil.list((String)SfaVisitEnum.customerKeyword.CUSTOMER_KEYWORD_ENUM.getDesc())))) {
            String keywords = keywordList.stream().map(e -> e.getDictValue()).collect(Collectors.joining("|"));
            queryAroundVo.setKeywords(keywords);
        }
        queryAroundVo.setRadius(null).setKeywords(null);
        PageResult result = (PageResult)ApiResultUtil.objResult((Result)this.gaoDeFeign.queryAround(queryAroundVo));
        AssertUtils.isNotNull((Object)result, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        List gaodeData = result.getData();
        Map collect = gaodeData.stream().collect(Collectors.toMap(GaodeNearbyVo::getId, gaodeNearbyVo -> gaodeNearbyVo, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        UserRedis userRedis = UserUtils.getUser();
        MdmTerminalCustomerElasticsearchPageReqVo mdmTerminalCustomerElasticsearchPageReqVo = new MdmTerminalCustomerElasticsearchPageReqVo();
        mdmTerminalCustomerElasticsearchPageReqVo.setPositionCodes(userRedis.getPoscode());
        mdmTerminalCustomerElasticsearchPageReqVo.setDistance(Double.valueOf(Double.parseDouble(SfaCustomerDistanceEnum.TS.getDesc())));
        String[] split = reqVo.getLocation().split(",");
        mdmTerminalCustomerElasticsearchPageReqVo.setLongitude(split[0]).setLatitude(split[1]);
        PageResult mdmResult = (PageResult)ApiResultUtil.objResult((Result)this.mdmTerminalCustomerElasticsearchFeign.list(mdmTerminalCustomerElasticsearchPageReqVo));
        List list = mdmResult.getData();
        if (CollectionUtil.listNotEmpty((List)list)) {
            list.forEach(o -> {
                if (collect.containsKey(o.getAmapId())) {
                    collect.remove(o.getAmapId(), collect.get(o.getAmapId()));
                }
            });
        }
        List nearbyVos = collect.values().stream().collect(Collectors.toList());
        List respVos = CrmBeanUtil.copyList(nearbyVos, SfaNearbyCustomerRespVo.class);
        respVos.forEach(o -> {
            Map map = SfaVisitEnum.visitButton.buildVisitUnfamiliarButton((String)userRedis.getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal());
            map.put(SfaVisitEnum.visitButton.NEW.getVal(), SfaVisitEnum.visitButton.NEW.getDesc());
            o.setButtons(map);
        });
        if (StringUtils.isNotEmpty((String)reqVo.getClientName())) {
            Map<String, SfaNearbyCustomerRespVo> respVoMap = respVos.stream().collect(Collectors.toMap(SfaNearbyCustomerRespVo::getName, a -> a, (k1, k2) -> k2));
            ArrayList<SfaNearbyCustomerRespVo> resp = new ArrayList<SfaNearbyCustomerRespVo>();
            for (String key : respVoMap.keySet()) {
                if (!key.contains(reqVo.getClientName())) continue;
                resp.add(respVoMap.get(key));
            }
            return resp;
        }
        return respVos;
    }

    @Override
    public SfaVisitResp findCooperationCustomerList(SfaNearbyCustomerReqVo reqVo) {
        this.doCheckParam(reqVo);
        List distanceList = DictUtil.list((String)SfaVisitEnum.customerKeyword.CUSTOMER_KEYWORD_ENUM.getDesc());
        AssertUtils.isNotEmpty((Collection)distanceList, (String)"\u7f3a\u5931\u6570\u636e\u5b57\u5178");
        String radius = ((DictDataVo)distanceList.get(0)).getDictValue();
        UserRedis userRedis = UserUtils.getUser();
        MdmTerminalCustomerElasticsearchPageReqVo mdmTerminalCustomerElasticsearchPageReqVo = new MdmTerminalCustomerElasticsearchPageReqVo();
        String[] split = reqVo.getLocation().split(",");
        mdmTerminalCustomerElasticsearchPageReqVo.setLongitude(split[0]).setLatitude(split[1]).setDistance(Double.valueOf(Double.parseDouble(radius))).setPositionCodes(userRedis.getPoscode()).setPageNum(reqVo.getPageNum()).setPageSize(reqVo.getPageSize());
        List list = ((PageResult)ApiResultUtil.objResult((Result)this.mdmTerminalCustomerElasticsearchFeign.list(mdmTerminalCustomerElasticsearchPageReqVo))).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaVisitResp();
        }
        Map<String, MdmTerminalCustomerElasticsearchRespVo> clientMap = list.stream().collect(Collectors.toMap(MdmTerminalCustomerElasticsearchRespVo::getCode, a -> a, (k1, k2) -> k1));
        AssertUtils.isNotNull(clientMap, (String)"\u672a\u627e\u5230\u5df2\u5408\u4f5c\u6570\u636e");
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitUserName(userRedis.getUsername());
        req.setVisitPositionCode(userRedis.getPoscode());
        req.setVisitDate(LocalDate.now().toString());
        req.setLongitude(new BigDecimal(split[0]));
        req.setLatitude(new BigDecimal(split[1]));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoEntities = this.sfaVisitPlanInfoService.getVisitInfoList(req).getPlanInfoEntities();
        AssertUtils.isNotNull(planInfoEntities, (String)"\u672a\u627e\u5230\u4eca\u65e5\u6570\u636e");
        Map<String, SfaVisitResp.SfaVisitPlanInfoResp> collect = planInfoEntities.stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientCode, a -> a, (k1, k2) -> k1));
        HashMap<String, SfaVisitResp.SfaVisitPlanInfoResp> map = new HashMap<String, SfaVisitResp.SfaVisitPlanInfoResp>();
        for (String o : clientMap.keySet()) {
            if (collect.containsKey(o)) {
                map.put(o, collect.get(o));
            }
            Map mapButton = SfaVisitEnum.visitButton.buildVisitUnfamiliarButton((String)userRedis.getUsername(), (String)LocalDate.now().toString(), (String)SfaVisitEnum.visitStatus.V1.getVal());
            SfaVisitResp.SfaVisitPlanInfoResp resp = (SfaVisitResp.SfaVisitPlanInfoResp)((Object)CrmBeanUtil.copy((Object)clientMap.get(o), SfaVisitResp.SfaVisitPlanInfoResp.class));
            resp.setDistance(BigDecimal.valueOf(clientMap.get(o).getDistance()));
            resp.setLongitude(new BigDecimal(clientMap.get(o).getLongitude()));
            resp.setLatitude(new BigDecimal(clientMap.get(o).getLatitude()));
            resp.setClientContacts(clientMap.get(o).getContactName());
            resp.setClientCode(clientMap.get(o).getCode());
            resp.setClientName(clientMap.get(o).getName());
            resp.setRedisHashKey("NONE");
            resp.setButtons(mapButton);
            resp.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            resp.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
            map.put(o, resp);
        }
        if (map.size() == clientMap.size()) {
            map.putAll(collect);
        }
        if (MapUtils.isEmpty(map)) {
            return new SfaVisitResp();
        }
        List sfaVisitPlanInfoRespVos = map.values().stream().collect(Collectors.toList());
        List<SfaVisitResp.SfaVisitPlanInfoResp> result = sfaVisitPlanInfoRespVos.stream().sorted(Comparator.nullsLast(Comparator.comparing(SfaVisitResp.SfaVisitPlanInfoResp::getDistance, Comparator.nullsLast(BigDecimal::compareTo)))).collect(Collectors.toList());
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(result);
        if (StringUtils.isNotEmpty((String)reqVo.getClientName())) {
            return this.searchByClientName(reqVo, sfaVisitResp);
        }
        return sfaVisitResp;
    }

    public void doCheckParam(SfaNearbyCustomerReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getLocation(), (String)"location\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPageNum().toString(), (String)"\u6bcf\u9875\u6570\u636e\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPageSize().toString(), (String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public SfaVisitResp searchByClientName(SfaNearbyCustomerReqVo reqVo, SfaVisitResp sfaVisitResp) {
        Map<String, SfaVisitResp.SfaVisitPlanInfoResp> clientNameMap = sfaVisitResp.getPlanInfoEntities().stream().collect(Collectors.toMap(SfaVisitResp.SfaVisitPlanInfoResp::getClientName, a -> a, (k1, k2) -> k2));
        SfaVisitResp result = new SfaVisitResp();
        ArrayList<SfaVisitResp.SfaVisitPlanInfoResp> resp = new ArrayList<SfaVisitResp.SfaVisitPlanInfoResp>();
        for (String key : clientNameMap.keySet()) {
            if (!key.contains(reqVo.getClientName())) continue;
            resp.add(clientNameMap.get(key));
        }
        result.setPlanInfoEntities(resp);
        return result;
    }
}

