/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.achievement.controller;

import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.google.common.collect.Lists;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;

public class AchievementRecordsMQSend {
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;

    public void saveAchievementRecordsMQ(SfaAchievementAccomplishRecordReqVo req) {
        if (StringUtil.isNotEmpty((String)req.getUpdateDate())) {
            req.setCreateTime(req.getCreateDate() + " " + req.getCreateDateSecond());
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("INDEX_ACCOMPLISH_RECORDS_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)Lists.newArrayList((Object[])new SfaAchievementAccomplishRecordReqVo[]{req})));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }
}

