/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.sfa.ClientEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.mapper.SfaTerminalMapper;
import com.biz.crm.moblie.model.SfaContactEntity;
import com.biz.crm.moblie.model.SfaSupplyEntity;
import com.biz.crm.moblie.model.SfaTerminalEntity;
import com.biz.crm.moblie.service.SfaContactService;
import com.biz.crm.moblie.service.SfaSupplyService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalMsgReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaTerminalMsgRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SfaTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaTerminalMapper, SfaTerminalEntity>
implements SfaTerminalService {
    @Autowired
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private SfaContactService sfaContactService;
    @Autowired
    private SfaSupplyService sfaSupplyService;
    private AchievementRecordsMQSend achievementRecordsMQSend;

    @Override
    public Result<List<MdmTerminalVo>> findTerminal() {
        Result currentAndSybPositionTerminalList = this.mdmTerminalFeign.findCurrentAndSybPositionTerminalList(null, UserUtils.getUser().getPoscode());
        return currentAndSybPositionTerminalList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTerminal(SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        this.checkVo(sfaTerminalMsgReqVo);
        List supplys = sfaTerminalMsgReqVo.getSupplys();
        UserRedis user = UserUtils.getUser();
        supplys.forEach(data -> {
            data.setFullName(user.getRealname());
            data.setPositionCode(user.getPoscode());
            data.setPositionName(user.getPosname());
        });
        sfaTerminalMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaTerminalEntity terminalEntity = (SfaTerminalEntity)((Object)CrmBeanUtil.copy((Object)sfaTerminalMsgReqVo, SfaTerminalEntity.class));
        this.save((Object)terminalEntity);
        this.saveSfaTerminalEntity(terminalEntity, sfaTerminalMsgReqVo);
        terminalEntity.setFormNo(terminalEntity.getId());
        Result voResult = this.taActBaseFeign.startProcess(this.createTerminalStartProcessReqVo(terminalEntity.getFormNo()));
        if (!voResult.isSuccess()) {
            throw new BusinessException(voResult.getMessage());
        }
        terminalEntity.setProcessNo(((ProcessCommonVo)voResult.getResult()).getProcessNo());
        this.saveOrUpdate((Object)terminalEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTerminal(SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        this.checkVo(sfaTerminalMsgReqVo);
        List supplys = sfaTerminalMsgReqVo.getSupplys();
        UserRedis user = UserUtils.getUser();
        supplys.forEach(data -> {
            data.setFullName(user.getRealname());
            data.setPositionCode(user.getPoscode());
            data.setPositionName(user.getPosname());
        });
        if (StringUtils.isEmpty((String)sfaTerminalMsgReqVo.getId())) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u5bf9\u5e94Id");
        }
        SfaTerminalEntity entity = (SfaTerminalEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(BaseIdEntity::getId, (Object)sfaTerminalMsgReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5ba1\u6279\u4fe1\u606f");
        }
        if (ActApproveStatusEnum.APPROVING.getCode().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u8be5\u4efb\u52a1\u6b63\u5728\u5ba1\u6279\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6279\u7ed3\u675f\uff0c\u518d\u63d0\u4ea4");
        }
        sfaTerminalMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaTerminalEntity terminalEntity = (SfaTerminalEntity)((Object)CrmBeanUtil.copy((Object)sfaTerminalMsgReqVo, SfaTerminalEntity.class));
        this.saveSfaTerminalEntity(terminalEntity, sfaTerminalMsgReqVo);
        terminalEntity.setFormNo(terminalEntity.getId());
        Result voResult = this.taActBaseFeign.startProcess(this.createTerminalStartProcessReqVo(terminalEntity.getFormNo()));
        if (!voResult.isSuccess()) {
            throw new BusinessException("\u518d\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25");
        }
        terminalEntity.setProcessNo(((ProcessCommonVo)voResult.getResult()).getProcessNo());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateActApproveStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (activitiCallBackVo.getProcessState() == 3) {
            this.update((Object)new SfaTerminalEntity().setActApproveStatus(ActApproveStatusEnum.REJECTED.getCode()), (Wrapper)Wrappers.lambdaUpdate(SfaTerminalEntity.class).eq(BaseIdEntity::getId, (Object)activitiCallBackVo.getFormNo()));
        } else if (activitiCallBackVo.getProcessState() == 2) {
            SfaTerminalEntity sfaTerminalEntity = (SfaTerminalEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(BaseIdEntity::getId, (Object)activitiCallBackVo.getFormNo())));
            sfaTerminalEntity.setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            this.update((Object)new SfaTerminalEntity().setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode()), (Wrapper)Wrappers.lambdaUpdate(SfaTerminalEntity.class).eq(BaseIdEntity::getId, (Object)activitiCallBackVo.getFormNo()));
            MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)CrmBeanUtil.copy((Object)((Object)sfaTerminalEntity), MdmTerminalVo.class);
            this.getMdmTerminalVo(mdmTerminalVo, sfaTerminalEntity);
            this.updateTerminalEnd(mdmTerminalVo, activitiCallBackVo);
        }
    }

    @Override
    public PageResult<SfaTerminalMsgRespVo> findAllSfaTerminal(SfaTerminalReqVo sfaTerminalReqVo) {
        LambdaQueryWrapper<SfaTerminalEntity> lambdaQueryWrapper = this.getTerminalWrapper(sfaTerminalReqVo);
        Page page = new Page((long)sfaTerminalReqVo.getPageNum().intValue(), (long)sfaTerminalReqVo.getPageSize().intValue());
        Page result = (Page)this.page((IPage)page, (Wrapper)lambdaQueryWrapper);
        List sfaTerminalEntities = result.getRecords();
        ArrayList mdmTerminalVoList = new ArrayList();
        sfaTerminalEntities.stream().forEach(data -> {
            MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)CrmBeanUtil.copy((Object)data, MdmTerminalVo.class);
            this.getMdmTerminalVo(mdmTerminalVo, (SfaTerminalEntity)((Object)data));
            mdmTerminalVoList.add(mdmTerminalVo);
        });
        List sfaTerminalMsgRespVos = CrmBeanUtil.copyList(mdmTerminalVoList, SfaTerminalMsgRespVo.class);
        return PageResult.builder().data(sfaTerminalMsgRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSfaActApproveStatus(String id, String remark, String actApproveStatus) {
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("sfa\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)actApproveStatus)) {
            throw new BusinessException("\u7ec8\u7aef\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
        }
        SfaTerminalEntity sfaTerminalEntity = (SfaTerminalEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        sfaTerminalEntity.setActRemarks(remark);
        Result resultResult = this.mobileFeign.findCurrentTask(new TaskQueryReqVO().setFormNo(id));
        if (0L == ((PageResult)resultResult.getResult()).getCount()) {
            throw new BusinessException("\u5f53\u524d\u804c\u4f4d\u6682\u65e0\u6743\u9650\u5ba1\u6279");
        }
        sfaTerminalEntity.setActApproveStatus(actApproveStatus);
        this.saveOrUpdate((Object)sfaTerminalEntity);
        TaskRspVO taskRspVO = (TaskRspVO)((PageResult)resultResult.getResult()).getData().get(0);
        if (ActApproveStatusEnum.REJECTED.getCode().equals(actApproveStatus)) {
            this.mobileFeign.taskReject(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.REJECT.getVal()).setTaskId(taskRspVO.getTaskId()));
        } else {
            this.mobileFeign.taskComplete(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.ISSUE.getVal()).setTaskId(taskRspVO.getTaskId()));
        }
    }

    @Override
    public Result<SfaTerminalMsgRespVo> querySfaTerminalVo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("\u5ba1\u6279\u7ec8\u7aefId\u4e3a\u7a7a");
        }
        SfaTerminalEntity sfaTerminalEntity = (SfaTerminalEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaTerminalEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        SfaTerminalMsgRespVo mdmTerminalVo = (SfaTerminalMsgRespVo)CrmBeanUtil.copy((Object)((Object)sfaTerminalEntity), SfaTerminalMsgRespVo.class);
        this.getSfaTerminalMsgRespVo(mdmTerminalVo, sfaTerminalEntity);
        mdmTerminalVo.setRemarks(sfaTerminalEntity.getActRemarks());
        return Result.ok((Object)mdmTerminalVo);
    }

    @Override
    public Result<Integer> countTerminal() {
        int count = 0;
        List formNoList = this.getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(formNoList)) {
            return Result.ok((Object)count);
        }
        count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaTerminalEntity.class).ne(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE)).eq(SfaTerminalEntity::getActApproveStatus, (Object)ActApproveStatusEnum.APPROVING)).in(SfaTerminalEntity::getFormNo, formNoList));
        return Result.ok((Object)count);
    }

    private void checkVo(SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        if (sfaTerminalMsgReqVo == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
    }

    private StartProcessReqVo createTerminalStartProcessReqVo(String formNo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo process = new StartProcessReqVo();
        process.setUserCode(user.getUsername());
        process.setPosCode(user.getPoscode());
        String processKey = null;
        Map map = DictUtil.getDictValueMapsByCodes((String)"customer_activity_keys");
        if (map == null) {
            throw new BusinessException("\u8bf7\u914d\u7f6e<\u6570\u636e\u5b57\u5178>:customer_activity_keys");
        }
        processKey = (String)map.get(ActivitiEnum.FormTypeEnum.TERMINAL.getProcessKey());
        if (StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u8bf7\u5728\u6570\u636e\u5b57\u5178-customer_activity_keys-\u4e2d\u6dfb\u52a0\u5b57\u5178");
        }
        process.setProcessKey(processKey);
        process.setTitle(ActivitiEnum.FormTypeEnum.TERMINAL.getTitle());
        process.setFormUrl("https");
        process.setFormNo(formNo);
        process.setFormType(ActivitiEnum.FormTypeEnum.TERMINAL.getFormType());
        process.setCostType(ActivitiEnum.FormTypeEnum.TERMINAL.getCostType());
        process.setCallBackFeign(ActivitiEnum.FormTypeEnum.TERMINAL.getCallBackFeign());
        process.setSignTicket(UUIDGenerator.generate());
        return process;
    }

    private void getMdmTerminalVo(MdmTerminalVo mdmTerminalVo, SfaTerminalEntity sfaTerminalEntity) {
        List sfaContactEntities = this.sfaContactService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId, (Object)sfaTerminalEntity.getId())).eq(SfaContactEntity::getType, (Object)ClientEnum.clientType.CUSTOMER.getValue()));
        List mdmTerminalContactVos = CrmBeanUtil.copyList((List)sfaContactEntities, MdmTerminalContactVo.class);
        mdmTerminalVo.setContacts(mdmTerminalContactVos);
        List sfaSupplyEntities = this.sfaSupplyService.list((Wrapper)Wrappers.lambdaQuery(SfaSupplyEntity.class).eq(SfaSupplyEntity::getTerminalId, (Object)sfaTerminalEntity.getId()));
        List mdmTerminalSupplyVos = CrmBeanUtil.copyList((List)sfaSupplyEntities, MdmTerminalSupplyVo.class);
        mdmTerminalVo.setSupplys(mdmTerminalSupplyVos);
    }

    private void getSfaTerminalMsgRespVo(SfaTerminalMsgRespVo mdmTerminalVo, SfaTerminalEntity sfaTerminalEntity) {
        List sfaContactEntities = this.sfaContactService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId, (Object)sfaTerminalEntity.getId())).eq(SfaContactEntity::getType, (Object)ClientEnum.clientType.CUSTOMER.getValue()));
        List mdmTerminalContactVos = CrmBeanUtil.copyList((List)sfaContactEntities, MdmTerminalContactVo.class);
        mdmTerminalVo.setContacts(mdmTerminalContactVos);
        List sfaSupplyEntities = this.sfaSupplyService.list((Wrapper)Wrappers.lambdaQuery(SfaSupplyEntity.class).eq(SfaSupplyEntity::getTerminalId, (Object)sfaTerminalEntity.getId()));
        List mdmTerminalSupplyVos = CrmBeanUtil.copyList((List)sfaSupplyEntities, MdmTerminalSupplyVo.class);
        mdmTerminalVo.setSupplys(mdmTerminalSupplyVos);
    }

    private void updateTerminalEnd(MdmTerminalVo mdmTerminalVo, ActivitiCallBackVo activitiCallBackVo) {
        mdmTerminalVo.setId(null);
        if (CollectionUtil.listNotEmpty((List)mdmTerminalVo.getContacts())) {
            ((MdmTerminalContactVo)mdmTerminalVo.getContacts().get(0)).setContactMain("1");
        }
        if (StringUtils.isEmpty((String)mdmTerminalVo.getTerminalCode())) {
            Result result = this.mdmTerminalFeign.save(mdmTerminalVo);
            if (result.getCode() != 200) {
                throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u5931\u8d25\u2014\u2014mdm\u65b0\u589e\u5931\u8d25");
            }
            SfaAchievementAccomplishRecordReqVo reqVo = new SfaAchievementAccomplishRecordReqVo();
            reqVo.setCustomerCode(result.getMessage()).setIndexCode(SfaVisitEnum.indexType.XZWD.getCode());
            this.achievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
        } else if (this.mdmTerminalFeign.update(mdmTerminalVo).getCode() != 200) {
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u5931\u8d25\u2014\u2014mdm\u66f4\u65b0\u5931\u8d25");
        }
    }

    private List<TaskRspVO> getTaskRspVO() {
        UserRedis user = UserUtils.getUser();
        Result currentTask = this.mobileFeign.findCurrentTask(new TaskQueryReqVO().setUserCode(user.getUsername()).setPositionCode(user.getPoscode()));
        List data = ((PageResult)currentTask.getResult()).getData();
        return data;
    }

    private List<TaskRspVO> getTaskRspDoneVo() {
        UserRedis user = UserUtils.getUser();
        Result currentTask = this.mobileFeign.findDoneTask(new TaskQueryReqVO().setUserCode(user.getUsername()).setPositionCode(user.getPoscode()));
        List data = ((PageResult)currentTask.getResult()).getData();
        return data;
    }

    private LambdaQueryWrapper<SfaTerminalEntity> getTerminalWrapper(SfaTerminalReqVo sfaTerminalReqVo) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SfaTerminalEntity.class);
        lambdaQueryWrapper.ne(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode());
        if (StringUtils.isEmpty((String)sfaTerminalReqVo.getActApproveStatus())) {
            List formNoList = this.getTaskRspDoneVo().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
            lambdaQueryWrapper.in(SfaTerminalEntity::getFormNo, formNoList);
        } else {
            List formNoList = this.getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
            lambdaQueryWrapper.in(SfaTerminalEntity::getFormNo, formNoList);
        }
        if (StringUtils.isNotEmpty((String)sfaTerminalReqVo.getTerminalName())) {
            lambdaQueryWrapper.like(SfaTerminalEntity::getTerminalName, (Object)sfaTerminalReqVo.getTerminalName());
        }
        if (StringUtils.isNotEmpty((String)sfaTerminalReqVo.getStartTime()) && StringUtils.isNotEmpty((String)sfaTerminalReqVo.getEndTime())) {
            lambdaQueryWrapper.between(CrmBaseEntity::getCreateDate, (Object)sfaTerminalReqVo.getStartTime(), (Object)sfaTerminalReqVo.getEndTime());
        }
        lambdaQueryWrapper.orderByDesc(CrmBaseEntity::getCreateDate);
        return lambdaQueryWrapper;
    }

    private void saveSfaTerminalEntity(SfaTerminalEntity terminalEntity, SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        this.sfaContactService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId, (Object)terminalEntity.getId())).eq(SfaContactEntity::getType, (Object)ClientEnum.clientType.TERMINAL.getValue()));
        this.sfaSupplyService.remove((Wrapper)Wrappers.lambdaQuery(SfaSupplyEntity.class).eq(SfaSupplyEntity::getTerminalId, (Object)terminalEntity.getId()));
        List contacts = sfaTerminalMsgReqVo.getContacts();
        List supplys = sfaTerminalMsgReqVo.getSupplys();
        List sfaContactEntities = CrmBeanUtil.copyList((List)contacts, SfaContactEntity.class);
        sfaContactEntities.stream().forEach(data -> data.setType(ClientEnum.clientType.CUSTOMER.getValue()).setClientId(terminalEntity.getId()));
        List sfaSupplyEntities = CrmBeanUtil.copyList((List)supplys, SfaSupplyEntity.class);
        sfaSupplyEntities.forEach(data -> data.setTerminalId(terminalEntity.getId()));
        this.sfaContactService.saveBatch(sfaContactEntities);
        this.sfaSupplyService.saveBatch(sfaSupplyEntities);
    }
}

