/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DistanceUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitCompleteInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.req.AddVisitCompleteInfoConsumerReqVo;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitPlanRouteRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRealRouteRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRouteRespVo;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitCompleteInfoServiceExpandImpl"})
public class SfaVisitCompleteInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitCompleteInfoMapper, SfaVisitCompleteInfoEntity>
implements ISfaVisitCompleteInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitCompleteInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private SfaVisitCompleteInfoMapper sfaVisitCompleteInfoMapper;
    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;
    @Resource
    private MdmUserFeign mdmUserFeign;

    @Override
    public PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoDailyList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        Page page = new Page((long)visitCompleteInfoSearchReqVo.getPageNum().intValue(), (long)visitCompleteInfoSearchReqVo.getPageSize().intValue());
        LambdaQueryWrapper<SfaVisitCompleteInfoEntity> queryWrapper = this.getQueryToGetList(visitCompleteInfoSearchReqVo);
        Page infoEntityPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        List result = CrmBeanUtil.copyList((List)infoEntityPage.getRecords(), SfaVisitCompleteInfoRespVo.class);
        return PageResult.builder().count(Long.valueOf(infoEntityPage.getTotal())).data(result).build();
    }

    @Override
    public PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoMonthList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        Page page = new Page((long)visitCompleteInfoSearchReqVo.getPageNum().intValue(), (long)visitCompleteInfoSearchReqVo.getPageSize().intValue());
        List<SfaVisitCompleteInfoEntity> visitCompleteInfoMonthList = this.sfaVisitCompleteInfoMapper.getVisitCompleteInfoMonthList((Page<SfaVisitCompleteInfoRespVo>)page, visitCompleteInfoSearchReqVo);
        visitCompleteInfoMonthList.forEach(data -> data.countNotCompleteNumAndPercent());
        List sfaVisitCompleteInfoRespVos = CrmBeanUtil.copyList(visitCompleteInfoMonthList, SfaVisitCompleteInfoRespVo.class);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(sfaVisitCompleteInfoRespVos).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addVisitCompleteInfoDaily(AddVisitCompleteInfoConsumerReqVo addVisitCompleteInfoConsumerReqVo) {
        this.checkAddVisit(addVisitCompleteInfoConsumerReqVo);
        String visitDate = addVisitCompleteInfoConsumerReqVo.getVisitDate();
        String visitStatus2 = addVisitCompleteInfoConsumerReqVo.getVisitStatus();
        String visitType2 = addVisitCompleteInfoConsumerReqVo.getVisitBigType();
        String visitPositionCode = addVisitCompleteInfoConsumerReqVo.getVisitPositionCode();
        SfaVisitCompleteInfoEntity completeInfoEntity = null;
        completeInfoEntity = (SfaVisitCompleteInfoEntity)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class).eq(SfaVisitCompleteInfoEntity::getVisitDate, (Object)visitDate)).eq(SfaVisitCompleteInfoEntity::getPosCode, (Object)visitPositionCode)));
        if (completeInfoEntity == null) {
            completeInfoEntity = new SfaVisitCompleteInfoEntity();
            completeInfoEntity.setName(addVisitCompleteInfoConsumerReqVo.getVisitRealName());
            completeInfoEntity.setPosCode(visitPositionCode);
            completeInfoEntity.setPosName(addVisitCompleteInfoConsumerReqVo.getVisitPositionName());
            completeInfoEntity.setOrgCode(addVisitCompleteInfoConsumerReqVo.getVisitOrgCode());
            completeInfoEntity.setOrgName(addVisitCompleteInfoConsumerReqVo.getVisitOrgName());
            completeInfoEntity.setVisitDate(visitDate);
        }
        this.updateCompleteInfo(visitStatus2, visitType2, completeInfoEntity);
        this.saveOrUpdate((Object)completeInfoEntity);
    }

    @Override
    public Result<SfaVisitRouteRespVo> dailyCompleteInfo(String date, String posName) {
        SfaVisitPlanRouteRespVo sfaVisitPlanRouteRespVo;
        MdmUserRespVo mdmUserRespVo;
        List<SfaVisitPlanInfoEntity> visitPlanInfoEntities = this.sfaVisitPlanInfoEntityRepositories.findByVisitPosNameAndVisitDateAndVisitBigType(posName, date, SfaVisitEnum.VisitBigType.VISIT.getVal());
        List sfaVisitPlanRouteRespVos = CrmBeanUtil.copyList(visitPlanInfoEntities, SfaVisitPlanRouteRespVo.class);
        if (CollectionUtil.listNotEmpty((List)sfaVisitPlanRouteRespVos) && (mdmUserRespVo = (MdmUserRespVo)ApiResultUtil.objResult((Result)this.mdmUserFeign.query(new MdmUserReqVo().setUserName((sfaVisitPlanRouteRespVo = (SfaVisitPlanRouteRespVo)sfaVisitPlanRouteRespVos.get(0)).getVisitUserName())))) != null) {
            String visitUserPhone = mdmUserRespVo.getUserPhone();
            sfaVisitPlanRouteRespVos.forEach(data -> data.setVisitUserPhone(visitUserPhone));
        }
        ArrayList<SfaVisitRealRouteRespVo> sfaVisitRealRouteRespVos = new ArrayList<SfaVisitRealRouteRespVo>();
        List<SfaVisitPlanInfoRedisData> visitRealInfoEntities = this.sfaVisitPlanInfoRedisDataRepositories.findByVisitPosNameAndVisitDateAndVisitBigType(posName, date, SfaVisitEnum.VisitBigType.VISIT.getVal());
        if (CollectionUtil.listNotEmpty(visitRealInfoEntities)) {
            visitRealInfoEntities.forEach(item -> {
                SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = item.getSfaVisitPlanInfoExecuteRedisData();
                SfaVisitRealRouteRespVo routeRespVo = (SfaVisitRealRouteRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoExecuteRedisData), SfaVisitRealRouteRespVo.class);
                routeRespVo.setClientAddress(sfaVisitPlanInfoExecuteRedisData.getInStoreAddress());
                routeRespVo.setLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
                routeRespVo.setLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
                routeRespVo.setVisitDate(sfaVisitPlanInfoExecuteRedisData.getInStore());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDateTime inStore = LocalDateTime.parse(sfaVisitPlanInfoExecuteRedisData.getInStore(), df);
                LocalDateTime outStore = LocalDateTime.parse(sfaVisitPlanInfoExecuteRedisData.getOutStore(), df);
                long inStoreMilli = inStore.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                long outStoreMilli = outStore.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
                LocalDateTime inStoreTimeOut = Instant.ofEpochMilli(outStoreMilli - inStoreMilli).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
                routeRespVo.setInStoreTime(inStoreTimeOut.format(CrmDateUtils.HHmmss));
                if (item.getLatitude() != null || item.getLongitude() != null) {
                    double latitude = item.getLatitude().doubleValue();
                    double longitude = item.getLongitude().doubleValue();
                    double outStoreLatitude = sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude().doubleValue();
                    double outStoreLongitude = sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude().doubleValue();
                    double distance = DistanceUtil.getDistance((double)latitude, (double)longitude, (double)outStoreLatitude, (double)outStoreLongitude);
                    routeRespVo.setDistanceToPlan(distance + "");
                }
                sfaVisitRealRouteRespVos.add(routeRespVo);
            });
        }
        SfaVisitRouteRespVo sfaVisitRouteRespVo = new SfaVisitRouteRespVo();
        sfaVisitRouteRespVo.setPlanInfoList(sfaVisitPlanRouteRespVos);
        sfaVisitRouteRespVo.setRealInfoList(sfaVisitRealRouteRespVos);
        return Result.ok((Object)sfaVisitRouteRespVo);
    }

    private void checkAddVisit(AddVisitCompleteInfoConsumerReqVo addVisitCompleteInfoConsumerReqVo) {
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitDate(), (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitPositionName(), (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitBigType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitUserName(), (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitRealName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)addVisitCompleteInfoConsumerReqVo.getVisitStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void updateCompleteInfo(String visitStatus2, String visitBigType, SfaVisitCompleteInfoEntity completeInfoEntity) {
        if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(visitBigType)) {
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(visitStatus2)) {
                completeInfoEntity.addRealCompleteVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V4.getVal().equals(visitStatus2)) {
                completeInfoEntity.addErrorCompleteVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V1.getVal().equals(visitStatus2)) {
                completeInfoEntity.addNotCompleteVisitNum();
            }
        } else if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(visitBigType)) {
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(visitStatus2)) {
                completeInfoEntity.addRealCompleteHelpVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V4.getVal().equals(visitStatus2)) {
                completeInfoEntity.addErrorCompleteHelpVisitNum();
            }
            if (SfaVisitEnum.visitStatus.V1.getVal().equals(visitStatus2)) {
                completeInfoEntity.addNotCompleteHelpVisitNum();
            }
        } else {
            throw new BusinessException("\u751f\u6210\u62dc\u8bbf\u5b8c\u6210\u62a5\u8868\u6570\u636e\u5f02\u5e38");
        }
        completeInfoEntity.countNotCompleteNumAndPercent();
    }

    private LambdaQueryWrapper<SfaVisitCompleteInfoEntity> getQueryToGetList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class);
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getName())) {
            queryWrapper.like(SfaVisitCompleteInfoEntity::getName, (Object)visitCompleteInfoSearchReqVo.getName());
        }
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getPosName())) {
            queryWrapper.like(SfaVisitCompleteInfoEntity::getPosName, (Object)visitCompleteInfoSearchReqVo.getName());
        }
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getStartTime())) {
            queryWrapper.ge(SfaVisitCompleteInfoEntity::getVisitDate, (Object)visitCompleteInfoSearchReqVo.getStartTime());
        }
        if (StringUtils.isNotEmpty((String)visitCompleteInfoSearchReqVo.getEndTime())) {
            queryWrapper.le(SfaVisitCompleteInfoEntity::getVisitDate, (Object)visitCompleteInfoSearchReqVo.getEndTime());
        }
        return queryWrapper;
    }
}

