/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignPersonnelVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPersonnelMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignRuleMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignSpecialMapper;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.worksignrule.service.ISfaWorkSignPlaceService;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.service.ISfaWorkSignSpecialService;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import com.biz.crm.worksignrule.service.impl.ExecuteSignRuleContext;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignRuleServiceExpandImpl"})
public class SfaWorkSignRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignRuleMapper, SfaWorkSignRuleEntity>
implements ISfaWorkSignRuleService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleServiceImpl.class);
    private final Object $lock = new Object[0];
    @Resource
    private ISfaWorkSignPersonnelService iSfaWorkSignPersonnelService;
    @Resource
    private ISfaWorkSignPlaceService iSfaWorkSignPlaceService;
    @Resource
    private ISfaWorkSignTimeService iSfaWorkSignTimeService;
    @Resource
    private ISfaWorkSignSpecialService iSfaWorkSignSpecialService;
    @Resource
    private ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;
    @Resource
    private ISfaWorkSignRecordService iSfaWorkSignRecordService;
    @Resource
    private SfaWorkSignRuleMapper sfaWorkSignRuleMapper;
    @Resource
    private SfaWorkSignPersonnelMapper personnelMapper;
    @Resource
    private SfaWorkSignPlaceMapper placeMapper;
    @Resource
    private SfaWorkSignSpecialMapper specialMapper;
    @Resource
    private SfaWorkSignTimeMapper signTimeMapper;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private ISfaCalculateSalaryDateService dateService;

    @Override
    @CrmLog
    public PageResult<SfaWorkSignRuleRespVo> findList(SfaWorkSignRuleVo sfaWorkSignRuleVo) {
        Page page = new Page((long)sfaWorkSignRuleVo.getPageNum().intValue(), (long)sfaWorkSignRuleVo.getPageSize().intValue());
        List<SfaWorkSignRuleRespVo> list = this.sfaWorkSignRuleMapper.findList((Page<SfaWorkSignRuleVo>)page, sfaWorkSignRuleVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaWorkSignRuleRespVo query(SfaWorkSignRuleReqVo reqVo) {
        List list = this.findList((SfaWorkSignRuleVo)reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new SfaWorkSignRuleRespVo();
        }
        SfaWorkSignRuleRespVo sfaWorkSignRuleRespVo = (SfaWorkSignRuleRespVo)list.get(0);
        SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo = new SfaWorkSignPersonnelReqVo();
        sfaWorkSignPersonnelReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignPersonnelReqVo.setPageSize(Integer.valueOf(-1));
        List personnelEntities = this.iSfaWorkSignPersonnelService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).eq(SfaWorkSignPersonnelEntity::getRuleCode, (Object)sfaWorkSignRuleRespVo.getRuleCode()));
        List sfaWorkSignPersonnelRespVos = CrmBeanUtil.copyList((List)personnelEntities, SfaWorkSignPersonnelRespVo.class);
        if (CollectionUtil.listNotEmpty((List)sfaWorkSignPersonnelRespVos)) {
            List org = sfaWorkSignPersonnelRespVos.stream().filter(data -> WorkSignEnum.codeType.ORG.getVal().equals(data.getCodeType())).collect(Collectors.toList());
            List posLevel = sfaWorkSignPersonnelRespVos.stream().filter(data -> WorkSignEnum.codeType.POS_LEVEL.getVal().equals(data.getCodeType())).collect(Collectors.toList());
            sfaWorkSignRuleRespVo.setSfaWorkSignPersonnelRespVo(org);
            sfaWorkSignRuleRespVo.setSfaWorkSignPersonnelPosRespVo(posLevel);
        }
        SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo = new SfaWorkSignPlaceReqVo();
        sfaWorkSignPlaceReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignPlaceReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignPlaceRespVos = this.iSfaWorkSignPlaceService.findList(sfaWorkSignPlaceReqVo).getData();
        sfaWorkSignRuleRespVo.setSfaWorkSignPlaceRespVos(sfaWorkSignPlaceRespVos);
        SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo = new SfaWorkSignTimeReqVo();
        sfaWorkSignTimeReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        sfaWorkSignTimeReqVo.setPageSize(Integer.valueOf(-1));
        List sfaWorkSignTimeRespVos = this.iSfaWorkSignTimeService.findList(sfaWorkSignTimeReqVo).getData();
        sfaWorkSignRuleRespVo.setSfaWorkSignTimeRespVos(sfaWorkSignTimeRespVos);
        SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo = new SfaWorkSignSpecialReqVo();
        sfaWorkSignSpecialReqVo.setRuleCode(sfaWorkSignRuleRespVo.getRuleCode());
        List<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialRespVos = this.iSfaWorkSignSpecialService.findNonPageList(sfaWorkSignSpecialReqVo);
        if (CollectionUtil.listNotEmpty(sfaWorkSignSpecialRespVos)) {
            ArrayList<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialMustRespVos = new ArrayList<SfaWorkSignSpecialRespVo>();
            ArrayList<SfaWorkSignSpecialRespVo> sfaWorkSignSpecialNotRespVos = new ArrayList<SfaWorkSignSpecialRespVo>();
            for (SfaWorkSignSpecialRespVo specialRespVos : sfaWorkSignSpecialRespVos) {
                if (SfaWorkSignEnum.workSignSpecialType.One.getVal().equals(specialRespVos.getWssType())) {
                    sfaWorkSignSpecialMustRespVos.add(specialRespVos);
                    continue;
                }
                sfaWorkSignSpecialNotRespVos.add(specialRespVos);
            }
            sfaWorkSignRuleRespVo.setSfaWorkSignSpecialMustRespVos(sfaWorkSignSpecialMustRespVos);
            sfaWorkSignRuleRespVo.setSfaWorkSignSpecialNotRespVos(sfaWorkSignSpecialNotRespVos);
        }
        return sfaWorkSignRuleRespVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaWorkSignRuleReqVo reqVo) {
        Object object = this.$lock;
        synchronized (object) {
            this.saveCheck(reqVo);
            SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleEntity.class));
            String code = CodeUtil.getCodeDefault();
            entity.setRuleCode(code);
            this.save((Object)entity);
            this.saveData(reqVo, entity);
        }
    }

    public void saveData(SfaWorkSignRuleReqVo reqVo, SfaWorkSignRuleEntity entity) {
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)reqVo.getSfaWorkSignPersonnelReqVo())) {
            if (CollectionUtil.listNotEmpty((List)reqVo.getSfaWorkSignPersonnelPosReqVo())) {
                reqVo.getSfaWorkSignPersonnelReqVo().addAll(reqVo.getSfaWorkSignPersonnelPosReqVo());
            }
            List personnelContainList = reqVo.getSfaWorkSignPersonnelReqVo().stream().map(o -> {
                SfaWorkSignPersonnelEntity personnelEntity = new SfaWorkSignPersonnelEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)personnelEntity));
                personnelEntity.setId(null);
                personnelEntity.setRuleCode(entity.getRuleCode());
                return personnelEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignPersonnelService.saveOrUpdateBatch(personnelContainList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignPlaceReqVos())) {
            List signPlaceEntityList = reqVo.getSfaWorkSignPlaceReqVos().stream().map(o -> {
                SfaWorkSignPlaceEntity signPlaceEntity = new SfaWorkSignPlaceEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signPlaceEntity));
                signPlaceEntity.setRuleCode(entity.getRuleCode());
                return signPlaceEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignPlaceService.saveOrUpdateBatch(signPlaceEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignTimeReqVos())) {
            List sfaWorkSignTimeReqVos = reqVo.getSfaWorkSignTimeReqVos();
            ArrayList signTimeEntityList = Lists.newArrayList();
            Integer i = 1;
            for (SfaWorkSignTimeReqVo temp : sfaWorkSignTimeReqVos) {
                SfaWorkSignTimeEntity signTimeEntity = (SfaWorkSignTimeEntity)((Object)CrmBeanUtil.copy((Object)temp, SfaWorkSignTimeEntity.class));
                signTimeEntity.setRuleCode(entity.getRuleCode());
                signTimeEntity.setWstNo(i.toString());
                signTimeEntityList.add(signTimeEntity);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.iSfaWorkSignTimeService.saveOrUpdateBatch(signTimeEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignSpecialMustReqVos())) {
            List signSpecialEntityList = reqVo.getSfaWorkSignSpecialMustReqVos().stream().map(o -> {
                SfaWorkSignSpecialEntity signSpecialEntity = new SfaWorkSignSpecialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)signSpecialEntity));
                signSpecialEntity.setWssType(SfaWorkSignEnum.workSignSpecialType.One.getVal());
                signSpecialEntity.setRuleCode(entity.getRuleCode());
                return signSpecialEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignSpecialService.saveOrUpdateBatch(signSpecialEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSfaWorkSignSpecialNotReqVos())) {
            List specialEntityList = reqVo.getSfaWorkSignSpecialNotReqVos().stream().map(o -> {
                SfaWorkSignSpecialEntity specialEntity = new SfaWorkSignSpecialEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)specialEntity));
                specialEntity.setWssType(SfaWorkSignEnum.workSignSpecialType.Two.getVal());
                specialEntity.setRuleCode(entity.getRuleCode());
                return specialEntity;
            }).collect(Collectors.toList());
            this.iSfaWorkSignSpecialService.saveOrUpdateBatch(specialEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaWorkSignRuleEntity entity = (SfaWorkSignRuleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        reqVo.setRuleCode(entity.getRuleCode());
        this.saveCheck(reqVo);
        SfaWorkSignRuleEntity updateEntity = (SfaWorkSignRuleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleEntity.class));
        updateEntity.setRuleCode(null);
        this.updateById((Object)updateEntity);
        reqVo.setRuleCode(entity.getRuleCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    public void deleteBatchDate(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getRuleCode()) || CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRuleCodes())) {
            SfaWorkSignPersonnelReqVo signPersonnelReqVo = new SfaWorkSignPersonnelReqVo();
            signPersonnelReqVo.setRuleCode(reqVo.getRuleCode());
            signPersonnelReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.personnelMapper.deleteProductsByParams(signPersonnelReqVo);
            SfaWorkSignPlaceReqVo signPlaceReqVo = new SfaWorkSignPlaceReqVo();
            signPlaceReqVo.setRuleCode(reqVo.getRuleCode());
            signPlaceReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.placeMapper.deleteProductsByParams(signPlaceReqVo);
            SfaWorkSignTimeReqVo signTimeReqVo = new SfaWorkSignTimeReqVo();
            signTimeReqVo.setRuleCode(reqVo.getRuleCode());
            signTimeReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.signTimeMapper.deleteProductsByParams(signTimeReqVo);
            SfaWorkSignSpecialReqVo signSpecialReqVo = new SfaWorkSignSpecialReqVo();
            signSpecialReqVo.setRuleCode(reqVo.getRuleCode());
            signSpecialReqVo.setRuleCodes(reqVo.getRuleCodes());
            this.specialMapper.deleteProductsByParams(signSpecialReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList((SfaWorkSignRuleVo)reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u8003\u52e4\u89c4\u5219\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (list.size() != reqVo.getIds().size()) {
            throw new BusinessException("\u4e3b\u952eID\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        List<String> result = this.sfaWorkSignRuleMapper.findUseRuleCodeByIds(reqVo.getIds());
        if (result != null && result.size() > 0) {
            throw new BusinessException("\u89c4\u5219\uff1a" + result.get(0) + " \u5df2\u751f\u6210\u8003\u52e4\u6570\u636e");
        }
        this.sfaWorkSignRuleMapper.deleteProductsByParams(reqVo);
        List ruleCodes = list.stream().map(SfaWorkSignRuleVo::getRuleCode).collect(Collectors.toList());
        reqVo.setRuleCodes(ruleCodes);
        this.deleteBatchDate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaWorkSignRuleReqVo reqVo) {
        List sfaWorkSignRuleEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5c06\u542f\u7528\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaWorkSignRuleEntities = this.sfaWorkSignRuleMapper.selectBatchIds(reqVo.getIds())))) {
            if (sfaWorkSignRuleEntities.size() != reqVo.getIds().size()) {
                throw new BusinessException("\u4e3b\u952eID\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
            sfaWorkSignRuleEntities.forEach(o -> {
                List<SfaWorkSignPersonnelRespVo> list = this.iSfaWorkSignPersonnelService.findListJoinRule(null, null, o.getRuleCode(), null);
                if (CollectionUtil.listEmpty(list)) {
                    throw new BusinessException("\u8be5\u89c4\u5219\u672a\u914d\u7f6e\u6253\u5361\u7ec4\u7ec7:" + o.getRuleCode());
                }
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRuleEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaWorkSignRuleReqVo reqVo) {
        List sfaWorkSignRuleEntities;
        if (StringUtils.isEmpty((CharSequence)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if ((sfaWorkSignRuleEntities = this.sfaWorkSignRuleMapper.selectBatchIds(reqVo.getIds())).size() != reqVo.getIds().size()) {
            throw new BusinessException("\u4e3b\u952eID\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleEntities)) {
            sfaWorkSignRuleEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleEntities);
    }

    private void defCheck(SfaWorkSignRuleReqVo reqVo) {
        if (StringUtils.isBlank((CharSequence)reqVo.getRuleType())) {
            reqVo.setRuleType(SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getElectronFence())) {
            reqVo.setElectronFence(SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal());
        }
        if (StringUtils.isBlank((CharSequence)reqVo.getRuleEffective())) {
            reqVo.setRuleEffective(SfaWorkSignEnum.RuleEffective.TOMORROW.getVal());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getHolidayWhether())) {
            reqVo.setHolidayWhether(YesNoEnum.yesNoEnum.NO.getValue());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getWsrPhotograph())) {
            reqVo.setWsrPhotograph(YesNoEnum.yesNoEnum.NO.getValue());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getWsrPhotograph())) {
            reqVo.setWsrPhotograph(YesNoEnum.yesNoEnum.NO.getValue());
        }
        if (!YesNoEnum.yesNoEnum.YES.getValue().equals(reqVo.getNonWorkingDaySignAstrict())) {
            reqVo.setNonWorkingDaySignAstrict(YesNoEnum.yesNoEnum.NO.getValue());
        }
    }

    public void saveCheck(SfaWorkSignRuleReqVo reqVo) {
        this.defCheck(reqVo);
        AssertUtils.isNotEmpty((String)reqVo.getRuleName(), (String)"\u8bf7\u8f93\u5165\u89c4\u5219\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getRuleType(), (String)"\u8bf7\u9009\u62e9\u89c4\u5219\u7c7b\u578b");
        this.checkPlace(reqVo.getElectronFence(), reqVo.getSfaWorkSignPlaceReqVos());
        this.checkSpecialDate(reqVo.getSfaWorkSignSpecialMustReqVos());
        this.checkSpecialDate(reqVo.getSfaWorkSignSpecialNotReqVos());
        this.checkSignRange(reqVo.getSfaWorkSignPersonnelReqVo(), reqVo);
        this.checkSignTime(reqVo);
        AssertUtils.isNotEmpty((String)reqVo.getWorkingDay(), (String)"\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
        AssertUtils.isNotEmpty((String)reqVo.getGooffWorkSignAstrict(), (String)"\u8bf7\u9009\u62e9\u4e0b\u73ed\u6253\u5361\u9650\u5236");
        this.checkDataExist(reqVo);
        reqVo.getSfaWorkSignPersonnelReqVo().forEach(data -> data.setCodeType(WorkSignEnum.codeType.ORG.getVal()));
        if (CollectionUtil.listNotEmpty((List)reqVo.getSfaWorkSignPersonnelPosReqVo())) {
            reqVo.getSfaWorkSignPersonnelPosReqVo().forEach(data -> data.setCodeType(WorkSignEnum.codeType.POS_LEVEL.getVal()));
        }
    }

    private void checkPlace(String electronFence, List<SfaWorkSignPlaceReqVo> placeReqVos) {
        if (CollectionUtil.listNotEmpty(placeReqVos)) {
            int p = 1;
            for (SfaWorkSignPlaceReqVo placeReqVo : placeReqVos) {
                AssertUtils.isNotEmpty((String)placeReqVo.getWspNo(), (String)("\u7b2c" + p + "\u6761\u6253\u5361\u5730\u70b9\uff0c\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                this.iSfaWorkSignPlaceService.saveCheck(placeReqVo);
                ++p;
            }
        }
        if (!SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal().equals(electronFence)) {
            AssertUtils.isNotEmpty(placeReqVos, (String)"\u8bf7\u6dfb\u52a0\u6253\u5361\u5730\u70b9");
            boolean nonClockAll = false;
            boolean nonClockIn = false;
            boolean nonClockOut = false;
            for (SfaWorkSignPlaceReqVo vo : placeReqVos) {
                if (SfaWorkSignEnum.WorkSignType.CLOCK_ALL.getVal().equals(vo.getPlaceSignType())) {
                    nonClockAll = true;
                    continue;
                }
                if (SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(vo.getPlaceSignType())) {
                    nonClockIn = true;
                    continue;
                }
                if (!SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal().equals(vo.getPlaceSignType())) continue;
                nonClockOut = true;
            }
            if (!(nonClockAll || nonClockIn && nonClockOut)) {
                throw new BusinessException("\u6253\u5361\u5730\u70b9\u5fc5\u987b\u5305\u542b\u4e0a\u4e0b\u73ed\u6253\u5361\uff01");
            }
        }
    }

    private void checkSignTime(SfaWorkSignRuleReqVo reqVo) {
        if (SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal().equals(reqVo.getRuleType())) {
            AssertUtils.isNotEmpty((Collection)reqVo.getSfaWorkSignTimeReqVos(), (String)"\u8bf7\u9009\u62e9\u6253\u5361\u65f6\u95f4");
        } else if (SfaWorkSignEnum.WorkSignRuleType.FREE_TIME.getVal().equals(reqVo.getRuleType())) {
            SfaWorkSignTimeReqVo vo = new SfaWorkSignTimeReqVo();
            vo.setGotoTime("23:59:59");
            vo.setGooffTime("00:00:00");
            vo.setGotoStartTime("00:00:00");
            vo.setGotoEndTime("23:59:59");
            vo.setGooffStartTime("00:00:00");
            vo.setGooffEndTime("23:59:59");
            reqVo.setSfaWorkSignTimeReqVos(Arrays.asList(vo));
        }
        List sfaWorkSignTimeReqVos = reqVo.getSfaWorkSignTimeReqVos();
        AssertUtils.isNotNull((Object)sfaWorkSignTimeReqVos, (String)"\u8bf7\u914d\u7f6e\u6253\u5361\u65f6\u95f4");
        String endTime = null;
        int i = 1;
        for (SfaWorkSignTimeReqVo timeReqVo : sfaWorkSignTimeReqVos) {
            this.iSfaWorkSignTimeService.saveCheck(timeReqVo);
            if (StringUtils.isEmpty(endTime)) {
                endTime = timeReqVo.getGooffEndTime();
            } else {
                if (LocalTime.parse(endTime).compareTo(LocalTime.parse(timeReqVo.getGotoStartTime())) > 0) {
                    throw new BusinessException("<\u7b2c" + (i - 1) + ">\u6bb5\u6253\u5361\u4e0b\u73ed\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e<\u7b2c" + i + ">\u6bb5\u6253\u5361\u4e0a\u73ed\u5f00\u59cb\u65f6\u95f4");
                }
                endTime = timeReqVo.getGooffEndTime();
            }
            ++i;
        }
    }

    private void checkSignRange(List<SfaWorkSignPersonnelReqVo> sfaWorkSignPersonnelReqVos, SfaWorkSignRuleReqVo reqVo) {
        AssertUtils.isNotEmpty(sfaWorkSignPersonnelReqVos, (String)"\u8bf7\u6dfb\u52a0\u6253\u5361\u7ec4\u7ec7");
        ArrayList<String> wspCodes = new ArrayList<String>();
        for (SfaWorkSignPersonnelReqVo vo : sfaWorkSignPersonnelReqVos) {
            AssertUtils.isNotEmpty((String)vo.getWspCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)vo.getWspName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)vo.getCodeType(), (String)"\u7f16\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            vo.setCurrentAble(YesNoEnum.yesNoEnum.NO.getValue());
            wspCodes.add(vo.getWspCode());
        }
        List personnelPosReqVo = reqVo.getSfaWorkSignPersonnelPosReqVo();
        personnelPosReqVo.forEach(data -> data.setCurrentAble(YesNoEnum.yesNoEnum.NO.getValue()));
        List stringsOrg = reqVo.getSfaWorkSignPersonnelReqVo().stream().map(SfaWorkSignPersonnelVo::getWspCode).collect(Collectors.toList());
        List listOrg = this.iSfaWorkSignPersonnelService.list((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).in(SfaWorkSignPersonnelEntity::getWspCode, stringsOrg));
        List stringsRuleCode = listOrg.stream().map(SfaWorkSignPersonnelEntity::getRuleCode).collect(Collectors.toList());
        if (CollectionUtil.listNotEmpty((List)reqVo.getSfaWorkSignPersonnelPosReqVo())) {
            List stringsPos = reqVo.getSfaWorkSignPersonnelPosReqVo().stream().map(SfaWorkSignPersonnelVo::getWspCode).collect(Collectors.toList());
            List personnelEntities = this.iSfaWorkSignPersonnelService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.POS_LEVEL)).in(SfaWorkSignPersonnelEntity::getRuleCode, stringsRuleCode)).in(SfaWorkSignPersonnelEntity::getWspCode, stringsPos));
            if (CollectionUtil.listNotEmpty((List)personnelEntities)) {
                throw new BusinessException("\u91cd\u590d\u6dfb\u52a0:\u89c4\u5219\u51b2\u7a81\u2014\u2014 \u89c4\u5219\u7f16\u7801\uff1a" + ((SfaWorkSignPersonnelEntity)((Object)personnelEntities.get(0))).getRuleCode());
            }
        } else {
            List<SfaWorkSignPersonnelRespVo> list = this.iSfaWorkSignPersonnelService.findListJoinRule(wspCodes, StringUtils.isNotEmpty((CharSequence)reqVo.getRuleCode()) ? reqVo.getRuleCode() : null, null, CrmEnableStatusEnum.ENABLE.getCode());
            if (CollectionUtil.listNotEmpty(list)) {
                throw new BusinessException("\u7ec4\u7ec7\u91cd\u590d\u6dfb\u52a0\uff1a\u7f16\u7801" + list.get(0).getWspCode() + "-\u89c4\u5219" + list.get(0).getRuleCode());
            }
        }
    }

    private void checkSpecialDate(List<SfaWorkSignSpecialReqVo> sfaWorkSignSpecialReqVos) {
        if (org.springframework.util.CollectionUtils.isEmpty(sfaWorkSignSpecialReqVos)) {
            return;
        }
        for (SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo : sfaWorkSignSpecialReqVos) {
            if (StringUtils.isBlank((CharSequence)sfaWorkSignSpecialReqVo.getWssDate())) {
                throw new BusinessException("\u8bf7\u9009\u62e9\u7279\u6b8a\u65e5\u671f");
            }
            try {
                LocalDate.parse(sfaWorkSignSpecialReqVo.getWssDate());
            }
            catch (Exception e) {
                throw new BusinessException("\u975e\u6cd5\u7684\u7279\u6b8a\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", (Throwable)e);
            }
        }
    }

    public void checkDataExist(SfaWorkSignRuleReqVo reqVo) {
        SfaWorkSignRuleEntity entity;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleEntity::getRuleName, (Object)reqVo.getRuleName());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (null != (entity = (SfaWorkSignRuleEntity)((Object)this.sfaWorkSignRuleMapper.selectOne((Wrapper)wrapper)))) {
            throw new BusinessException("\u5df2\u5b58\u5728\u8003\u52e4\u89c4\u5219[" + reqVo.getRuleName() + "]");
        }
    }

    private List<SfaWorkSignRuleEntity> filterRule(List<SfaWorkSignRuleEntity> tempRules) {
        return tempRules.stream().filter(v -> {
            LocalDate getCreateDate;
            if (SfaWorkSignEnum.RuleEffective.NOW.getVal().equals(v.getRuleEffective())) {
                return true;
            }
            try {
                getCreateDate = LocalDate.parse(v.getCreateDate());
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u8003\u52e4\u89c4\u5219:\u65e0\u6cd5\u8f6c\u6362\u89c4\u5219\u521b\u5efa\u65e5\u671f\uff0c\u5df2\u5ffd\u7565\u6b64\u89c4\u5219\uff1aruleName = {}", (Object)v.getRuleName(), (Object)e);
                return false;
            }
            return LocalDate.now().compareTo(getCreateDate) > 0;
        }).collect(Collectors.toList());
    }

    @Override
    public void executeWorkSignRule(SfaWorkSignExecuteReqVo reqVo) {
        LambdaQueryWrapper wrappers = Wrappers.lambdaQuery(SfaWorkSignRuleEntity.class);
        List rules = this.sfaWorkSignRuleMapper.selectList((Wrapper)(wrappers = (LambdaQueryWrapper)wrappers.eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)rules)) {
            log.warn("\u6267\u884c\u8003\u52e4\u89c4\u5219:\u65e0\u53ef\u6267\u884c\u7684\u89c4\u5219");
            return;
        }
        ExecuteSignRuleContext context = new ExecuteSignRuleContext(rules, reqVo.getExecuteDate());
        this.loadContextData(context);
        this.saveSignRuleInfo(reqVo, context);
    }

    private void saveSignRuleInfo(SfaWorkSignExecuteReqVo reqVo, ExecuteSignRuleContext context) {
        String update = reqVo.getExecuteDate() + "_" + System.currentTimeMillis();
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SfaWorkSignRuleInfoEntity.class).set(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)update)).set(CrmBaseEntity::getEnableStatus, (Object)CrmDelFlagEnum.DELETE.getCode())).set(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode())).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)reqVo.getExecuteDate());
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getIds())) {
            Map<String, SfaWorkSignRuleEntity> ruleEntityIdMap = context.getRules().stream().collect(Collectors.toMap(BaseIdEntity::getId, vo -> vo, (k1, k2) -> k2));
            ArrayList<SfaWorkSignRuleEntity> choiceRuleList = new ArrayList<SfaWorkSignRuleEntity>(0);
            for (Object id : reqVo.getIds()) {
                SfaWorkSignRuleEntity vo2 = ruleEntityIdMap.get(id);
                if (vo2 == null) {
                    throw new BusinessException("\u7981\u7528\u72b6\u6001\u4e0b\u4e0d\u80fd\u8fdb\u884c\u624b\u52a8\u5237\u65b0\uff01");
                }
                choiceRuleList.add(vo2);
            }
            if (choiceRuleList.get(0) == null || choiceRuleList.size() != reqVo.getIds().size()) {
                throw new BusinessException("\u7981\u7528\u72b6\u6001\u4e0b\u4e0d\u80fd\u8fdb\u884c\u624b\u52a8\u5237\u65b0\uff01");
            }
            ruleEntityIdMap = choiceRuleList.stream().collect(Collectors.toMap(SfaWorkSignRuleEntity::getRuleCode, vo -> vo, (k1, k2) -> k2));
            ArrayList ruleInfoEntities = Lists.newArrayList();
            for (SfaWorkSignRuleInfoEntity ruleInfoEntity : context.getRuleInfoEntities()) {
                if (ruleEntityIdMap.get(ruleInfoEntity.getRuleCode()) == null) continue;
                ruleInfoEntities.add(ruleInfoEntity);
            }
            if (CollectionUtils.isEmpty((Collection)ruleInfoEntities)) {
                throw new BusinessException("\u8003\u52e4\u89c4\u5219\u4e0b\u7684\u7ec4\u7ec7\u65e0\u4eba\u5458\u4fe1\u606f");
            }
            Map<String, SfaWorkSignRuleInfoEntity> ruleInfoEntityIdMap = ruleInfoEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, vo -> vo, (k1, k2) -> k2));
            ArrayList recordEntities = Lists.newArrayList();
            for (SfaWorkSignRecordEntity recordEntity : context.getRecordEntities()) {
                if (ruleInfoEntityIdMap.get(recordEntity.getWsRuleInfoId()) == null) continue;
                recordEntities.add(recordEntity);
            }
            context.setRuleInfoEntities(ruleInfoEntities);
            context.setRecordEntities(recordEntities);
            LambdaUpdateWrapper updateWrapperByRuleCode = (LambdaUpdateWrapper)updateWrapper.clone();
            updateWrapperByRuleCode.in(SfaWorkSignRuleInfoEntity::getRuleCode, (Collection)choiceRuleList.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toList()));
            this.iSfaWorkSignRuleInfoService.update((Wrapper)updateWrapperByRuleCode);
            LambdaUpdateWrapper updateWrapperByUser = (LambdaUpdateWrapper)updateWrapper.clone();
            updateWrapperByUser.in(SfaWorkSignRuleInfoEntity::getUserName, (Collection)ruleInfoEntities.stream().map(SfaWorkSignRuleInfoEntity::getUserName).collect(Collectors.toList()));
            this.iSfaWorkSignRuleInfoService.update((Wrapper)updateWrapperByUser);
            this.iSfaWorkSignRecordService.remove((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(CrmBaseEntity::getCreateDate, (Object)reqVo.getExecuteDate()));
        } else {
            this.iSfaWorkSignRuleInfoService.update((Wrapper)updateWrapper);
            this.iSfaWorkSignRecordService.remove((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(CrmBaseEntity::getCreateDate, (Object)reqVo.getExecuteDate()));
        }
        this.iSfaWorkSignRuleInfoService.saveBatchPartition(context.getRuleInfoEntities());
        this.iSfaWorkSignRecordService.saveBatchPartition(context.getRecordEntities());
    }

    @Override
    public SfaWorkSignRuleRespVo getSignRuleByOrgCode(String orgCode) {
        List tempRules = this.sfaWorkSignRuleMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRuleEntity.class).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (tempRules == null || tempRules.size() == 0) {
            throw new BusinessException("\u5f53\u524d\u65e0\u53ef\u6267\u884c\u7684\u8003\u52e4\u89c4\u5219");
        }
        Map<String, List<SfaWorkSignPersonnelEntity>> personnelEntityMap = this.iSfaWorkSignPersonnelService.selectMappingByRuleCodes(tempRules.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toSet()));
        Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap = this.getOrgToRuleMap(personnelEntityMap);
        ExecuteSignRuleContext.OrgToRule orgToRule = orgToRuleMap.get(orgCode);
        if (orgToRule == null) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219");
        }
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setRuleCode(orgToRule.getRuleCode());
        SfaWorkSignRuleRespVo ruleRespVo = this.query(sfaWorkSignRuleReqVo);
        if (ruleRespVo == null) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219");
        }
        return ruleRespVo;
    }

    private void buildRuleInfoAndRecord(ExecuteSignRuleContext context, SfaWorkSignRuleEntity entity, MdmOrgWithPositionRespVo mdmOrgWithPositionRespVo, boolean holiday, Map<String, List<SfaWorkSignPersonnelEntity>> posLevelListMap) {
        if (null == mdmOrgWithPositionRespVo) {
            return;
        }
        List positionRespVos = mdmOrgWithPositionRespVo.getPositionList();
        if (CollectionUtil.listEmpty((List)positionRespVos)) {
            return;
        }
        String orgCode = mdmOrgWithPositionRespVo.getOrgCode();
        context.setOrgCodeNow(orgCode);
        context.setOrgNameNow(mdmOrgWithPositionRespVo.getOrgName());
        MdmOrgRespVo parentOrg = OrgUtil.getOrgByCode((String)orgCode);
        if (null != parentOrg) {
            context.setParentOrgCodeNow(parentOrg.getParentCode());
            context.setParentOrgNameNow(parentOrg.getParentName());
        }
        List<SfaWorkSignTimeEntity> sfaWorkSignTimeEntities = context.getTimeMapping().get(entity.getRuleCode());
        List<SfaWorkSignPersonnelEntity> workSignPersonnelEntities = posLevelListMap.get(entity.getRuleCode());
        List stringsPos = null;
        if (CollectionUtil.listNotEmpty(workSignPersonnelEntities)) {
            stringsPos = workSignPersonnelEntities.stream().map(SfaWorkSignPersonnelEntity::getWspCode).collect(Collectors.toList());
        }
        for (MdmPositionUserOrgRespVo positionRespVo : positionRespVos) {
            if (!context.addUser(positionRespVo.getUserName())) {
                log.warn("\u8003\u52e4\u89c4\u5219\u4efb\u52a1\u8ba1\u7b97\uff1a\u5ffd\u7565\u5df2\u88ab\u5176\u4ed6\u89c4\u5219\u8ba1\u7b97\u8fc7\u6216\u65e0\u6cd5\u8bc6\u522b\u7684\u7528\u6237 user={}", (Object)positionRespVo.getUserName());
                continue;
            }
            if (stringsPos != null && !stringsPos.contains(positionRespVo.getPositionLevelCode())) continue;
            SfaWorkSignRuleInfoEntity infoEntity = SfaWorkSignRuleInfoEntity.buildRuleInfoEntity(context, entity, positionRespVo);
            this.setSignMust(infoEntity, context.getSignDate(), context.getSpecialMapping().get(entity.getRuleCode()), holiday, entity.getWorkingDay());
            context.addRuleInfo(infoEntity);
            for (SfaWorkSignTimeEntity sfaWorkSignTimeEntity : sfaWorkSignTimeEntities) {
                context.addRecord(SfaWorkSignRecordEntity.buildClockInOut(infoEntity, sfaWorkSignTimeEntity));
            }
        }
    }

    private void setSignMust(SfaWorkSignRuleInfoEntity infoEntity, String signDate, List<SfaWorkSignSpecialEntity> specialEntityList, boolean holiday, String workingDay) {
        int weekNo;
        if (holiday) {
            infoEntity.setSignMust(YesNoEnum.yesNoEnum.NO.getValue());
            infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.HOLIDAY_NO_SIGN.getValue());
            return;
        }
        if (specialEntityList != null && specialEntityList.size() > 0) {
            for (SfaWorkSignSpecialEntity specialEntity : specialEntityList) {
                if (!signDate.equals(specialEntity.getWssDate())) continue;
                if (YesNoEnum.yesNoEnum.ONE.getValue().equals(specialEntity.getWssType())) {
                    infoEntity.setSignMust(YesNoEnum.yesNoEnum.YES.getValue());
                    infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.SPECIAL_DAY_SIGN.getValue());
                    return;
                }
                infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue());
                break;
            }
        }
        if (workingDay.indexOf((weekNo = LocalDate.now().getDayOfWeek().getValue()) + "") > -1) {
            infoEntity.setSignMust(YesNoEnum.yesNoEnum.YES.getValue());
            if (StringUtils.isEmpty((CharSequence)infoEntity.getSignOrNonType())) {
                infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.WORKDAY_SIGN.getValue());
            }
        } else {
            infoEntity.setSignMust(YesNoEnum.yesNoEnum.NO.getValue());
            if (StringUtils.isEmpty((CharSequence)infoEntity.getSignOrNonType())) {
                infoEntity.setSignOrNonType(WorkSignEnum.signOrNonType.WORK_DAY_NO_SIGN.getValue());
            }
        }
    }

    private void loadContextData(ExecuteSignRuleContext context) {
        Set<String> ruleCodes = context.getRuleCodes();
        context.setPlaceMapping(this.iSfaWorkSignPlaceService.selectMappingByRuleCodes(ruleCodes));
        context.setTimeMapping(this.iSfaWorkSignTimeService.selectMappingByRuleCodes(ruleCodes));
        context.setSpecialMapping(this.iSfaWorkSignSpecialService.selectMappingByRuleCodes(ruleCodes));
        context.setPersonnelMapping(this.iSfaWorkSignPersonnelService.selectMappingByRuleCodes(ruleCodes));
        Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap = this.getOrgToRuleMap(context.getPersonnelMapping());
        context.setOrgToRuleMap(orgToRuleMap);
        Map<String, List<SfaWorkSignPersonnelEntity>> posLevelListMap = this.iSfaWorkSignPersonnelService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignPersonnelEntity.class).in(SfaWorkSignPersonnelEntity::getRuleCode, ruleCodes)).eq(SfaWorkSignPersonnelEntity::getCodeType, (Object)WorkSignEnum.codeType.POS_LEVEL.getVal())).stream().collect(Collectors.groupingBy(SfaWorkSignPersonnelEntity::getRuleCode));
        Map<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentY = ((List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findOrgWithSinglePositionList((List)Lists.newArrayList(context.getOrgToRuleMap().keySet())), (boolean)true)).stream().collect(Collectors.toMap(MdmOrgWithPositionRespVo::getOrgCode, v -> {
            v.setPositionList(this.filterPrimary(v.getPositionList()));
            return v;
        }, (v1, v2) -> v1));
        context.setOrgPositionMappingCurrentY(orgPositionMappingCurrentY);
        boolean holiday = this.dateService.isHoliday(context.getSignDate());
        for (String orgCode : context.getOrgToRuleMap().keySet()) {
            ExecuteSignRuleContext.OrgToRule orgToRule = context.getOrgToRuleMap().get(orgCode);
            MdmOrgWithPositionRespVo positionRespVos = orgPositionMappingCurrentY.get(orgCode);
            this.buildRuleInfoAndRecord(context, context.getRuleEntityMap().get(orgToRule.getRuleCode()), positionRespVos, holiday, posLevelListMap);
        }
    }

    public Map<String, ExecuteSignRuleContext.OrgToRule> getOrgToRuleMap(Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping) {
        List treeList = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.getOrgTree(), (boolean)true);
        HashMap<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap = new HashMap<String, ExecuteSignRuleContext.OrgToRule>();
        personnelMapping.forEach((k, v) -> v.forEach(vo -> this.findOrg(treeList, (SfaWorkSignPersonnelEntity)((Object)((Object)vo)), (String)k, (Map<String, ExecuteSignRuleContext.OrgToRule>)orgToRuleMap)));
        return orgToRuleMap;
    }

    private void findOrg(List<MdmOrgTreeRespVo> treeList, SfaWorkSignPersonnelEntity personnelEntity, String ruleCode, Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap) {
        for (MdmOrgTreeRespVo vo : treeList) {
            if (vo.getOrgCode().equals(personnelEntity.getWspCode())) {
                orgToRuleMap.put(personnelEntity.getWspCode(), new ExecuteSignRuleContext.OrgToRule(0, ruleCode));
                if (!CollectionUtils.isNotEmpty((Collection)vo.getChildren())) break;
                this.setOrgToRuleMap(vo.getChildren(), 1, ruleCode, orgToRuleMap);
                break;
            }
            if (!CollectionUtils.isNotEmpty((Collection)vo.getChildren())) continue;
            this.findOrg(vo.getChildren(), personnelEntity, ruleCode, orgToRuleMap);
        }
    }

    private void setOrgToRuleMap(List<MdmOrgTreeRespVo> treeList, Integer leave, String ruleCode, Map<String, ExecuteSignRuleContext.OrgToRule> orgToRuleMap) {
        for (MdmOrgTreeRespVo vo : treeList) {
            ExecuteSignRuleContext.OrgToRule orgToRule = orgToRuleMap.get(vo.getOrgCode());
            if (orgToRule != null && orgToRule.getLeave() < leave) continue;
            orgToRuleMap.put(vo.getOrgCode(), new ExecuteSignRuleContext.OrgToRule(leave, ruleCode));
            if (!CollectionUtils.isNotEmpty((Collection)vo.getChildren())) continue;
            this.setOrgToRuleMap(vo.getChildren(), leave + 1, ruleCode, orgToRuleMap);
        }
    }

    private List<MdmPositionUserOrgRespVo> filterPrimary(List<MdmPositionUserOrgRespVo> positionRespVos) {
        if (null == positionRespVos) {
            return Lists.newArrayList();
        }
        return positionRespVos.stream().filter(v -> YesNoEnum.yesNoEnum.ONE.getValue().equals(v.getPrimaryFlag())).collect(Collectors.toList());
    }
}

