/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderDetailReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderStockAnalysisReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderDetailProRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderDetailRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemProRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderStockAnalysisRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderFormMapper;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderFormService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepOrderFormServiceExpandImpl"})
public class SfaVisitStepOrderFormServiceImpl<M extends BaseMapper<T>, T>
implements ISfaVisitStepOrderFormService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderFormServiceImpl.class);
    @Resource
    private SfaVisitStepOrderFormMapper mapper;
    @Autowired
    private ISfaVisitStepOrderItemService orderItemService;

    @Override
    public PageResult<SfaVisitStepOrderDetailRespVo> orderDetail(SfaVisitStepOrderDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderDetailRespVo> list = this.mapper.orderDetail((Page<SfaVisitStepOrderDetailRespVo>)page, reqVo);
        this.translateCode(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepOrderDetailRespVo orderInfo(final String id) {
        List<SfaVisitStepOrderDetailRespVo> list = this.mapper.orderDetail(null, new SfaVisitStepOrderDetailReqVo(){
            {
                this.setId(id);
            }
        });
        this.translateCode(list);
        if (list == null || list.size() == 0) {
            throw new BusinessException("\u8ba2\u5355\u660e\u7ec6id\u9519\u8bef\uff01");
        }
        SfaVisitStepOrderDetailRespVo respVo = list.get(0);
        List<SfaVisitStepOrderItemRespVo> itemList = this.orderItemService.findList(respVo.getId());
        this.translateUnit(itemList);
        respVo.setSfaVisitStepOrderItemRespVos(itemList);
        return respVo;
    }

    @Override
    public SfaVisitStepOrderDetailProRespVo orderInfoProgramme(final String id) {
        List<SfaVisitStepOrderDetailRespVo> list = this.mapper.orderDetail(null, new SfaVisitStepOrderDetailReqVo(){
            {
                this.setId(id);
            }
        });
        this.translateCode(list);
        if (list == null || list.size() == 0) {
            throw new BusinessException("\u8ba2\u5355\u660e\u7ec6id\u9519\u8bef\uff01");
        }
        List proRespVos = CrmBeanUtil.copyList(list, SfaVisitStepOrderDetailProRespVo.class);
        SfaVisitStepOrderDetailProRespVo respVo = (SfaVisitStepOrderDetailProRespVo)proRespVos.get(0);
        List<SfaVisitStepOrderItemRespVo> itemList = this.orderItemService.findList(respVo.getId());
        List filterList = itemList.stream().filter(date -> StringUtils.isNotEmpty((String)date.getSetMeal())).collect(Collectors.toList());
        Map collect = filterList.stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemRespVo::getSetMeal, Collectors.toList()));
        ArrayList<SfaVisitStepOrderItemProRespVo> sfaVisitStepOrderItemProRespVos = new ArrayList<SfaVisitStepOrderItemProRespVo>();
        for (Map.Entry map : collect.entrySet()) {
            SfaVisitStepOrderItemProRespVo sfaVisitStepOrderItemProRespVo = new SfaVisitStepOrderItemProRespVo();
            String setMeal = map.getKey();
            List voList = map.getValue();
            sfaVisitStepOrderItemProRespVo.setSetMeal(setMeal);
            Map proMap = voList.stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemRespVo::getProductType, Collectors.toList()));
            List<SfaVisitStepOrderItemRespVo> bpVos = proMap.get(SfaActivityEnum.bpItemType.bp.getVal());
            this.translateUnit(bpVos);
            List<SfaVisitStepOrderItemRespVo> zpVos = proMap.get(SfaActivityEnum.bpItemType.zp.getVal());
            this.translateUnit(zpVos);
            sfaVisitStepOrderItemProRespVo.setBpVos(bpVos);
            sfaVisitStepOrderItemProRespVo.setZpVos(zpVos);
            sfaVisitStepOrderItemProRespVos.add(sfaVisitStepOrderItemProRespVo);
        }
        respVo.setProRespVos(sfaVisitStepOrderItemProRespVos);
        return respVo;
    }

    @Override
    public PageResult<SfaVisitStepOrderStockAnalysisRespVo> stockAnalysis(SfaVisitStepOrderStockAnalysisReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderStockAnalysisRespVo> list = this.mapper.stockAnalysis((Page<SfaVisitStepOrderStockAnalysisRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public void translateCode(List<SfaVisitStepOrderDetailRespVo> list) {
        Map orderType = DictUtil.getDictValueMapsByCodes((String)"sfa_order_source");
        Map approalType = DictUtil.getDictValueMapsByCodes((String)"sfa_approval");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(data -> {
                if (StringUtils.isNotEmpty((String)data.getOrderSource())) {
                    data.setOrderSourceName((String)orderType.get(data.getOrderSource()));
                }
                if (StringUtils.isNotEmpty((String)data.getApprovalStatus())) {
                    data.setApprovalStatusName((String)approalType.get(data.getApprovalStatus()));
                }
            });
        }
    }

    public void translateUnit(List<SfaVisitStepOrderItemRespVo> list) {
        Map unitName = DictUtil.getDictValueMapsByCodes((String)"product_sale_unit");
        Map typeName = DictUtil.getDictValueMapsByCodes((String)"sfa_product_type");
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(data -> {
                if (StringUtils.isNotEmpty((String)data.getUnit())) {
                    data.setUnitName((String)unitName.get(data.getUnit()));
                }
                if (StringUtils.isNotEmpty((String)data.getProductType())) {
                    data.setProductTypeName((String)typeName.get(data.getProductType()));
                }
            });
        }
    }
}

