/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.SfaClientByCustConExtend;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalMsgReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaCustomerMsgRespVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaTerminalMsgRespVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/client"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0\u9875\u9762-\u5ba2\u6237\u7ba1\u7406"})
public class SfaClientController {
    private static final Logger log = LoggerFactory.getLogger(SfaClientController.class);
    @Autowired
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired(required=false)
    private SfaClientByCustConExtend sfaClientByCustConExtend;
    @Autowired
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private SfaTerminalService sfaTerminalService;
    @Autowired
    private SfaCustomerService sfaCustomerService;

    @ApiOperation(value="\u5ba2\u6237\u67e5\u8be2")
    @PostMapping(value={"/findClientByCustConList"})
    @CrmLog
    public Page<MdmCustomerMsgRespVo> findClientByCustomerConList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (null == mdmCustomerMsgReqVo.getPageNum()) {
            mdmCustomerMsgReqVo.setPageNum(Integer.valueOf(0));
        }
        if (null == mdmCustomerMsgReqVo.getPageSize()) {
            mdmCustomerMsgReqVo.setPageSize(Integer.valueOf(50));
        }
        PageResult pageResult = null;
        pageResult = null != this.sfaClientByCustConExtend ? this.sfaClientByCustConExtend.findClientByCustomerConList(mdmCustomerMsgReqVo) : (PageResult)this.mdmCustomerMsgFeign.list(mdmCustomerMsgReqVo).getResult();
        return pageResult == null ? new PageImpl((List)Lists.newArrayList(), (Pageable)PageRequest.of((int)mdmCustomerMsgReqVo.getPageNum(), (int)mdmCustomerMsgReqVo.getPageSize()), 0L) : new PageImpl(pageResult.getData(), (Pageable)PageRequest.of((int)mdmCustomerMsgReqVo.getPageNum(), (int)mdmCustomerMsgReqVo.getPageSize()), pageResult.getCount().longValue());
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5ba2\u6237\u4e3b\u8054\u7cfb\u4eba\u53ca\u8ddd\u79bb\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/findCustomer"})
    @CrmLog
    public Result<PageResult<MdmCustomerContactPageRespVo>> findCustomer(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        return this.mdmCustomerMsgFeign.distanceContactNoBpmFilterPage(mdmCustomerDistanceContactPageReqVo);
    }

    @ApiOperation(value="\u5ba2\u6237\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"//findClientByCustomerQuery"})
    @CrmLog
    public Result<MdmCustomerMsgRespVo> findClientByCustomerQuery(@RequestParam(value="id", required=false) String id, @RequestParam(value="customerCode", required=false) String customerCode) {
        Result result = this.mdmCustomerMsgFeign.query(id, customerCode);
        return result;
    }

    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237")
    @PostMapping(value={"/saveCustomer"})
    @CrmLog
    public Result saveCustomer(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.sfaCustomerService.saveCustomer(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237")
    @PostMapping(value={"/updateCustomer"})
    @CrmLog
    public Result updateCustomer(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.sfaCustomerService.updateCustomer(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ec8\u7aef\u67e5\u8be2")
    @PostMapping(value={"/findTerminal"})
    @CrmLog
    public Result<PageResult<MdmTerminalContactPageVo>> findTerminal(@RequestBody MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
        Result pageResultResult = this.mdmTerminalFeign.distanceContactNoBpmFilterPage(mdmTerminalDistanceContactPageReqVo);
        return pageResultResult;
    }

    @ApiOperation(value="\u6839\u636e\u8425\u4e1a\u6267\u7167\u53f7\u67e5\u51fa\u6307\u5b9a\u7ec8\u7aef")
    @GetMapping(value={"/findTerminalByLicenseRegisterNumb"})
    @CrmLog
    public Result<MdmTerminalVo> findTerminalByLicenseRegisterNumb(@RequestParam(value="licenseRegisterNumber", required=false) String licenseRegisterNumber, @RequestParam(value="terminalName", required=false) String terminalName) {
        Result detailByRegisterOrName = this.mdmTerminalFeign.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        return detailByRegisterOrName;
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u7ec8\u7aef")
    @GetMapping(value={"/queryTerminal"})
    @CrmLog
    public Result<MdmTerminalVo> query(@RequestParam(value="id", required=false) String id, @RequestParam(value="terminalCode", required=false) String terminalCode) {
        Result mdmTerminalVoResult = this.mdmTerminalFeign.query(id, terminalCode);
        return mdmTerminalVoResult;
    }

    @ApiOperation(value="\u65b0\u589e\u7ec8\u7aef")
    @PostMapping(value={"/saveTerminal"})
    @CrmLog
    public Result saveTerminal(@RequestBody SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        this.sfaTerminalService.saveTerminal(sfaTerminalMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec8\u7aef")
    @PostMapping(value={"/updateTerminal"})
    @CrmLog
    public Result updateTerminal(@RequestBody SfaTerminalMsgReqVo sfaTerminalMsgReqVo) {
        this.sfaTerminalService.updateTerminal(sfaTerminalMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5ba2\u6237\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/customerEnd"})
    @CrmLog
    public Result customerEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        this.sfaCustomerService.updateActApproveStatus(activitiCallBackVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ec8\u7aef\u5ba1\u6838\u6d41\u7a0b\u7ed3\u675f")
    @PostMapping(value={"/terminalEnd"})
    @CrmLog
    public Result terminalEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        this.sfaTerminalService.updateActApproveStatus(activitiCallBackVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u5ba1\u6838\u7684\u6240\u6709\u7ec8\u7aef-\u5c0f\u7a0b\u5e8f\u7aef")
    @PostMapping(value={"/findAllTerminal"})
    @CrmLog
    public Result<PageResult<SfaTerminalMsgRespVo>> findAllTerminal(@RequestBody SfaTerminalReqVo sfaTerminalReqVo) {
        return Result.ok(this.sfaTerminalService.findAllSfaTerminal(sfaTerminalReqVo));
    }

    @ApiOperation(value="\u7ec8\u7aef\u5ba1\u6279-\u5c0f\u7a0b\u5e8f\u7aef")
    @GetMapping(value={"/updateSfaTerminal"})
    @CrmLog
    public Result updateSfaTerminal(@RequestParam(value="id", required=false) String id, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="actApproveStatus", required=false) String actApproveStatus) {
        this.sfaTerminalService.updateSfaActApproveStatus(id, remark, actApproveStatus);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5ba1\u6279\u7ec8\u7aef\u7684\u4fe1\u606f-\u5c0f\u7a0b\u5e8f\u7aef")
    @GetMapping(value={"/querySfaTerminal"})
    @CrmLog
    public Result<SfaTerminalMsgRespVo> querySfaTerminalVo(@RequestParam(value="id", required=false) String id) {
        return this.sfaTerminalService.querySfaTerminalVo(id);
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5ba1\u6279\u7ecf\u9500\u5546\u7684\u4fe1\u606f-\u5c0f\u7a0b\u5e8f\u7aef")
    @GetMapping(value={"/querySfaCustomerMsgVo"})
    @CrmLog
    @CrmDictMethod
    public Result<SfaCustomerMsgRespVo> querySfaCustomerMsgVo(@RequestParam(value="id", required=false) String id) {
        return this.sfaCustomerService.querySfaCustomerVo(id);
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u5ba1\u6279-\u5c0f\u7a0b\u5e8f\u7aef")
    @GetMapping(value={"/updateSfaCustomer"})
    @CrmLog
    public Result updateSfaCustomer(@RequestParam(value="id", required=false) String id, @RequestParam(value="remark", required=false) String remark, @RequestParam(value="actApproveStatus", required=false) String actApproveStatus) {
        this.sfaCustomerService.updateSfaActApproveStatus(id, remark, actApproveStatus);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u5ba1\u6838\u7684\u6240\u6709\u7ecf\u9500\u5546-\u5c0f\u7a0b\u5e8f\u7aef")
    @PostMapping(value={"/findAllCustomer"})
    @CrmLog
    public Result<PageResult<MdmCustomerMsgReqVo>> findAllCustomer(@RequestBody SfaCustomerReqVo sfaCustomerReqVo) {
        return Result.ok(this.sfaCustomerService.findAllSfaCustomer(sfaCustomerReqVo));
    }

    @ApiOperation(value="\u5f85\u5904\u7406\u7684\u7ecf\u9500\u5546\u6570\u91cf")
    @GetMapping(value={"/countCustomerInApproving"})
    @CrmLog
    public Result<Integer> countCustomerInApproving() {
        return this.sfaCustomerService.countCustomer();
    }

    @ApiOperation(value="\u5f85\u5904\u7406\u7684\u7ec8\u7aef\u6570\u91cf")
    @GetMapping(value={"/countTerminalInApproving"})
    @CrmLog
    public Result<Integer> countTerminalInApproving() {
        return this.sfaTerminalService.countTerminal();
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u65b0\u589e\u6570")
    @GetMapping(value={"/getCustomerNum"})
    @CrmLog
    public Result<Integer> getCustomerNum(@RequestParam(value="dateFlag", required=false) String dateFlag2) {
        return Result.ok((Object)this.sfaCustomerService.getCustomerNum(dateFlag2));
    }
}

