/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEntity;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEsData;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultRedisData;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepDefaultEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"defaultVisitStepExecutorExpandImpl"})
public class DefaultVisitStepExecutor<ExecuteReq extends SfaVisitStepDefaultEntity>
extends AbstractVisitStepRedisExecutor<ExecuteReq, SfaVisitStepDefaultEsData, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(DefaultVisitStepExecutor.class);
    @Resource
    private SfaVisitStepDefaultEsDataRepositories sfaVisitStepDefaultEsDataRepositories;

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_DEF.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepDefaultRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), SfaVisitEnum.visitStep.VISIT_STEP_STORE_CHECK.getVal(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepDefaultRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(UUIDGenerator.generate());
        SfaVisitStepDefaultEntity dataReq = (SfaVisitStepDefaultEntity)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected SfaVisitStepDefaultRedisData buildRedisData(VisitStepExecuteReq<? extends SfaVisitStepDefaultEntity> visitStepExecuteReq) {
        SfaVisitStepDefaultEntity executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepDefaultRedisData redisData = (SfaVisitStepDefaultRedisData)CrmBeanUtil.copy((Object)executeData, SfaVisitStepDefaultRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        return redisData;
    }

    @Override
    protected SfaVisitStepDefaultEsData doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepDefaultRedisData redisData = (SfaVisitStepDefaultRedisData)this.redisService.hmget(SfaVisitStepDefaultRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey());
        if (null == redisData) {
            SfaVisitStepDefaultEsData dataResp = new SfaVisitStepDefaultEsData(){
                {
                    this.initAttachmentExt();
                }
            };
            dataResp.setSfaVisitStepFrom(fromRespVo);
            return dataResp;
        }
        SfaVisitStepDefaultEsData dataResp = (SfaVisitStepDefaultEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepDefaultEsData.class);
        dataResp.setAttachmentExt1(redisData.getAttachmentExt1());
        dataResp.setAttachmentExt2(redisData.getAttachmentExt2());
        dataResp.setAttachmentExt3(redisData.getAttachmentExt3());
        dataResp.setAttachmentExt4(redisData.getAttachmentExt4());
        dataResp.setAttachmentExt5(redisData.getAttachmentExt5());
        dataResp.setAttachmentExt6(redisData.getAttachmentExt6());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepDefaultEsData esData = this.sfaVisitStepDefaultEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public SfaVisitStepDefaultEsData getEsDataById(String id) {
        Optional optional = this.sfaVisitStepDefaultEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (SfaVisitStepDefaultEsData)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected SfaVisitStepDefaultEsData doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepDefaultEsData redisData = (SfaVisitStepDefaultEsData)this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return redisData;
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getClientType())) {
                throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepDefaultEsData dataResp = new SfaVisitStepDefaultEsData(){
                {
                    this.initAttachmentExt();
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType()));
            return dataResp;
        }
        SfaVisitStepDefaultEsData esData = this.getEsDataById(bizId);
        if (null == esData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        return esData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepDefaultRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        SfaVisitStepDefaultEntity executeData = (SfaVisitStepDefaultEntity)visitStepExecuteReq.getStepExecuteData();
        if (null == executeData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepDefaultRedisData redisData = (SfaVisitStepDefaultRedisData)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), executorLoadReq.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey());
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepDefaultRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepDefaultEsData oldData;
        SfaVisitStepDefaultEsData dataResp = (SfaVisitStepDefaultEsData)CrmBeanUtil.copy((Object)redisData, SfaVisitStepDefaultEsData.class);
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = (SfaVisitStepDefaultEsData)this.getEsDataByVisitPlanInfo(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepDefaultEsDataRepositories.save(dataResp);
    }
}

