/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.checkin.mapper.SfaCheckInSignGroupReportMapper;
import com.biz.crm.checkin.model.SfaCheckInSignGroupReportEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.req.ClockReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DistanceUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.req.SfaSignRecordBatchReqVo;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignRecordServiceExpandImpl"})
public class SfaWorkSignRecordServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignRecordMapper, SfaWorkSignRecordEntity>
implements ISfaWorkSignRecordService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRecordServiceImpl.class);
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Resource
    private ISfaWorkOvertimeService iSfaWorkOvertimeService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private SfaCheckInSignGroupReportMapper signGroupReportMapper;
    @Resource
    private SfaWorkSignPlaceMapper sfaWorkSignPlaceMapper;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSignRecord(SfaSignRecordReqVo sfaSignRecordReqVo) {
        if (StringUtils.isEmpty((String)sfaSignRecordReqVo.getId()) || StringUtils.isEmpty((String)sfaSignRecordReqVo.getExceptionRemarks()) || StringUtils.isEmpty((String)sfaSignRecordReqVo.getWorkSignStatus())) {
            throw new BusinessException("\u8bf7\u786e\u8ba4\u5fc5\u586b\u9879\u4e0d\u4e3a\u7a7a");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SfaWorkSignRecordEntity.class).set(SfaWorkSignRecordEntity::getWorkSignStatus, (Object)sfaSignRecordReqVo.getWorkSignStatus())).set(SfaWorkSignRecordEntity::getExceptionRemarks, (Object)sfaSignRecordReqVo.getExceptionRemarks())).eq(BaseIdEntity::getId, (Object)sfaSignRecordReqVo.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatchList(SfaSignRecordBatchReqVo sfaSignRecordBatchReqVo) {
        if (StringUtils.isEmpty((String)sfaSignRecordBatchReqVo.getWorkSignStatus()) || CollectionUtil.listEmpty(sfaSignRecordBatchReqVo.getIds()) || StringUtils.isEmpty((String)sfaSignRecordBatchReqVo.getWsPlaceStatus())) {
            throw new BusinessException("\u8bf7\u786e\u8ba4\u4fee\u6539\u8003\u52e4\u72b6\u6001\u7684\u53c2\u6570\u662f\u5426\u4e3a\u7a7a");
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SfaWorkSignRecordEntity.class).in(BaseIdEntity::getId, sfaSignRecordBatchReqVo.getIds())).set(SfaWorkSignRecordEntity::getWorkSignStatus, (Object)sfaSignRecordBatchReqVo.getWorkSignStatus())).set(SfaWorkSignRecordEntity::getWsPlaceStatus, (Object)sfaSignRecordBatchReqVo.getWorkSignStatus()));
    }

    @Override
    public PageResult<SfaWorkSignRecordRespVo> findList(SfaWorkSignRecordReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRecordRespVo> list = this.sfaWorkSignRecordMapper.findList((Page<SfaWorkSignRecordRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRecordRespVo query(SfaWorkSignRecordReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSignRecordReqVo reqVo) {
        SfaWorkSignRecordEntity entity = (SfaWorkSignRecordEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRecordEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSignRecordReqVo reqVo) {
        SfaWorkSignRecordEntity entity = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    public List<SfaWorkSignRecordEntity> getRecordsByInfo(String signRuleInfoId, String signType) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)signRuleInfoId);
        if (StringUtils.isNotEmpty((String)signType)) {
            wrapper.eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)signType);
        }
        return this.sfaWorkSignRecordMapper.selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result gotoWorkClock(ClockReqVo clockReqVo) {
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)clockReqVo.getId())));
        if (null == sfaWorkSignRecord) {
            throw new BusinessException("\u8003\u52e4\u8bb0\u5f55\u4e0d\u5b58\u5728:" + clockReqVo.getId());
        }
        boolean isClockIn = SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType());
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.sfaWorkSignRuleInfoService.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity) {
            throw new BusinessException("\u8003\u52e4\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        workSignRuleInfoEntity.checkSignTime(isClockIn, Arrays.asList(sfaWorkSignRecord));
        SfaWorkSignRuleInfoRespVo workSignRuleInfo = (SfaWorkSignRuleInfoRespVo)CrmBeanUtil.copy((Object)((Object)workSignRuleInfoEntity), SfaWorkSignRuleInfoRespVo.class);
        if (!workSignRuleInfo.getId().equals(sfaWorkSignRecord.getWsRuleInfoId())) {
            throw new BusinessException("\u8003\u52e4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        this.gooffWorkSignAstrictCheck(sfaWorkSignRecord, workSignRuleInfo);
        if (CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(workSignRuleInfo.getWsrPhotograph()) && CollectionUtils.isEmpty((Collection)clockReqVo.getSfaWorkSignPictureReqVos())) {
            throw new BusinessException("\u8003\u52e4\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.pleaceCheck(sfaWorkSignRecord, workSignRuleInfo, clockReqVo);
        this.calculateWorkSignStatus(sfaWorkSignRecord, workSignRuleInfo);
        sfaWorkSignRecord.setRemarks(clockReqVo.getRemarks());
        this.injectUserInfo(sfaWorkSignRecord);
        this.updateById((Object)sfaWorkSignRecord);
        List workSignPictureEntityList = clockReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
            SfaWorkSignPictureEntity workSignPictureEntity = (SfaWorkSignPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaWorkSignPictureEntity.class)));
            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
            return workSignPictureEntity;
        }).collect(Collectors.toList());
        this.sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        return Result.ok((Object)((Object)sfaWorkSignRecord));
    }

    @Override
    @Transactional(readOnly=true)
    public NeedClock needWorkSign() {
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.sfaWorkSignRuleInfoService.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity) {
            return this.needFreeSign(new NeedClock());
        }
        List clockIn = this.sfaWorkSignRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfoEntity.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal()));
        List clockOut = this.sfaWorkSignRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfoEntity.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal()));
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(workSignRuleInfoEntity.getSignMust())) {
            return this.needFreeSign(this.needClock(workSignRuleInfoEntity, clockIn, clockOut));
        }
        boolean has = this.iSfaWorkOvertimeService.hasOvertime(workSignRuleInfoEntity);
        if (has) {
            if (YesNoEnum.yesNoEnum.NO.getValue().equals(workSignRuleInfoEntity.getNonWorkingDaySignAstrict())) {
                return this.needFreeSign(new NeedClock());
            }
            return this.needFreeSign(this.needClock(workSignRuleInfoEntity, clockIn, clockOut));
        }
        return this.needFreeSign(new NeedClock());
    }

    private NeedClock needClock(SfaWorkSignRuleInfoEntity workSignRuleInfoEntity, List<SfaWorkSignRecordEntity> clockIn, List<SfaWorkSignRecordEntity> clockOut) {
        NeedClock needClock = new NeedClock();
        if (WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue().equals(workSignRuleInfoEntity.getSignOrNonType())) {
            return needClock;
        }
        if (clockIn != null && clockIn.size() > 0) {
            clockIn.forEach(vo -> {
                if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(vo.getWorkSignStatus())) {
                    needClock.setClockIn(true);
                    needClock.setClockInNum(needClock.getClockInNum() + 1);
                }
            });
        }
        if (SfaWorkSignEnum.GooffWorkSignAstrictEnum.NO_SIGN.getVal().equals(workSignRuleInfoEntity.getGooffWorkSignAstrict())) {
            return needClock;
        }
        if (clockOut != null && clockOut.size() > 0) {
            clockOut.forEach(vo -> {
                if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(vo.getWorkSignStatus())) {
                    needClock.setClockOut(true);
                    needClock.setClockOutNum(needClock.getClockOutNum() + 1);
                }
            });
        }
        return needClock;
    }

    private NeedClock needFreeSign(NeedClock needClock) {
        Integer count = this.signGroupReportMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class).eq(SfaCheckInSignGroupReportEntity::getCheckInDate, (Object)LocalDate.now().toString())).eq(SfaCheckInSignGroupReportEntity::getUserName, (Object)UserUtils.getUser().getUsername())).eq(SfaCheckInSignGroupReportEntity::getSignStatus, (Object)SfaWorkSignEnum.WorkSignStatus.NONE.getVal()));
        if (count != null && count > 0) {
            needClock.setFreeSign(true);
            needClock.setFreeSignNum(count);
        }
        return needClock;
    }

    private void gooffWorkSignAstrictCheck(SfaWorkSignRecordEntity recordEntity, SfaWorkSignRuleInfoRespVo workSignRuleInfo) {
        if (SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(recordEntity.getWorkSignType())) {
            return;
        }
        if (SfaWorkSignEnum.GooffWorkSignAstrictEnum.GOTO_WORK_REQUIRED.getVal().equals(workSignRuleInfo.getGooffWorkSignAstrict())) {
            SfaWorkSignRecordEntity clockIn = (SfaWorkSignRecordEntity)((Object)this.sfaWorkSignRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfo.getId())).eq(SfaWorkSignRecordEntity::getSfaSignTimeId, (Object)recordEntity.getSfaSignTimeId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal())));
            if (clockIn == null) {
                throw new BusinessException("\u4e0a\u73ed\u6253\u5361\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockIn.getWorkSignStatus())) {
                throw new BusinessException("\u672a\u4e0a\u73ed\u6253\u5361\uff0c\u4e0d\u80fd\u4e0b\u73ed\u6253\u5361\uff01");
            }
        }
    }

    private void calculateWorkSignStatus(SfaWorkSignRecordEntity sfaWorkSignRecord, SfaWorkSignRuleInfoRespVo workSignRuleInfo) {
        String ruleDate = workSignRuleInfo.getRuleDate();
        boolean isClockIn = SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType());
        String time = sfaWorkSignRecord.getSfaSignTime();
        LocalDateTime gotoTime = LocalDateTime.parse(ruleDate + " " + time, CrmDateUtils.yyyyMMddHHmmss);
        LocalDateTime localDateTime = LocalDateTime.now();
        if (isClockIn) {
            if (localDateTime.compareTo(gotoTime) > 0) {
                sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.BE_LATE.getVal());
            } else {
                sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
            }
        } else if (localDateTime.compareTo(gotoTime) < 0) {
            sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.LEAVE_EARLY.getVal());
        } else {
            sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
        }
        sfaWorkSignRecord.setWorkSignTime(localDateTime.format(CrmDateUtils.HHmmss));
    }

    private void injectUserInfo(SfaWorkSignRecordEntity sfaWorkSignRecord) {
        UserRedis userRedis = UserUtils.getUser();
        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
    }

    private void pleaceCheck(SfaWorkSignRecordEntity sfaWorkSignRecord, SfaWorkSignRuleInfoRespVo workSignRuleInfo, ClockReqVo clockReqVo) {
        sfaWorkSignRecord.setWorkSignPlace(clockReqVo.getWorkSignPlace());
        sfaWorkSignRecord.setLngIn(clockReqVo.getLngIn());
        sfaWorkSignRecord.setLatIn(clockReqVo.getLatIn());
        String electronFence = workSignRuleInfo.getElectronFence();
        if (SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal().equals(electronFence)) {
            return;
        }
        sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal());
        if (SfaWorkSignEnum.ElectronFenceEnum.OUT_SIGN_OK.getVal().equals(electronFence)) {
            sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
            return;
        }
        List workSignPlaceEntities = this.sfaWorkSignPlaceMapper.selectList((Wrapper)Wrappers.lambdaQuery(SfaWorkSignPlaceEntity.class).eq(SfaWorkSignPlaceEntity::getRuleCode, (Object)workSignRuleInfo.getRuleCode()));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)workSignPlaceEntities)) {
            for (SfaWorkSignPlaceEntity workSignPlace : workSignPlaceEntities) {
                if (WorkSignEnum.workSignPlaceType.VISIT_PLAN_PLACE.getVal().equals(workSignPlace.getPlaceName()) && this.checkVisitPlanPlace(workSignPlace, clockReqVo)) {
                    sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
                    break;
                }
                String placeLngin = workSignPlace.getPlaceLngin();
                String placeLatin = workSignPlace.getPlaceLatin();
                String placeRange = workSignPlace.getPlaceRange();
                double placeRanged = Double.valueOf(placeRange.trim());
                double wsDistance = DistanceUtil.GetPointDistance((String)(clockReqVo.getLatIn() + "," + clockReqVo.getLngIn()), (String)(placeLatin + "," + placeLngin));
                if (!(wsDistance <= placeRanged)) continue;
                sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
                break;
            }
        }
        if (SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal().equals(sfaWorkSignRecord.getWsPlaceStatus()) && SfaWorkSignEnum.ElectronFenceEnum.NO_OUT_SIGN.getVal().equals(electronFence)) {
            throw new BusinessException("\u4e0d\u5141\u8bb8\u8303\u56f4\u5916\u6253\u5361");
        }
    }

    private boolean checkVisitPlanPlace(SfaWorkSignPlaceEntity workSignPlace, ClockReqVo clockReqVo) {
        UserRedis user = UserUtils.getUser();
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        req.setVisitDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        req.setVisitPositionCode(user.getPoscode());
        req.setVisitUserName(user.getUsername());
        List planInfoEntities = this.sfaVisitPlanInfoService.doGetVisitInfoList(req).stream().filter(v -> null != v.getLongitude() && null != v.getLatitude()).collect(Collectors.toList());
        for (SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity : planInfoEntities) {
            String placeLngin = sfaVisitPlanInfoEntity.getLongitude().toString();
            String placeLatin = sfaVisitPlanInfoEntity.getLatitude().toString();
            String placeRange = workSignPlace.getPlaceRange();
            double placeRanged = Double.valueOf(placeRange.trim());
            double wsDistance = DistanceUtil.GetPointDistance((String)(clockReqVo.getLatIn() + "," + clockReqVo.getLngIn()), (String)(placeLatin + "," + placeLngin));
            if (!(wsDistance <= placeRanged)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goFreeSignIn(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        return Result.ok();
    }

    @Override
    public void saveBatchPartition(List<SfaWorkSignRecordEntity> recordEntityList) {
        if (CollectionUtil.listEmpty(recordEntityList)) {
            return;
        }
        List partitionList = Lists.partition(recordEntityList, (int)50);
        for (List recordEntities : partitionList) {
            this.saveBatch(recordEntities);
        }
    }

    @Override
    public PageResult<SfaSignHistoryListRespVo> findSignHistory(SfaSignHistoryListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaSignHistoryListRespVo> list = this.sfaWorkSignRecordMapper.findSignHistory((Page<SfaSignHistoryListRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

