/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo;
import com.biz.crm.moblie.service.SfaApprovalService;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.mapper.SfaWorkSignRuleInfoMapper;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignRuleInfoServiceExpandImpl"})
public class SfaWorkSignRuleInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignRuleInfoMapper, SfaWorkSignRuleInfoEntity>
implements ISfaWorkSignRuleInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRuleInfoServiceImpl.class);
    @Resource
    private SfaWorkSignRuleInfoMapper sfaWorkSignRuleInfoMapper;
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Resource
    private SfaWorkSignTimeMapper sfaWorkSignTimeMapper;
    @Resource
    private ISfaWorkOvertimeService iSfaWorkOvertimeService;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Resource
    private SfaApprovalService sfaApprovalService;

    @Override
    public PageResult<SfaWorkSignRuleInfoRespVo> findList(SfaWorkSignRuleInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRuleInfoRespVo> list = this.sfaWorkSignRuleInfoMapper.findList((Page<SfaWorkSignRuleInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRuleInfoRespVo query(SfaWorkSignRuleInfoReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSignRuleInfoReqVo reqVo) {
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRuleInfoEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSignRuleInfoReqVo reqVo) {
        SfaWorkSignRuleInfoEntity entity = (SfaWorkSignRuleInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSignRuleInfoReqVo reqVo) {
        List sfaWorkSignRuleInfoEntities = this.sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
    }

    @Override
    public PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(SfaWorkSignInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignInfoRespVo> list = this.sfaWorkSignRuleInfoMapper.findWorkSignInfoList((Page<SfaWorkSignInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private SfaWorkSignRecordRespVo buildSfaWorkSignRecordRespVo(SfaWorkSignRuleInfoEntity workSignRuleInfoEntity, SfaWorkSignRecordEntity sfaWorkSignRecord) {
        SfaWorkSignRecordRespVo workSignRecordRespVo = (SfaWorkSignRecordRespVo)CrmBeanUtil.copy((Object)((Object)sfaWorkSignRecord), SfaWorkSignRecordRespVo.class);
        SfaWorkSignTimeEntity sfaWorkSignTimeEntity = (SfaWorkSignTimeEntity)((Object)this.sfaWorkSignTimeMapper.selectOne((Wrapper)Wrappers.lambdaQuery(SfaWorkSignTimeEntity.class).eq(BaseIdEntity::getId, (Object)sfaWorkSignRecord.getSfaSignTimeId())));
        workSignRecordRespVo.setGotoEndTime(sfaWorkSignTimeEntity.getGotoEndTime());
        workSignRecordRespVo.setGooffEndTime(sfaWorkSignTimeEntity.getGooffEndTime());
        workSignRecordRespVo.setGooffStartTime(sfaWorkSignTimeEntity.getGooffStartTime());
        workSignRecordRespVo.setGotoStartTime(sfaWorkSignTimeEntity.getGotoStartTime());
        workSignRecordRespVo.setGotoTime(sfaWorkSignTimeEntity.getGotoTime());
        workSignRecordRespVo.setGooffTime(sfaWorkSignTimeEntity.getGooffTime());
        workSignRecordRespVo.setRuleDate(workSignRuleInfoEntity.getRuleDate());
        workSignRecordRespVo.setWsrPhotograph(workSignRuleInfoEntity.getWsrPhotograph());
        workSignRecordRespVo.setSfaWorkSignPictureRespVos(this.sfaWorkSignPictureService.selectByRecordId(sfaWorkSignRecord.getId()));
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(workSignRuleInfoEntity.getSignMust())) {
            if (WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue().equals(workSignRuleInfoEntity.getSignOrNonType())) {
                workSignRecordRespVo.setExecuteAsWorkingDay(Boolean.valueOf(false));
                return workSignRecordRespVo;
            }
            workSignRecordRespVo.setExecuteAsWorkingDay(Boolean.valueOf(true));
            return workSignRecordRespVo;
        }
        boolean has = this.iSfaWorkOvertimeService.hasOvertime(workSignRuleInfoEntity);
        if (has && YesNoEnum.yesNoEnum.YES.getValue().equals(workSignRuleInfoEntity.getNonWorkingDaySignAstrict())) {
            workSignRecordRespVo.setExecuteAsWorkingDay(Boolean.valueOf(true));
            return workSignRecordRespVo;
        }
        workSignRecordRespVo.setExecuteAsWorkingDay(Boolean.valueOf(false));
        return workSignRecordRespVo;
    }

    @Override
    @Transactional(readOnly=true)
    public SfaWorkSignRuleInfoEntity loadRuleInfoForClock() {
        UserRedis userRedis = UserUtils.getUser();
        String username = userRedis.getUsername();
        String ruleDate = LocalDateTime.now().format(CrmDateUtils.yyyyMMdd);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaWorkSignRuleInfoEntity::getUserName, (Object)username)).eq(SfaWorkSignRuleInfoEntity::getRuleDate, (Object)ruleDate);
        SfaWorkSignRuleInfoEntity sfaWorkSignRuleInfo = (SfaWorkSignRuleInfoEntity)((Object)this.sfaWorkSignRuleInfoMapper.selectOne((Wrapper)wrapper));
        return sfaWorkSignRuleInfo;
    }

    @Override
    public SfaWorkSignRecordRespVo findSignRecordByNow(SfaWorkSignEnum.WorkSignType signType) {
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity) {
            throw new BusinessException("\u4eca\u65e5\u65e0\u9700\u7b7e\u5230");
        }
        List sfaWorkSignRecords = this.sfaWorkSignRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfoEntity.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)signType.getVal()));
        if (null == sfaWorkSignRecords || sfaWorkSignRecords.size() == 0 || sfaWorkSignRecords.get(0) == null) {
            throw new BusinessException("\u4eca\u65e5\u65e0\u9700\u7b7e\u5230");
        }
        SfaWorkSignRecordEntity sfaWorkSignRecord = workSignRuleInfoEntity.checkSignTime(signType.equals((Object)SfaWorkSignEnum.WorkSignType.CLOCK_IN), sfaWorkSignRecords);
        return this.buildSfaWorkSignRecordRespVo(workSignRuleInfoEntity, sfaWorkSignRecord);
    }

    @Override
    public SfaNoticeRespVo getAllNotice() {
        NeedClock needClock = this.sfaWorkSignRecordService.needWorkSign();
        Result<Long> result = this.sfaApprovalService.countApproving();
        SfaNoticeRespVo sfaNoticeRespVo = new SfaNoticeRespVo();
        return sfaNoticeRespVo.setNeedClock(needClock).setApproval((Long)result.getResult());
    }

    @Override
    public void saveBatchPartition(List<SfaWorkSignRuleInfoEntity> infoEntityList) {
        if (CollectionUtil.listEmpty(infoEntityList)) {
            return;
        }
        List partitionList = Lists.partition(infoEntityList, (int)50);
        for (List infoEntities : partitionList) {
            this.saveBatch(infoEntities);
        }
    }
}

