/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.base.utils.ProcessUtil;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderAsExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.moblie.controller.workbench.req.OrderWorkbenchDataReq;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecuteOrderProductReqVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEsData;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepOrderServiceImpl;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"orderVisitStepExecutorExpandImpl"})
public class OrderVisitStepExecutor<ExecuteReq extends OrderStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, OrderStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(OrderVisitStepExecutor.class);
    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
    @Resource
    private ISfaAsExecutionService sfaAsExecutionService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
    @Resource
    protected SfaVisitStepOrderServiceImpl sfaVisitStepOrderService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepOrderService;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_ORDER.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setOrderSourceName(SfaOrderSourceEnum.VISIT.getDesc());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), SfaVisitEnum.visitStep.VISIT_STEP_ORDER.getVal(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderWorkbenchDataReq dataReq = (OrderWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        dataReq.convert();
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        SfaVisitStepOrderEsData sfaVisitStepOrderEsData = null;
        if (StringUtils.isNotEmpty((String)dataReq.getId())) {
            Optional optionalVisitStepOrderEsData = this.sfaVisitStepOrderEsDataRepositories.findById(dataReq.getId());
            if (!optionalVisitStepOrderEsData.isPresent()) {
                throw new BusinessException("\u4fee\u6539\u5931\u8d25\u672a\u5728ES\u627e\u5230id\u5bf9\u5e94\u6570\u636e");
            }
            sfaVisitStepOrderEsData = (SfaVisitStepOrderEsData)optionalVisitStepOrderEsData.get();
            OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
            stepExecuteData.setOrderSource(sfaVisitStepOrderEsData.getOrderSource());
        }
        this.check(null, visitStepExecuteReq);
        this.checkForWorkbench(null, visitStepExecuteReq);
        if (null != sfaVisitStepOrderEsData) {
            this.updateOrderEsData(visitStepExecuteReq, sfaVisitStepOrderEsData);
            return;
        }
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(dataReq, redisData);
        redisData.setVisitPlanInfoId("WORKBENCH");
        this.doExecuteForWorkbench(redisData, visitStepExecuteReq, SfaOrderSourceEnum.WORKBENCH);
    }

    public void executeForAs(OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo> dataReq) {
        dataReq.convert();
        VisitStepExecuteReq<OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>> visitStepExecuteReq = new VisitStepExecuteReq<OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo>>();
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        visitStepExecuteReq.setFormId("FORM_ID_AS");
        visitStepExecuteReq.setStepExecuteData(dataReq);
        this.checkForAs(null, visitStepExecuteReq);
        Optional optionalVisitStepOrderEsData = this.sfaVisitStepOrderEsDataRepositories.findById(dataReq.getId());
        if (optionalVisitStepOrderEsData.isPresent()) {
            SfaVisitStepOrderEsData sfaVisitStepOrderEsData = (SfaVisitStepOrderEsData)optionalVisitStepOrderEsData.get();
            this.updateOrderEsData(visitStepExecuteReq, sfaVisitStepOrderEsData);
            return;
        }
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(dataReq.getId());
        redisData.setVisitPlanInfoId(dataReq.getVisitPlanInfoId());
        this.buildEntity(dataReq, redisData);
        this.doExecuteForWorkbench(redisData, visitStepExecuteReq, SfaOrderSourceEnum.SCHEME);
    }

    protected void doExecuteForWorkbench(SfaVisitStepOrderRedisData redisData, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaOrderSourceEnum orderSourceEnum) {
        redisData.setOrderSource(orderSourceEnum.getCode());
        redisData.setOrderSourceName(orderSourceEnum.getDesc());
        ClientReq dataReq = (ClientReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepOrderRedisData[]{redisData}), fromRespVo);
        SfaAchievementAccomplishRecordReqVo reqVo = (SfaAchievementAccomplishRecordReqVo)CrmBeanUtil.copy((Object)dataReq, SfaAchievementAccomplishRecordReqVo.class);
        reqVo.setRelationId(redisData.getId()).setIndexCode(SfaVisitEnum.indexType.XD.getCode()).setCustomerCode(dataReq.getClientCode());
        AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo, UserUtils.getUser());
    }

    public void updateOrderApprovalStatus(ActivitiCallBackVo activitiCallBackVo) {
        String processState2 = activitiCallBackVo.getProcessState().toString();
        Optional repositoriesById = this.sfaVisitStepOrderEsDataRepositories.findById(activitiCallBackVo.getFormNo());
        SfaVisitStepOrderEsData sfaVisitStepOrderEsData = (SfaVisitStepOrderEsData)repositoriesById.get();
        if (ActivitiEnum.processState.PASS.getVal().equals(processState2)) {
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
            SfaAchievementAccomplishRecordReqVo reqVo = (SfaAchievementAccomplishRecordReqVo)CrmBeanUtil.copy((Object)sfaVisitStepOrderEsData, SfaAchievementAccomplishRecordReqVo.class);
            reqVo.setCustomerCode(sfaVisitStepOrderEsData.getClientCode()).setRelationId(reqVo.getId()).setIndexCode(SfaVisitEnum.indexType.XD.getCode());
            AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo, UserUtils.getUser());
            if (SfaOrderSourceEnum.SCHEME.getCode().equals(sfaVisitStepOrderEsData.getOrderSource())) {
                OrderAsExecuteDataResp orderAsExecuteDataResp = new OrderAsExecuteDataResp();
                orderAsExecuteDataResp.setSfaVisitStepOrderItems(sfaVisitStepOrderEsData.getSfaVisitStepOrderItems());
                orderAsExecuteDataResp.convert();
                SfaAsExecuteOrderProductReqVo sfaAsExecuteOrderProductReqVo = new SfaAsExecuteOrderProductReqVo();
                sfaAsExecuteOrderProductReqVo.setExecuteId(sfaVisitStepOrderEsData.getId());
                sfaAsExecuteOrderProductReqVo.setSfaActSchemeSetmealRespVos(orderAsExecuteDataResp.getSfaActSchemeSetmealRespVos());
                this.sfaAsExecutionService.updateExecutionProduct(sfaAsExecuteOrderProductReqVo);
            }
        }
        if (ActivitiEnum.processState.REJECT.getVal().equals(processState2)) {
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.REJECT.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.REJECT.getDesc());
        }
        if (ActivitiEnum.processState.ROLLBACK.getVal().equals(processState2)) {
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getDesc());
        }
        this.sfaVisitStepOrderEsDataRepositories.save(sfaVisitStepOrderEsData);
    }

    private void updateOrderEsData(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaVisitStepOrderEsData sfaVisitStepOrderEsData) {
        OrderStepExecuteData orderStepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        CrmBeanUtil.copyProperties((Object)orderStepExecuteData, (Object)sfaVisitStepOrderEsData);
        sfaVisitStepOrderEsData.setSfaVisitStepOrderItems(orderStepExecuteData.getSfaVisitStepOrderItems());
        sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.APPROVAL.getValue());
        sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.APPROVAL.getDesc());
        sfaVisitStepOrderEsData.setProcessNo(ProcessUtil.startProcess(sfaVisitStepOrderEsData.getId(), ActivitiEnum.FormTypeEnum.ORDER));
        this.sfaAchievementAccomplishRecordService.delete(sfaVisitStepOrderEsData.getId());
        this.sfaVisitStepOrderEsDataRepositories.save(sfaVisitStepOrderEsData);
    }

    protected SfaVisitStepOrderRedisData buildRedisData(VisitStepExecuteReq<? extends OrderStepExecuteData> visitStepExecuteReq) {
        OrderStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)CrmBeanUtil.copy((Object)executeData, SfaVisitStepOrderRedisData.class));
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        List<OrderAsDataReq.OrderItemAsReqVo> itemAsReqVos = executeData.getSfaVisitStepOrderItems();
        redisData.setSfaVisitStepOrderItems(itemAsReqVos);
        redisData.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setOrderDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setOrderYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setOrderYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        redisData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
        redisData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
        redisData.setCustomerCode(executeData.getCustomerCode());
        redisData.setCustomerName(executeData.getCustomerName());
        redisData.setAddress(executeData.getAddress());
        redisData.setContacts(executeData.getContacts());
        redisData.setTelephone(executeData.getTelephone());
        redisData.setExpectReceive(executeData.getExpectReceive());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)executeData.getRemarks())) {
            redisData.setRemarks(executeData.getRemarks());
        }
        BigDecimal price = BigDecimal.ZERO;
        for (OrderAsDataReq.OrderItemAsReqVo itemAsReqVo : itemAsReqVos) {
            if (null == itemAsReqVo.getPrice()) continue;
            price = price.add(itemAsReqVo.getPrice());
        }
        redisData.setTotalPrice(price);
        return redisData;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepOrderRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void checkHead(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getId())) {
            super.check(visitStepExecuteReq);
        }
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (!SfaOrderSourceEnum.SCHEME.getCode().equals(stepExecuteData.getOrderSource()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getAddress())) {
            throw new BusinessException("\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getContacts())) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getTelephone())) {
            throw new BusinessException("\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        this.checkHead(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        List sfaVisitStepOrderItems = stepExecuteData.getSfaVisitStepOrderItems();
        if (CollectionUtils.isEmpty(sfaVisitStepOrderItems)) {
            throw new BusinessException("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItemTemp = null;
        for (OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getProductCode())) {
                throw new BusinessException("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getProductName())) {
                throw new BusinessException("\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getSeriesCode())) {
                throw new BusinessException("\u5546\u54c1\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getSeriesName())) {
                throw new BusinessException("\u5546\u54c1\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            }
            if (!SfaOrderSourceEnum.SCHEME.getCode().equals(stepExecuteData.getOrderSource())) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getUnit())) {
                    throw new BusinessException("\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getUnitName())) {
                    throw new BusinessException("\u5546\u54c1\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a");
                }
            }
            if (null == sfaVisitStepOrderItem.getQuantity()) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
            if (null == sfaVisitStepOrderItem.getPrice()) {
                throw new BusinessException("\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a");
            }
            sfaVisitStepOrderItemTemp = sfaVisitStepOrderItem;
        }
        if (sfaVisitStepOrderItemTemp instanceof OrderStepExecuteData.OrderItemReqVo) {
            List orderItemAsReqVos = CrmBeanUtil.copyList(sfaVisitStepOrderItems, OrderAsDataReq.OrderItemAsReqVo.class);
            stepExecuteData.setSfaVisitStepOrderItems(orderItemAsReqVos);
        }
    }

    protected void checkForWorkbench(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderWorkbenchDataReq stepExecuteData = (OrderWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getClientCode())) {
            throw new BusinessException("\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getClientName())) {
            throw new BusinessException("\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getClientType())) {
            throw new BusinessException("\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        }
    }

    protected void checkForAs(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = (OrderStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        List sfaVisitStepOrderItems = stepExecuteData.getSfaVisitStepOrderItems();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)stepExecuteData.getId())) {
            throw new BusinessException("\u8ba2\u5355id\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(sfaVisitStepOrderItems)) {
            throw new BusinessException("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        for (OrderAsDataReq.OrderItemAsReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getItmeType())) {
                throw new BusinessException("\u8ba2\u5355\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sfaVisitStepOrderItem.getSetmealId())) continue;
            throw new BusinessException("\u8ba2\u5355\u5546\u54c1\u65b9\u6848\u5957\u9910id\u4e3a\u7a7a");
        }
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepOrderEsData esData = this.sfaVisitStepOrderEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepOrderEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected OrderStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepOrderEsData redisData = (SfaVisitStepOrderEsData)this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return this.buildDataResp(redisData);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            OrderStepExecuteDataResp dataResp = new OrderStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        SfaVisitStepOrderEsData esData = (SfaVisitStepOrderEsData)this.getEsDataById(bizId);
        return this.buildDataResp(esData);
    }

    private OrderStepExecuteDataResp buildDataResp(SfaVisitStepOrderEsData esData) {
        OrderStepExecuteDataResp dataResp;
        if (null == esData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        if (SfaOrderSourceEnum.SCHEME.getCode().equals(esData.getOrderSource())) {
            dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)esData, OrderAsExecuteDataResp.class);
            dataResp.setSfaVisitStepOrderItems(CrmBeanUtil.copyList(esData.getSfaVisitStepOrderItems(), OrderAsDataReq.OrderItemAsReqVo.class));
        } else {
            dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)esData, OrderStepExecuteDataResp.class);
            dataResp.setSfaVisitStepOrderItems(esData.getSfaVisitStepOrderItems());
        }
        dataResp.convert();
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        List itemReqVos = dataResp.getSfaVisitStepOrderItems();
        BigDecimal totalPrice = BigDecimal.ZERO;
        totalPrice.setScale(2, 0);
        for (OrderStepExecuteData.OrderItemReqVo itemReqVo : itemReqVos) {
            BigDecimal temp = itemReqVo.getPrice();
            if (null == temp) continue;
            totalPrice = totalPrice.add(temp);
        }
        dataResp.setTotalPrice(totalPrice);
        return dataResp;
    }

    @Override
    protected OrderStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepOrderRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
        }
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), OrderStepExecuteDataResp.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    protected List<? extends CrmBaseEntity> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepOrderRedisData[]{redisData});
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), executorLoadReq.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepOrderRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepOrderEsData oldData;
        SfaVisitStepOrderEsData dataResp = (SfaVisitStepOrderEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepOrderEsData.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = (SfaVisitStepOrderEsData)this.getEsDataByVisitPlanInfo(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
            dataResp.setOrderCode(oldData.getOrderCode());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dataResp.getOrderCode())) {
            redisData.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        }
        this.sfaVisitStepOrderEsDataRepositories.save(dataResp);
    }
}

