/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.visitstep.req.VisitStepPageReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

@ApiModel(value="\u6d3b\u52a8\u62a5\u8868\u5206\u9875-\u53c2\u6570")
public class GetCompleteActivityTablePageReq
extends VisitStepPageReq {
    @ApiModelProperty(value="\u6d3b\u52a8\u7f16\u7801")
    private String activityCode;
    @ApiModelProperty(value="\u6d3b\u52a8\u540d\u79f0")
    private String activityName;
    @ApiModelProperty(value="\u5ba2\u6237\u7f16\u7801")
    private String clientCode;
    @ApiModelProperty(value="\u5ba2\u6237\u540d\u79f0")
    private String clientName;
    @ApiModelProperty(value="\u6d3b\u52a8\u6267\u884c\u65f6\u95f4")
    private String startActivityTime;
    @ApiModelProperty(value="\u6d3b\u52a8\u6267\u884c\u65f6\u95f4")
    private String endActivityTime;

    public NativeSearchQuery buildQuery() {
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        if (StringUtils.isBlank((CharSequence)this.getStepCode())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u6b65\u9aa4\u7f16\u7801");
        }
        builder.must((QueryBuilder)QueryBuilders.termQuery((String)"stepCode", (String)this.getStepCode()));
        if (StringUtils.isNotBlank((CharSequence)this.getActivityCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"activityCode", (String)this.getActivityCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getActivityName())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"activityName", (String)this.getActivityName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getClientCode())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientCode", (String)this.getClientCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getClientName())) {
            builder.must((QueryBuilder)QueryBuilders.termQuery((String)"clientName", (String)this.getClientName()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getStartActivityTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityTime").from((Object)this.getStartActivityTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEndActivityTime())) {
            builder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"activityTime").to((Object)this.getEndActivityTime()));
        }
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        nativeSearchQueryBuilder.withQuery((QueryBuilder)builder);
        nativeSearchQueryBuilder.withPageable((Pageable)PageRequest.of((int)(this.getPageNum() - 1), (int)this.getPageSize()));
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort((String)"activityTime").order(SortOrder.DESC));
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getStartActivityTime() {
        return this.startActivityTime;
    }

    public String getEndActivityTime() {
        return this.endActivityTime;
    }

    public void setActivityCode(String activityCode2) {
        this.activityCode = activityCode2;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setStartActivityTime(String startActivityTime) {
        this.startActivityTime = startActivityTime;
    }

    public void setEndActivityTime(String endActivityTime) {
        this.endActivityTime = endActivityTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCompleteActivityTablePageReq)) {
            return false;
        }
        GetCompleteActivityTablePageReq other = (GetCompleteActivityTablePageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$activityCode = this.getActivityCode();
        String other$activityCode = other.getActivityCode();
        if (this$activityCode == null ? other$activityCode != null : !this$activityCode.equals(other$activityCode)) {
            return false;
        }
        String this$activityName = this.getActivityName();
        String other$activityName = other.getActivityName();
        if (this$activityName == null ? other$activityName != null : !this$activityName.equals(other$activityName)) {
            return false;
        }
        String this$clientCode = this.getClientCode();
        String other$clientCode = other.getClientCode();
        if (this$clientCode == null ? other$clientCode != null : !this$clientCode.equals(other$clientCode)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$startActivityTime = this.getStartActivityTime();
        String other$startActivityTime = other.getStartActivityTime();
        if (this$startActivityTime == null ? other$startActivityTime != null : !this$startActivityTime.equals(other$startActivityTime)) {
            return false;
        }
        String this$endActivityTime = this.getEndActivityTime();
        String other$endActivityTime = other.getEndActivityTime();
        return !(this$endActivityTime == null ? other$endActivityTime != null : !this$endActivityTime.equals(other$endActivityTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetCompleteActivityTablePageReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $activityCode = this.getActivityCode();
        result = result * 59 + ($activityCode == null ? 43 : $activityCode.hashCode());
        String $activityName = this.getActivityName();
        result = result * 59 + ($activityName == null ? 43 : $activityName.hashCode());
        String $clientCode = this.getClientCode();
        result = result * 59 + ($clientCode == null ? 43 : $clientCode.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $startActivityTime = this.getStartActivityTime();
        result = result * 59 + ($startActivityTime == null ? 43 : $startActivityTime.hashCode());
        String $endActivityTime = this.getEndActivityTime();
        result = result * 59 + ($endActivityTime == null ? 43 : $endActivityTime.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetCompleteActivityTablePageReq(activityCode=" + this.getActivityCode() + ", activityName=" + this.getActivityName() + ", clientCode=" + this.getClientCode() + ", clientName=" + this.getClientName() + ", startActivityTime=" + this.getStartActivityTime() + ", endActivityTime=" + this.getEndActivityTime() + ")";
    }
}

