/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.integral.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.integral.mapper.SfaIntegralRuleMapper;
import com.biz.crm.integral.model.SfaIntegralRangeEntity;
import com.biz.crm.integral.model.SfaIntegralRuleEntity;
import com.biz.crm.integral.model.SfaIntegralTaskEntity;
import com.biz.crm.integral.service.SfaIntegralRangeService;
import com.biz.crm.integral.service.SfaIntegralRuleService;
import com.biz.crm.integral.service.SfaIntegralTaskService;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRuleReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRangeRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRulePageRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRuleRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralTaskRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaIntegralRuleServiceExpandImpl"})
public class SfaIntegralRuleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaIntegralRuleMapper, SfaIntegralRuleEntity>
implements SfaIntegralRuleService {
    private static final Logger log = LoggerFactory.getLogger(SfaIntegralRuleServiceImpl.class);
    @Autowired
    SfaIntegralRangeService sfaIntegralRangeService;
    @Autowired
    SfaIntegralTaskService sfaIntegralTaskService;
    @Autowired
    SfaIntegralRuleMapper sfaIntegralRuleMapper;
    @Autowired
    MdmPositionFeign mdmPositionFeign;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveIntegralRule(SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        this.checkRuleVo(sfaIntegralRuleReqVo);
        if (StringUtils.isNotEmpty((String)sfaIntegralRuleReqVo.getId())) {
            throw new BusinessException("\u65b0\u589e\u65f6\u79ef\u5206\u89c4\u5219id\u5fc5\u987b\u4e3a\u7a7a");
        }
        List sfaIntegralRangeEntities = CrmBeanUtil.copyList((List)sfaIntegralRuleReqVo.getPosLevel(), SfaIntegralRangeEntity.class);
        List sfaIntegralRangeEntitiesOrg = CrmBeanUtil.copyList((List)sfaIntegralRuleReqVo.getOrgs(), SfaIntegralRangeEntity.class);
        sfaIntegralRangeEntities.stream().forEach(data -> data.setType(IntegralEnum.ruleType.POS_LEVEL.getValue()));
        sfaIntegralRangeEntitiesOrg.stream().forEach(data -> data.setType(IntegralEnum.ruleType.ORG.getValue()));
        this.checkOrgAndRole(sfaIntegralRangeEntitiesOrg, sfaIntegralRangeEntities, sfaIntegralRuleReqVo.getId());
        sfaIntegralRangeEntities.addAll(sfaIntegralRangeEntitiesOrg);
        SfaIntegralRuleEntity sfaIntegralRuleEntity = (SfaIntegralRuleEntity)((Object)CrmBeanUtil.copy((Object)sfaIntegralRuleReqVo, SfaIntegralRuleEntity.class));
        sfaIntegralRuleEntity.setIntegralRuleCode(CodeUtil.generateCode((String)IntegralEnum.ruleCode.INTEGRAL_RULE_CODE.getValue()));
        List sfaIntegralTaskEntities = CrmBeanUtil.copyList((List)sfaIntegralRuleReqVo.getTasks(), SfaIntegralTaskEntity.class);
        this.save((Object)sfaIntegralRuleEntity);
        sfaIntegralRangeEntities.stream().forEach(data -> data.setIntegralRuleId(sfaIntegralRuleEntity.getId()));
        sfaIntegralTaskEntities.stream().forEach(data -> data.setIntegralRuleId(sfaIntegralRuleEntity.getId()));
        this.sfaIntegralRangeService.saveBatch(sfaIntegralRangeEntities);
        this.sfaIntegralTaskService.saveBatch(sfaIntegralTaskEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteIntegralRule(String id) {
        this.sfaIntegralTaskService.remove((Wrapper)Wrappers.lambdaQuery(SfaIntegralTaskEntity.class).eq(SfaIntegralTaskEntity::getIntegralRuleId, (Object)id));
        this.sfaIntegralRangeService.remove((Wrapper)Wrappers.lambdaQuery(SfaIntegralRangeEntity.class).eq(SfaIntegralRangeEntity::getIntegralRuleId, (Object)id));
        this.removeById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateIntegralRule(SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        this.checkRuleVo(sfaIntegralRuleReqVo);
        if (StringUtils.isEmpty((String)sfaIntegralRuleReqVo.getId())) {
            throw new BusinessException("\u79ef\u5206\u89c4\u5219id\u4e3a\u7a7a");
        }
        List sfaIntegralRangeEntities = CrmBeanUtil.copyList((List)sfaIntegralRuleReqVo.getPosLevel(), SfaIntegralRangeEntity.class);
        List sfaIntegralRangeEntitiesOrg = CrmBeanUtil.copyList((List)sfaIntegralRuleReqVo.getOrgs(), SfaIntegralRangeEntity.class);
        sfaIntegralRangeEntities.stream().forEach(data -> data.setType(IntegralEnum.ruleType.POS_LEVEL.getValue()));
        sfaIntegralRangeEntitiesOrg.stream().forEach(data -> data.setType(IntegralEnum.ruleType.ORG.getValue()));
        this.checkOrgAndRole(sfaIntegralRangeEntitiesOrg, sfaIntegralRangeEntities, sfaIntegralRuleReqVo.getId());
        sfaIntegralRangeEntities.addAll(sfaIntegralRangeEntitiesOrg);
        SfaIntegralRuleEntity sfaIntegralRuleEntity = (SfaIntegralRuleEntity)((Object)CrmBeanUtil.copy((Object)sfaIntegralRuleReqVo, SfaIntegralRuleEntity.class));
        List sfaIntegralTaskEntities = CrmBeanUtil.copyList((List)sfaIntegralRuleReqVo.getTasks(), SfaIntegralTaskEntity.class);
        sfaIntegralRangeEntities.stream().forEach(data -> data.setIntegralRuleId(sfaIntegralRuleReqVo.getId()));
        sfaIntegralTaskEntities.stream().forEach(data -> data.setIntegralRuleId(sfaIntegralRuleReqVo.getId()));
        this.updateById((Object)sfaIntegralRuleEntity);
        this.sfaIntegralRangeService.remove((Wrapper)Wrappers.lambdaQuery(SfaIntegralRangeEntity.class).eq(SfaIntegralRangeEntity::getIntegralRuleId, (Object)sfaIntegralRuleReqVo.getId()));
        this.sfaIntegralTaskService.remove((Wrapper)Wrappers.lambdaQuery(SfaIntegralTaskEntity.class).eq(SfaIntegralTaskEntity::getIntegralRuleId, (Object)sfaIntegralRuleReqVo.getId()));
        this.sfaIntegralRangeService.saveBatch(sfaIntegralRangeEntities);
        this.sfaIntegralTaskService.saveBatch(sfaIntegralTaskEntities);
    }

    @Override
    public SfaIntegralRuleRespVo queryById(String id) {
        List sfaIntegralRangeEntities = this.sfaIntegralRangeService.list((Wrapper)Wrappers.lambdaQuery(SfaIntegralRangeEntity.class).eq(SfaIntegralRangeEntity::getIntegralRuleId, (Object)id));
        List sfaIntegralTaskEntities = this.sfaIntegralTaskService.list((Wrapper)Wrappers.lambdaQuery(SfaIntegralTaskEntity.class).eq(SfaIntegralTaskEntity::getIntegralRuleId, (Object)id));
        SfaIntegralRuleEntity sfaIntegralRuleEntity = (SfaIntegralRuleEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaIntegralRuleEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        SfaIntegralRuleRespVo ruleRespVo = this.getRuleRespVo(sfaIntegralRangeEntities, sfaIntegralTaskEntities, sfaIntegralRuleEntity);
        return ruleRespVo;
    }

    @Override
    public PageResult<SfaIntegralRulePageRespVo> pageIntegralRule(SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        Page page = new Page((long)sfaIntegralRuleReqVo.getPageNum().intValue(), (long)sfaIntegralRuleReqVo.getPageSize().intValue());
        List<SfaIntegralRulePageRespVo> pageRule = this.sfaIntegralRuleMapper.pageRule(page, sfaIntegralRuleReqVo);
        pageRule.stream().forEach(data -> data.setEnableStatusName(CrmEnableStatusEnum.ENABLE.getDes()));
        return PageResult.builder().data(pageRule).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> ids) {
        this.sfaIntegralTaskService.remove((Wrapper)Wrappers.lambdaQuery(SfaIntegralTaskEntity.class).in(SfaIntegralTaskEntity::getIntegralRuleId, ids));
        this.sfaIntegralRangeService.remove((Wrapper)Wrappers.lambdaQuery(SfaIntegralRangeEntity.class).in(SfaIntegralRangeEntity::getIntegralRuleId, ids));
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableByIds(List<String> ids) {
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SfaIntegralRuleEntity.class).in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableByIds(List<String> ids) {
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SfaIntegralRuleEntity.class).in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode()));
    }

    @Override
    public SfaIntegralRuleRespVo getTaskByLoginUser() {
        UserRedis user = UserUtils.getUser();
        Result detail = this.mdmPositionFeign.detail(null, user.getPoscode());
        String positionLevelCode = ((MdmPositionRespVo)detail.getResult()).getPositionLevelCode();
        String orgcode = user.getOrgcode();
        List sfaIntegralRangeEntities = this.sfaIntegralRangeService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaIntegralRangeEntity.class).eq(SfaIntegralRangeEntity::getCode, (Object)positionLevelCode)).or()).eq(SfaIntegralRangeEntity::getCode, (Object)orgcode));
        if (sfaIntegralRangeEntities.size() == 0 || sfaIntegralRangeEntities.size() > 2) {
            return new SfaIntegralRuleRespVo().setTasks(new ArrayList());
        }
        String integralRuleId = ((SfaIntegralRangeEntity)((Object)sfaIntegralRangeEntities.get(0))).getIntegralRuleId();
        return this.queryById(integralRuleId);
    }

    private void checkOrgAndRole(List<SfaIntegralRangeEntity> sfaIntegralOrgRanges, List<SfaIntegralRangeEntity> sfaIntegralPosRanges, String id) {
        List rangeEntities;
        sfaIntegralOrgRanges.addAll(sfaIntegralPosRanges);
        List IntegralRangeCodes = sfaIntegralOrgRanges.stream().map(SfaIntegralRangeEntity::getCode).collect(Collectors.toList());
        LambdaQueryWrapper QueryWrapper = Wrappers.lambdaQuery(SfaIntegralRangeEntity.class);
        if (StringUtils.isNotEmpty((String)id)) {
            QueryWrapper.ne(SfaIntegralRangeEntity::getIntegralRuleId, (Object)id);
        }
        if (CollectionUtil.listEmpty((List)(rangeEntities = this.sfaIntegralRangeService.list((Wrapper)QueryWrapper.in(SfaIntegralRangeEntity::getCode, IntegralRangeCodes))))) {
            return;
        }
        List orgRuleId = rangeEntities.stream().filter(data -> data.getType().equals(IntegralEnum.ruleType.ORG.getValue())).map(SfaIntegralRangeEntity::getIntegralRuleId).collect(Collectors.toList());
        List posRuleId = rangeEntities.stream().filter(data -> data.getType().equals(IntegralEnum.ruleType.POS_LEVEL.getValue())).map(SfaIntegralRangeEntity::getIntegralRuleId).collect(Collectors.toList());
        List ruleId = orgRuleId.stream().filter(data -> posRuleId.contains(data)).collect(Collectors.toList());
        if (CollectionUtil.listNotEmpty(ruleId)) {
            List ruleEntities = this.list((Wrapper)Wrappers.lambdaQuery(SfaIntegralRuleEntity.class).in(BaseIdEntity::getId, ruleId));
            StringJoiner sj = new StringJoiner("\u3001");
            ruleEntities.forEach(data -> sj.add(data.getIntegralRuleName()));
            throw new BusinessException("\u4e0e\u5176\u4ed6\u79ef\u5206\u89c4\u5219\u91cd\u590d\uff1a" + sj.toString());
        }
    }

    private void checkRuleVo(SfaIntegralRuleReqVo sfaIntegralRuleReqVo) {
        if (StringUtils.isEmpty((String)sfaIntegralRuleReqVo.getIntegralRuleName())) {
            throw new BusinessException("\u89c4\u5219\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)sfaIntegralRuleReqVo.getStartTime()) || StringUtils.isEmpty((String)sfaIntegralRuleReqVo.getEndTime())) {
            throw new BusinessException("\u6709\u6548\u671f\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtil.listEmpty((List)sfaIntegralRuleReqVo.getPosLevel())) {
            throw new BusinessException("\u804c\u4f4d\u5217\u8868\u4e3a\u7a7a");
        }
        if (CollectionUtil.listEmpty((List)sfaIntegralRuleReqVo.getOrgs())) {
            throw new BusinessException("\u7ec4\u7ec7\u5217\u8868\u4e3a\u7a7a");
        }
    }

    private SfaIntegralRuleRespVo getRuleRespVo(List<SfaIntegralRangeEntity> sfaIntegralRangeEntities, List<SfaIntegralTaskEntity> sfaIntegralTaskEntities, SfaIntegralRuleEntity sfaIntegralRuleEntity) {
        List sfaIntegralRangeRespVos = CrmBeanUtil.copyList(sfaIntegralRangeEntities, SfaIntegralRangeRespVo.class);
        List sfaIntegralTaskRespVos = CrmBeanUtil.copyList(sfaIntegralTaskEntities, SfaIntegralTaskRespVo.class);
        List orgVo = sfaIntegralRangeRespVos.stream().filter(data -> IntegralEnum.ruleType.ORG.getValue().equals(data.getType())).collect(Collectors.toList());
        List posVo = sfaIntegralRangeRespVos.stream().filter(data -> IntegralEnum.ruleType.POS_LEVEL.getValue().equals(data.getType())).collect(Collectors.toList());
        SfaIntegralRuleRespVo sfaIntegralRuleRespVo = (SfaIntegralRuleRespVo)CrmBeanUtil.copy((Object)((Object)sfaIntegralRuleEntity), SfaIntegralRuleRespVo.class);
        sfaIntegralRuleRespVo.setOrgs(orgVo);
        sfaIntegralRuleRespVo.setPos(posVo);
        sfaIntegralRuleRespVo.setTasks(sfaIntegralTaskRespVos);
        return sfaIntegralRuleRespVo;
    }
}

