/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.StoreCheckWorkbenchDataReq;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEsData;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepStoreCheckServiceImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"storeCheckVisitStepExecutorExpandImpl"})
public class StoreCheckVisitStepExecutor<ExecuteReq extends StoreCheckStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, StoreCheckStepExecuteDataResp, ExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(StoreCheckVisitStepExecutor.class);
    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;
    @Resource
    private SfaVisitStepStoreCheckServiceImpl sfaVisitStepStoreCheckService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return this.sfaVisitStepStoreCheckService;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_STORE_CHECK.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
    }

    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        StoreCheckWorkbenchDataReq dataReq = (StoreCheckWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setVisitPlanInfoId("WORKBENCH");
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList((Object[])new SfaVisitStepStoreCheckRedisData[]{redisData}), fromRespVo);
    }

    protected SfaVisitStepStoreCheckRedisData buildRedisData(VisitStepExecuteReq<? extends StoreCheckStepExecuteData> visitStepExecuteReq) {
        StoreCheckStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)CrmBeanUtil.copy((Object)executeData, SfaVisitStepStoreCheckRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRegularShelfDisplayList(executeData.getRegularShelfDisplayList());
        redisData.setMaterialDisplayList(executeData.getMaterialDisplayList());
        redisData.setPriceList(executeData.getPriceList());
        return redisData;
    }

    @Override
    protected StoreCheckStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepStoreCheckRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setRegularShelfDisplayList(list);
                    this.setMaterialDisplayList(list);
                    this.setPriceList(list);
                }
            };
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        SfaVisitStepStoreCheckEsData esData = this.sfaVisitStepStoreCheckEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepStoreCheckEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    protected StoreCheckStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank((CharSequence)visitPlanInfoId)) {
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            SfaVisitStepStoreCheckEsData redisData = (SfaVisitStepStoreCheckEsData)this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return this.buildDataResp(redisData);
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            StoreCheckStepExecuteDataResp dataResp = new StoreCheckStepExecuteDataResp(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setRegularShelfDisplayList(list);
                    this.setMaterialDisplayList(list);
                    this.setPriceList(list);
                }
            };
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        SfaVisitStepStoreCheckEsData redisData = (SfaVisitStepStoreCheckEsData)this.getEsDataById(bizId);
        return this.buildDataResp(redisData);
    }

    private StoreCheckStepExecuteDataResp buildDataResp(SfaVisitStepStoreCheckEsData redisData) {
        if (null == redisData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepStoreCheckRedisData storeCheckRedisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)storeCheckRedisData);
        StringJoiner checkType = new StringJoiner(",");
        StringJoiner checkTypeDesc = new StringJoiner(",");
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getRegularShelfDisplayList())) {
            checkType.add(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getMaterialDisplayList())) {
            checkType.add(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getPriceList())) {
            checkType.add(SfaVisitEnum.checkStoreType.PRICE.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.PRICE.getDesc());
        }
        storeCheckRedisData.setCheckType(checkType.toString());
        storeCheckRedisData.setCheckTypeDesc(checkTypeDesc.toString());
        storeCheckRedisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        storeCheckRedisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        storeCheckRedisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        storeCheckRedisData.setCheckTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        storeCheckRedisData.setCheckDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        storeCheckRedisData.setCheckYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        storeCheckRedisData.setCheckYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        UserRedis userRedis = UserUtils.getUser();
        storeCheckRedisData.setUserName(userRedis.getUsername());
        storeCheckRedisData.setRealName(userRedis.getUsername());
        storeCheckRedisData.setPosCode(userRedis.getPoscode());
        storeCheckRedisData.setPosName(userRedis.getPosname());
        storeCheckRedisData.setOrgCode(userRedis.getOrgcode());
        storeCheckRedisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = (StoreCheckStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == storeCheckStepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getCheckAddress())) {
            throw new BusinessException("\u5b9a\u4f4d\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getLongitude())) {
            throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getLatitude())) {
            throw new BusinessException("\u7eac\u5ea6\u4e3a\u7a7a");
        }
        this.checkPics(storeCheckStepExecuteData.getRegularShelfDisplayList(), 1, 5, "\u5e38\u89c4\u8d27\u67b6\u9648\u5217");
        this.checkPics(storeCheckStepExecuteData.getMaterialDisplayList(), 1, 5, "\u7269\u6599\u9648\u5217\u4e3a\u7a7a");
        this.checkPics(storeCheckStepExecuteData.getPriceList(), 1, 5, "\u4ef7\u683c\u7b7e\u4e3a\u7a7a");
    }

    @Override
    protected List<? extends CrmBaseEntity> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), (Object)loadParam.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)loadParam)));
            return null;
        }
        return Lists.newArrayList((Object[])new SfaVisitStepStoreCheckRedisData[]{redisData});
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), executorLoadReq.getStepCode()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        this.doTransToEs(redisData, fromRespVo);
    }

    protected void doTransToEs(SfaVisitStepStoreCheckRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepStoreCheckEsData oldData;
        SfaVisitStepStoreCheckEsData dataResp = (SfaVisitStepStoreCheckEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepStoreCheckEsData.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = (SfaVisitStepStoreCheckEsData)this.getEsDataByVisitPlanInfo(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepStoreCheckEsDataRepositories.save(dataResp);
    }
}

