/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class SfaAttachmentUtil {
    private static ISfaAttachmentService sfaAttachmentService = (ISfaAttachmentService)SpringApplicationContextUtil.getApplicationContext().getBean(ISfaAttachmentService.class);

    private SfaAttachmentUtil() {
    }

    public static List<SfaAttachmentEntity> build(List<CrmAttachment> attachments, AttachmentBizTypeEnum bizType, String bizId) {
        if (null == bizType) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        return SfaAttachmentUtil.build(attachments, bizType.getVal(), bizId);
    }

    public static List<SfaAttachmentEntity> build(List<CrmAttachment> attachments, String bizType, String bizId) {
        if (CollectionUtils.isEmpty(attachments)) {
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((CharSequence)bizType)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        List<SfaAttachmentEntity> entities = attachments.stream().map(v -> {
            SfaAttachmentEntity entity = (SfaAttachmentEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaAttachmentEntity.class)));
            entity.setAttachmentBizType(bizType);
            entity.setAttachmentBizTypeName((String)AttachmentBizTypeEnum.GETMAP.get(bizType));
            entity.setFullUrl(entity.getUrlPathPrefix() + entity.getUrlPath());
            entity.setBizId(bizId);
            return entity;
        }).collect(Collectors.toList());
        return entities;
    }

    public static List<SfaAttachmentEntity> insert(List<CrmAttachment> attachments, AttachmentBizTypeEnum bizType, String bizId) {
        List<SfaAttachmentEntity> entities = SfaAttachmentUtil.build(attachments, bizType, bizId);
        return SfaAttachmentUtil.insert(entities);
    }

    public static List<SfaAttachmentEntity> insert(List<CrmAttachment> attachments, String bizType, String bizId) {
        List<SfaAttachmentEntity> entities = SfaAttachmentUtil.build(attachments, bizType, bizId);
        return SfaAttachmentUtil.insert(entities);
    }

    public static List<SfaAttachmentEntity> insert(List<SfaAttachmentEntity> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return Lists.newArrayList();
        }
        sfaAttachmentService.saveBatch(attachments, 50);
        return attachments;
    }

    public static void del(AttachmentBizTypeEnum bizType, String bizId) {
        if (null == bizType) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        sfaAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType.getVal()));
    }

    public static void del(String bizType, String bizId) {
        if (StringUtils.isBlank((CharSequence)bizType)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        sfaAttachmentService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType));
    }

    public static void delByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        sfaAttachmentService.removeByIds(ids);
    }

    public static List<SfaAttachmentEntity> getList(AttachmentBizTypeEnum bizType, String bizId) {
        if (null == bizType) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        return sfaAttachmentService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType.getVal()));
    }

    public static List<SfaAttachmentEntity> getList(String bizType, String bizId) {
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1\u7c7b\u578b");
        }
        if (StringUtils.isBlank((CharSequence)bizId)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9644\u4ef6\u4e1a\u52a1ID");
        }
        return sfaAttachmentService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaAttachmentEntity.class).eq(SfaAttachmentEntity::getBizId, (Object)bizId)).eq(SfaAttachmentEntity::getAttachmentBizType, (Object)bizType));
    }
}

