/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.achievement.controller;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.UserRedis;
import java.util.List;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AchievementRecordsMQSend {
    private static final Logger log = LoggerFactory.getLogger(AchievementRecordsMQSend.class);
    private static RocketMQProducer rocketMQProducer = (RocketMQProducer)SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    public static void saveAchievementRecordsMQ(SfaAchievementAccomplishRecordReqVo req, UserRedis user) {
        List orgList;
        String createOrgCodeList = "";
        if (StringUtils.isNotEmpty((CharSequence)user.getOrgcode()) && CollectionUtil.listNotEmpty((List)(orgList = OrgUtil.getParentOrgListIncludeSelf((String)user.getOrgcode())))) {
            createOrgCodeList = orgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.joining(","));
        }
        req.setCreateOrgCodeList(createOrgCodeList);
        if (StringUtil.isNotEmpty((String)req.getUpdateDate())) {
            req.setCreateTime(req.getCreateDate() + " " + req.getCreateDateSecond());
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("INDEX_ACCOMPLISH_RECORDS_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)req));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }
}

