/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepColletItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"sfaVisitStepColletServiceExpandImpl"})
public class SfaVisitStepColletServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepColletMapper, SfaVisitStepColletEntity>
implements ISfaVisitStepColletService,
VisitDataDurabilityService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepColletServiceImpl.class);
    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;
    @Resource
    private ISfaVisitStepColletItemService sfaVisitStepColletItemService;

    @Override
    @Transactional
    public List<? extends CrmBaseEntity> dataDurability(List<? extends CrmBaseEntity> baseEntity, SfaVisitStepFromRespVo fromRespVo) {
        if (CollectionUtils.isEmpty(baseEntity)) {
            return Lists.newArrayList();
        }
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)baseEntity.get(0);
        baseEntity = Lists.newArrayList((Object[])new SfaVisitStepColletRedisData[]{this.save(redisData)});
        this.doTransToEs(redisData, fromRespVo);
        return baseEntity;
    }

    @Override
    @Transactional
    public SfaVisitStepColletRedisData save(SfaVisitStepColletRedisData redisData) {
        this.saveOrUpdate((Object)redisData);
        List<CompetitorStepExecuteData.ColletItemReqVo> colletItems = redisData.getSfaVisitStepColletItemReqVos();
        if (!CollectionUtils.isEmpty(colletItems)) {
            List itemEntities = colletItems.stream().map(v -> {
                SfaVisitStepColletItemEntity copy = (SfaVisitStepColletItemEntity)((Object)((Object)CrmBeanUtil.copy((Object)v, SfaVisitStepColletItemEntity.class)));
                copy.setColletId(redisData.getId());
                return copy;
            }).collect(Collectors.toList());
            this.sfaVisitStepColletItemService.saveBatch(itemEntities);
        }
        List<CrmAttachment> pictureReqVos = redisData.getSfaVisitPictureReqVos();
        SfaAttachmentUtil.insert(pictureReqVos, AttachmentBizTypeEnum.VISIT_STEP_COLLET, redisData.getId());
        return redisData;
    }

    protected void doTransToEs(SfaVisitStepColletRedisData redisData, SfaVisitStepFromRespVo fromRespVo) {
        SfaVisitStepColletEsData oldData;
        SfaVisitStepColletEsData dataResp = (SfaVisitStepColletEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepColletEsData.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        if (StringUtils.isNotBlank((CharSequence)dataResp.getVisitPlanInfoId()) && null != (oldData = this.sfaVisitStepColletEsDataRepositories.findByVisitPlanInfoIdAndStepCode(dataResp.getVisitPlanInfoId(), dataResp.getStepCode()))) {
            dataResp.setId(oldData.getId());
        }
        this.sfaVisitStepColletEsDataRepositories.save(dataResp);
    }
}

