/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAddSignTypeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaActivitiUtils;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaExceptionReportMapper;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.model.SfaExceptionReportEntity;
import com.biz.crm.worksign.model.SfaSignApplyAttachmentEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaSignApplyAttachmentService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"sfaExceptionReportServiceExpandImpl"})
public class SfaExceptionReportServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaExceptionReportMapper, SfaExceptionReportEntity>
implements ISfaExceptionReportService {
    private static final Logger log = LoggerFactory.getLogger(SfaExceptionReportServiceImpl.class);
    @Resource
    private SfaExceptionReportMapper mapper;
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaSignFormsService formsService;
    @Autowired
    private ISfaSignApplyAttachmentService attachmentService;
    @Resource
    private ISfaWorkSignRecordService sfaWorkSignRecordService;

    @Override
    public List<SfaAddSignTypeRespVo> getAddSignType(String startTime, String endTime) {
        UserRedis user = UserUtils.getUser();
        List result = this.sfaWorkSignRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).ne(SfaWorkSignRecordEntity::getWorkSignStatus, (Object)SfaWorkSignEnum.WorkSignStatus.OK.getVal())).between(CrmBaseEntity::getCreateDate, (Object)startTime, (Object)endTime)).eq(SfaWorkSignRecordEntity::getWsUserName, (Object)user.getUsername()));
        if (CollectionUtil.listEmpty((List)result)) {
            throw new BusinessException("\u5f53\u524d\u65f6\u95f4\u65e0\u5f02\u5e38\u6253\u5361\u4fe1\u606f");
        }
        List typeRespVos = CrmBeanUtil.copyList((List)result, SfaAddSignTypeRespVo.class);
        if (typeRespVos.size() >= 2) {
            typeRespVos.add(new SfaAddSignTypeRespVo().setWorkSignType(SfaWorkSignEnum.WorkSignType.CLOCK_ALL.getVal()));
        }
        return typeRespVos;
    }

    @Override
    public PageResult<SfaExceptionReportRespVo> findList(SfaExceptionReportListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaExceptionReportRespVo> list = this.mapper.findList((Page<SfaExceptionReportRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaExceptionReportRespVo query(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("\u8bf7\u4f20\u5165ID");
        }
        SfaExceptionReportEntity exceptionReportEntity = (SfaExceptionReportEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaExceptionReportEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        if (exceptionReportEntity == null) {
            throw new BusinessException("\u8be5ID\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8865\u6253\u5361\u4fe1\u606f");
        }
        SfaExceptionReportRespVo reportRespVo = (SfaExceptionReportRespVo)CrmBeanUtil.copy((Object)((Object)exceptionReportEntity), SfaExceptionReportRespVo.class);
        reportRespVo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)reportRespVo.getBpmStatus()));
        ArrayList signTypeRespVos = new ArrayList();
        List<String> strings = Arrays.asList(exceptionReportEntity.getExceptionRecordIds().split(","));
        strings.forEach(data -> {
            SfaWorkSignRecordEntity recordEntity = (SfaWorkSignRecordEntity)((Object)((Object)this.sfaWorkSignRecordService.getOne((Wrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(BaseIdEntity::getId, data))));
            SfaAddSignTypeRespVo typeRespVo = (SfaAddSignTypeRespVo)CrmBeanUtil.copy((Object)((Object)recordEntity), SfaAddSignTypeRespVo.class);
            typeRespVo.setWorkSignTypeName(DictUtil.dictValue((String)"AddSignType", (String)typeRespVo.getWorkSignType()));
            signTypeRespVos.add(typeRespVo);
        });
        reportRespVo.setAddSignTypeRespVos(signTypeRespVos);
        SfaSignApplyAttachmentEntity signApplyAttachmentEntityList = (SfaSignApplyAttachmentEntity)((Object)this.attachmentService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaSignApplyAttachmentEntity.class).eq(SfaSignApplyAttachmentEntity::getApplyType, (Object)WorkSignEnum.signApplyType.EXCEPTION.getValue())).eq(SfaSignApplyAttachmentEntity::getSourceId, (Object)reportRespVo.getId())));
        if (signApplyAttachmentEntityList != null) {
            reportRespVo.setAttachmentListJson(signApplyAttachmentEntityList.getAttachmentListJson());
        }
        return reportRespVo;
    }

    @Override
    public SfaExceptionReportRespVo queryByAuditTaskId(String auditTaskId) {
        SfaExceptionReportListReqVo reqVo = new SfaExceptionReportListReqVo();
        reqVo.setAuditTaskIdList(Arrays.asList(auditTaskId));
        PageResult<SfaExceptionReportRespVo> result = this.findList(reqVo);
        if (result == null || result.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaExceptionReportRespVo)result.getData().get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result apply(SfaExceptionReportReqVo reqVo) {
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaExceptionReportEntity.class));
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            SfaExceptionReportEntity old = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)reqVo.getId())));
            if (old == null) {
                return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
        }
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            entity.setUserName(UserUtils.getUser().getUsername());
        }
        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = this.formsService.getUserOrgInfo(entity.getUserName());
        entity.setRealName(mdmPositionUserOrgRespVo.getFullName());
        entity.setPosCode(mdmPositionUserOrgRespVo.getPositionCode());
        entity.setPosName(mdmPositionUserOrgRespVo.getPositionName());
        String orgCode = mdmPositionUserOrgRespVo.getOrgCode();
        entity.setOrgCode(orgCode);
        entity.setOrgName(mdmPositionUserOrgRespVo.getOrgName());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)orgCode);
        if (null != mdmOrgRespVo) {
            entity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            entity.setParentOrgName(mdmOrgRespVo.getParentName());
        }
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        SfaSignUtils.verifyStartAndEndDate((String)entity.getBeginTime(), (String)entity.getEndTime());
        LocalDate localDate = LocalDate.now();
        if (!LocalDate.parse(entity.getEndTime()).isBefore(localDate)) {
            return Result.error((String)"\u53ea\u80fd\u62a5\u5907\u5f53\u5929\u4e4b\u524d\u7684\u5f02\u5e38\u7b7e\u5230");
        }
        if (localDate.getDayOfMonth() > 8) {
            if (LocalDate.parse(entity.getBeginTime()).isBefore(LocalDate.of(localDate.getYear(), localDate.getMonth(), 1))) {
                return Result.error((String)"\u53ea\u80fd\u62a5\u5907\u5f53\u6708\u5f02\u5e38\u7b7e\u5230");
            }
        } else {
            LocalDate ult = LocalDate.now().minusMonths(1L);
            if (LocalDate.parse(entity.getBeginTime()).isBefore(LocalDate.of(ult.getYear(), ult.getMonth(), 1))) {
                return Result.error((String)"\u53ea\u80fd\u62a5\u5907\u4e0a\u6708\u5f02\u5e38\u7b7e\u5230");
            }
        }
        this.checkExceptionReport(reqVo, entity);
        if (StringUtils.isEmpty((String)entity.getUserName()) || StringUtil.isEmpty((String)entity.getRealName()) || StringUtil.isEmpty((String)entity.getPosCode())) {
            return Result.error((String)"\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        entity.setAuditTaskId(entity.getId());
        StartProcessReqVo startProcessReqVO = SfaActivitiUtils.createStartProcessReqVO((String)entity.getUserName(), (String)entity.getPosCode(), (String)entity.getAuditTaskId(), (ActivitiEnum.FormTypeEnum)ActivitiEnum.FormTypeEnum.EXCEPTION, (String)entity.getBeginTime(), (String)entity.getEndTime(), (String)entity.getOrgCode());
        Result result = this.taActBaseFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        this.saveOrUpdate((Object)entity);
        this.attachmentService.save(WorkSignEnum.signApplyType.EXCEPTION.getValue(), entity.getId(), reqVo.getAttachmentList());
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result rollback(String id) {
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType(), ActivitiEnum.getFormType());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result auditCommit(String id) {
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) && !entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListExceptionRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaExceptionReportListReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            Map<String, TaskRspVO> taskMap = taskRspVOPageResult.getData().stream().collect(Collectors.toMap(TaskRspVO::getFormNo, vo -> vo, (key1, key2) -> key2));
            reqVo.setAuditTaskIdList(new ArrayList<String>(taskMap.keySet()));
            PageResult<SfaExceptionReportRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                List data = pageResult.getData().stream().sorted((x, y) -> CrmDateUtils.parseyyyyMMddHHmmss((String)y.getApplicationDate()).compareTo(CrmDateUtils.parseyyyyMMddHHmmss((String)x.getApplicationDate()))).collect(Collectors.toList());
                pageResult.setData(data);
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListExceptionRespVo(vo, (TaskRspVO)taskMap.get(vo.getAuditTaskId()))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaExceptionReportEntity::getAuditTaskId, (Object)reqVo.getFormId());
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            List<String> ruleInfoIds = this.sfaWorkSignRecordMapper.getRuleInfoIds(entity.getUserName(), entity.getBeginTime(), entity.getEndTime());
            if (CollectionUtils.isNotEmpty(ruleInfoIds)) {
                this.sfaWorkSignRecordMapper.updateExceptionSign(entity.getUserName(), ruleInfoIds);
            }
        } else if (ActivitiEnum.AuditResultType.REJECT.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.REJECT.getValue());
        } else if (ActivitiEnum.AuditResultType.RECOVER.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        } else {
            throw new BusinessException("\u5ba1\u6279\u5931\u8d25");
        }
        this.saveOrUpdate((Object)entity);
    }

    private void checkExceptionReport(SfaExceptionReportReqVo reqVo, SfaExceptionReportEntity entity) {
        if (CollectionUtil.listEmpty((List)reqVo.getWorkSignRecordIdList())) {
            throw new BusinessException("\u672a\u9009\u62e9\u8865\u6253\u5361\u7c7b\u578b");
        }
        List signRecordIdList = reqVo.getWorkSignRecordIdList();
        List entityList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaExceptionReportEntity.class).eq(SfaExceptionReportEntity::getBeginTime, (Object)entity.getBeginTime())).eq(SfaExceptionReportEntity::getEndTime, (Object)entity.getEndTime())).eq(SfaExceptionReportEntity::getUserName, (Object)entity.getUserName())).eq(SfaExceptionReportEntity::getPosCode, (Object)entity.getPosCode())).eq(SfaExceptionReportEntity::getOrgCode, (Object)entity.getOrgCode())).ne(SfaExceptionReportEntity::getBpmStatus, (Object)SfaCommonEnum.dataBpmStatus.REJECT.getValue())).ne(SfaExceptionReportEntity::getBpmStatus, (Object)SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue()));
        if (CollectionUtil.listNotEmpty((List)entityList)) {
            entityList.forEach(data -> {
                List<String> strings = Arrays.asList(data.getExceptionRecordIds().split(","));
                strings.stream().forEach(item -> {
                    if (signRecordIdList.contains(item)) {
                        throw new BusinessException("\u5b58\u5728\u76f8\u5173\u7684\u8865\u6253\u5361\u5ba1\u6279");
                    }
                });
            });
        }
        String exceptionRecordIds = reqVo.getWorkSignRecordIdList().stream().collect(Collectors.joining(","));
        entity.setExceptionRecordIds(exceptionRecordIds);
    }
}

