/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.helpdefense.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.helpdefense.mapper.SfaHelpDefenseMapper;
import com.biz.crm.helpdefense.model.SfaHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.model.SfaHelpDefenseEntity;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseDetailService;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgContactPageRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.sfa.helpdefense.SfaHelpDefenseDto;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaHelpDefenseServiceExpandImpl"})
@Transactional
public class SfaHelpDefenseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaHelpDefenseMapper, SfaHelpDefenseEntity>
implements ISfaHelpDefenseService {
    private static final Logger log = LoggerFactory.getLogger(SfaHelpDefenseServiceImpl.class);
    @Resource
    private SfaHelpDefenseMapper sfaHelpDefenseMapper;
    @Resource
    private ISfaHelpDefenseDetailService sfaHelpDefenseDetailService;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private ISfaVisitPlanService sfaVisitPlanService;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;

    @Override
    public PageResult<SfaHelpDefenseRespVo> findList(SfaHelpDefenseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaHelpDefenseRespVo> list = this.sfaHelpDefenseMapper.findList((Page<SfaHelpDefenseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaHelpDefenseRespVo findSfaHelpDefenseDetail(SfaHelpDefenseReqVo reqVo) {
        SfaHelpDefenseEntity sfaHelpDefenseEntity;
        SfaHelpDefenseRespVo respVo = null;
        AssertUtils.isNotEmpty((String)reqVo.getHelpDefenseDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        if (!StringUtils.isNotEmpty((String)reqVo.getHelpUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setHelpUserName(userRedis.getUsername());
            reqVo.setHelpPosCode(userRedis.getPoscode());
        }
        if ((sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaHelpDefenseEntity::getHelpUserName, (Object)reqVo.getHelpUserName())).eq(SfaHelpDefenseEntity::getHelpPosCode, (Object)reqVo.getHelpPosCode())).eq(SfaHelpDefenseEntity::getHelpDefenseDate, (Object)reqVo.getHelpDefenseDate())).one())) == null) {
            return respVo;
        }
        respVo = (SfaHelpDefenseRespVo)CrmBeanUtil.copy((Object)((Object)sfaHelpDefenseEntity), SfaHelpDefenseRespVo.class);
        this.getSfaHelpDefenseDetailList(respVo);
        return respVo;
    }

    @Override
    public SfaHelpDefenseRespVo queryDetailById(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        SfaHelpDefenseEntity sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaHelpDefenseEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u4e3a\u7a7a");
        }
        SfaHelpDefenseRespVo sfaHelpDefenseRespVo = (SfaHelpDefenseRespVo)CrmBeanUtil.copy((Object)((Object)sfaHelpDefenseEntity), SfaHelpDefenseRespVo.class);
        this.getSfaHelpDefenseDetailList(sfaHelpDefenseRespVo);
        return sfaHelpDefenseRespVo;
    }

    private void getSfaHelpDefenseDetailList(SfaHelpDefenseRespVo sfaHelpDefenseRespVo) {
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntityList = this.sfaVisitPlanInfoServiceEsImpl.findByVisitPlanCode(sfaHelpDefenseRespVo.getId());
        List sfaHelpDefenseDetailRespVos = sfaVisitPlanInfoEntityList.stream().map(v -> {
            SfaHelpDefenseDetailRespVo temp = (SfaHelpDefenseDetailRespVo)CrmBeanUtil.copy((Object)v, SfaHelpDefenseDetailRespVo.class);
            temp.setHelpDefenseId(sfaHelpDefenseRespVo.getId());
            temp.setHelpDefenseStatus(v.getVisitStatus());
            temp.setHelpDefenseStatusDesc(v.getVisitStatusName());
            return temp;
        }).collect(Collectors.toList());
        Map<String, List<SfaHelpDefenseDetailRespVo>> detailMap = sfaHelpDefenseDetailRespVos.stream().collect(Collectors.groupingBy(data -> this.fetchGroupKey((SfaHelpDefenseDetailRespVo)data)));
        ArrayList<SfaHelpDefenseDto> sfaHelpDefenseDtos = new ArrayList<SfaHelpDefenseDto>();
        for (Map.Entry<String, List<SfaHelpDefenseDetailRespVo>> map : detailMap.entrySet()) {
            SfaHelpDefenseDetailRespVo sfaHelpDefenseDetailRespVo = map.getValue().get(0);
            SfaHelpDefenseDto sfaHelpDefenseDto = (SfaHelpDefenseDto)CrmBeanUtil.copy((Object)sfaHelpDefenseDetailRespVo, SfaHelpDefenseDto.class);
            map.getValue().forEach(data -> {
                data.setHelpDefenseStatusDesc((String)SfaVisitEnum.HelpVisitStatus.GETMAP.get(data.getHelpDefenseStatus()));
                data.setClientTypeDesc((String)SfaVisitEnum.ClientType.GETMAP.get(data.getClientType()));
            });
            sfaHelpDefenseDto.setSfaHelpDefenseDetailList(map.getValue());
            sfaHelpDefenseDtos.add(sfaHelpDefenseDto);
        }
        sfaHelpDefenseRespVo.setSfaHelpDefenseList(sfaHelpDefenseDtos);
    }

    private void buildClientCodes(List<SfaHelpDefenseDto> sfaHelpDefenseList, List<String> customerCodes, List<String> terminalCodes) {
        if (null == sfaHelpDefenseList) {
            return;
        }
        sfaHelpDefenseList.forEach(data -> {
            List sfaHelpDefenseDetailList = data.getSfaHelpDefenseDetailList();
            if (null == sfaHelpDefenseDetailList) {
                return;
            }
            sfaHelpDefenseDetailList.forEach(da -> {
                if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(da.getClientType())) {
                    terminalCodes.add(da.getClientCode());
                } else {
                    customerCodes.add(da.getClientCode());
                }
            });
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaHelpDefenseReqVo reqVo) {
        this.checkParam(reqVo);
        SfaHelpDefenseEntity sfaHelpDefenseEntityTemp = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaHelpDefenseEntity::getHelpUserName, (Object)reqVo.getHelpUserName())).eq(SfaHelpDefenseEntity::getHelpPosCode, (Object)reqVo.getHelpPosCode())).eq(SfaHelpDefenseEntity::getHelpDefenseDate, (Object)reqVo.getHelpDefenseDate())).one());
        if (null == sfaHelpDefenseEntityTemp) {
            sfaHelpDefenseEntityTemp = (SfaHelpDefenseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaHelpDefenseEntity.class));
        } else {
            String id = sfaHelpDefenseEntityTemp.getId();
            CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)reqVo, (Object)((Object)sfaHelpDefenseEntityTemp));
            sfaHelpDefenseEntityTemp.setId(id);
        }
        SfaHelpDefenseEntity sfaHelpDefenseEntity = sfaHelpDefenseEntityTemp;
        this.saveOrUpdate((Object)sfaHelpDefenseEntity);
        ArrayList sfaHelpDefenseDetailEntityList = new ArrayList();
        StringJoiner coverHelpRealName = new StringJoiner(",");
        HashMap daysPlanInfo = Maps.newHashMap();
        ArrayList planInfoEntities = Lists.newArrayList();
        List sfaHelpDefenseList = reqVo.getSfaHelpDefenseList();
        ArrayList customerCodes = Lists.newArrayList();
        ArrayList terminalCodes = Lists.newArrayList();
        this.buildClientCodes(sfaHelpDefenseList, customerCodes, terminalCodes);
        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        sfaHelpDefenseList.forEach(data -> {
            List sfaHelpDefenseDetailList = data.getSfaHelpDefenseDetailList();
            sfaHelpDefenseDetailList.forEach(da -> {
                SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey;
                SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity;
                String visitDate = reqVo.getHelpDefenseDate();
                String visitUserName = reqVo.getHelpUserName();
                String visitPosCode = reqVo.getHelpPosCode();
                String visitBigType = SfaVisitEnum.VisitBigType.HELP_VISIT.getVal();
                String redisHash = SfaVisitPlanInfoEntity.getInstance().redisHash(visitDate, visitUserName, visitPosCode, visitBigType).toString();
                Map visitPlanInfoMap = (Map)daysPlanInfo.get(redisHash);
                if (null == visitPlanInfoMap) {
                    visitPlanInfoMap = Maps.newHashMap();
                }
                if (null == (sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)visitPlanInfoMap.get((visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitDate, visitUserName, visitPosCode, visitBigType, da.getClientType(), da.getClientCode())).getRedisHashKey()))) {
                    sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)CrmBeanUtil.copy((Object)da, SfaVisitPlanInfoEntity.class);
                    this.buildSfaVisitPlanInfoEntity(sfaVisitPlanInfoEntity, sfaHelpDefenseEntity, (SfaHelpDefenseDto)data);
                    SfaClientData clientData = (SfaClientData)clientDataMap.get(da.getClientType() + da.getClientCode());
                    CrmBeanUtil.copyPropertiesIgnoreEmpty((Object)clientData, (Object)sfaVisitPlanInfoEntity);
                    planInfoEntities.add(sfaVisitPlanInfoEntity);
                } else {
                    sfaVisitPlanInfoEntity.setCoverHelpOrgCode(new StringJoiner(",").add(sfaVisitPlanInfoEntity.getCoverHelpOrgCode()).add(data.getCoverHelpOrgCode()).toString());
                    sfaVisitPlanInfoEntity.setCoverHelpOrgName(new StringJoiner(",").add(sfaVisitPlanInfoEntity.getCoverHelpOrgName()).add(data.getCoverHelpOrgName()).toString());
                    sfaVisitPlanInfoEntity.setCoverHelpPosCode(new StringJoiner(",").add(sfaVisitPlanInfoEntity.getCoverHelpPosCode()).add(data.getCoverHelpPosCode()).toString());
                    sfaVisitPlanInfoEntity.setCoverHelpPosName(new StringJoiner(",").add(sfaVisitPlanInfoEntity.getCoverHelpPosName()).add(data.getCoverHelpPosName()).toString());
                    sfaVisitPlanInfoEntity.setCoverHelpRealName(new StringJoiner(",").add(sfaVisitPlanInfoEntity.getCoverHelpRealName()).add(data.getCoverHelpRealName()).toString());
                    sfaVisitPlanInfoEntity.setCoverHelpUserName(new StringJoiner(",").add(sfaVisitPlanInfoEntity.getCoverHelpUserName()).add(data.getCoverHelpUserName()).toString());
                }
                sfaVisitPlanInfoEntity.setId(null);
                sfaVisitPlanInfoEntity.setVisitPlanCode(sfaHelpDefenseEntity.getId());
                sfaHelpDefenseDetailEntityList.add(sfaVisitPlanInfoEntity);
                coverHelpRealName.add(data.getCoverHelpRealName());
                visitPlanInfoMap.put(visitRedisHashKey.getRedisHashKey(), sfaVisitPlanInfoEntity);
                daysPlanInfo.put(redisHash, visitPlanInfoMap);
            });
        });
        this.injectClientInfo(planInfoEntities);
        sfaHelpDefenseEntity.setCoverHelpRealName(coverHelpRealName.toString());
        this.updateById((Object)sfaHelpDefenseEntity);
        this.sfaVisitPlanService.saveVisitPlanInfoToRedisAndEs(daysPlanInfo);
    }

    private void buildSfaVisitPlanInfoEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaHelpDefenseEntity sfaHelpDefenseEntity, SfaHelpDefenseDto data) {
        sfaVisitPlanInfoEntity.setVisitUserName(sfaHelpDefenseEntity.getHelpUserName());
        sfaVisitPlanInfoEntity.setVisitRealName(sfaHelpDefenseEntity.getHelpRealName());
        sfaVisitPlanInfoEntity.setVisitOrgCode(sfaHelpDefenseEntity.getHelpOrgCode());
        sfaVisitPlanInfoEntity.setVisitOrgName(sfaHelpDefenseEntity.getHelpOrgName());
        sfaVisitPlanInfoEntity.setVisitPlanCode(sfaHelpDefenseEntity.getId());
        sfaVisitPlanInfoEntity.setVisitPosCode(sfaHelpDefenseEntity.getHelpPosCode());
        sfaVisitPlanInfoEntity.setVisitPosName(sfaHelpDefenseEntity.getHelpPosName());
        sfaVisitPlanInfoEntity.setVisitDate(sfaHelpDefenseEntity.getHelpDefenseDate());
        LocalDate date = LocalDate.parse(sfaHelpDefenseEntity.getHelpDefenseDate(), CrmDateUtils.yyyyMMdd);
        sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
        sfaVisitPlanInfoEntity.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)sfaHelpDefenseEntity.getHelpPosCode());
        if (null != mdmOrgRespVo) {
            sfaVisitPlanInfoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            sfaVisitPlanInfoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        }
        sfaVisitPlanInfoEntity.setCoverHelpOrgCode(data.getCoverHelpOrgCode());
        sfaVisitPlanInfoEntity.setCoverHelpOrgName(data.getCoverHelpOrgName());
        sfaVisitPlanInfoEntity.setCoverHelpPosCode(data.getCoverHelpPosCode());
        sfaVisitPlanInfoEntity.setCoverHelpPosName(data.getCoverHelpPosName());
        sfaVisitPlanInfoEntity.setCoverHelpRealName(data.getCoverHelpRealName());
        sfaVisitPlanInfoEntity.setCoverHelpUserName(data.getCoverHelpUserName());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal());
        sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getDesc());
        sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.HELP_VISIT.getDesc());
        sfaVisitPlanInfoEntity.setClientTypeName((String)SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
        SfaVisitPlanInfoEntity.buildDefEntityData((CrmBaseEntity)sfaVisitPlanInfoEntity);
    }

    @Override
    @Transactional
    public void update(SfaHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952eid\u4e3a\u7a7a");
        this.checkParam(reqVo);
        LocalDate now = LocalDate.now();
        LocalDate updateNow = LocalDate.parse(reqVo.getHelpDefenseDate());
        if (!updateNow.isEqual(now) && !updateNow.isAfter(now)) {
            throw new BusinessException("\u4fee\u6539\u7684\u534f\u8bbf\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        SfaHelpDefenseEntity sfaHelpDefenseEntity = (SfaHelpDefenseEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).one());
        if (sfaHelpDefenseEntity == null) {
            throw new BusinessException("\u67e5\u8be2\u534f\u8bbf\u6570\u636e\u4fe1\u606f\u4e3a\u7a7a");
        }
        sfaHelpDefenseEntity.setHelpDefenseDate(reqVo.getHelpDefenseDate());
        LocalDate helpDefenseDate = LocalDate.parse(sfaHelpDefenseEntity.getHelpDefenseDate());
        if (!helpDefenseDate.isAfter(now)) {
            throw new BusinessException("\u4e0d\u53ef\u4fee\u6539\u5f53\u5929/\u5386\u53f2\u534f\u8bbf\u6570\u636e");
        }
        String id = sfaHelpDefenseEntity.getId();
        List sfaHelpDefenseDetailEntities = ((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().eq(SfaHelpDefenseDetailEntity::getHelpDefenseId, (Object)id)).list();
        List detailIds = sfaHelpDefenseDetailEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.updateById((Object)sfaHelpDefenseEntity);
        this.sfaHelpDefenseDetailService.removeByIds(detailIds);
        ArrayList sfaHelpDefenseDetailEntityList = new ArrayList();
        StringBuffer coverHelpRealName = new StringBuffer();
        reqVo.getSfaHelpDefenseList().forEach(data -> {
            reqVo.setCoverHelpPosCode(data.getCoverHelpPosCode());
            Integer count = this.sfaHelpDefenseMapper.selectSfaHelpDefenseCountByCondition(reqVo);
            if (now.isEqual(updateNow) ? count > 1 : count > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u534f\u8bbf\u65e5\u671f\u5185\u7684\u534f\u8bbf\u6570\u636e\u4fe1\u606f");
            }
            data.getSfaHelpDefenseDetailList().forEach(da -> {
                SfaHelpDefenseDetailEntity sfaHelpDefenseDetailEntity = (SfaHelpDefenseDetailEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)da, SfaHelpDefenseDetailEntity.class))));
                sfaHelpDefenseDetailEntity.setCoverHelpOrgCode(data.getCoverHelpOrgCode());
                sfaHelpDefenseDetailEntity.setCoverHelpOrgName(data.getCoverHelpOrgName());
                sfaHelpDefenseDetailEntity.setCoverHelpPosCode(data.getCoverHelpPosCode());
                sfaHelpDefenseDetailEntity.setCoverHelpPosName(data.getCoverHelpPosName());
                sfaHelpDefenseDetailEntity.setCoverHelpRealName(data.getCoverHelpRealName());
                sfaHelpDefenseDetailEntity.setCoverHelpUserName(data.getCoverHelpUserName());
                sfaHelpDefenseDetailEntity.setHelpDefenseStatus(SfaVisitEnum.HelpVisitStatus.READY_HELP_DEFENSE.getVal());
                sfaHelpDefenseDetailEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                sfaHelpDefenseDetailEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                sfaHelpDefenseDetailEntity.setHelpDefenseId(id);
                sfaHelpDefenseDetailEntityList.add(sfaHelpDefenseDetailEntity);
                if (coverHelpRealName.length() == 0) {
                    coverHelpRealName.append(data.getCoverHelpRealName());
                } else {
                    coverHelpRealName.append(",").append(data.getCoverHelpRealName());
                }
            });
        });
        this.sfaHelpDefenseDetailService.saveBatch(sfaHelpDefenseDetailEntityList);
        sfaHelpDefenseEntity.setCoverHelpRealName(coverHelpRealName.toString());
        this.updateById((Object)sfaHelpDefenseEntity);
    }

    private void injectClientInfo(List<SfaVisitPlanInfoEntity> planInfoEntities) {
        Result terminalResult;
        Result customerResult;
        final List customerCodes = planInfoEntities.stream().filter(o -> SfaVisitEnum.ClientType.DEALER.getVal().equals(o.getClientType())).map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toList());
        final List terminalCodes = planInfoEntities.stream().filter(o -> SfaVisitEnum.ClientType.TERMINAL.getVal().equals(o.getClientType())).map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toList());
        Map<Object, Object> terminalMap = new HashMap();
        Map<Object, Object> customerMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes) && (customerResult = this.mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo(){
            {
                this.setCustomerCodeList(customerCodes);
                this.setPageSize(-1);
            }
        })).isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)customerResult.getResult()).getData())) {
            customerMap = ((PageResult)customerResult.getResult()).getData().stream().collect(Collectors.toMap(MdmCustomerMsgContactPageRespVo::getCustomerCode, Function.identity()));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodes) && (terminalResult = this.mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo(){
            {
                this.setTerminalCodeList(terminalCodes);
                this.setPageSize(-1);
            }
        })).isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)terminalResult.getResult()).getData())) {
            terminalMap = ((PageResult)terminalResult.getResult()).getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, Function.identity()));
        }
        for (SfaVisitPlanInfoEntity data : planInfoEntities) {
            if (customerMap.containsKey(data.getClientCode())) {
                MdmCustomerMsgContactPageRespVo customer = (MdmCustomerMsgContactPageRespVo)customerMap.get(data.getClientCode());
                data.setClientAddress(customer.getRegisteredAddress());
                data.setClientPhone(customer.getContactPhone());
                if (StringUtils.isNotEmpty((String)customer.getLongitude()) && StringUtils.isNotEmpty((String)customer.getLatitude())) {
                    data.setLongitude(new BigDecimal(customer.getLongitude()));
                    data.setLatitude(new BigDecimal(customer.getLatitude()));
                }
            }
            if (!terminalMap.containsKey(data.getClientCode())) continue;
            MdmTerminalContactPageVo terminal = (MdmTerminalContactPageVo)terminalMap.get(data.getClientCode());
            data.setClientAddress(terminal.getTerminalAddress());
            data.setClientPhone(terminal.getContactPhone());
            data.setClientPhoto(terminal.getShopImagePath());
            if (!StringUtils.isNotEmpty((String)terminal.getLongitude()) || !StringUtils.isNotEmpty((String)terminal.getLatitude())) continue;
            data.setLongitude(new BigDecimal(terminal.getLongitude()));
            data.setLatitude(new BigDecimal(terminal.getLatitude()));
        }
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u62dc\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a");
        GetVisitListReq.MoreReq req = new GetVisitListReq.MoreReq();
        req.setVisitUserName(reqVo.getVisitUserName());
        req.setVisitPositionCode(reqVo.getVisitPosCode());
        req.setVisitDate(reqVo.getVisitDate());
        req.setClientType(reqVo.getClientType());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoService.getVisitInfoListByClientType(req);
        List<SfaVisitPlanInfoRespVo> plans = list.stream().map(v -> {
            SfaVisitPlanInfoRespVo respVo = (SfaVisitPlanInfoRespVo)CrmBeanUtil.copy((Object)v, SfaVisitPlanInfoRespVo.class);
            return respVo;
        }).collect(Collectors.toList());
        return plans;
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findAllSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u62dc\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.findAllSfaVisitPlanInfo(reqVo);
        return sfaVisitPlanInfoEntities;
    }

    private void checkParam(SfaHelpDefenseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getHelpOrgCode(), (String)"\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpOrgName(), (String)"\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpPosCode(), (String)"\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpPosName(), (String)"\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpUserName(), (String)"\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpRealName(), (String)"\u534f\u8bbf\u4eba\u5458\u59d3\u540d\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getHelpDefenseDate(), (String)"\u534f\u8bbf\u65e5\u671f\u4e3a\u7a7a");
        List sfaHelpDefenseList = reqVo.getSfaHelpDefenseList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)sfaHelpDefenseList)) {
            throw new BusinessException("\u88ab\u534f\u8bbf\u4eba\u5458\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        HashSet coverHelpPosCodes = Sets.newHashSet();
        for (SfaHelpDefenseDto sfaHelpDefenseDto : sfaHelpDefenseList) {
            if (coverHelpPosCodes.contains(sfaHelpDefenseDto.getCoverHelpPosCode())) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u88ab\u534f\u8bbf\u4eba\u5458[" + sfaHelpDefenseDto.getCoverHelpPosName() + "]");
            }
            coverHelpPosCodes.add(sfaHelpDefenseDto.getCoverHelpPosCode());
            AssertUtils.isNotEmpty((String)sfaHelpDefenseDto.getCoverHelpOrgCode(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaHelpDefenseDto.getCoverHelpOrgName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaHelpDefenseDto.getCoverHelpPosCode(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaHelpDefenseDto.getCoverHelpPosName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u804c\u4f4d\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaHelpDefenseDto.getCoverHelpUserName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u8d26\u53f7\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)sfaHelpDefenseDto.getCoverHelpRealName(), (String)"\u88ab\u534f\u8bbf\u4eba\u5458\u59d3\u540d\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((Collection)sfaHelpDefenseDto.getSfaHelpDefenseDetailList(), (String)"\u88ab\u534f\u8bbf\u5ba2\u6237\u5217\u8868\u4e3a\u7a7a");
            HashSet clientCodes = Sets.newHashSet();
            List sfaHelpDefenseDetailList = sfaHelpDefenseDto.getSfaHelpDefenseDetailList();
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)sfaHelpDefenseDetailList)) {
                throw new BusinessException("\u88ab\u534f\u8bbf\u4eba\u5458[" + sfaHelpDefenseDto.getCoverHelpPosName() + "]\u7f51\u70b9\u5217\u8868\u4e3a\u7a7a");
            }
            sfaHelpDefenseDetailList.forEach(da -> {
                if (clientCodes.contains(da.getClientCode())) {
                    throw new BusinessException("\u88ab\u534f\u8bbf\u4eba\u5458[" + sfaHelpDefenseDto.getCoverHelpPosName() + "]\u5b58\u5728\u91cd\u590d\u7684\u7f51\u70b9[" + da.getClientName() + "]");
                }
                clientCodes.add(da.getClientCode());
                AssertUtils.isNotEmpty((String)da.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)da.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)da.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        List sfaHelpDefenseEntities = this.sfaHelpDefenseMapper.selectBatchIds(ids);
        List idList = sfaHelpDefenseEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        List sfaHelpDefenseDetailEntityList = ((LambdaQueryChainWrapper)this.sfaHelpDefenseDetailService.lambdaQuery().in(SfaHelpDefenseDetailEntity::getHelpDefenseId, idList)).list();
        List detailIdList = sfaHelpDefenseDetailEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.removeByIds(idList);
        this.sfaHelpDefenseDetailService.removeByIds(detailIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaHelpDefenseReqVo reqVo) {
        List sfaHelpDefenseEntities = this.sfaHelpDefenseMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaHelpDefenseEntities)) {
            sfaHelpDefenseEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaHelpDefenseEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaHelpDefenseReqVo reqVo) {
        List sfaHelpDefenseEntities = this.sfaHelpDefenseMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaHelpDefenseEntities)) {
            sfaHelpDefenseEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaHelpDefenseEntities);
    }

    private String fetchGroupKey(SfaHelpDefenseDetailRespVo respVo) {
        return respVo.getCoverHelpUserName() + "_" + respVo.getCoverHelpPosCode() + "_" + respVo.getCoverHelpOrgCode();
    }
}

