/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.ActivityExecuteHelper;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityDisplayStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.ActivityWorkbenchDataReq;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityDisplayExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityDisplayExecutionEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceEsImpl;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnMissingBean(name={"activityDisplayVisitStepExecutorExpandImpl"})
public class ActivityDisplayVisitStepExecutor<ExecuteReq extends ActivityStepExecuteData>
extends AbstractVisitStepRedisExecutor<ExecuteReq, ActivityDisplayStepExecuteDataResp, ActivityExecutorLoadReq> {
    private static final Logger log = LoggerFactory.getLogger(ActivityDisplayVisitStepExecutor.class);
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ActivityExecuteHelper activityExecuteHelper;
    @Resource
    private SfaVisitStepActivityDisplayExecutionEsDataRepositories sfaVisitStepActivityDisplayExecutionEsDataRepositories;
    @Resource
    private SfaVisitStepActivityExecutionServiceEsImpl sfaVisitStepActivityExecutionServiceEsImpl;

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal();
    }

    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getActivityType(), redisData.getStepCode()).toString(), redisData.buildRedisDataForWrite(), 691200L);
        if (this.activityExecuteHelper.activityStepCompleted(visitStepExecuteReq.getRedisHashKey(), SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal(), redisData.getStepCode())) {
            this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        }
    }

    public String executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        visitStepExecuteReq.setRedisHashKey("WORKBENCH");
        this.check(null, visitStepExecuteReq);
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(UUIDGenerator.generate());
        redisData.setVisitPlanInfoId("WORKBENCH");
        ActivityWorkbenchDataReq dataReq = (ActivityWorkbenchDataReq)visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.doTransToEs(Lists.newArrayList((Object[])new SfaVisitStepActivityExecutionRedisData[]{redisData}), fromRespVo, redisData.getVisitPlanInfoId());
        return redisData.getId();
    }

    protected SfaVisitStepActivityExecutionRedisData buildRedisData(VisitStepExecuteReq<? extends ActivityStepExecuteData> visitStepExecuteReq) {
        ActivityStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(executeData.getActivityExecutionId());
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)((Object)CrmBeanUtil.copy((Object)executeData, SfaVisitStepActivityExecutionRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setActivityRequireReqVoList(executeData.getActivityRequireReqVoList());
        redisData.setActivityCode(sfaActivityExecutionRespVo.getActivityCode());
        redisData.setActivityType(sfaActivityExecutionRespVo.getActivityType());
        redisData.setActivityExecutionId(sfaActivityExecutionRespVo.getId());
        redisData.setActivityTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        redisData.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        redisData.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        redisData.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        redisData.setSalesVolume(sfaActivityExecutionRespVo.getSalesVolume());
        redisData.setApplyAmount(sfaActivityExecutionRespVo.getApplyAmount());
        redisData.setActivityDesc(sfaActivityExecutionRespVo.getActivityDesc());
        redisData.setActivityDesc(sfaActivityExecutionRespVo.getActivityDesc());
        return redisData;
    }

    protected SfaActivityExecutionRespVo loadSfaActData(String activityExecutionId) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(activityExecutionId);
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6570\u636e");
        }
        return sfaActivityExecutionRespVo;
    }

    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepActivityExecutionRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData((CrmBaseEntity)redisData);
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        redisData.setLastActivityTime(this.lastActivityTime(redisData.getStepCode(), redisData.getClientCode(), redisData.getId()));
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        ActivityStepExecuteData stepExecuteData = (ActivityStepExecuteData)visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("\u6267\u884c\u6570\u636e\u4e3a\u7a7a");
        }
        List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList = stepExecuteData.getActivityRequireReqVoList();
        if (!CollectionUtils.isEmpty(activityRequireReqVoList)) {
            for (ActivityStepExecuteData.ActivityRequireReqVo requireReqVo : activityRequireReqVoList) {
                List<CrmAttachment> pictureList = requireReqVo.getPictureList();
                this.checkPics(pictureList, 1, 5, requireReqVo.getActivityRequireName());
            }
        }
    }

    @Override
    protected ActivityDisplayStepExecuteDataResp doLoad(ActivityExecutorLoadReq loadParam) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(loadParam.getRedisHashKey());
        SfaVisitPlanInfoEntity planInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(loadParam.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(loadParam.getFormId());
        final SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(loadParam.getActivityExecutionId());
        StringJoiner redisHash = SfaVisitStepActivityExecutionRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), sfaActivityExecutionRespVo.getActivityType(), fromRespVo.getStepCode());
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)((Object)this.redisService.hmget(redisHash.toString(), (Object)new StringJoiner(":").add(loadParam.getRedisHashKey()).add(sfaActivityExecutionRespVo.getActivityCode()).toString()));
        if (null == redisData) {
            redisData = new SfaVisitStepActivityExecutionRedisData(){
                {
                    this.buildActivityRequireReqVoList(sfaActivityExecutionRespVo.getActivityRequire());
                }
            };
        }
        redisData.setLastActivityTime(this.lastActivityTime(fromRespVo.getStepCode(), planInfoEntity.getClientCode(), planInfoEntity.getId()));
        ActivityDisplayStepExecuteDataResp dataResp = (ActivityDisplayStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), ActivityDisplayStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        dataResp.setClientName(planInfoEntity.getClientName());
        dataResp.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        dataResp.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        dataResp.setActivityCode(sfaActivityExecutionRespVo.getActivityCode());
        dataResp.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        dataResp.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        dataResp.setDisplayContent(this.buildDisplayContent(sfaActivityExecutionRespVo));
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional optional = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return (StepExecuteDataResp)optional.get();
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
    }

    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        return null;
    }

    @Override
    protected ActivityDisplayStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq param) {
        ActivityExecutorWorkbenchLoadReq loadParam = (ActivityExecutorWorkbenchLoadReq)param;
        if (StringUtils.isBlank((CharSequence)loadParam.getActivityExecutionId())) {
            throw new BusinessException("\u6d3b\u52a8id\u4e3a\u7a7a");
        }
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isBlank((CharSequence)visitPlanInfoId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank((CharSequence)loadParam.getStepCode())) {
                throw new BusinessException("\u6b65\u9aa4\u7f16\u7801\u4e3a\u7a7a");
            }
            final SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(loadParam.getActivityExecutionId());
            SfaVisitStepActivityDisplayExecutionEsData redisData = new SfaVisitStepActivityDisplayExecutionEsData(){
                {
                    this.buildActivityRequireReqVoList(sfaActivityExecutionRespVo.getActivityRequire());
                }
            };
            ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = this.buildDisplayContent(sfaActivityExecutionRespVo);
            ActivityDisplayStepExecuteDataResp dataResp = (ActivityDisplayStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, ActivityDisplayStepExecuteDataResp.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            dataResp.setDisplayContent(displayContent);
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), param.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        }
        SfaVisitStepActivityDisplayExecutionEsData redisData = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.findByActivityExecutionIdAndVisitPlanInfoId(loadParam.getActivityExecutionId(), visitPlanInfoId);
        if (null == redisData) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u6570\u636e\u8be6\u7ec6\u4fe1\u606f!");
        }
        ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = redisData.getDisplayContent();
        ActivityDisplayStepExecuteDataResp dataResp = (ActivityDisplayStepExecuteDataResp)CrmBeanUtil.copy((Object)redisData, ActivityDisplayStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        dataResp.setDisplayContent(displayContent);
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    private ActivityDisplayStepExecuteDataResp.DisplayContent buildDisplayContent(SfaActivityExecutionRespVo sfaActivityExecutionRespVo) {
        ActivityDisplayStepExecuteDataResp.DisplayContent displayContent = new ActivityDisplayStepExecuteDataResp.DisplayContent();
        displayContent.setActivityProductList(sfaActivityExecutionRespVo.getActivityProductList());
        List visitPictureList = sfaActivityExecutionRespVo.getVisitPictureList();
        List pictureList = CrmAttachment.convertVisitPic((List)visitPictureList);
        displayContent.setPictureList(pictureList);
        return displayContent;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        List redisDataList = (List)this.redisService.hmValues(SfaVisitStepActivityExecutionRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey(), SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal(), executorLoadReq.getStepCode()).toString());
        if (CollectionUtils.isEmpty((Collection)redisDataList)) {
            log.warn("\u5c06\u6570\u636e\u4f20\u8f93\u5230ES: \u6ca1\u6709\u6267\u884c\u6570\u636e\u9700\u8981\u4f20\u8f93\uff08\u53ef\u80fd\u7528\u6237\u6ca1\u6709\u6267\u884c\u8be5\u6b65\u9aa4\uff09\uff0cexecutorLoadReq={}", (Object)JsonPropertyUtil.toJsonString((Object)((Object)executorLoadReq)));
            return;
        }
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(executorLoadReq.getFormId());
        this.doTransToEs(redisDataList, fromRespVo, executorLoadReq.getVisitInfoId());
    }

    protected void doTransToEs(List<SfaVisitStepActivityExecutionRedisData> redisDataList, SfaVisitStepFromRespVo fromRespVo, String visitInfoId) {
        List<String> activityExecutionIds = redisDataList.stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toList());
        Map<String, SfaVisitStepActivityDisplayExecutionEsData> historyData = this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.findByActivityExecutionIdInAndVisitPlanInfoId(activityExecutionIds, visitInfoId).stream().collect(Collectors.toMap(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, v -> v, (o, o2) -> o2));
        ArrayList esData = Lists.newArrayList();
        for (SfaVisitStepActivityExecutionRedisData redisData : redisDataList) {
            SfaVisitStepActivityDisplayExecutionEsData dataResp = (SfaVisitStepActivityDisplayExecutionEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepActivityDisplayExecutionEsData.class);
            dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
            dataResp.setSfaVisitStepFrom(fromRespVo);
            SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(redisData.getActivityExecutionId());
            dataResp.setDisplayContent(this.buildDisplayContent(sfaActivityExecutionRespVo));
            String id = historyData.containsKey(dataResp.getActivityExecutionId()) ? historyData.get(dataResp.getActivityExecutionId()).getId() : UUIDGenerator.generate();
            dataResp.setId(id);
            if (StringUtils.isBlank((CharSequence)dataResp.getVisitPlanInfoId())) {
                dataResp.setVisitPlanInfoId(dataResp.getId());
            }
            esData.add(dataResp);
        }
        this.sfaVisitStepActivityDisplayExecutionEsDataRepositories.saveAll(esData);
    }

    private String lastActivityTime(String stepCode, String clientCode, String currentId) {
        SfaVisitStepActivityDisplayExecutionEsData esData = this.sfaVisitStepActivityExecutionServiceEsImpl.getLastActivityTimeRecord(stepCode, clientCode, LocalDateTime.now(), currentId);
        if (null == esData) {
            return null;
        }
        return esData.getActivityTime();
    }
}

